/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.PathExecLazyValue;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001e\u001a\u00020\tH\u0002J \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u0013H\u0007J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013H\u0002J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0013H\u0007J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0007J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0007J \u0010'\u001a\u00020(2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00130.2\b\u0010/\u001a\u0004\u0018\u00010\u0013H\u0007J\u0012\u00100\u001a\u0004\u0018\u00010\u00132\u0006\u0010)\u001a\u00020*H\u0007J \u00101\u001a\b\u0012\u0004\u0012\u00020\u00130.2\b\u00102\u001a\u0004\u0018\u00010\u00132\u0006\u0010-\u001a\u00020\u0013H\u0007J\b\u00103\u001a\u00020\tH\u0007J.\u00104\u001a\u00020\u00132\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u00132\u0014\u00108\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013\u0018\u000109H\u0007J\u001c\u0010:\u001a\u0004\u0018\u00010\u00132\u0006\u0010;\u001a\u00020<2\b\u0010=\u001a\u0004\u0018\u00010>H\u0007J\u0010\u0010?\u001a\u00020@2\u0006\u0010)\u001a\u00020*H\u0007J\u0010\u0010A\u001a\u00020@2\u0006\u0010)\u001a\u00020*H\u0007J\u0018\u0010B\u001a\u00020C2\u0006\u0010)\u001a\u00020*2\u0006\u0010D\u001a\u00020\u0013H\u0007J\u0018\u0010E\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010D\u001a\u00020\u0013H\u0007J\u0018\u0010F\u001a\u00020*2\u0006\u0010)\u001a\u00020*2\u0006\u0010D\u001a\u00020\u0013H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u00138FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0015\u0010\u0002\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u00138FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0019\u0010\u0002\u001a\u0004\b\u001a\u0010\u0017R\u001a\u0010\u001b\u001a\u00020\u00138FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001c\u0010\u0002\u001a\u0004\b\u001d\u0010\u0017\u00a8\u0006G"}, d2={"Lcom/intellij/execution/util/ExecUtil;", "", "()V", "hasGkSudo", "Lcom/intellij/openapi/util/io/PathExecLazyValue;", "hasGnomeTerminal", "hasKdeSudo", "hasKdeTerminal", "hasNice", "", "getHasNice", "()Z", "hasNice$delegate", "Lkotlin/Lazy;", "hasPkExec", "hasSetsid", "hasUrxvt", "hasXTerm", "nicePath", "", "openCommandPath", "openCommandPath$annotations", "getOpenCommandPath", "()Ljava/lang/String;", "osascriptPath", "osascriptPath$annotations", "getOsascriptPath", "windowsShellName", "windowsShellName$annotations", "getWindowsShellName", "canRunLowPriority", "createTempExecutableScript", "Ljava/io/File;", "prefix", "suffix", "content", "escapeAppleScriptArgument", "arg", "escapeUnixShellArgument", "execAndGetOutput", "Lcom/intellij/execution/process/ProcessOutput;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "timeoutInMilliseconds", "", "command", "", "workDir", "execAndReadLine", "getTerminalCommand", "title", "hasTerminalApp", "loadTemplate", "loader", "Ljava/lang/ClassLoader;", "templateName", "variables", "", "readFirstLine", "stream", "Ljava/io/InputStream;", "cs", "Ljava/nio/charset/Charset;", "setupLowPriorityExecution", "", "setupNoTtyExecution", "sudo", "Ljava/lang/Process;", "prompt", "sudoAndGetOutput", "sudoCommand", "intellij.platform.ide"})
public final class ExecUtil {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final PathExecLazyValue hasGkSudo;
    private static final PathExecLazyValue hasKdeSudo;
    private static final PathExecLazyValue hasPkExec;
    private static final PathExecLazyValue hasGnomeTerminal;
    private static final PathExecLazyValue hasKdeTerminal;
    private static final PathExecLazyValue hasUrxvt;
    private static final PathExecLazyValue hasXTerm;
    private static final PathExecLazyValue hasSetsid;
    private static final String nicePath = "/usr/bin/nice";
    private static final Lazy hasNice$delegate;
    public static final ExecUtil INSTANCE;

    static {
        ExecUtil execUtil;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ExecUtil.class), "hasNice", "getHasNice()Z"))};
        INSTANCE = execUtil = new ExecUtil();
        hasGkSudo = new PathExecLazyValue("gksudo");
        hasKdeSudo = new PathExecLazyValue("kdesudo");
        hasPkExec = new PathExecLazyValue("pkexec");
        hasGnomeTerminal = new PathExecLazyValue("gnome-terminal");
        hasKdeTerminal = new PathExecLazyValue("konsole");
        hasUrxvt = new PathExecLazyValue("urxvt");
        hasXTerm = new PathExecLazyValue("xterm");
        hasSetsid = new PathExecLazyValue("setsid");
        hasNice$delegate = LazyKt.lazy((Function0)hasNice.2.INSTANCE);
    }

    private final boolean getHasNice() {
        Lazy lazy = hasNice$delegate;
        ExecUtil execUtil = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (Boolean)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void osascriptPath$annotations() {
    }

    @NotNull
    public static final String getOsascriptPath() {
        return "/usr/bin/osascript";
    }

    @JvmStatic
    public static /* synthetic */ void openCommandPath$annotations() {
    }

    @NotNull
    public static final String getOpenCommandPath() {
        return "/usr/bin/open";
    }

    @JvmStatic
    public static /* synthetic */ void windowsShellName$annotations() {
    }

    @NotNull
    public static final String getWindowsShellName() {
        String string = CommandLineUtil.getWinShellName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CommandLineUtil.getWinShellName()");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String loadTemplate(@NotNull ClassLoader loader, @NotNull String templateName, @Nullable Map<String, String> variables) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)loader, (String)"loader");
        Intrinsics.checkParameterIsNotNull((Object)templateName, (String)"templateName");
        InputStream inputStream = loader.getResourceAsStream(templateName);
        if (inputStream == null) {
            throw (Throwable)new IOException("Template '" + templateName + "' not found by " + loader);
        }
        InputStream stream = inputStream;
        String string = FileUtil.loadTextAndClose((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.loadTextAndClos\u2026 StandardCharsets.UTF_8))");
        String template = string;
        if (variables == null || variables.isEmpty()) {
            return template;
        }
        StringBuilder buffer = new StringBuilder(template);
        Map<String, String> map = variables;
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry;
            Map.Entry<String, String> entry2 = entry = iterator.next();
            String name = entry2.getKey();
            entry2 = entry;
            String value = entry2.getValue();
            int pos = buffer.indexOf(name);
            if (pos < 0) continue;
            buffer.replace(pos, pos + name.length(), value);
        }
        String string2 = buffer.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"buffer.toString()");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final File createTempExecutableScript(@NotNull String prefix, @NotNull String suffix, @NotNull String content) throws IOException, ExecutionException {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull((Object)suffix, (String)"suffix");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        File tempDir = new File(PathManager.getTempPath());
        File file = FileUtil.createTempFile((File)tempDir, (String)prefix, (String)suffix, (boolean)true, (boolean)true);
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtil.createTempFile(\u2026efix, suffix, true, true)");
        File tempFile = file;
        String string = content;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
        Charset charset2 = charset;
        File file2 = tempFile;
        byte[] byArray = string.getBytes(charset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        FileUtil.writeToFile((File)file2, (byte[])byArray2);
        if (!tempFile.setExecutable(true, true)) {
            throw (Throwable)new ExecutionException("Failed to make temp file executable: " + tempFile);
        }
        return tempFile;
    }

    @JvmStatic
    @NotNull
    public static final ProcessOutput execAndGetOutput(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        ProcessOutput processOutput = new CapturingProcessHandler(commandLine).runProcess();
        Intrinsics.checkExpressionValueIsNotNull((Object)processOutput, (String)"CapturingProcessHandler(commandLine).runProcess()");
        return processOutput;
    }

    @JvmStatic
    @NotNull
    public static final ProcessOutput execAndGetOutput(@NotNull GeneralCommandLine commandLine, int timeoutInMilliseconds) throws ExecutionException {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        ProcessOutput processOutput = new CapturingProcessHandler(commandLine).runProcess(timeoutInMilliseconds);
        Intrinsics.checkExpressionValueIsNotNull((Object)processOutput, (String)"CapturingProcessHandler(\u2026ss(timeoutInMilliseconds)");
        return processOutput;
    }

    @JvmStatic
    @Nullable
    public static final String execAndReadLine(@NotNull GeneralCommandLine commandLine) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        try {
            Process process = commandLine.createProcess();
            Intrinsics.checkExpressionValueIsNotNull((Object)process, (String)"commandLine.createProcess()");
            InputStream inputStream = process.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"commandLine.createProcess().inputStream");
            string = ExecUtil.readFirstLine(inputStream, commandLine.getCharset());
        }
        catch (ExecutionException e) {
            Logger.getInstance(ExecUtil.class).debug((Throwable)e);
            string = null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @Nullable
    public static final String readFirstLine(@NotNull InputStream stream, @Nullable Charset cs) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        try {
            String string;
            object = new BufferedReader(cs == null ? new InputStreamReader(stream) : new InputStreamReader(stream, cs));
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl = false;
                string = it.readLine();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = string;
        }
        catch (IOException e) {
            Logger.getInstance(ExecUtil.class).debug((Throwable)e);
            object = null;
        }
        return object;
    }

    @JvmStatic
    @NotNull
    public static final Process sudo(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws ExecutionException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        Intrinsics.checkParameterIsNotNull((Object)prompt, (String)"prompt");
        Process process = ExecUtil.sudoCommand(commandLine, prompt).createProcess();
        Intrinsics.checkExpressionValueIsNotNull((Object)process, (String)"sudoCommand(commandLine, prompt).createProcess()");
        return process;
    }

    @JvmStatic
    @NotNull
    public static final GeneralCommandLine sudoCommand(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws ExecutionException, IOException {
        GeneralCommandLine generalCommandLine;
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        Intrinsics.checkParameterIsNotNull((Object)prompt, (String)"prompt");
        if (SystemInfo.isUnix && Intrinsics.areEqual((Object)"root", (Object)System.getenv("USER"))) {
            return commandLine;
        }
        List command = CollectionsKt.mutableListOf((Object[])new String[]{commandLine.getExePath()});
        Collection collection = command;
        ParametersList parametersList = commandLine.getParametersList();
        Intrinsics.checkExpressionValueIsNotNull((Object)parametersList, (String)"commandLine.parametersList");
        List<String> list = parametersList.getList();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"commandLine.parametersList.list");
        Iterable iterable = list;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        if (SystemInfo.isWinVistaOrNewer) {
            File file = PathManager.findBinFileWithException((String)"launcher.exe");
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"PathManager.findBinFileW\u2026Exception(\"launcher.exe\")");
            File launcherExe = file;
            Collection collection2 = CollectionsKt.listOf((Object[])new String[]{launcherExe.getPath(), commandLine.getExePath()});
            ParametersList parametersList2 = commandLine.getParametersList();
            Intrinsics.checkExpressionValueIsNotNull((Object)parametersList2, (String)"commandLine.parametersList");
            List<String> list2 = parametersList2.getParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"commandLine.parametersList.parameters");
            generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)collection2, (Iterable)list2));
        } else if (SystemInfo.isMac) {
            String string = StringUtil.join((Collection)command, (Function)sudoCommand.sudoCommandLine.escapedCommand.1.INSTANCE, (String)" & \" \" & ");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.join(command,\u2026ent(it) }, \" & \\\" \\\" & \")");
            String escapedCommand2 = string;
            String escapedScript = "tell current application\n   activate\n   do shell script " + escapedCommand2 + " with administrator privileges without altering line endings\n" + "end tell";
            generalCommandLine = new GeneralCommandLine(ExecUtil.getOsascriptPath(), "-e", escapedScript);
        } else {
            Boolean bl = (Boolean)hasGkSudo.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"hasGkSudo.value");
            if (bl.booleanValue()) {
                generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])new String[]{"gksudo", "--message", prompt, "--"}), (Iterable)command));
            } else {
                Boolean bl2 = (Boolean)hasKdeSudo.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)bl2, (String)"hasKdeSudo.value");
                if (bl2.booleanValue()) {
                    generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])new String[]{"kdesudo", "--comment", prompt, "--"}), (Iterable)command));
                } else {
                    Boolean bl3 = (Boolean)hasPkExec.getValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl3, (String)"hasPkExec.value");
                    if (bl3.booleanValue()) {
                        command.add(0, "pkexec");
                        generalCommandLine = new GeneralCommandLine(command);
                    } else if (SystemInfo.isUnix && ExecUtil.hasTerminalApp()) {
                        String string = StringUtil.join((Collection)command, (Function)sudoCommand.sudoCommandLine.escapedCommandLine.1.INSTANCE, (String)" ");
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.join(command,\u2026ShellArgument(it) }, \" \")");
                        String escapedCommandLine2 = string;
                        File script = ExecUtil.createTempExecutableScript("sudo", ".sh", "#!/bin/sh\necho " + ExecUtil.escapeUnixShellArgument(prompt) + "\n" + "echo\n" + "sudo -- " + escapedCommandLine2 + "\n" + "STATUS=$?\n" + "echo\n" + "read -p \"Press Enter to close this window...\" TEMP\n" + "exit $STATUS\n");
                        String string2 = script.getAbsolutePath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"script.absolutePath");
                        generalCommandLine = new GeneralCommandLine(ExecUtil.getTerminalCommand("Install", string2));
                    } else {
                        throw (Throwable)new UnsupportedOperationException("Unsupported OS/desktop: " + SystemInfo.OS_NAME + '/' + SystemInfo.SUN_DESKTOP);
                    }
                }
            }
        }
        GeneralCommandLine sudoCommandLine2 = generalCommandLine;
        GeneralCommandLine generalCommandLine2 = sudoCommandLine2.withWorkDirectory(commandLine.getWorkDirectory()).withEnvironment(commandLine.getEnvironment()).withParentEnvironmentType(commandLine.getParentEnvironmentType()).withRedirectErrorStream(commandLine.isRedirectErrorStream());
        Intrinsics.checkExpressionValueIsNotNull((Object)generalCommandLine2, (String)"sudoCommandLine\n      .w\u2026ne.isRedirectErrorStream)");
        return generalCommandLine2;
    }

    @JvmStatic
    @NotNull
    public static final ProcessOutput sudoAndGetOutput(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws IOException, ExecutionException {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        Intrinsics.checkParameterIsNotNull((Object)prompt, (String)"prompt");
        return ExecUtil.execAndGetOutput(ExecUtil.sudoCommand(commandLine, prompt));
    }

    private final String escapeAppleScriptArgument(String arg) {
        return "quoted form of \"" + StringsKt.replace$default((String)arg, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + '\"';
    }

    @JvmStatic
    @NotNull
    public static final String escapeUnixShellArgument(@NotNull String arg) {
        Intrinsics.checkParameterIsNotNull((Object)arg, (String)"arg");
        return '\'' + StringsKt.replace$default((String)arg, (String)"'", (String)"'\"'\"'", (boolean)false, (int)4, null) + '\'';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean hasTerminalApp() {
        if (SystemInfo.isWindows) return true;
        if (SystemInfo.isMac) return true;
        Boolean bl = (Boolean)hasKdeTerminal.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"hasKdeTerminal.value");
        if (bl != false) return true;
        Boolean bl2 = (Boolean)hasGnomeTerminal.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)bl2, (String)"hasGnomeTerminal.value");
        if (bl2 != false) return true;
        Boolean bl3 = (Boolean)hasUrxvt.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)bl3, (String)"hasUrxvt.value");
        if (bl3 != false) return true;
        Boolean bl4 = (Boolean)hasXTerm.getValue();
        Intrinsics.checkExpressionValueIsNotNull((Object)bl4, (String)"hasXTerm.value");
        if (bl4 == false) return false;
        return true;
    }

    @JvmStatic
    @NotNull
    public static final List<String> getTerminalCommand(@Nullable String title, @NotNull String command) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        if (SystemInfo.isWindows) {
            Object[] objectArray = new String[5];
            objectArray[0] = ExecUtil.getWindowsShellName();
            objectArray[1] = "/c";
            objectArray[2] = "start";
            String string = title;
            if (string == null || (string = StringsKt.replace$default((String)string, (char)'\"', (char)'\'', (boolean)false, (int)4, null)) == null) {
                string = "";
            }
            String string2 = GeneralCommandLine.inescapableQuote(string);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"GeneralCommandLine.inesc\u2026replace('\"', '\\'') ?: \"\")");
            objectArray[3] = string2;
            objectArray[4] = command;
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (SystemInfo.isMac) {
            list = CollectionsKt.listOf((Object[])new String[]{ExecUtil.getOpenCommandPath(), "-a", "Terminal", command});
        } else {
            Boolean bl = (Boolean)hasKdeTerminal.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"hasKdeTerminal.value");
            if (bl.booleanValue()) {
                list = title != null ? CollectionsKt.listOf((Object[])new String[]{"konsole", "-p", "tabtitle=\"" + StringsKt.replace$default((String)title, (char)'\"', (char)'\'', (boolean)false, (int)4, null) + '\"', "-e", command}) : CollectionsKt.listOf((Object[])new String[]{"konsole", "-e", command});
            } else {
                Boolean bl2 = (Boolean)hasGnomeTerminal.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)bl2, (String)"hasGnomeTerminal.value");
                if (bl2.booleanValue()) {
                    list = title != null ? CollectionsKt.listOf((Object[])new String[]{"gnome-terminal", "-t", title, "-x", command}) : CollectionsKt.listOf((Object[])new String[]{"gnome-terminal", "-x", command});
                } else {
                    Boolean bl3 = (Boolean)hasUrxvt.getValue();
                    Intrinsics.checkExpressionValueIsNotNull((Object)bl3, (String)"hasUrxvt.value");
                    if (bl3.booleanValue()) {
                        list = title != null ? CollectionsKt.listOf((Object[])new String[]{"urxvt", "-title", title, "-e", command}) : CollectionsKt.listOf((Object[])new String[]{"urxvt", "-e", command});
                    } else {
                        Boolean bl4 = (Boolean)hasXTerm.getValue();
                        Intrinsics.checkExpressionValueIsNotNull((Object)bl4, (String)"hasXTerm.value");
                        if (bl4.booleanValue()) {
                            list = title != null ? CollectionsKt.listOf((Object[])new String[]{"xterm", "-T", title, "-e", command}) : CollectionsKt.listOf((Object[])new String[]{"xterm", "-e", command});
                        } else {
                            throw (Throwable)new UnsupportedOperationException("Unsupported OS/desktop: " + SystemInfo.OS_NAME + '/' + SystemInfo.SUN_DESKTOP);
                        }
                    }
                }
            }
        }
        return list;
    }

    @JvmStatic
    public static final void setupLowPriorityExecution(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        if (INSTANCE.canRunLowPriority()) {
            String string = commandLine.getExePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"commandLine.exePath");
            String executablePath = string;
            if (SystemInfo.isWindows) {
                commandLine.setExePath(ExecUtil.getWindowsShellName());
                commandLine.getParametersList().prependAll("/c", "start", "/b", "/low", "/wait", GeneralCommandLine.inescapableQuote(""), executablePath);
            } else {
                commandLine.setExePath(nicePath);
                commandLine.getParametersList().prependAll("-n", "10", executablePath);
            }
        }
    }

    private final boolean canRunLowPriority() {
        return Registry.is((String)"ide.allow.low.priority.process") && (SystemInfo.isWindows || this.getHasNice());
    }

    @JvmStatic
    public static final void setupNoTtyExecution(@NotNull GeneralCommandLine commandLine) {
        Intrinsics.checkParameterIsNotNull((Object)commandLine, (String)"commandLine");
        if (SystemInfo.isLinux) {
            Boolean bl = (Boolean)hasSetsid.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"hasSetsid.value");
            if (bl.booleanValue()) {
                String string = commandLine.getExePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"commandLine.exePath");
                String executablePath = string;
                commandLine.setExePath("setsid");
                commandLine.getParametersList().prependAll(executablePath);
            }
        }
    }

    @Deprecated(message="use {@link #execAndGetOutput(GeneralCommandLine)} instead (to be removed in IDEA 2019) ")
    @JvmStatic
    @NotNull
    public static final ProcessOutput execAndGetOutput(@NotNull List<String> command, @Nullable String workDir) throws ExecutionException {
        Intrinsics.checkParameterIsNotNull(command, (String)"command");
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(command).withWorkDirectory(workDir);
        Intrinsics.checkExpressionValueIsNotNull((Object)generalCommandLine, (String)"GeneralCommandLine(comma\u2026ithWorkDirectory(workDir)");
        GeneralCommandLine commandLine = generalCommandLine;
        ProcessOutput processOutput = new CapturingProcessHandler(commandLine).runProcess();
        Intrinsics.checkExpressionValueIsNotNull((Object)processOutput, (String)"CapturingProcessHandler(commandLine).runProcess()");
        return processOutput;
    }

    private ExecUtil() {
    }

    public static final /* synthetic */ String access$escapeAppleScriptArgument(ExecUtil $this, String arg) {
        return $this.escapeAppleScriptArgument(arg);
    }
}

