/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.properties;

import com.intellij.application.options.codeStyle.properties.CodeStyleChoiceList;
import com.intellij.application.options.codeStyle.properties.ExternalStringAccessor;
import com.intellij.util.containers.BidirectionalMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumPropertyAccessor
extends ExternalStringAccessor<Enum>
implements CodeStyleChoiceList {
    private final Class myEnumClass;
    private final BidirectionalMap<String, Enum> myEnumMap;

    public EnumPropertyAccessor(@NotNull Object object, @NotNull Field field) {
        if (object == null) {
            EnumPropertyAccessor.$$$reportNull$$$0(0);
        }
        if (field == null) {
            EnumPropertyAccessor.$$$reportNull$$$0(1);
        }
        super(object, field);
        this.myEnumMap = new BidirectionalMap();
        this.myEnumClass = field.getType();
        this.fillEnumMap();
    }

    private void fillEnumMap() {
        T[] enumConstants = this.myEnumClass.getEnumConstants();
        if (enumConstants != null) {
            for (Object enumConstant : enumConstants) {
                this.myEnumMap.put((Object)enumConstant.toString().toLowerCase(Locale.ENGLISH), (Object)((Enum)enumConstant));
            }
        }
    }

    @Override
    @NotNull
    public List<String> getChoices() {
        ArrayList<String> arrayList = new ArrayList<String>(this.myEnumMap.keySet());
        if (arrayList == null) {
            EnumPropertyAccessor.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @Nullable
    protected Enum fromExternal(@NotNull String str) {
        if (str == null) {
            EnumPropertyAccessor.$$$reportNull$$$0(3);
        }
        return (Enum)this.myEnumMap.get((Object)str);
    }

    @Override
    @NotNull
    protected String toExternal(@NotNull Enum value) {
        if (value == null) {
            EnumPropertyAccessor.$$$reportNull$$$0(4);
        }
        List names = this.myEnumMap.getKeysByValue((Object)value);
        assert (names != null && names.size() > 0) : "Unexpected value " + value.toString();
        String string = (String)names.get(0);
        if (string == null) {
            EnumPropertyAccessor.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/properties/EnumPropertyAccessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/properties/EnumPropertyAccessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChoices";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toExternal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fromExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

