/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.classpath;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.util.ui.classpath.ChooseLibrariesDialogBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseLibrariesFromTablesDialog
extends ChooseLibrariesDialogBase {
    @Nullable
    private final Project myProject;
    private final boolean myShowCustomLibraryTables;

    protected ChooseLibrariesFromTablesDialog(@NotNull String title, @NotNull Project project2, boolean showCustomLibraryTables) {
        if (title == null) {
            ChooseLibrariesFromTablesDialog.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            ChooseLibrariesFromTablesDialog.$$$reportNull$$$0(1);
        }
        super(project2, title);
        this.myShowCustomLibraryTables = showCustomLibraryTables;
        this.myProject = project2;
    }

    protected ChooseLibrariesFromTablesDialog(@NotNull JComponent parentComponent, @NotNull String title, @Nullable Project project2, boolean showCustomLibraryTables) {
        if (parentComponent == null) {
            ChooseLibrariesFromTablesDialog.$$$reportNull$$$0(2);
        }
        if (title == null) {
            ChooseLibrariesFromTablesDialog.$$$reportNull$$$0(3);
        }
        super(parentComponent, title);
        this.myShowCustomLibraryTables = showCustomLibraryTables;
        this.myProject = project2;
    }

    public static ChooseLibrariesFromTablesDialog createDialog(@NotNull String title, @NotNull Project project2, boolean showCustomLibraryTables) {
        if (title == null) {
            ChooseLibrariesFromTablesDialog.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            ChooseLibrariesFromTablesDialog.$$$reportNull$$$0(5);
        }
        ChooseLibrariesFromTablesDialog dialog = new ChooseLibrariesFromTablesDialog(title, project2, showCustomLibraryTables);
        dialog.init();
        return dialog;
    }

    @Override
    @NotNull
    protected Project getProject() {
        if (this.myProject != null) {
            Project project2 = this.myProject;
            if (project2 == null) {
                ChooseLibrariesFromTablesDialog.$$$reportNull$$$0(6);
            }
            return project2;
        }
        Project project3 = super.getProject();
        if (project3 == null) {
            ChooseLibrariesFromTablesDialog.$$$reportNull$$$0(7);
        }
        return project3;
    }

    @Override
    protected JComponent createNorthPanel() {
        return null;
    }

    @Override
    protected void collectChildren(Object element, List<Object> result) {
        if (element instanceof Application) {
            for (LibraryTable table : ChooseLibrariesFromTablesDialog.getLibraryTables(this.myProject, this.myShowCustomLibraryTables)) {
                if (!this.hasLibraries(table)) continue;
                result.add(table);
            }
        } else if (element instanceof LibraryTable) {
            Collections.addAll(result, this.getLibraries((LibraryTable)element));
        }
    }

    public static List<LibraryTable> getLibraryTables(Project project2, boolean showCustomLibraryTables) {
        ArrayList<LibraryTable> tables = new ArrayList<LibraryTable>();
        LibraryTablesRegistrar registrar = LibraryTablesRegistrar.getInstance();
        if (project2 != null) {
            tables.add(registrar.getLibraryTable(project2));
        }
        tables.add(registrar.getLibraryTable());
        if (showCustomLibraryTables) {
            tables.addAll(registrar.getCustomLibraryTables());
        }
        return tables;
    }

    private boolean hasLibraries(LibraryTable table) {
        Library[] libraries2;
        for (Library library : libraries2 = this.getLibraries(table)) {
            if (!this.acceptsElement(library)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int getLibraryTableWeight(@NotNull LibraryTable libraryTable) {
        if (libraryTable == null) {
            ChooseLibrariesFromTablesDialog.$$$reportNull$$$0(8);
        }
        if (libraryTable.getTableLevel().equals("module")) {
            return 0;
        }
        if (this.isProjectLibraryTable(libraryTable)) {
            return 1;
        }
        if (ChooseLibrariesFromTablesDialog.isApplicationLibraryTable(libraryTable)) {
            return 2;
        }
        return 3;
    }

    private static boolean isApplicationLibraryTable(LibraryTable libraryTable) {
        return libraryTable.equals(LibraryTablesRegistrar.getInstance().getLibraryTable());
    }

    private boolean isProjectLibraryTable(LibraryTable libraryTable) {
        LibraryTablesRegistrar registrar = LibraryTablesRegistrar.getInstance();
        return this.myProject != null && libraryTable.equals(registrar.getLibraryTable(this.myProject));
    }

    @Override
    protected boolean isAutoExpandLibraryTable(@NotNull LibraryTable libraryTable) {
        if (libraryTable == null) {
            ChooseLibrariesFromTablesDialog.$$$reportNull$$$0(9);
        }
        return ChooseLibrariesFromTablesDialog.isApplicationLibraryTable(libraryTable) || this.isProjectLibraryTable(libraryTable);
    }

    @NotNull
    protected Library[] getLibraries(@NotNull LibraryTable table) {
        if (table == null) {
            ChooseLibrariesFromTablesDialog.$$$reportNull$$$0(10);
        }
        Library[] libraryArray = table.getLibraries();
        if (libraryArray == null) {
            ChooseLibrariesFromTablesDialog.$$$reportNull$$$0(11);
        }
        return libraryArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/classpath/ChooseLibrariesFromTablesDialog";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryTable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/classpath/ChooseLibrariesFromTablesDialog";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDialog";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryTableWeight";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAutoExpandLibraryTable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLibraries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

