/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task.impl;

import com.intellij.compiler.impl.CompileContextImpl;
import com.intellij.compiler.impl.CompileDriver;
import com.intellij.compiler.impl.CompileScopeUtil;
import com.intellij.compiler.impl.CompositeScope;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.impl.compiler.ArtifactCompileScope;
import com.intellij.packaging.impl.compiler.ArtifactsWorkspaceSettings;
import com.intellij.task.EmptyCompileScopeBuildTask;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ModuleFilesBuildTask;
import com.intellij.task.ModuleResourcesBuildTask;
import com.intellij.task.ProjectModelBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskNotification;
import com.intellij.task.ProjectTaskResult;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpsProjectTaskRunner
extends ProjectTaskRunner {
    private static final Logger LOG = Logger.getInstance(JpsProjectTaskRunner.class);
    public static final Key<Object> EXECUTION_SESSION_ID_KEY = ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY;

    public void run(@NotNull Project project2, final @NotNull ProjectTaskContext context, @Nullable ProjectTaskNotification callback, @NotNull Collection<? extends ProjectTask> tasks) {
        if (project2 == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(1);
        }
        if (tasks == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(2);
        }
        MessageBusConnection connection = project2.getMessageBus().connect((Disposable)project2);
        connection.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)new CompilationStatusListener(){

            public void fileGenerated(@NotNull String outputRoot, @NotNull String relativePath) {
                if (outputRoot == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (relativePath == null) {
                    1.$$$reportNull$$$0(1);
                }
                context.fileGenerated(outputRoot, relativePath);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputRoot";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "relativePath";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/task/impl/JpsProjectTaskRunner$1";
                objectArray[2] = "fileGenerated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        CompileStatusNotification compileNotification = (aborted, errors, warnings, compileContext) -> {
            context.putUserData(CompileContextImpl.CONTEXT_KEY, (Object)compileContext);
            if (callback != null) {
                callback.finished(new ProjectTaskResult(aborted, errors, warnings));
            }
            connection.disconnect();
        };
        Map<Class<? extends ProjectTask>, List<ProjectTask>> taskMap = JpsProjectTaskRunner.groupBy(tasks);
        JpsProjectTaskRunner.runModulesResourcesBuildTasks(project2, context, compileNotification, taskMap);
        JpsProjectTaskRunner.runModulesBuildTasks(project2, context, compileNotification, taskMap);
        JpsProjectTaskRunner.runFilesBuildTasks(project2, compileNotification, taskMap);
        JpsProjectTaskRunner.runEmptyBuildTask(project2, context, compileNotification, taskMap);
        JpsProjectTaskRunner.runArtifactsBuildTasks(project2, context, compileNotification, taskMap);
    }

    public boolean canRun(@NotNull ProjectTask projectTask) {
        if (projectTask == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(3);
        }
        return projectTask instanceof ModuleBuildTask || projectTask instanceof EmptyCompileScopeBuildTask || projectTask instanceof ProjectModelBuildTask && ((ProjectModelBuildTask)projectTask).getBuildableElement() instanceof Artifact;
    }

    public static Map<Class<? extends ProjectTask>, List<ProjectTask>> groupBy(@NotNull Collection<? extends ProjectTask> tasks) {
        if (tasks == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(4);
        }
        return tasks.stream().collect(Collectors.groupingBy(o -> {
            if (o instanceof ModuleFilesBuildTask) {
                return ModuleFilesBuildTask.class;
            }
            if (o instanceof ModuleResourcesBuildTask) {
                return ModuleResourcesBuildTask.class;
            }
            if (o instanceof ModuleBuildTask) {
                return ModuleBuildTask.class;
            }
            if (o instanceof ProjectModelBuildTask) {
                return ProjectModelBuildTask.class;
            }
            if (o instanceof EmptyCompileScopeBuildTask) {
                return EmptyCompileScopeBuildTask.class;
            }
            return o.getClass();
        }));
    }

    private static void runModulesBuildTasks(@NotNull Project project2, @NotNull ProjectTaskContext context, @NotNull CompileStatusNotification compileNotification, @NotNull Map<Class<? extends ProjectTask>, List<ProjectTask>> tasksMap) {
        Collection buildTasks;
        if (project2 == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(5);
        }
        if (context == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(6);
        }
        if (compileNotification == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(7);
        }
        if (tasksMap == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(8);
        }
        if (ContainerUtil.isEmpty((Collection)(buildTasks = (Collection)tasksMap.get(ModuleBuildTask.class)))) {
            return;
        }
        ModulesBuildSettings modulesBuildSettings = JpsProjectTaskRunner.assembleModulesBuildSettings(buildTasks);
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project2);
        if (modulesBuildSettings.isRebuild()) {
            compilerManager.rebuild(compileNotification);
        } else {
            CompileScope scope = JpsProjectTaskRunner.createScope(compilerManager, context, modulesBuildSettings.modules, modulesBuildSettings.includeDependentModules, modulesBuildSettings.includeRuntimeDependencies);
            if (modulesBuildSettings.isIncrementalBuild) {
                compilerManager.make(scope, compileNotification);
            } else {
                compilerManager.compile(scope, compileNotification);
            }
        }
    }

    private static void runEmptyBuildTask(@NotNull Project project2, @NotNull ProjectTaskContext context, @NotNull CompileStatusNotification compileNotification, @NotNull Map<Class<? extends ProjectTask>, List<ProjectTask>> tasksMap) {
        Collection buildTasks;
        if (project2 == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(9);
        }
        if (context == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(10);
        }
        if (compileNotification == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(11);
        }
        if (tasksMap == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(12);
        }
        if (ContainerUtil.isEmpty((Collection)(buildTasks = (Collection)tasksMap.get(EmptyCompileScopeBuildTask.class)))) {
            return;
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project2);
        CompileScope scope = JpsProjectTaskRunner.createScope(compilerManager, context, Collections.EMPTY_SET, false, false);
        EmptyCompileScopeBuildTask task = (EmptyCompileScopeBuildTask)buildTasks.iterator().next();
        if (task.isIncrementalBuild()) {
            compilerManager.make(scope, compileNotification);
        } else {
            compilerManager.compile(scope, compileNotification);
        }
    }

    private static void runModulesResourcesBuildTasks(@NotNull Project project2, @NotNull ProjectTaskContext context, @NotNull CompileStatusNotification compileNotification, @NotNull Map<Class<? extends ProjectTask>, List<ProjectTask>> tasksMap) {
        Collection buildTasks;
        if (project2 == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(13);
        }
        if (context == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(14);
        }
        if (compileNotification == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(15);
        }
        if (tasksMap == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(16);
        }
        if (ContainerUtil.isEmpty((Collection)(buildTasks = (Collection)tasksMap.get(ModuleResourcesBuildTask.class)))) {
            return;
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project2);
        ModulesBuildSettings modulesBuildSettings = JpsProjectTaskRunner.assembleModulesBuildSettings(buildTasks);
        CompileScope scope = JpsProjectTaskRunner.createScope(compilerManager, context, modulesBuildSettings.modules, modulesBuildSettings.includeDependentModules, modulesBuildSettings.includeRuntimeDependencies);
        List moduleNames = ContainerUtil.map(modulesBuildSettings.modules, Module::getName);
        CompileScopeUtil.setResourcesScopeForExternalBuild(scope, moduleNames);
        if (modulesBuildSettings.isIncrementalBuild) {
            compilerManager.make(scope, compileNotification);
        } else {
            compilerManager.compile(scope, compileNotification);
        }
    }

    private static ModulesBuildSettings assembleModulesBuildSettings(Collection<? extends ProjectTask> buildTasks) {
        boolean includeRuntimeDependencies;
        SmartList modules = new SmartList();
        List incrementalTasks = ContainerUtil.newSmartList();
        List excludeDependentTasks = ContainerUtil.newSmartList();
        List excludeRuntimeTasks = ContainerUtil.newSmartList();
        for (ProjectTask projectTask : buildTasks) {
            ModuleBuildTask moduleBuildTask = (ModuleBuildTask)projectTask;
            modules.add(moduleBuildTask.getModule());
            if (moduleBuildTask.isIncrementalBuild()) {
                incrementalTasks.add(moduleBuildTask);
            }
            if (!moduleBuildTask.isIncludeDependentModules()) {
                excludeDependentTasks.add(moduleBuildTask);
            }
            if (moduleBuildTask.isIncludeRuntimeDependencies()) continue;
            excludeRuntimeTasks.add(moduleBuildTask);
        }
        boolean isIncrementalBuild = incrementalTasks.size() == buildTasks.size();
        boolean bl = excludeDependentTasks.size() != buildTasks.size();
        boolean bl2 = includeRuntimeDependencies = excludeRuntimeTasks.size() != buildTasks.size();
        if (!isIncrementalBuild && !incrementalTasks.isEmpty()) {
            JpsProjectTaskRunner.assertModuleBuildSettingsConsistent(incrementalTasks, "will be built ignoring incremental build setting");
        }
        if (bl && !excludeDependentTasks.isEmpty()) {
            JpsProjectTaskRunner.assertModuleBuildSettingsConsistent(excludeDependentTasks, "will be built along with dependent modules");
        }
        if (includeRuntimeDependencies && !excludeRuntimeTasks.isEmpty()) {
            JpsProjectTaskRunner.assertModuleBuildSettingsConsistent(excludeRuntimeTasks, "will be built along with runtime dependencies");
        }
        return new ModulesBuildSettings(isIncrementalBuild, bl, includeRuntimeDependencies, (Collection<Module>)modules);
    }

    private static void assertModuleBuildSettingsConsistent(Collection<ModuleBuildTask> moduleBuildTasks, String warnMsg) {
        String moduleNames = StringUtil.join(moduleBuildTasks, task -> task.getModule().getName(), (String)", ");
        LOG.warn("Module" + (moduleBuildTasks.size() > 1 ? "s" : "") + " : '" + moduleNames + "' " + warnMsg);
    }

    private static CompileScope createScope(CompilerManager compilerManager, ProjectTaskContext context, Collection<Module> modules, boolean includeDependentModules, boolean includeRuntimeDependencies) {
        RunConfiguration configuration;
        CompositeScope scope;
        CompositeScope compositeScope = scope = !modules.isEmpty() ? compilerManager.createModulesCompileScope(modules.toArray(Module.EMPTY_ARRAY), includeDependentModules, includeRuntimeDependencies) : new CompositeScope(CompileScope.EMPTY_ARRAY);
        if (context.isAutoRun()) {
            CompileDriver.setCompilationStartedAutomatically(scope);
        }
        if ((configuration = context.getRunConfiguration()) != null) {
            scope.putUserData(CompilerManager.RUN_CONFIGURATION_KEY, configuration);
            scope.putUserData(CompilerManager.RUN_CONFIGURATION_TYPE_ID_KEY, configuration.getType().getId());
        }
        ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY.set((UserDataHolder)scope, context.getSessionId());
        return scope;
    }

    private static void runFilesBuildTasks(@NotNull Project project2, @NotNull CompileStatusNotification compileNotification, @NotNull Map<Class<? extends ProjectTask>, List<ProjectTask>> tasksMap) {
        Collection filesTargets;
        if (project2 == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(17);
        }
        if (compileNotification == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(18);
        }
        if (tasksMap == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(19);
        }
        if (!ContainerUtil.isEmpty((Collection)(filesTargets = (Collection)tasksMap.get(ModuleFilesBuildTask.class)))) {
            VirtualFile[] files = (VirtualFile[])filesTargets.stream().flatMap(target -> Stream.of(((ModuleFilesBuildTask)target).getFiles())).toArray(VirtualFile[]::new);
            CompilerManager.getInstance((Project)project2).compile(files, compileNotification);
        }
    }

    private static void runArtifactsBuildTasks(@NotNull Project project2, @NotNull ProjectTaskContext context, @NotNull CompileStatusNotification compileNotification, @NotNull Map<Class<? extends ProjectTask>, List<ProjectTask>> tasksMap) {
        Collection buildTasks;
        if (project2 == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(20);
        }
        if (context == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(21);
        }
        if (compileNotification == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(22);
        }
        if (tasksMap == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(23);
        }
        if (!ContainerUtil.isEmpty((Collection)(buildTasks = (Collection)tasksMap.get(ProjectModelBuildTask.class)))) {
            SmartList toMake = new SmartList();
            SmartList toCompile = new SmartList();
            for (ProjectTask buildProjectTask : buildTasks) {
                ProjectModelBuildTask buildTask = (ProjectModelBuildTask)buildProjectTask;
                ProjectModelBuildableElement buildableElement = buildTask.getBuildableElement();
                if (!(buildableElement instanceof Artifact)) continue;
                if (buildTask.isIncrementalBuild()) {
                    toMake.add((Artifact)buildableElement);
                    continue;
                }
                toCompile.add((Artifact)buildableElement);
            }
            JpsProjectTaskRunner.buildArtifacts(project2, (List<Artifact>)toMake, context.getSessionId(), compileNotification, false);
            JpsProjectTaskRunner.buildArtifacts(project2, (List<Artifact>)toCompile, context.getSessionId(), compileNotification, true);
        }
    }

    private static void buildArtifacts(@NotNull Project project2, @NotNull List<Artifact> artifacts, @Nullable Object sessionId, @Nullable CompileStatusNotification compileNotification, boolean forceArtifactBuild) {
        if (project2 == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(24);
        }
        if (artifacts == null) {
            JpsProjectTaskRunner.$$$reportNull$$$0(25);
        }
        if (!artifacts.isEmpty()) {
            CompileScope scope = ArtifactCompileScope.createArtifactsScope(project2, artifacts, forceArtifactBuild);
            ArtifactsWorkspaceSettings.getInstance(project2).setArtifactsToBuild(artifacts);
            ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY.set((UserDataHolder)scope, sessionId);
            CompilerManager.getInstance((Project)project2).make(scope, compileNotification);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 10: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTask";
                break;
            }
            case 7: 
            case 11: 
            case 15: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compileNotification";
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasksMap";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
        }
        objectArray2[1] = "com/intellij/task/impl/JpsProjectTaskRunner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "run";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canRun";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "groupBy";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "runModulesBuildTasks";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "runEmptyBuildTask";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "runModulesResourcesBuildTasks";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "runFilesBuildTasks";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "runArtifactsBuildTasks";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "buildArtifacts";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ModulesBuildSettings {
        final boolean isIncrementalBuild;
        final boolean includeDependentModules;
        final boolean includeRuntimeDependencies;
        final Collection<Module> modules;

        ModulesBuildSettings(boolean isIncrementalBuild, boolean includeDependentModules, boolean includeRuntimeDependencies, Collection<Module> modules) {
            this.isIncrementalBuild = isIncrementalBuild;
            this.includeDependentModules = includeDependentModules;
            this.includeRuntimeDependencies = includeRuntimeDependencies;
            this.modules = modules;
        }

        boolean isRebuild() {
            if (!this.isIncrementalBuild && !this.modules.isEmpty()) {
                Module someModule = this.modules.iterator().next();
                Module[] projectModules = ModuleManager.getInstance((Project)someModule.getProject()).getModules();
                return projectModules.length == this.modules.size();
            }
            return false;
        }
    }
}

