/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.template.impl.TemplateImplUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HintHint;
import com.intellij.util.SmartList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubstitutionShortInfoHandler
implements DocumentListener,
EditorMouseMotionListener,
CaretListener {
    private static final Key<SubstitutionShortInfoHandler> LISTENER_KEY = Key.create((String)"sslistener.key");
    private static final TooltipGroup SS_INFO_TOOLTIP_GROUP = new TooltipGroup("SS_INFO_TOOLTIP_GROUP", 0);
    private long modificationTimeStamp;
    private final List<String> variables;
    private final Editor editor;
    @Nullable
    private final Consumer<? super String> myCurrentVariableCallback;
    public static final Key<Configuration> CURRENT_CONFIGURATION_KEY = Key.create((String)"SS.CurrentConfiguration");

    SubstitutionShortInfoHandler(@NotNull Editor _editor, @Nullable Consumer<? super String> currentVariableCallback) {
        if (_editor == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(0);
        }
        this.variables = new SmartList();
        this.editor = _editor;
        this.myCurrentVariableCallback = currentVariableCallback;
    }

    public void mouseMoved(@NotNull EditorMouseEvent e) {
        if (e == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(1);
        }
        LogicalPosition position = this.editor.xyToLogicalPosition(e.getMouseEvent().getPoint());
        this.handleInputFocusMovement(position, false);
    }

    private void handleInputFocusMovement(LogicalPosition position, boolean caret) {
        int start;
        Configuration configuration = (Configuration)this.editor.getUserData(CURRENT_CONFIGURATION_KEY);
        if (configuration == null) {
            return;
        }
        this.checkModelValidity();
        int offset = this.editor.logicalPositionToOffset(position);
        Document document = this.editor.getDocument();
        int length = document.getTextLength();
        CharSequence elements = document.getCharsSequence();
        for (start = offset - 1; start >= 0 && Character.isJavaIdentifierPart(elements.charAt(start)) && elements.charAt(start) != '$'; --start) {
        }
        String text = "";
        String variableName = null;
        int end = -1;
        if (start >= 0 && elements.charAt(start) == '$') {
            for (end = offset; end < length && Character.isJavaIdentifierPart(elements.charAt(end)) && elements.charAt(end) != '$'; ++end) {
            }
            if (end < length && elements.charAt(end) == '$' && this.variables.contains(variableName = elements.subSequence(start + 1, end).toString())) {
                String currentVariableName;
                NamedScriptableDefinition variable = configuration.findVariable(variableName);
                text = SubstitutionShortInfoHandler.getShortParamString(variable, !this.editor.isViewer() && !variableName.equals(configuration.getCurrentVariableName()));
                boolean replacementVariable = variable instanceof ReplacementVariableDefinition || variable == null && configuration instanceof ReplaceConfiguration;
                String string = currentVariableName = replacementVariable ? variableName + "$replacement" : variableName;
                if (this.myCurrentVariableCallback != null) {
                    if (caret) {
                        this.myCurrentVariableCallback.accept(currentVariableName);
                        caret = false;
                    }
                } else {
                    configuration.setCurrentVariableName(currentVariableName);
                }
            }
        }
        if (this.myCurrentVariableCallback != null && caret) {
            this.myCurrentVariableCallback.accept("__context__");
        }
        if (variableName != null) {
            SubstitutionShortInfoHandler.showTooltip(this.editor, start, end + 1, text);
        }
    }

    private void checkModelValidity() {
        Document document = this.editor.getDocument();
        if (this.modificationTimeStamp != document.getModificationStamp()) {
            this.variables.clear();
            this.variables.addAll(TemplateImplUtil.parseVariables((CharSequence)document.getCharsSequence()).keySet());
            this.modificationTimeStamp = document.getModificationStamp();
        }
    }

    public void caretPositionChanged(@NotNull CaretEvent e) {
        if (e == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(2);
        }
        this.handleInputFocusMovement(e.getNewPosition(), true);
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(3);
        }
        if (event.getOldLength() == event.getNewLength()) {
            return;
        }
        this.handleInputFocusMovement(this.editor.getCaretModel().getLogicalPosition(), true);
    }

    public List<String> getVariables() {
        this.checkModelValidity();
        return this.variables;
    }

    @NotNull
    static String getShortParamString(NamedScriptableDefinition namedScriptableDefinition, boolean editLink) {
        String script;
        String text;
        boolean newDialog = Registry.is((String)"ssr.use.new.search.dialog");
        if (namedScriptableDefinition == null) {
            String string = SSRBundle.message(newDialog ? "no.filters.tooltip.message" : "no.constraints.specified.tooltip.message", new Object[0]);
            if (string == null) {
                SubstitutionShortInfoHandler.$$$reportNull$$$0(4);
            }
            return string;
        }
        StringBuilder buf = new StringBuilder();
        String inactiveTextColor = ColorUtil.toHtmlColor((Color)UIUtil.getInactiveTextColor());
        String linkColor = ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Link.linkColor());
        if (namedScriptableDefinition instanceof MatchVariableConstraint) {
            String name2;
            MatchVariableConstraint constraint = (MatchVariableConstraint)namedScriptableDefinition;
            if (constraint.isPartOfSearchResults() && !newDialog) {
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("target.tooltip.message", new Object[0]));
            }
            if (constraint.getRegExp() != null && !constraint.getRegExp().isEmpty()) {
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("text.tooltip.message", constraint.isInvertRegExp() ? 1 : 0, StringUtil.escapeXmlEntities((String)constraint.getRegExp()), constraint.isWholeWordsOnly() ? 1 : 0, constraint.isWithinHierarchy() ? 1 : 0, inactiveTextColor));
            } else if (constraint.isWithinHierarchy()) {
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("hierarchy.tooltip.message", new Object[0]));
            }
            if (!StringUtil.isEmpty((String)constraint.getReferenceConstraint())) {
                text = StringUtil.escapeXmlEntities((String)StringUtil.unquoteString((String)constraint.getReferenceConstraint()));
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("reference.target.tooltip.message", constraint.isInvertReference() ? 1 : 0, text));
            }
            constraint.getNameOfExprType();
            if (!constraint.getNameOfExprType().isEmpty()) {
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("exprtype.tooltip.message", constraint.isInvertExprType() ? 1 : 0, StringUtil.escapeXmlEntities((String)constraint.getNameOfExprType()), constraint.isExprTypeWithinHierarchy() ? 1 : 0, inactiveTextColor));
            }
            constraint.getNameOfFormalArgType();
            if (!constraint.getNameOfFormalArgType().isEmpty()) {
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("expected.type.tooltip.message", constraint.isInvertFormalType() ? 1 : 0, StringUtil.escapeXmlEntities((String)constraint.getNameOfFormalArgType()), constraint.isFormalArgTypeWithinHierarchy() ? 1 : 0, inactiveTextColor));
            }
            if (StringUtil.isNotEmpty((String)constraint.getWithinConstraint())) {
                text = StringUtil.escapeXmlEntities((String)StringUtil.unquoteString((String)constraint.getWithinConstraint()));
                SubstitutionShortInfoHandler.append(buf, SSRBundle.message("within.constraints.tooltip.message", constraint.isInvertWithinConstraint() ? 1 : 0, text));
            }
            if (!"__context__".equals(name2 = constraint.getName())) {
                int maxCount = constraint.getMaxCount();
                int minCount = constraint.getMinCount();
                if (!newDialog || minCount != 1 || maxCount != 1) {
                    SubstitutionShortInfoHandler.append(buf, SSRBundle.message("min.occurs.tooltip.message", minCount, maxCount == Integer.MAX_VALUE ? "\u221e" : Integer.valueOf(maxCount)));
                }
            }
        }
        if ((script = namedScriptableDefinition.getScriptCodeConstraint()) != null && script.length() > 2) {
            text = "<pre><code>" + StringUtil.escapeXmlEntities((String)StringUtil.unquoteString((String)script)) + "</code></pre>";
            SubstitutionShortInfoHandler.append(buf, SSRBundle.message("script.tooltip.message", text));
        }
        if (buf.length() == 0 && !editLink) {
            buf.append(SSRBundle.message(!newDialog ? "no.constraints.specified.tooltip.message" : "no.filters.tooltip.message", new Object[0]));
        }
        if (editLink && newDialog) {
            if (buf.length() > 0) {
                buf.append("<br>");
            }
            buf.append("<a style=\"color:").append(linkColor).append("\" href=\"#ssr_edit_filters/").append(namedScriptableDefinition.getName()).append("\">Edit filters</a>");
        }
        String string = buf.toString();
        if (string == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static void append(StringBuilder buf, String str) {
        if (buf.length() > 0) {
            buf.append(", ");
        }
        buf.append(str);
    }

    private static void showTooltip(@NotNull Editor editor, int start, int end, @NotNull String text) {
        if (editor == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(6);
        }
        if (text == null) {
            SubstitutionShortInfoHandler.$$$reportNull$$$0(7);
        }
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        Point left = editor.logicalPositionToXY(editor.offsetToLogicalPosition(start));
        int documentLength = editor.getDocument().getTextLength();
        if (end >= documentLength) {
            end = documentLength;
        }
        Point right = editor.logicalPositionToXY(editor.offsetToLogicalPosition(end));
        Point bestPoint = new Point(left.x + (right.x - left.x) / 2, right.y + editor.getLineHeight() / 2);
        if (visibleArea.x > bestPoint.x) {
            bestPoint.x = visibleArea.x;
        } else if (visibleArea.x + visibleArea.width < bestPoint.x) {
            bestPoint.x = visibleArea.x + visibleArea.width - 5;
        }
        Point p = SwingUtilities.convertPoint(editor.getContentComponent(), bestPoint, editor.getComponent().getRootPane().getLayeredPane());
        HintHint hint = new HintHint(editor, bestPoint).setAwtTooltip(true).setShowImmediately(true);
        TooltipController.getInstance().showTooltip(editor, p, text, visibleArea.width, false, SS_INFO_TOOLTIP_GROUP, hint);
    }

    static SubstitutionShortInfoHandler retrieve(Editor editor) {
        return (SubstitutionShortInfoHandler)editor.getUserData(LISTENER_KEY);
    }

    static void install(Editor editor, @Nullable Consumer<? super String> currentVariableCallback) {
        SubstitutionShortInfoHandler handler = new SubstitutionShortInfoHandler(editor, currentVariableCallback);
        editor.addEditorMouseMotionListener((EditorMouseMotionListener)handler);
        editor.getDocument().addDocumentListener((DocumentListener)handler);
        editor.getCaretModel().addCaretListener((CaretListener)handler);
        editor.putUserData(LISTENER_KEY, (Object)handler);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/SubstitutionShortInfoHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/SubstitutionShortInfoHandler";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortParamString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "mouseMoved";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "caretPositionChanged";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "documentChanged";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showTooltip";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

