/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class StringToConstraintsTransformer {
    @NonNls
    private static final String REF = "ref";
    @NonNls
    private static final String REGEX = "regex";
    @NonNls
    private static final String REGEXW = "regexw";
    @NonNls
    private static final String EXPRTYPE = "exprtype";
    @NonNls
    private static final String FORMAL = "formal";
    @NonNls
    private static final String SCRIPT = "script";
    @NonNls
    private static final String CONTAINS = "contains";
    @NonNls
    private static final String WITHIN = "within";
    private static final Set<String> knownOptions = ContainerUtil.set((Object[])new String[]{"ref", "regex", "regexw", "exprtype", "formal", "script", "contains", "within"});

    public static void transformCriteria(@NotNull String criteria, MatchOptions options) {
        if (criteria == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(0);
        }
        StringBuilder pattern = new StringBuilder();
        int anonymousTypedVarsCount = 0;
        boolean targetFound = false;
        MatchVariableConstraint context = new MatchVariableConstraint();
        context.setName("__context__");
        options.addVariableConstraint(context);
        int length = criteria.length();
        for (int index = 0; index < length; ++index) {
            char ch = criteria.charAt(index);
            if (index == 0 && ch == '[') {
                index = StringToConstraintsTransformer.handleTypedVarCondition(0, criteria, options.getVariableConstraint("__context__"));
                if (index == length) break;
                ch = criteria.charAt(index);
            }
            if (ch == '\\' && index + 1 < length) {
                ch = criteria.charAt(++index);
            } else if (ch == '\'') {
                String typedVar;
                int endIndex;
                int newIndex = StringToConstraintsTransformer.handleCharacterLiteral(criteria, index, pattern);
                if (newIndex != index) {
                    index = newIndex;
                    continue;
                }
                for (endIndex = ++index; endIndex < length && Character.isJavaIdentifierPart(criteria.charAt(endIndex)); ++endIndex) {
                }
                if (endIndex == index) {
                    throw new MalformedPatternException(SSRBundle.message("error.expected.character", new Object[0]));
                }
                boolean target = true;
                if (criteria.charAt(index) == '_') {
                    target = false;
                    typedVar = endIndex == index + 1 ? "_" + ++anonymousTypedVarsCount : criteria.substring(index + 1, endIndex);
                } else {
                    typedVar = criteria.substring(index, endIndex);
                }
                pattern.append("$").append(typedVar).append("$");
                index = endIndex;
                MatchVariableConstraint constraint = options.getVariableConstraint(typedVar);
                boolean constraintCreated = false;
                if (constraint == null) {
                    constraint = new MatchVariableConstraint();
                    constraint.setName(typedVar);
                    constraintCreated = true;
                }
                int savedIndex = index;
                int minOccurs = 1;
                int maxOccurs = 1;
                boolean greedy = true;
                if (index < length) {
                    ch = criteria.charAt(index);
                    if (ch == '+') {
                        maxOccurs = Integer.MAX_VALUE;
                        ++index;
                    } else if (ch == '?') {
                        minOccurs = 0;
                        ++index;
                    } else if (ch == '*') {
                        minOccurs = 0;
                        maxOccurs = Integer.MAX_VALUE;
                        ++index;
                    } else if (ch == '{') {
                        ++index;
                        minOccurs = -1;
                        maxOccurs = -1;
                        while (index < length && (ch = criteria.charAt(index)) >= '0' && ch <= '9') {
                            if (minOccurs < 0) {
                                minOccurs = 0;
                            }
                            if ((minOccurs = minOccurs * 10 + (ch - 48)) < 0) {
                                throw new MalformedPatternException(SSRBundle.message("error.overflow", new Object[0]));
                            }
                            ++index;
                        }
                        if (ch == ',') {
                            ++index;
                            while (index < length && (ch = criteria.charAt(index)) >= '0' && ch <= '9') {
                                if (maxOccurs < 0) {
                                    maxOccurs = 0;
                                }
                                if ((maxOccurs = maxOccurs * 10 + (ch - 48)) < 0) {
                                    throw new MalformedPatternException(SSRBundle.message("error.overflow", new Object[0]));
                                }
                                ++index;
                            }
                        } else {
                            maxOccurs = -2;
                        }
                        if (ch != '}') {
                            if (minOccurs < 0 && maxOccurs < 0) {
                                throw new MalformedPatternException(SSRBundle.message("error.expected.digit", new Object[0]));
                            }
                            if (maxOccurs < 0) {
                                throw new MalformedPatternException(SSRBundle.message("error.expected.brace1", new Object[0]));
                            }
                            throw new MalformedPatternException(SSRBundle.message("error.expected.brace2", new Object[0]));
                        }
                        if (minOccurs < 0 && maxOccurs < 0) {
                            throw new MalformedPatternException(SSRBundle.message("error.empty.quantifier", new Object[0]));
                        }
                        if (minOccurs == -1) {
                            minOccurs = 0;
                        } else if (maxOccurs == -1) {
                            maxOccurs = Integer.MAX_VALUE;
                        } else if (maxOccurs == -2) {
                            maxOccurs = minOccurs;
                        }
                        ++index;
                    }
                    if (index < length && (ch = criteria.charAt(index)) == '?') {
                        greedy = false;
                        ++index;
                    }
                }
                if (constraintCreated) {
                    constraint.setMinCount(minOccurs);
                    constraint.setMaxCount(maxOccurs);
                    constraint.setGreedy(greedy);
                    constraint.setPartOfSearchResults(target);
                    if (targetFound && target) {
                        throw new MalformedPatternException(SSRBundle.message("error.only.one.target.allowed", new Object[0]));
                    }
                    targetFound |= target;
                } else if (savedIndex != index) {
                    throw new MalformedPatternException(SSRBundle.message("error.condition.only.on.first.variable.reference", new Object[0]));
                }
                if (index < length && criteria.charAt(index) == ':') {
                    if (++index >= length) {
                        throw new MalformedPatternException(SSRBundle.message("error.expected.condition", ":"));
                    }
                    ch = criteria.charAt(index);
                    if (ch == ':') {
                        pattern.append(ch);
                    } else {
                        if (!constraintCreated) {
                            throw new MalformedPatternException(SSRBundle.message("error.condition.only.on.first.variable.reference", new Object[0]));
                        }
                        index = StringToConstraintsTransformer.handleTypedVarCondition(index, criteria, constraint);
                    }
                }
                if (constraintCreated) {
                    options.addVariableConstraint(constraint);
                }
                if (index == length) break;
                --index;
                continue;
            }
            pattern.append(ch);
        }
        options.setSearchPattern(pattern.toString());
    }

    public static int handleCharacterLiteral(String criteria, int index, StringBuilder pattern) {
        int length = criteria.length();
        if (index + 1 < length && criteria.charAt(index + 1) == '\'') {
            pattern.append('\'');
            return index + 1;
        }
        if (index + 2 < length && criteria.charAt(index + 2) == '\'') {
            pattern.append(criteria, index, index + 3);
            return index + 2;
        }
        if (index + 3 < length && criteria.charAt(index + 1) == '\\' && criteria.charAt(index + 3) == '\'') {
            pattern.append(criteria, index, index + 4);
            return index + 3;
        }
        if (index + 7 < length && criteria.charAt(index + 1) == '\\' && criteria.charAt(index + 2) == 'u' && criteria.charAt(index + 7) == '\'') {
            pattern.append(criteria, index, index + 8);
            return index + 7;
        }
        return index;
    }

    private static int handleTypedVarCondition(int index, String criteria, MatchVariableConstraint constraint) {
        int length = criteria.length();
        char ch = criteria.charAt(index);
        if (ch == '!') {
            constraint.setInvertRegExp(true);
            if (++index >= length) {
                throw new MalformedPatternException(SSRBundle.message("error.expected.condition", Character.valueOf(ch)));
            }
            ch = criteria.charAt(index);
        }
        if (ch == '+' || ch == '*') {
            switch (ch) {
                case '+': {
                    constraint.setStrictlyWithinHierarchy(true);
                    break;
                }
                case '*': {
                    constraint.setWithinHierarchy(true);
                }
            }
            if (++index >= length) {
                throw new MalformedPatternException(SSRBundle.message("error.expected.condition", Character.valueOf(ch)));
            }
            ch = criteria.charAt(index);
        }
        if (ch == '[') {
            boolean quoted = false;
            int endIndex = index++;
            while (++endIndex < length) {
                if (criteria.charAt(endIndex - 1) == '\\') continue;
                ch = criteria.charAt(endIndex);
                if (ch == '\"') {
                    quoted = !quoted;
                    continue;
                }
                if (ch != ']' || quoted) continue;
            }
            if (quoted) {
                throw new MalformedPatternException(SSRBundle.message("error.expected.value", "\""));
            }
            if (ch != ']') {
                throw new MalformedPatternException(SSRBundle.message("error.expected.value", "]"));
            }
            StringToConstraintsTransformer.parseCondition(constraint, criteria.substring(index, endIndex));
            return endIndex + 1;
        }
        return StringToConstraintsTransformer.handleRegExp(index, criteria, constraint);
    }

    private static int handleRegExp(int index, String criteria, MatchVariableConstraint constraint) {
        int endIndex;
        int length = criteria.length();
        for (endIndex = index; endIndex < length && !Character.isWhitespace(criteria.charAt(endIndex)); ++endIndex) {
        }
        if (endIndex == index) {
            if (criteria.charAt(index - 1) == ':') {
                throw new MalformedPatternException(SSRBundle.message("error.expected.condition", ":"));
            }
            return endIndex;
        }
        String regexp = criteria.substring(index, endIndex);
        if (!constraint.getRegExp().isEmpty() && !constraint.getRegExp().equals(regexp)) {
            throw new MalformedPatternException(SSRBundle.message("error.two.different.type.constraints", new Object[0]));
        }
        StringToConstraintsTransformer.checkRegex(regexp);
        constraint.setRegExp(regexp);
        return endIndex;
    }

    private static void parseCondition(MatchVariableConstraint constraint, String condition) {
        int length = condition.length();
        StringBuilder text = new StringBuilder();
        boolean invert = false;
        boolean optionExpected = true;
        for (int i = 0; i < length; ++i) {
            char c = condition.charAt(i);
            if (Character.isWhitespace(c)) {
                if (text.length() == 0) continue;
                StringToConstraintsTransformer.handleOption(constraint, text.toString(), "", invert);
                optionExpected = false;
                continue;
            }
            if (c == '(') {
                if (text.length() == 0) {
                    throw new MalformedPatternException(SSRBundle.message("error.expected.condition.name", new Object[0]));
                }
                String option = text.toString();
                if (!knownOptions.contains(option)) {
                    throw new MalformedPatternException(SSRBundle.message("option.is.not.recognized.error.message", option));
                }
                text.setLength(0);
                int spaces = 0;
                while (++i < length && condition.charAt(i) == ' ') {
                    ++spaces;
                }
                --i;
                boolean quoted = false;
                boolean closed = false;
                while (++i < length) {
                    c = condition.charAt(i);
                    if (condition.charAt(i - 1) != '\\') {
                        if (c == '\"') {
                            quoted = !quoted;
                        } else if (c == ')' && !quoted) {
                            int j;
                            for (j = 1; j <= spaces && condition.charAt(i - j) == ' '; ++j) {
                            }
                            if (j - 1 == spaces) {
                                closed = true;
                                break;
                            }
                        }
                    }
                    text.append(c);
                }
                if (text.length() == 0) {
                    throw new MalformedPatternException(SSRBundle.message("error.argument.expected", option));
                }
                if (quoted) {
                    throw new MalformedPatternException(SSRBundle.message("error.expected.value", "\""));
                }
                if (!closed) {
                    throw new MalformedPatternException(SSRBundle.message("error.expected.value", StringUtil.repeatSymbol((char)' ', (int)spaces) + ")"));
                }
                StringToConstraintsTransformer.handleOption(constraint, option, text.toString(), invert);
                text.setLength(0);
                invert = false;
                optionExpected = false;
                continue;
            }
            if (c == '&') {
                if (text.length() != 0) {
                    StringToConstraintsTransformer.handleOption(constraint, text.toString(), "", invert);
                    optionExpected = false;
                }
                if (++i == length || condition.charAt(i) != '&' || optionExpected) {
                    throw new MalformedPatternException(SSRBundle.message("error.unexpected.value", "&"));
                }
                text.setLength(0);
                invert = false;
                optionExpected = true;
                continue;
            }
            if (!optionExpected) {
                throw new MalformedPatternException(SSRBundle.message("error.expected.value", "&&"));
            }
            if (c == '!') {
                if (text.length() != 0) {
                    throw new MalformedPatternException(SSRBundle.message("error.unexpected.value", "!"));
                }
                invert = !invert;
                continue;
            }
            text.append(c);
        }
        if (text.length() != 0) {
            StringToConstraintsTransformer.handleOption(constraint, text.toString(), "", invert);
        } else {
            if (invert) {
                throw new MalformedPatternException(SSRBundle.message("error.expected.condition", "!"));
            }
            if (optionExpected) {
                throw new MalformedPatternException(SSRBundle.message("error.expected.condition", length == 0 ? "[" : "&&"));
            }
        }
    }

    private static void handleOption(@NotNull MatchVariableConstraint constraint, @NotNull String option, @NotNull String argument, boolean invert) {
        if (constraint == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(1);
        }
        if (option == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(2);
        }
        if (argument == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(3);
        }
        argument = argument.trim();
        if (option.equalsIgnoreCase(REF)) {
            constraint.setReferenceConstraint(argument);
            constraint.setInvertReference(invert);
        } else if (option.equalsIgnoreCase(REGEX) || option.equalsIgnoreCase(REGEXW)) {
            if (argument.charAt(0) == '*') {
                argument = argument.substring(1);
                constraint.setWithinHierarchy(true);
            }
            StringToConstraintsTransformer.checkRegex(argument);
            constraint.setRegExp(argument);
            constraint.setInvertRegExp(invert);
            if (option.equalsIgnoreCase(REGEXW)) {
                constraint.setWholeWordsOnly(true);
            }
        } else if (option.equalsIgnoreCase(EXPRTYPE)) {
            if (argument.charAt(0) == '*') {
                argument = argument.substring(1);
                constraint.setExprTypeWithinHierarchy(true);
            }
            if (Registry.is((String)"ssr.use.regexp.to.specify.type")) {
                StringToConstraintsTransformer.checkRegex(argument);
            } else {
                argument = StringToConstraintsTransformer.unescape(argument);
            }
            constraint.setNameOfExprType(argument);
            constraint.setInvertExprType(invert);
        } else if (option.equalsIgnoreCase(FORMAL)) {
            if (argument.charAt(0) == '*') {
                argument = argument.substring(1);
                constraint.setFormalArgTypeWithinHierarchy(true);
            }
            if (Registry.is((String)"ssr.use.regexp.to.specify.type")) {
                StringToConstraintsTransformer.checkRegex(argument);
            } else {
                argument = StringToConstraintsTransformer.unescape(argument);
            }
            constraint.setNameOfFormalArgType(argument);
            constraint.setInvertFormalType(invert);
        } else if (option.equalsIgnoreCase(SCRIPT)) {
            if (invert) {
                throw new MalformedPatternException(SSRBundle.message("error.cannot.invert", option));
            }
            constraint.setScriptCodeConstraint(argument);
        } else if (option.equalsIgnoreCase(CONTAINS)) {
            constraint.setContainsConstraint(argument);
            constraint.setInvertContainsConstraint(invert);
        } else if (option.equalsIgnoreCase(WITHIN)) {
            if (!"__context__".equals(constraint.getName())) {
                throw new MalformedPatternException(SSRBundle.message("error.only.applicable.to.complete.match", option));
            }
            constraint.setWithinConstraint(argument);
            constraint.setInvertWithinConstraint(invert);
        } else assert (false);
    }

    private static void checkRegex(@NotNull String regex) {
        if (regex == null) {
            StringToConstraintsTransformer.$$$reportNull$$$0(4);
        }
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new MalformedPatternException(SSRBundle.message("invalid.regular.expression", e.getMessage()));
        }
    }

    private static String unescape(String s) {
        StringBuilder result = new StringBuilder();
        boolean escaped = false;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            int c = s.codePointAt(i);
            if (c == 92 && !escaped) {
                escaped = true;
                continue;
            }
            escaped = false;
            result.appendCodePoint(c);
        }
        return result.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "criteria";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = REGEX;
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/compiler/StringToConstraintsTransformer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "transformCriteria";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "handleOption";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRegex";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

