/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.UnsupportedPatternException;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.compiler.GlobalCompilingVisitor;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementBuilder;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StructuralSearchProfile {
    public static final ExtensionPointName<StructuralSearchProfile> EP_NAME = ExtensionPointName.create((String)"com.intellij.structuralsearch.profile");

    public abstract void compile(PsiElement[] var1, @NotNull GlobalCompilingVisitor var2);

    @NotNull
    public abstract PsiElementVisitor createMatchingVisitor(@NotNull GlobalMatchingVisitor var1);

    @NotNull
    public abstract NodeFilter getLexicalNodesFilter();

    @NotNull
    public abstract CompiledPattern createCompiledPattern();

    public List<MatchPredicate> getCustomPredicates(MatchVariableConstraint constraint, String name2, MatchOptions options) {
        return Collections.emptyList();
    }

    public abstract boolean isMyLanguage(@NotNull Language var1);

    @NotNull
    public PsiElement[] createPatternTree(@NotNull String text, @NotNull PatternTreeContext context, @NotNull FileType fileType, @Nullable Language language, @Nullable String contextName, @Nullable String extension, @NotNull Project project2, boolean physical) {
        if (text == null) {
            StructuralSearchProfile.$$$reportNull$$$0(0);
        }
        if (context == null) {
            StructuralSearchProfile.$$$reportNull$$$0(1);
        }
        if (fileType == null) {
            StructuralSearchProfile.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(3);
        }
        String ext = extension != null ? extension : fileType.getDefaultExtension();
        String name2 = "__dummy." + ext;
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project2);
        PsiFile file = language == null ? factory.createFileFromText(name2, fileType, (CharSequence)text, LocalTimeCounter.currentTime(), physical, true) : factory.createFileFromText(name2, language, (CharSequence)text, physical, true);
        PsiElement[] psiElementArray = file != null ? file.getChildren() : PsiElement.EMPTY_ARRAY;
        if (psiElementArray == null) {
            StructuralSearchProfile.$$$reportNull$$$0(4);
        }
        return psiElementArray;
    }

    @NotNull
    public PsiElement[] createPatternTree(@NotNull String text, @NotNull PatternTreeContext context, @NotNull FileType fileType, @NotNull Project project2, boolean physical) {
        if (text == null) {
            StructuralSearchProfile.$$$reportNull$$$0(5);
        }
        if (context == null) {
            StructuralSearchProfile.$$$reportNull$$$0(6);
        }
        if (fileType == null) {
            StructuralSearchProfile.$$$reportNull$$$0(7);
        }
        if (project2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(8);
        }
        PsiElement[] psiElementArray = this.createPatternTree(text, context, fileType, null, null, null, project2, physical);
        if (psiElementArray == null) {
            StructuralSearchProfile.$$$reportNull$$$0(9);
        }
        return psiElementArray;
    }

    @NotNull
    public Document createDocument(@NotNull Project project2, @NotNull FileType fileType, Language dialect, String text) {
        PsiCodeFragment codeFragment;
        if (project2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(10);
        }
        if (fileType == null) {
            StructuralSearchProfile.$$$reportNull$$$0(11);
        }
        if ((codeFragment = this.createCodeFragment(project2, text, null)) == null) {
            codeFragment = StructuralSearchProfile.createFileFragment(project2, fileType, dialect, text);
        }
        if (codeFragment != null) {
            Document doc = PsiDocumentManager.getInstance((Project)project2).getDocument((PsiFile)codeFragment);
            assert (doc != null) : "code fragment element should be physical";
            Document document = doc;
            if (document == null) {
                StructuralSearchProfile.$$$reportNull$$$0(12);
            }
            return document;
        }
        Document document = EditorFactory.getInstance().createDocument((CharSequence)text);
        if (document == null) {
            StructuralSearchProfile.$$$reportNull$$$0(13);
        }
        return document;
    }

    @NotNull
    public Editor createEditor(@NotNull Project project2, @NotNull FileType fileType, Language dialect, String text) {
        PsiCodeFragment codeFragment;
        if (project2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(14);
        }
        if (fileType == null) {
            StructuralSearchProfile.$$$reportNull$$$0(15);
        }
        if ((codeFragment = this.createCodeFragment(project2, text, null)) == null) {
            codeFragment = StructuralSearchProfile.createFileFragment(project2, fileType, dialect, text);
        }
        if (codeFragment != null) {
            Document doc = PsiDocumentManager.getInstance((Project)project2).getDocument((PsiFile)codeFragment);
            assert (doc != null) : "code fragment element should be physical";
            DaemonCodeAnalyzer.getInstance((Project)project2).setHighlightingEnabled((PsiFile)codeFragment, false);
            Editor editor = UIUtil.createEditor(doc, project2, true, true, this.getTemplateContextType());
            if (editor == null) {
                StructuralSearchProfile.$$$reportNull$$$0(16);
            }
            return editor;
        }
        EditorFactory factory = EditorFactory.getInstance();
        Document document = factory.createDocument((CharSequence)text);
        EditorEx editor = (EditorEx)factory.createEditor(document, project2);
        editor.getSettings().setFoldingOutlineShown(false);
        EditorEx editorEx = editor;
        if (editorEx == null) {
            StructuralSearchProfile.$$$reportNull$$$0(17);
        }
        return editorEx;
    }

    private static PsiFile createFileFragment(Project project2, FileType fileType, Language dialect, String text) {
        String name2 = "__dummy." + fileType.getDefaultExtension();
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project2);
        return dialect == null ? factory.createFileFromText(name2, fileType, (CharSequence)text, LocalTimeCounter.currentTime(), true, true) : factory.createFileFromText(name2, dialect, (CharSequence)text, true, true);
    }

    @Nullable
    public PsiCodeFragment createCodeFragment(Project project2, String text, @Nullable PsiElement context) {
        return null;
    }

    @NotNull
    public abstract Class<? extends TemplateContextType> getTemplateContextTypeClass();

    public final TemplateContextType getTemplateContextType() {
        Class<? extends TemplateContextType> clazz = this.getTemplateContextTypeClass();
        return (TemplateContextType)ContainerUtil.findInstance((Object[])TemplateContextType.EP_NAME.getExtensions(), clazz);
    }

    @Nullable
    public FileType detectFileType(@NotNull PsiElement context) {
        if (context == null) {
            StructuralSearchProfile.$$$reportNull$$$0(18);
        }
        return null;
    }

    @Nullable
    public StructuralReplaceHandler getReplaceHandler(@NotNull Project project2, @NotNull ReplaceOptions replaceOptions) {
        if (project2 == null) {
            StructuralSearchProfile.$$$reportNull$$$0(19);
        }
        if (replaceOptions == null) {
            StructuralSearchProfile.$$$reportNull$$$0(20);
        }
        return null;
    }

    public void checkSearchPattern(CompiledPattern pattern) {
    }

    public void checkReplacementPattern(Project project2, ReplaceOptions options) {
        String fileType = options.getMatchOptions().getFileType().getName().toLowerCase();
        throw new UnsupportedPatternException(SSRBundle.message("replacement.not.supported.for.filetype", fileType));
    }

    public boolean canBeVarDelimeter(@NotNull PsiElement element) {
        if (element == null) {
            StructuralSearchProfile.$$$reportNull$$$0(21);
        }
        return false;
    }

    public String getText(PsiElement match, int start, int end) {
        String matchText = match.getText();
        if (start == 0 && end == -1) {
            return matchText;
        }
        return matchText.substring(start, end == -1 ? matchText.length() : end);
    }

    @NotNull
    public String getTypedVarString(PsiElement element) {
        String name2;
        if (element instanceof PsiNamedElement && (name2 = ((PsiNamedElement)element).getName()) != null) {
            String string = name2;
            if (string == null) {
                StructuralSearchProfile.$$$reportNull$$$0(22);
            }
            return string;
        }
        String string = element.getText();
        if (string == null) {
            StructuralSearchProfile.$$$reportNull$$$0(23);
        }
        return string;
    }

    public String getMeaningfulText(PsiElement element) {
        return this.getTypedVarString(element);
    }

    public String getAlternativeText(PsiElement element, String previousText) {
        return null;
    }

    public PsiElement updateCurrentNode(PsiElement node) {
        return node;
    }

    public PsiElement extendMatchedByDownUp(PsiElement node) {
        return node;
    }

    public PsiElement extendMatchOnePsiFile(PsiElement file) {
        return file;
    }

    public LanguageFileType getDefaultFileType(@Nullable LanguageFileType fileType) {
        return fileType;
    }

    public Configuration[] getPredefinedTemplates() {
        return Configuration.EMPTY_ARRAY;
    }

    public void provideAdditionalReplaceOptions(@NotNull PsiElement node, ReplaceOptions options, ReplacementBuilder builder) {
        if (node == null) {
            StructuralSearchProfile.$$$reportNull$$$0(24);
        }
    }

    public int handleSubstitution(ParameterInfo info, MatchResult match, StringBuilder result, int offset, ReplacementInfo replacementInfo) {
        if (info.getName().equals(match.getName())) {
            String replacementString;
            boolean removeSemicolon = false;
            if (match.hasChildren() && !match.isScopeMatch()) {
                StringBuilder buf = new StringBuilder();
                for (MatchResult matchResult : match.getChildren()) {
                    PsiElement currentElement = matchResult.getMatch();
                    if (buf.length() > 0) {
                        if (info.isArgumentContext()) {
                            buf.append(',');
                        } else {
                            PsiElement sibling = currentElement.getPrevSibling();
                            buf.append(sibling instanceof PsiWhiteSpace ? sibling.getText() : " ");
                        }
                    }
                    buf.append(matchResult.getMatchImage());
                    removeSemicolon = currentElement instanceof PsiComment;
                }
                replacementString = buf.toString();
            } else {
                if (info.isStatementContext()) {
                    removeSemicolon = match.getMatch() instanceof PsiComment;
                }
                replacementString = match.getMatchImage();
            }
            offset = Replacer.insertSubstitution(result, offset, info, replacementString);
            if (info.isStatementContext() && (removeSemicolon || StringUtil.endsWithChar((CharSequence)replacementString, (char)';') || StringUtil.endsWithChar((CharSequence)replacementString, (char)'}'))) {
                int start = info.getStartIndex() + offset;
                result.delete(start, start + 1);
                --offset;
            }
        }
        return offset;
    }

    public int handleNoSubstitution(ParameterInfo info, int offset, StringBuilder result) {
        if (info.isHasCommaBefore()) {
            result.delete(info.getBeforeDelimiterPos() + offset, info.getBeforeDelimiterPos() + 1 + offset);
            --offset;
        } else if (info.isHasCommaAfter()) {
            result.delete(info.getAfterDelimiterPos() + offset, info.getAfterDelimiterPos() + 1 + offset);
            --offset;
        }
        return offset;
    }

    @Contract(value="null -> false")
    public boolean isIdentifier(@Nullable PsiElement element) {
        return false;
    }

    @NotNull
    public Collection<String> getReservedWords() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            StructuralSearchProfile.$$$reportNull$$$0(25);
        }
        return set;
    }

    public boolean isDocCommentOwner(PsiElement match) {
        return false;
    }

    @Contract(value="!null -> !null")
    public PsiElement getPresentableElement(PsiElement element) {
        return this.isIdentifier(element) ? element.getParent() : element;
    }

    public boolean isApplicableConstraint(String constraintName, @Nullable PsiElement variableNode, boolean completePattern, boolean target) {
        switch (constraintName) {
            case "MINIMUM ZERO": {
                if (target) {
                    return false;
                }
            }
            case "MAXIMUM UNLIMITED": 
            case "TEXT": 
            case "REFERENCE": {
                return !completePattern;
            }
        }
        return false;
    }

    public final boolean isApplicableConstraint(String constraintName, List<? extends PsiElement> nodes, boolean completePattern, boolean target) {
        if (nodes.isEmpty()) {
            return this.isApplicableConstraint(constraintName, (PsiElement)null, completePattern, target);
        }
        boolean result = true;
        for (PsiElement psiElement : nodes) {
            result &= this.isApplicableConstraint(constraintName, psiElement, completePattern, target);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/StructuralSearchProfile";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceOptions";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/StructuralSearchProfile";
                break;
            }
            case 4: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createPatternTree";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypedVarString";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getReservedWords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPatternTree";
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 25: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "detectFileType";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getReplaceHandler";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "canBeVarDelimeter";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "provideAdditionalReplaceOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

