/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableTypeFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.ChangeVariableTypeQuickFixProvider;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.typeMigration.TypeMigrationProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeMigrationVariableTypeFixProvider
implements ChangeVariableTypeQuickFixProvider {
    private static final Logger LOG1 = Logger.getInstance(TypeMigrationVariableTypeFixProvider.class);

    @NotNull
    public IntentionAction[] getFixes(@NotNull PsiVariable variable, @NotNull PsiType toReturn) {
        if (variable == null) {
            TypeMigrationVariableTypeFixProvider.$$$reportNull$$$0(0);
        }
        if (toReturn == null) {
            TypeMigrationVariableTypeFixProvider.$$$reportNull$$$0(1);
        }
        IntentionAction[] intentionActionArray = new IntentionAction[]{TypeMigrationVariableTypeFixProvider.createTypeMigrationFix(variable, toReturn)};
        if (intentionActionArray == null) {
            TypeMigrationVariableTypeFixProvider.$$$reportNull$$$0(2);
        }
        return intentionActionArray;
    }

    @NotNull
    public static VariableTypeFix createTypeMigrationFix(@NotNull PsiVariable variable, @NotNull PsiType toReturn) {
        if (variable == null) {
            TypeMigrationVariableTypeFixProvider.$$$reportNull$$$0(3);
        }
        if (toReturn == null) {
            TypeMigrationVariableTypeFixProvider.$$$reportNull$$$0(4);
        }
        VariableTypeFix variableTypeFix = TypeMigrationVariableTypeFixProvider.createTypeMigrationFix(variable, toReturn, false);
        if (variableTypeFix == null) {
            TypeMigrationVariableTypeFixProvider.$$$reportNull$$$0(5);
        }
        return variableTypeFix;
    }

    @NotNull
    public static VariableTypeFix createTypeMigrationFix(@NotNull PsiVariable variable, @NotNull PsiType toReturn, final boolean optimizeImports) {
        if (variable == null) {
            TypeMigrationVariableTypeFixProvider.$$$reportNull$$$0(6);
        }
        if (toReturn == null) {
            TypeMigrationVariableTypeFixProvider.$$$reportNull$$$0(7);
        }
        VariableTypeFix variableTypeFix = new VariableTypeFix(variable, toReturn){

            @NotNull
            public String getText() {
                String string = "Migrate '" + this.myName + "' type to '" + this.getReturnType().getCanonicalText() + "'";
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void invoke(@NotNull Project project2, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (file == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (startElement == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (endElement == null) {
                    1.$$$reportNull$$$0(4);
                }
                TypeMigrationVariableTypeFixProvider.runTypeMigrationOnVariable((PsiVariable)startElement, this.getReturnType(), editor, optimizeImports, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "startElement";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "endElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (variableTypeFix == null) {
            TypeMigrationVariableTypeFixProvider.$$$reportNull$$$0(8);
        }
        return variableTypeFix;
    }

    public static void runTypeMigrationOnVariable(@NotNull PsiVariable variable, @NotNull PsiType targetType, @Nullable(value="is null when called from inspection") Editor editor, boolean optimizeImports, boolean allowDependentRoots) {
        if (variable == null) {
            TypeMigrationVariableTypeFixProvider.$$$reportNull$$$0(9);
        }
        if (targetType == null) {
            TypeMigrationVariableTypeFixProvider.$$$reportNull$$$0(10);
        }
        Project project2 = variable.getProject();
        if (!FileModificationService.getInstance().prepareFileForWrite(variable.getContainingFile())) {
            return;
        }
        try {
            WriteAction.run(() -> variable.normalizeDeclaration());
            TypeMigrationRules rules = new TypeMigrationRules(project2);
            rules.setBoundScope((SearchScope)GlobalSearchScope.projectScope((Project)project2));
            TypeMigrationProcessor.runHighlightingTypeMigration((Project)project2, (Editor)editor, (TypeMigrationRules)rules, (PsiElement)variable, (PsiType)targetType, (boolean)optimizeImports, (boolean)allowDependentRoots);
            WriteAction.run(() -> JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)variable));
            UndoUtil.markPsiFileForUndo((PsiFile)variable.getContainingFile());
        }
        catch (IncorrectOperationException e) {
            LOG1.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReturn";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeMigrationFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFixes";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTypeMigrationFix";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runTypeMigrationOnVariable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

