/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibraryConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ConfigurationErrorQuickFix;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructureBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LibraryProjectStructureElement
extends ProjectStructureElement {
    private final Library myLibrary;

    public LibraryProjectStructureElement(@NotNull StructureConfigurableContext context, @NotNull Library library) {
        if (context == null) {
            LibraryProjectStructureElement.$$$reportNull$$$0(0);
        }
        if (library == null) {
            LibraryProjectStructureElement.$$$reportNull$$$0(1);
        }
        super(context);
        this.myLibrary = library;
    }

    public Library getLibrary() {
        return this.myLibrary;
    }

    @Override
    public void check(ProjectStructureProblemsHolder problemsHolder) {
        if (((LibraryEx)this.myLibrary).isDisposed()) {
            return;
        }
        LibraryEx library = (LibraryEx)this.myContext.getLibraryModel(this.myLibrary);
        if (library == null || library.isDisposed()) {
            return;
        }
        this.reportInvalidRoots(problemsHolder, library, OrderRootType.CLASSES, "classes", ProjectStructureProblemType.error("library-invalid-classes-path"));
        String libraryName = library.getName();
        if (libraryName == null || !libraryName.startsWith("Maven: ")) {
            this.reportInvalidRoots(problemsHolder, library, OrderRootType.SOURCES, "sources", ProjectStructureProblemType.warning("library-invalid-source-javadoc-path"));
            this.reportInvalidRoots(problemsHolder, library, JavadocOrderRootType.getInstance(), "javadoc", ProjectStructureProblemType.warning("library-invalid-source-javadoc-path"));
        }
    }

    private void reportInvalidRoots(ProjectStructureProblemsHolder problemsHolder, LibraryEx library, @NotNull OrderRootType type, String rootName, ProjectStructureProblemType problemType) {
        List invalidUrls;
        if (type == null) {
            LibraryProjectStructureElement.$$$reportNull$$$0(2);
        }
        if (!(invalidUrls = library.getInvalidRootUrls(type)).isEmpty()) {
            String description = LibraryProjectStructureElement.createInvalidRootsDescription(invalidUrls, rootName, library.getName());
            PlaceInProjectStructure place = this.createPlace();
            String message = ProjectBundle.message((String)"project.roots.error.message.invalid.roots", (Object[])new Object[]{rootName, invalidUrls.size()});
            ProjectStructureProblemDescription.ProblemLevel level = library.getTable().getTableLevel().equals("project") ? ProjectStructureProblemDescription.ProblemLevel.PROJECT : ProjectStructureProblemDescription.ProblemLevel.GLOBAL;
            problemsHolder.registerProblem(new ProjectStructureProblemDescription(message, description, place, problemType, level, Collections.singletonList(new RemoveInvalidRootsQuickFix((Library)library, type, invalidUrls)), true));
        }
    }

    private static String createInvalidRootsDescription(List<String> invalidClasses, String rootName, String libraryName) {
        StringBuilder buffer = new StringBuilder();
        String name2 = StringUtil.escapeXmlEntities((String)libraryName);
        buffer.append("Library ");
        buffer.append("<a href='http://library/").append(name2).append("'>").append(name2).append("</a>");
        buffer.append(" has broken " + rootName + " " + StringUtil.pluralize((String)"path", (int)invalidClasses.size()) + ":");
        for (String url : invalidClasses) {
            buffer.append("<br>&nbsp;&nbsp;");
            buffer.append(PathUtil.toPresentableUrl((String)url));
        }
        return XmlStringUtil.wrapInHtml((CharSequence)buffer);
    }

    @NotNull
    private PlaceInProjectStructure createPlace() {
        Project project2 = this.myContext.getProject();
        PlaceInProjectStructureBase placeInProjectStructureBase = new PlaceInProjectStructureBase(project2, ProjectStructureConfigurable.getInstance(project2).createProjectOrGlobalLibraryPlace(this.myLibrary), this);
        if (placeInProjectStructureBase == null) {
            LibraryProjectStructureElement.$$$reportNull$$$0(3);
        }
        return placeInProjectStructureBase;
    }

    @Override
    public List<ProjectStructureElementUsage> getUsagesInElement() {
        return Collections.emptyList();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LibraryProjectStructureElement)) {
            return false;
        }
        return this.getSourceOrThis() == ((LibraryProjectStructureElement)o).getSourceOrThis();
    }

    public ActionCallback navigate() {
        return this.createPlace().navigate();
    }

    @NotNull
    private Library getSourceOrThis() {
        InvocationHandler invocationHandler = Proxy.isProxyClass(this.myLibrary.getClass()) ? Proxy.getInvocationHandler(this.myLibrary) : null;
        Library realLibrary = invocationHandler instanceof ModuleEditor.ProxyDelegateAccessor ? (Library)((ModuleEditor.ProxyDelegateAccessor)((Object)invocationHandler)).getDelegate() : this.myLibrary;
        Library source = realLibrary instanceof LibraryImpl ? ((LibraryImpl)realLibrary).getSource() : null;
        Library library = source != null ? source : this.myLibrary;
        if (library == null) {
            LibraryProjectStructureElement.$$$reportNull$$$0(4);
        }
        return library;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this.getSourceOrThis());
    }

    @Override
    public boolean shouldShowWarningIfUnused() {
        LibraryTable libraryTable = this.myLibrary.getTable();
        if (libraryTable == null) {
            return false;
        }
        return "project".equals(libraryTable.getTableLevel());
    }

    @Override
    public ProjectStructureProblemDescription createUnusedElementWarning() {
        List<ConfigurationErrorQuickFix> fixes = Arrays.asList(new AddLibraryToDependenciesFix(), new RemoveLibraryFix(), new RemoveAllUnusedLibrariesFix());
        String name2 = StringUtil.escapeXmlEntities((String)this.myLibrary.getName());
        String libraryName = "<a href='http://library/" + name2 + "'>" + name2 + "</a>";
        return new ProjectStructureProblemDescription(XmlStringUtil.wrapInHtml((CharSequence)("Library " + libraryName + " is not used")), null, this.createPlace(), ProjectStructureProblemType.unused("unused-library"), ProjectStructureProblemDescription.ProblemLevel.PROJECT, fixes, false);
    }

    @Override
    public String getPresentableName() {
        return this.myLibrary.getName();
    }

    @Override
    public String getTypeName() {
        return "Library";
    }

    @Override
    public String getId() {
        return "library:" + this.myLibrary.getTable().getTableLevel() + ":" + this.myLibrary.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/LibraryProjectStructureElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/LibraryProjectStructureElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createPlace";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceOrThis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reportInvalidRoots";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RemoveAllUnusedLibrariesFix
    extends ConfigurationErrorQuickFix {
        private RemoveAllUnusedLibrariesFix() {
            super("Remove All Unused Libraries");
        }

        @Override
        public void performFix() {
            BaseLibrariesConfigurable configurable = BaseLibrariesConfigurable.getInstance(LibraryProjectStructureElement.this.myContext.getProject(), "project");
            Library[] libraries2 = configurable.getModelProvider().getModifiableModel().getLibraries();
            ArrayList<LibraryProjectStructureElement> toRemove = new ArrayList<LibraryProjectStructureElement>();
            for (Library library : libraries2) {
                LibraryProjectStructureElement libraryElement = new LibraryProjectStructureElement(LibraryProjectStructureElement.this.myContext, library);
                if (!LibraryProjectStructureElement.this.myContext.getDaemonAnalyzer().getUsages(libraryElement).isEmpty()) continue;
                toRemove.add(libraryElement);
            }
            configurable.removeLibraries(toRemove);
        }
    }

    private class RemoveLibraryFix
    extends ConfigurationErrorQuickFix {
        private RemoveLibraryFix() {
            super("Remove Library");
        }

        @Override
        public void performFix() {
            BaseLibrariesConfigurable.getInstance(LibraryProjectStructureElement.this.myContext.getProject(), LibraryProjectStructureElement.this.myLibrary.getTable().getTableLevel()).removeLibrary(LibraryProjectStructureElement.this);
        }
    }

    private class AddLibraryToDependenciesFix
    extends ConfigurationErrorQuickFix {
        private AddLibraryToDependenciesFix() {
            super("Add to Dependencies...");
        }

        @Override
        public void performFix() {
            LibraryEditingUtil.showDialogAndAddLibraryToDependencies(LibraryProjectStructureElement.this.myLibrary, LibraryProjectStructureElement.this.myContext.getProject(), false);
        }
    }

    private class RemoveInvalidRootsQuickFix
    extends ConfigurationErrorQuickFix {
        private final Library myLibrary;
        private final OrderRootType myType;
        private final List<String> myInvalidUrls;

        RemoveInvalidRootsQuickFix(Library library, OrderRootType type, List<String> invalidUrls) {
            super("Remove invalid " + StringUtil.pluralize((String)"root", (int)invalidUrls.size()));
            this.myLibrary = library;
            this.myType = type;
            this.myInvalidUrls = invalidUrls;
        }

        @Override
        public void performFix() {
            LibraryTable.ModifiableModel libraryTable = LibraryProjectStructureElement.this.myContext.getModifiableLibraryTable(this.myLibrary.getTable());
            if (libraryTable instanceof LibrariesModifiableModel) {
                for (String invalidRoot : this.myInvalidUrls) {
                    ExistingLibraryEditor libraryEditor = ((LibrariesModifiableModel)libraryTable).getLibraryEditor(this.myLibrary);
                    libraryEditor.removeRoot(invalidRoot, this.myType);
                }
                LibraryProjectStructureElement.this.myContext.getDaemonAnalyzer().queueUpdate(LibraryProjectStructureElement.this);
                ProjectStructureConfigurable structureConfigurable = ProjectStructureConfigurable.getInstance(LibraryProjectStructureElement.this.myContext.getProject());
                LibraryProjectStructureElement.this.navigate().doWhenDone(() -> {
                    NamedConfigurable configurable = structureConfigurable.getConfigurableFor(this.myLibrary).getSelectedConfigurable();
                    if (configurable instanceof LibraryConfigurable) {
                        ((LibraryConfigurable)configurable).updateComponent();
                    }
                });
            }
        }
    }
}

