/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.classpath.AddItemPopupAction;
import com.intellij.openapi.roots.ui.configuration.classpath.AddLibraryDependencyAction;
import com.intellij.openapi.roots.ui.configuration.classpath.AddModuleDependencyAction;
import com.intellij.openapi.roots.ui.configuration.classpath.AddNewModuleLibraryAction;
import com.intellij.openapi.roots.ui.configuration.classpath.AnalyzeModuleDependencyAction;
import com.intellij.openapi.roots.ui.configuration.classpath.ChangeLibraryLevelInClasspathAction;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanelAction;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathTableItem;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathTableModel;
import com.intellij.openapi.roots.ui.configuration.classpath.InlineModuleDependencyAction;
import com.intellij.openapi.roots.ui.configuration.classpath.InvalidJdkItem;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.EditExistingLibraryDialog;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ConvertModuleLibraryToRepositoryLibraryAction;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FindUsagesInProjectStructureActionBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureLibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.SdkProjectStructureElement;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.OrderPanelListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.table.JBTable;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TextTransferable;
import gnu.trove.TIntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClasspathPanelImpl
extends JPanel
implements ClasspathPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanelImpl");
    private final JBTable myEntryTable;
    private final ClasspathTableModel myModel;
    private final EventDispatcher<OrderPanelListener> myListeners = EventDispatcher.create(OrderPanelListener.class);
    private List<AddItemPopupAction<?>> myPopupActions = null;
    private final AnActionButton myEditButton;
    private final ModuleConfigurationState myState;
    private AnActionButton myRemoveButton;
    private int myInsideChange = 0;

    public ClasspathPanelImpl(ModuleConfigurationState state) {
        super(new BorderLayout());
        this.myState = state;
        this.myModel = new ClasspathTableModel(state, this.getStructureConfigurableContext());
        this.myEntryTable = new JBTable((TableModel)((Object)this.myModel)){

            protected TableRowSorter<TableModel> createRowSorter(TableModel model) {
                return new JBTable.DefaultColumnInfoBasedRowSorter(model){

                    public void toggleSortOrder(int column) {
                        if (this.isSortable(column)) {
                            RowSorter.SortKey oldKey = (RowSorter.SortKey)ContainerUtil.getFirstItem((List)this.getSortKeys());
                            SortOrder oldOrder = oldKey == null || oldKey.getColumn() != column ? SortOrder.UNSORTED : oldKey.getSortOrder();
                            this.setSortKeys(Collections.singletonList(new RowSorter.SortKey(column, ClasspathPanelImpl.getNextSortOrder(oldOrder))));
                        }
                    }
                };
            }
        };
        this.myEntryTable.setShowGrid(false);
        this.myEntryTable.setDragEnabled(false);
        this.myEntryTable.setIntercellSpacing(new Dimension(0, 0));
        this.myEntryTable.setDefaultRenderer(ClasspathTableItem.class, (TableCellRenderer)((Object)new TableItemRenderer(this.getStructureConfigurableContext())));
        this.myEntryTable.setDefaultRenderer(Boolean.class, (TableCellRenderer)new ExportFlagRenderer(this.myEntryTable.getDefaultRenderer(Boolean.class)));
        ComboBox scopeEditor = new ComboBox((ComboBoxModel)new EnumComboBoxModel(DependencyScope.class));
        this.myEntryTable.setDefaultEditor(DependencyScope.class, (TableCellEditor)new DefaultCellEditor((JComboBox<?>)scopeEditor));
        this.myEntryTable.setDefaultRenderer(DependencyScope.class, (TableCellRenderer)new ComboBoxTableRenderer<DependencyScope>(DependencyScope.values()){

            protected String getTextFor(@NotNull DependencyScope value) {
                if (value == null) {
                    2.$$$reportNull$$$0(0);
                }
                return value.getDisplayName();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl$2", "getTextFor"));
            }
        });
        this.myEntryTable.setTransferHandler(new TransferHandler(){

            @Override
            @Nullable
            protected Transferable createTransferable(JComponent c) {
                OrderEntry entry = ClasspathPanelImpl.this.getSelectedEntry();
                if (entry == null) {
                    return null;
                }
                String text = entry.getPresentableName();
                return new TextTransferable(text);
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }
        });
        this.myEntryTable.getSelectionModel().setSelectionMode(2);
        new SpeedSearchBase<JBTable>(this.myEntryTable){

            public int getSelectedIndex() {
                return ClasspathPanelImpl.this.myEntryTable.getSelectedRow();
            }

            protected int convertIndexToModel(int viewIndex) {
                return ClasspathPanelImpl.this.myEntryTable.convertRowIndexToModel(viewIndex);
            }

            @NotNull
            public Object[] getAllElements() {
                int count = ClasspathPanelImpl.this.myModel.getRowCount();
                Object[] elements = new Object[count];
                for (int idx = 0; idx < count; ++idx) {
                    elements[idx] = ClasspathPanelImpl.this.myModel.getItem(idx);
                }
                if (elements == null) {
                    4.$$$reportNull$$$0(0);
                }
                return elements;
            }

            public String getElementText(Object element) {
                return ClasspathPanelImpl.getCellAppearance((ClasspathTableItem)element, ClasspathPanelImpl.this.getStructureConfigurableContext(), false).getText();
            }

            public void selectElement(Object element, String selectedText) {
                int count = ClasspathPanelImpl.this.myModel.getRowCount();
                for (int row = 0; row < count; ++row) {
                    if (!element.equals(ClasspathPanelImpl.this.myModel.getItem(row))) continue;
                    int viewRow = ClasspathPanelImpl.this.myEntryTable.convertRowIndexToView(row);
                    ClasspathPanelImpl.this.myEntryTable.getSelectionModel().setSelectionInterval(viewRow, viewRow);
                    TableUtil.scrollSelectionToVisible((JTable)ClasspathPanelImpl.this.myEntryTable);
                    break;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl$4", "getAllElements"));
            }
        };
        this.setFixedColumnWidth(0, ClasspathTableModel.EXPORT_COLUMN_NAME);
        this.setFixedColumnWidth(2, DependencyScope.COMPILE.toString() + "     ");
        this.myEntryTable.getTableHeader().getColumnModel().getColumn(1).setPreferredWidth(10000);
        this.myEntryTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = ClasspathPanelImpl.this.myEntryTable.getSelectedRows();
                boolean currentlyMarked = true;
                for (int selectedRow : selectedRows) {
                    ClasspathTableItem item = ClasspathPanelImpl.this.getItemAt(selectedRow);
                    if (selectedRow < 0 || !item.isExportable()) {
                        return;
                    }
                    currentlyMarked &= item.isExported();
                }
                for (int selectedRow : selectedRows) {
                    ClasspathPanelImpl.this.getItemAt(selectedRow).setExported(!currentlyMarked);
                }
                ClasspathPanelImpl.this.myModel.fireTableDataChanged();
                TableUtil.selectRows((JTable)ClasspathPanelImpl.this.myEntryTable, (int[])selectedRows);
            }
        }, KeyStroke.getKeyStroke(32, 0), 0);
        this.myEditButton = new AnActionButton(ProjectBundle.message((String)"module.classpath.button.edit", (Object[])new Object[0]), null, IconUtil.getEditIcon()){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                ClasspathPanelImpl.this.doEdit();
            }

            public boolean isEnabled() {
                ClasspathTableItem selectedItem = ClasspathPanelImpl.this.getSelectedItem();
                return selectedItem != null && selectedItem.isEditable();
            }

            public boolean isDumbAware() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl$6", "actionPerformed"));
            }
        };
        this.add((Component)this.createTableWithButtons(), "Center");
        if (this.myEntryTable.getRowCount() > 0) {
            this.myEntryTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                ClasspathPanelImpl.this.navigate(true);
                return true;
            }
        }.installOn((Component)this.myEntryTable);
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        AnAction navigateAction = new AnAction(ProjectBundle.message((String)"classpath.panel.navigate.action.text", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                ClasspathPanelImpl.this.navigate(false);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(1);
                }
                Presentation presentation = e.getPresentation();
                presentation.setEnabled(false);
                OrderEntry entry = ClasspathPanelImpl.this.getSelectedEntry();
                if (entry != null && entry.isValid() && !(entry instanceof ModuleSourceOrderEntry)) {
                    presentation.setEnabled(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl$8";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        navigateAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("EditSource").getShortcutSet(), (JComponent)this.myEntryTable);
        actionGroup.add((AnAction)this.myEditButton);
        actionGroup.add((AnAction)this.myRemoveButton);
        actionGroup.add(navigateAction);
        actionGroup.add((AnAction)new InlineModuleDependencyAction(this));
        actionGroup.add((AnAction)new MyFindUsagesAction());
        actionGroup.add((AnAction)new AnalyzeModuleDependencyAction(this));
        this.addChangeLibraryLevelAction(actionGroup, "project");
        this.addChangeLibraryLevelAction(actionGroup, "application");
        this.addChangeLibraryLevelAction(actionGroup, "module");
        actionGroup.add((AnAction)new ConvertModuleLibraryToRepositoryLibraryAction(this, this.getStructureConfigurableContext()));
        PopupHandler.installPopupHandler((JComponent)this.myEntryTable, (ActionGroup)actionGroup, (String)"unknown", (ActionManager)ActionManager.getInstance());
    }

    @NotNull
    private static SortOrder getNextSortOrder(@NotNull SortOrder order) {
        if (order == null) {
            ClasspathPanelImpl.$$$reportNull$$$0(0);
        }
        switch (order) {
            case ASCENDING: {
                SortOrder sortOrder = SortOrder.DESCENDING;
                if (sortOrder == null) {
                    ClasspathPanelImpl.$$$reportNull$$$0(1);
                }
                return sortOrder;
            }
            case DESCENDING: {
                SortOrder sortOrder = SortOrder.UNSORTED;
                if (sortOrder == null) {
                    ClasspathPanelImpl.$$$reportNull$$$0(2);
                }
                return sortOrder;
            }
        }
        SortOrder sortOrder = SortOrder.ASCENDING;
        if (sortOrder == null) {
            ClasspathPanelImpl.$$$reportNull$$$0(3);
        }
        return sortOrder;
    }

    private ClasspathTableItem<?> getItemAt(int selectedRow) {
        return (ClasspathTableItem)this.myModel.getItem(this.myEntryTable.convertRowIndexToModel(selectedRow));
    }

    private void addChangeLibraryLevelAction(DefaultActionGroup actionGroup, String tableLevel) {
        LibraryTablePresentation presentation = LibraryEditingUtil.getLibraryTablePresentation(this.getProject(), tableLevel);
        actionGroup.add((AnAction)new ChangeLibraryLevelInClasspathAction(this, presentation.getDisplayName(true), tableLevel));
    }

    @Override
    @Nullable
    public OrderEntry getSelectedEntry() {
        ClasspathTableItem<?> item = this.getSelectedItem();
        return item != null ? (OrderEntry)item.getEntry() : null;
    }

    @Nullable
    private ClasspathTableItem<?> getSelectedItem() {
        if (this.myEntryTable.getSelectedRowCount() != 1) {
            return null;
        }
        return this.getItemAt(this.myEntryTable.getSelectedRow());
    }

    private void setFixedColumnWidth(int columnIndex, String sampleText) {
        TableColumn column = this.myEntryTable.getTableHeader().getColumnModel().getColumn(columnIndex);
        FontMetrics fontMetrics = this.myEntryTable.getFontMetrics(this.myEntryTable.getFont());
        int width = fontMetrics.stringWidth(" " + sampleText + " ") + JBUI.scale((int)4);
        column.setPreferredWidth(width);
        column.setMinWidth(width);
        column.setResizable(false);
    }

    @Override
    public void navigate(boolean openLibraryEditor) {
        Sdk jdk;
        OrderEntry entry = this.getSelectedEntry();
        ProjectStructureConfigurable rootConfigurable = ProjectStructureConfigurable.getInstance(this.myState.getProject());
        if (entry instanceof ModuleOrderEntry) {
            Module module2 = ((ModuleOrderEntry)entry).getModule();
            if (module2 != null) {
                rootConfigurable.select(module2.getName(), null, true);
            }
        } else if (entry instanceof LibraryOrderEntry) {
            if (!openLibraryEditor && !((LibraryOrderEntry)entry).getLibraryLevel().equals("module")) {
                rootConfigurable.select((LibraryOrderEntry)entry, true);
            } else {
                this.doEdit();
            }
        } else if (entry instanceof JdkOrderEntry && (jdk = ((JdkOrderEntry)entry).getJdk()) != null) {
            rootConfigurable.select(jdk, true);
        }
    }

    private JComponent createTableWithButtons() {
        final ClasspathPanelAction removeAction = new ClasspathPanelAction(this){

            @Override
            public void run() {
                ClasspathPanelImpl.this.removeSelectedItems(TableUtil.removeSelectedItems((JTable)ClasspathPanelImpl.this.myEntryTable));
            }
        };
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)this.myEntryTable);
        AnActionButtonUpdater moveUpDownUpdater = e -> {
            for (RowSorter.SortKey key : this.myEntryTable.getRowSorter().getSortKeys()) {
                if (key.getSortOrder() == SortOrder.UNSORTED) continue;
                return false;
            }
            return true;
        };
        decorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ClasspathPanelImpl.this.initPopupActions();
                ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<AddItemPopupAction<?>>(null, ClasspathPanelImpl.this.myPopupActions){

                    public Icon getIconFor(AddItemPopupAction<?> aValue) {
                        return aValue.getIcon();
                    }

                    public boolean hasSubstep(AddItemPopupAction<?> selectedValue) {
                        return selectedValue.hasSubStep();
                    }

                    public boolean isMnemonicsNavigationEnabled() {
                        return true;
                    }

                    public PopupStep onChosen(AddItemPopupAction<?> selectedValue, boolean finalChoice) {
                        if (selectedValue.hasSubStep()) {
                            return selectedValue.createSubStep();
                        }
                        return this.doFinalStep(() -> selectedValue.execute());
                    }

                    @NotNull
                    public String getTextFor(AddItemPopupAction<?> value) {
                        String string = "&" + value.getIndex() + "  " + value.getTitle();
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl$13$1", "getTextFor"));
                    }
                });
                popup.show(button.getPreferredPopupPoint());
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                removeAction.actionPerformed(null);
            }
        }).setRemoveActionUpdater(e -> {
            int[] selectedRows;
            for (int selectedRow : selectedRows = this.myEntryTable.getSelectedRows()) {
                if (this.getItemAt(selectedRow).isRemovable()) continue;
                return false;
            }
            return selectedRows.length > 0;
        }).setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ClasspathPanelImpl.this.moveSelectedRows(-1);
            }
        }).setMoveUpActionUpdater(moveUpDownUpdater).setMoveUpActionName("Move Up (disabled if items are shown in sorted order)").setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ClasspathPanelImpl.this.moveSelectedRows(1);
            }
        }).setMoveDownActionUpdater(moveUpDownUpdater).setMoveDownActionName("Move Down (disabled if items are shown in sorted order)").addExtraAction(this.myEditButton);
        JPanel panel = decorator.createPanel();
        this.myRemoveButton = ToolbarDecorator.findRemoveButton((JComponent)panel);
        return panel;
    }

    private void doEdit() {
        OrderEntry entry = this.getSelectedEntry();
        if (!(entry instanceof LibraryOrderEntry)) {
            return;
        }
        Library library = ((LibraryOrderEntry)entry).getLibrary();
        if (library == null) {
            return;
        }
        LibraryTable table = library.getTable();
        String tableLevel = table != null ? table.getTableLevel() : "module";
        LibraryTablePresentation presentation = LibraryEditingUtil.getLibraryTablePresentation(this.getProject(), tableLevel);
        LibraryTableModifiableModelProvider provider = this.getModifiableModelProvider(tableLevel);
        EditExistingLibraryDialog dialog = EditExistingLibraryDialog.createDialog(this, provider, library, this.myState.getProject(), presentation, this.getStructureConfigurableContext());
        dialog.setContextModule(this.getRootModel().getModule());
        dialog.show();
        this.myEntryTable.repaint();
        ModuleStructureConfigurable.getInstance(this.myState.getProject()).getTree().repaint();
    }

    private void removeSelectedItems(List removedRows) {
        if (removedRows.isEmpty()) {
            return;
        }
        for (Object removedRow : removedRows) {
            ClasspathTableItem item = (ClasspathTableItem)((Object[])removedRow)[1];
            Object orderEntry = item.getEntry();
            if (orderEntry == null) continue;
            this.getRootModel().removeOrderEntry(orderEntry);
        }
        int[] selectedRows = this.myEntryTable.getSelectedRows();
        this.myModel.fireTableDataChanged();
        TableUtil.selectRows((JTable)this.myEntryTable, (int[])selectedRows);
        StructureConfigurableContext context = ModuleStructureConfigurable.getInstance(this.myState.getProject()).getContext();
        context.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(context, this.getRootModel().getModule()));
    }

    @Override
    @NotNull
    public LibraryTableModifiableModelProvider getModifiableModelProvider(@NotNull String tableLevel) {
        if (tableLevel == null) {
            ClasspathPanelImpl.$$$reportNull$$$0(4);
        }
        if ("module".equals(tableLevel)) {
            final LibraryTable moduleLibraryTable = this.getRootModel().getModuleLibraryTable();
            LibraryTableModifiableModelProvider libraryTableModifiableModelProvider = new LibraryTableModifiableModelProvider(){

                @Override
                public LibraryTable.ModifiableModel getModifiableModel() {
                    return moduleLibraryTable.getModifiableModel();
                }
            };
            if (libraryTableModifiableModelProvider == null) {
                ClasspathPanelImpl.$$$reportNull$$$0(5);
            }
            return libraryTableModifiableModelProvider;
        }
        StructureLibraryTableModifiableModelProvider structureLibraryTableModifiableModelProvider = this.getStructureConfigurableContext().createModifiableModelProvider(tableLevel);
        if (structureLibraryTableModifiableModelProvider == null) {
            ClasspathPanelImpl.$$$reportNull$$$0(6);
        }
        return structureLibraryTableModifiableModelProvider;
    }

    @Override
    public void runClasspathPanelAction(Runnable action) {
        try {
            this.disableModelUpdate();
            action.run();
        }
        finally {
            this.enableModelUpdate();
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEntryTable, true));
        }
    }

    @Override
    public void addItems(List<? extends ClasspathTableItem<?>> toAdd) {
        for (ClasspathTableItem<?> item : toAdd) {
            this.myModel.addRow(item);
        }
        TIntArrayList toSelect = new TIntArrayList();
        for (int i = this.myModel.getRowCount() - toAdd.size(); i < this.myModel.getRowCount(); ++i) {
            toSelect.add(this.myEntryTable.convertRowIndexToView(i));
        }
        TableUtil.selectRows((JTable)this.myEntryTable, (int[])toSelect.toNativeArray());
        TableUtil.scrollSelectionToVisible((JTable)this.myEntryTable);
        StructureConfigurableContext context = ModuleStructureConfigurable.getInstance(this.myState.getProject()).getContext();
        context.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(context, this.getRootModel().getModule()));
    }

    @Override
    public ModifiableRootModel getRootModel() {
        return this.myState.getRootModel();
    }

    @Override
    public Project getProject() {
        return this.myState.getProject();
    }

    @Override
    public ModuleConfigurationState getModuleConfigurationState() {
        return this.myState;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public void rootsChanged() {
        this.forceInitFromModel();
    }

    private void initPopupActions() {
        if (this.myPopupActions == null) {
            int actionIndex = 1;
            ArrayList actions = new ArrayList();
            StructureConfigurableContext context = this.getStructureConfigurableContext();
            actions.add(new AddNewModuleLibraryAction(this, actionIndex++, context));
            actions.add(new AddLibraryDependencyAction((ClasspathPanel)this, actionIndex++, ProjectBundle.message((String)"classpath.add.library.action", (Object[])new Object[0]), context));
            actions.add(new AddModuleDependencyAction(this, actionIndex, context));
            this.myPopupActions = actions;
        }
    }

    private StructureConfigurableContext getStructureConfigurableContext() {
        return ProjectStructureConfigurable.getInstance(this.myState.getProject()).getContext();
    }

    private void enableModelUpdate() {
        --this.myInsideChange;
    }

    private void disableModelUpdate() {
        ++this.myInsideChange;
    }

    public void addListener(OrderPanelListener listener) {
        this.myListeners.addListener((EventListener)listener);
    }

    public void removeListener(OrderPanelListener listener) {
        this.myListeners.removeListener((EventListener)listener);
    }

    private void moveSelectedRows(int increment) {
        int row;
        LOG.assertTrue(increment == -1 || increment == 1);
        if (this.myEntryTable.isEditing()) {
            this.myEntryTable.getCellEditor().stopCellEditing();
        }
        ListSelectionModel selectionModel = this.myEntryTable.getSelectionModel();
        int n = row = increment < 0 ? 0 : this.myModel.getRowCount() - 1;
        while (increment < 0 ? row < this.myModel.getRowCount() : row >= 0) {
            if (selectionModel.isSelectedIndex(row)) {
                int newRow = this.moveRow(row, increment);
                selectionModel.removeSelectionInterval(row, row);
                selectionModel.addSelectionInterval(newRow, newRow);
            }
            row += increment < 0 ? 1 : -1;
        }
        Rectangle cellRect = this.myEntryTable.getCellRect(selectionModel.getMinSelectionIndex(), 0, true);
        this.myEntryTable.scrollRectToVisible(cellRect);
        this.myEntryTable.repaint();
    }

    public void selectOrderEntry(@NotNull OrderEntry entry) {
        if (entry == null) {
            ClasspathPanelImpl.$$$reportNull$$$0(7);
        }
        for (int row = 0; row < this.myModel.getRowCount(); ++row) {
            Object orderEntry = this.getItemAt(row).getEntry();
            if (orderEntry == null || !entry.getPresentableName().equals(orderEntry.getPresentableName()) || orderEntry instanceof ExportableOrderEntry && entry instanceof ExportableOrderEntry && ((ExportableOrderEntry)entry).getScope() != ((ExportableOrderEntry)orderEntry).getScope()) continue;
            this.myEntryTable.getSelectionModel().setSelectionInterval(row, row);
            TableUtil.scrollSelectionToVisible((JTable)this.myEntryTable);
        }
        IdeFocusManager.getInstance((Project)this.myState.getProject()).requestFocus((Component)this.myEntryTable, true);
    }

    private int moveRow(int row, int increment) {
        int newIndex = Math.abs(row + increment) % this.myModel.getRowCount();
        this.myModel.exchangeRows(row, newIndex);
        return newIndex;
    }

    public void stopEditing() {
        TableUtil.stopEditing((JTable)this.myEntryTable);
    }

    public void initFromModel() {
        if (this.myInsideChange == 0) {
            this.forceInitFromModel();
        }
    }

    public void forceInitFromModel() {
        HashSet oldSelection = new HashSet();
        for (int i : this.myEntryTable.getSelectedRows()) {
            ContainerUtil.addIfNotNull(oldSelection, this.getItemAt(i));
        }
        this.myModel.clear();
        this.myModel.init();
        this.myModel.fireTableDataChanged();
        TIntArrayList newSelection = new TIntArrayList();
        for (int i = 0; i < this.myModel.getRowCount(); ++i) {
            if (!oldSelection.contains(this.getItemAt(i))) continue;
            newSelection.add(i);
        }
        TableUtil.selectRows((JTable)this.myEntryTable, (int[])newSelection.toNativeArray());
    }

    static CellAppearanceEx getCellAppearance(ClasspathTableItem<?> item, StructureConfigurableContext context, boolean selected) {
        OrderEntryAppearanceService service = OrderEntryAppearanceService.getInstance();
        if (item instanceof InvalidJdkItem) {
            return service.forJdk(null, false, selected, true);
        }
        Object entry = item.getEntry();
        assert (entry != null) : item;
        return service.forOrderEntry(context.getProject(), entry, selected);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableLevel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextSortOrder";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModelProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNextSortOrder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModifiableModelProvider";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectOrderEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyFindUsagesAction
    extends FindUsagesInProjectStructureActionBase {
        private MyFindUsagesAction() {
            super((JComponent)ClasspathPanelImpl.this.myEntryTable, ClasspathPanelImpl.this.myState.getProject());
        }

        @Override
        protected boolean isEnabled() {
            return this.getSelectedElement() != null;
        }

        @Override
        protected ProjectStructureElement getSelectedElement() {
            Sdk jdk;
            OrderEntry entry = ClasspathPanelImpl.this.getSelectedEntry();
            if (entry instanceof LibraryOrderEntry) {
                Library library = ((LibraryOrderEntry)entry).getLibrary();
                if (library != null) {
                    return new LibraryProjectStructureElement(this.getContext(), library);
                }
            } else if (entry instanceof ModuleOrderEntry) {
                Module module2 = ((ModuleOrderEntry)entry).getModule();
                if (module2 != null) {
                    return new ModuleProjectStructureElement(this.getContext(), module2);
                }
            } else if (entry instanceof JdkOrderEntry && (jdk = ((JdkOrderEntry)entry).getJdk()) != null) {
                return new SdkProjectStructureElement(this.getContext(), jdk);
            }
            return null;
        }

        @Override
        protected RelativePoint getPointToShowResults() {
            Rectangle rect = ClasspathPanelImpl.this.myEntryTable.getCellRect(ClasspathPanelImpl.this.myEntryTable.getSelectedRow(), 1, false);
            Point location = rect.getLocation();
            location.y += rect.height;
            return new RelativePoint((Component)ClasspathPanelImpl.this.myEntryTable, location);
        }
    }

    private static class ExportFlagRenderer
    implements TableCellRenderer {
        private final TableCellRenderer myDelegate;
        private final JPanel myBlankPanel;

        ExportFlagRenderer(TableCellRenderer delegate) {
            this.myDelegate = delegate;
            this.myBlankPanel = new JPanel();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (!table.isCellEditable(row, column)) {
                this.myBlankPanel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                return this.myBlankPanel;
            }
            return this.myDelegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private static class TableItemRenderer
    extends ColoredTableCellRenderer {
        private final Border NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        private final StructureConfigurableContext myContext;

        TableItemRenderer(StructureConfigurableContext context) {
            this.myContext = context;
        }

        protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            this.setPaintFocusBorder(false);
            this.setFocusBorderAroundIcon(true);
            this.setBorder(this.NO_FOCUS_BORDER);
            if (value instanceof ClasspathTableItem) {
                ClasspathTableItem tableItem = (ClasspathTableItem)value;
                ClasspathPanelImpl.getCellAppearance(tableItem, this.myContext, selected).customize((SimpleColoredComponent)this);
                this.setToolTipText(tableItem.getTooltipText());
            }
        }
    }
}

