/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.ComplexPackagingElementNode;
import com.intellij.packaging.elements.ComplexPackagingElement;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ComplexElementSubstitutionParameters {
    private final Set<ComplexPackagingElementType<?>> myTypesToSubstitute = new HashSet();
    private final Set<ComplexPackagingElement<?>> mySubstituted = new HashSet();

    public void setSubstituteAll() {
        ContainerUtil.addAll(this.myTypesToSubstitute, (Object[])PackagingElementFactory.getInstance().getComplexElementTypes());
        this.mySubstituted.clear();
    }

    public void setSubstituteNone() {
        this.myTypesToSubstitute.clear();
        this.mySubstituted.clear();
    }

    public boolean shouldSubstitute(@NotNull ComplexPackagingElement<?> element) {
        ComplexPackagingElementType type;
        if (element == null) {
            ComplexElementSubstitutionParameters.$$$reportNull$$$0(0);
        }
        return this.myTypesToSubstitute.contains(type = (ComplexPackagingElementType)element.getType()) || this.mySubstituted.contains(element);
    }

    public void setShowContent(ComplexPackagingElementType<?> type, boolean showContent) {
        if (showContent) {
            this.myTypesToSubstitute.add(type);
        } else {
            this.myTypesToSubstitute.remove(type);
        }
        Iterator<ComplexPackagingElement<?>> iterator = this.mySubstituted.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().getType().equals(type)) continue;
            iterator.remove();
        }
    }

    public Set<ComplexPackagingElementType<?>> getTypesToSubstitute() {
        return Collections.unmodifiableSet(this.myTypesToSubstitute);
    }

    public void setShowContent(ComplexPackagingElementNode complexNode) {
        this.mySubstituted.addAll(complexNode.getPackagingElements());
    }

    public void doNotSubstitute(ComplexPackagingElement<?> element) {
        this.mySubstituted.remove(element);
    }

    public boolean isShowContentForType(@NotNull ComplexPackagingElementType type) {
        if (type == null) {
            ComplexElementSubstitutionParameters.$$$reportNull$$$0(1);
        }
        return this.myTypesToSubstitute.contains(type);
    }

    public boolean isAllSubstituted() {
        return this.myTypesToSubstitute.containsAll(Arrays.asList(PackagingElementFactory.getInstance().getComplexElementTypes()));
    }

    public boolean isNoneSubstituted() {
        return this.myTypesToSubstitute.isEmpty() && this.mySubstituted.isEmpty();
    }

    public void setTypesToShowContent(Collection<ComplexPackagingElementType<?>> types) {
        this.myTypesToSubstitute.clear();
        this.myTypesToSubstitute.addAll(types);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/ComplexElementSubstitutionParameters";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldSubstitute";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isShowContentForType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

