/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.externalSystem.view.RunConfigurationsNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=40)
public class ModuleNode
extends ExternalSystemNode<ModuleData> {
    private final boolean myIsRoot;
    private final ModuleData myData;
    private Collection<ModuleNode> myAllModules = Collections.emptyList();
    private final RunConfigurationsNode myRunConfigurationsNode;

    public ModuleNode(ExternalProjectsView externalProjectsView, DataNode<ModuleData> dataNode, @Nullable ExternalSystemNode parent, boolean isRoot) {
        super(externalProjectsView, parent, dataNode);
        this.myIsRoot = isRoot;
        this.myData = (ModuleData)dataNode.getData();
        this.myRunConfigurationsNode = new RunConfigurationsNode(externalProjectsView, this);
    }

    public void setAllModules(Collection<ModuleNode> allModules) {
        this.myAllModules = allModules;
    }

    protected void update(@NotNull PresentationData presentation) {
        if (presentation == null) {
            ModuleNode.$$$reportNull$$$0(0);
        }
        super.update(presentation);
        presentation.setIcon(this.getUiAware().getProjectIcon());
        String hint = null;
        if (this.myIsRoot) {
            hint = "root";
        }
        String tooltip = this.myData.toString() + (this.myData.getDescription() != null ? "<br>" + this.myData.getDescription() : "");
        this.setNameAndTooltip(this.getName(), tooltip, hint);
    }

    @Override
    @NotNull
    protected List<? extends ExternalSystemNode> doBuildChildren() {
        ArrayList myChildNodes = ContainerUtil.newArrayList();
        if (this.getExternalProjectsView().getGroupModules()) {
            List childModules = ContainerUtil.findAll(this.myAllModules, module2 -> module2 != this && StringUtil.equals((CharSequence)module2.getIdeParentGrouping(), (CharSequence)this.getIdeGrouping()));
            myChildNodes.addAll(childModules);
        }
        myChildNodes.addAll(super.doBuildChildren());
        myChildNodes.add(this.myRunConfigurationsNode);
        ArrayList arrayList = myChildNodes;
        if (arrayList == null) {
            ModuleNode.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    @Nullable
    protected String getMenuId() {
        return "ExternalSystemView.ModuleMenu";
    }

    @Override
    public int compareTo(@NotNull ExternalSystemNode node) {
        if (node == null) {
            ModuleNode.$$$reportNull$$$0(2);
        }
        return this.myIsRoot ? -1 : (node instanceof ModuleNode && ((ModuleNode)node).myIsRoot ? 1 : super.compareTo(node));
    }

    public void updateRunConfigurations() {
        this.myRunConfigurationsNode.updateRunConfigurations();
        this.childrenChanged();
        this.getExternalProjectsView().updateUpTo(this);
        this.getExternalProjectsView().updateUpTo(this.myRunConfigurationsNode);
    }

    @Override
    public String getName() {
        if (this.getExternalProjectsView().getGroupModules()) {
            return this.myData.getExternalName();
        }
        return super.getName();
    }

    @Override
    public boolean isVisible() {
        if (!this.myIsRoot && this.getExternalProjectsView().getGroupModules()) {
            ModuleNode parentModule = this.findParent(ModuleNode.class);
            if (parentModule != null) {
                return StringUtil.equals((CharSequence)parentModule.getIdeGrouping(), (CharSequence)this.getIdeParentGrouping());
            }
            ProjectNode parentProject = this.findParent(ProjectNode.class);
            if (parentProject != null) {
                return StringUtil.equals((CharSequence)parentProject.getIdeGrouping(), (CharSequence)this.getIdeParentGrouping());
            }
        }
        return super.isVisible();
    }

    @Nullable
    public String getIdeGrouping() {
        ModuleData data = (ModuleData)this.getData();
        if (data == null) {
            return null;
        }
        return data.getIdeGrouping();
    }

    @Nullable
    public String getIdeParentGrouping() {
        ModuleData data = (ModuleData)this.getData();
        if (data == null) {
            return null;
        }
        return data.getIdeParentGrouping();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/view/ModuleNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/ModuleNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "doBuildChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

