/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.settings;

import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.project.settings.ConfigurationData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.settings.ConfigurationHandler;
import com.intellij.openapi.externalSystem.service.project.settings.EncodingConfigurationHandler;
import com.intellij.openapi.externalSystem.service.project.settings.RunConfigurationHandlerKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/settings/EncodingConfigurationHandler;", "Lcom/intellij/openapi/externalSystem/service/project/settings/ConfigurationHandler;", "()V", "onSuccessImport", "", "project", "Lcom/intellij/openapi/project/Project;", "projectData", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModelsProvider;", "configuration", "Lcom/intellij/openapi/externalSystem/model/project/settings/ConfigurationData;", "Companion", "intellij.platform.externalSystem.impl"})
public final class EncodingConfigurationHandler
implements ConfigurationHandler {
    private static final String DEFAULT_CHARSET = "<System Default>";
    public static final Companion Companion = new Companion(null);

    public void onSuccessImport(@NotNull Project project2, @Nullable ProjectData projectData, @NotNull IdeModelsProvider modelsProvider, @NotNull ConfigurationData configuration) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)modelsProvider, (String)"modelsProvider");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        EncodingConfigurationHandler.Companion.onEncodingBlock(configuration, new Function1<Map<?, ?>, Unit>(project2){
            final /* synthetic */ Project $project;

            public final void invoke(@NotNull Map<?, ?> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
                EncodingProjectManager encodingProjectManager = EncodingProjectManager.getInstance((Project)this.$project);
                if (encodingProjectManager == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl");
                }
                EncodingProjectManagerImpl encodingManager = (EncodingProjectManagerImpl)encodingProjectManager;
                Map mapping = com.intellij.openapi.externalSystem.service.project.settings.EncodingConfigurationHandler$Companion.access$getCharsetProjectMapping(EncodingConfigurationHandler.Companion, $receiver, encodingManager);
                TransactionGuard.getInstance().submitTransactionAndWait(new Runnable($receiver, encodingManager, mapping){
                    final /* synthetic */ Map $this_onEncodingBlock;
                    final /* synthetic */ EncodingProjectManagerImpl $encodingManager;
                    final /* synthetic */ Map $mapping;

                    public final void run() {
                        this.$encodingManager.setMapping(this.$mapping);
                        com.intellij.openapi.externalSystem.service.project.settings.EncodingConfigurationHandler$Companion.access$onCharset(EncodingConfigurationHandler.Companion, this.$this_onEncodingBlock, "encoding", (Function1)new Function1<Charset, Unit>(this){
                            final /* synthetic */ onSuccessImport.1 this$0;

                            public final void invoke(@Nullable Charset it) {
                                EncodingProjectManagerImpl encodingProjectManagerImpl = this.this$0.$encodingManager;
                                Object object = it;
                                if (object == null || (object = ((Charset)object).name()) == null) {
                                    object = "";
                                }
                                encodingProjectManagerImpl.setDefaultCharsetName((String)object);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        });
                        com.intellij.openapi.externalSystem.service.project.settings.EncodingConfigurationHandler$Companion.access$onBomPolicy(EncodingConfigurationHandler.Companion, this.$this_onEncodingBlock, "bomPolicy", (Function1)new Function1<EncodingProjectManagerImpl.BOMForNewUTF8Files, Unit>(this){
                            final /* synthetic */ onSuccessImport.1 this$0;

                            public final void invoke(@NotNull EncodingProjectManagerImpl.BOMForNewUTF8Files it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                this.this$0.$encodingManager.setBOMForNewUtf8Files(it);
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        });
                        com.intellij.openapi.externalSystem.service.project.settings.EncodingConfigurationHandler$Companion.access$onMap(EncodingConfigurationHandler.Companion, this.$this_onEncodingBlock, "properties", (Function1)new Function1<Map<?, ?>, Unit>(this){
                            final /* synthetic */ onSuccessImport.1 this$0;

                            public final void invoke(@NotNull Map<?, ?> $receiver) {
                                Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
                                com.intellij.openapi.externalSystem.service.project.settings.EncodingConfigurationHandler$Companion.access$onCharset(EncodingConfigurationHandler.Companion, $receiver, "encoding", (Function1)new Function1<Charset, Unit>(this){
                                    final /* synthetic */ onSuccessImport.3 this$0;

                                    public final void invoke(@Nullable Charset it) {
                                        this.this$0.this$0.$encodingManager.setDefaultCharsetForPropertiesFiles(null, it);
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(1);
                                    }
                                });
                                com.intellij.openapi.externalSystem.service.project.settings.EncodingConfigurationHandler$Companion.access$onBoolean(EncodingConfigurationHandler.Companion, $receiver, "transparentNativeToAsciiConversion", (Function1)new Function1<Boolean, Unit>(this){
                                    final /* synthetic */ onSuccessImport.3 this$0;

                                    public final void invoke(boolean it) {
                                        this.this$0.this$0.$encodingManager.setNative2AsciiForPropertiesFiles(null, it);
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(1);
                                    }
                                });
                            }
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }
                        });
                    }
                    {
                        this.$this_onEncodingBlock = map;
                        this.$encodingManager = encodingProjectManagerImpl;
                        this.$mapping = map2;
                    }
                });
            }
            {
                this.$project = project2;
                super(1);
            }
        });
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0005\u001a\u00020\u0006*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00072\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\tH\u0002J(\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J9\u0010\u000f\u001a\u00020\u0006\"\u0006\b\u0000\u0010\u0010\u0018\u0001*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00072\u0006\u0010\u0011\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u00020\u00060\u0012H\u0082\bJ0\u0010\u0013\u001a\u00020\u0006*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00072\u0006\u0010\u0011\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00060\u0012H\u0002J0\u0010\u0015\u001a\u00020\u0006*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00072\u0006\u0010\u0011\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00060\u0012H\u0002J2\u0010\u0017\u001a\u00020\u0006*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00072\u0006\u0010\u0011\u001a\u00020\u00042\u0014\u0010\b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\u00060\u0012H\u0002J-\u0010\u0018\u001a\u00020\u0006*\u00020\u00192\u001f\u0010\b\u001a\u001b\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\u00060\u0012\u00a2\u0006\u0002\b\u001aH\u0002J=\u0010\u001b\u001a\u00020\u0006*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00072\u0006\u0010\u0011\u001a\u00020\u00042\u001f\u0010\b\u001a\u001b\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\u00060\u0012\u00a2\u0006\u0002\b\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/externalSystem/service/project/settings/EncodingConfigurationHandler$Companion;", "", "()V", "DEFAULT_CHARSET", "", "forEachCharsetMapping", "", "", "action", "Lkotlin/Function2;", "getCharsetProjectMapping", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/nio/charset/Charset;", "encodingManager", "Lcom/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl;", "on", "T", "name", "Lkotlin/Function1;", "onBomPolicy", "Lcom/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl$BOMForNewUTF8Files;", "onBoolean", "", "onCharset", "onEncodingBlock", "Lcom/intellij/openapi/externalSystem/model/project/settings/ConfigurationData;", "Lkotlin/ExtensionFunctionType;", "onMap", "intellij.platform.externalSystem.impl"})
    public static final class Companion {
        private final void onEncodingBlock(@NotNull ConfigurationData $receiver, Function1<? super Map<?, ?>, Unit> action) {
            Object data = $receiver.find("encodings");
            if (!(data instanceof Map)) {
                return;
            }
            action.invoke(data);
        }

        private final <T> void on(@NotNull Map<?, ?> $receiver, String name2, Function1<? super T, Unit> action) {
            int $i$f$on = 0;
            Map<?, ?> map = $receiver;
            Object obj = map.get(name2);
            if (obj == null) {
                return;
            }
            Object data = obj;
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (!(data instanceof Object)) {
                RunConfigurationHandlerKt.getLOG().warn("unexpected type " + data.getClass().getName() + " of " + name2 + " encoding configuration, skipping");
                return;
            }
            action.invoke(data);
        }

        /*
         * WARNING - void declaration
         */
        private final void onBomPolicy(@NotNull Map<?, ?> $receiver, String name2, Function1<? super EncodingProjectManagerImpl.BOMForNewUTF8Files, Unit> action) {
            block11: {
                EncodingProjectManagerImpl.BOMForNewUTF8Files bOMForNewUTF8Files;
                Object data$iv;
                block12: {
                    Object v;
                    block10: {
                        void $receiver$iv;
                        Map<?, ?> map = $receiver;
                        Companion this_$iv = this;
                        boolean $i$f$on = false;
                        void var7_7 = $receiver$iv;
                        v = var7_7.get(name2);
                        if (v != null) break block10;
                        break block11;
                    }
                    data$iv = v;
                    if (data$iv instanceof String) break block12;
                    RunConfigurationHandlerKt.getLOG().warn("unexpected type " + data$iv.getClass().getName() + " of " + name2 + " encoding configuration, skipping");
                    break block11;
                }
                String it = (String)data$iv;
                boolean bl = false;
                switch (it) {
                    case "WITH_BOM": {
                        bOMForNewUTF8Files = EncodingProjectManagerImpl.BOMForNewUTF8Files.ALWAYS;
                        break;
                    }
                    case "WITH_NO_BOM": {
                        bOMForNewUTF8Files = EncodingProjectManagerImpl.BOMForNewUTF8Files.NEVER;
                        break;
                    }
                    case "WITH_BOM_ON_WINDOWS": {
                        bOMForNewUTF8Files = EncodingProjectManagerImpl.BOMForNewUTF8Files.WINDOWS_ONLY;
                        break;
                    }
                    default: {
                        RunConfigurationHandlerKt.getLOG().warn("unsupported BOM policy " + it + " of encoding configuration, skipping");
                        break block11;
                    }
                }
                EncodingProjectManagerImpl.BOMForNewUTF8Files option = bOMForNewUTF8Files;
                action.invoke((Object)option);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void onCharset(@NotNull Map<?, ?> $receiver, String name2, Function1<? super Charset, Unit> action) {
            void $receiver$iv;
            Map<?, ?> map = $receiver;
            Companion this_$iv = this;
            boolean $i$f$on = false;
            void var7_7 = $receiver$iv;
            Object v = var7_7.get(name2);
            if (v == null) {
            } else {
                Object data$iv = v;
                if (!(data$iv instanceof String)) {
                    RunConfigurationHandlerKt.getLOG().warn("unexpected type " + data$iv.getClass().getName() + " of " + name2 + " encoding configuration, skipping");
                } else {
                    String it = (String)data$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it, (Object)EncodingConfigurationHandler.DEFAULT_CHARSET)) {
                        action.invoke(null);
                    } else {
                        Charset charset = CharsetToolkit.forName((String)it);
                        if (charset == null) {
                            RunConfigurationHandlerKt.getLOG().warn("unsupported charset " + it + " of " + name2 + " encoding configuration, skipping");
                        } else {
                            action.invoke((Object)charset);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void onMap(@NotNull Map<?, ?> $receiver, String name2, Function1<? super Map<?, ?>, Unit> action) {
            void $receiver$iv;
            Map<?, ?> map = $receiver;
            Companion this_$iv = this;
            boolean $i$f$on = false;
            void var7_7 = $receiver$iv;
            Object v = var7_7.get(name2);
            if (v == null) {
            } else {
                Object data$iv = v;
                if (!(data$iv instanceof Map)) {
                    RunConfigurationHandlerKt.getLOG().warn("unexpected type " + data$iv.getClass().getName() + " of " + name2 + " encoding configuration, skipping");
                } else {
                    action.invoke(data$iv);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void onBoolean(@NotNull Map<?, ?> $receiver, String name2, Function1<? super Boolean, Unit> action) {
            void $receiver$iv;
            Map<?, ?> map = $receiver;
            Companion this_$iv = this;
            boolean $i$f$on = false;
            void var7_7 = $receiver$iv;
            Object v = var7_7.get(name2);
            if (v == null) {
            } else {
                Object data$iv = v;
                if (!(data$iv instanceof Boolean)) {
                    RunConfigurationHandlerKt.getLOG().warn("unexpected type " + data$iv.getClass().getName() + " of " + name2 + " encoding configuration, skipping");
                } else {
                    action.invoke(data$iv);
                }
            }
        }

        private final void forEachCharsetMapping(@NotNull Map<?, ?> $receiver, Function2<? super String, ? super String, Unit> action) {
            this.onMap($receiver, "mapping", (Function1)new Function1<Map<?, ?>, Unit>(action){
                final /* synthetic */ Function2 $action;

                public final void invoke(@NotNull Map<?, ?> $receiver) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
                    Map<?, ?> map = $receiver;
                    Iterator<Map.Entry<?, ?>> iterator = map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<?, ?> entry;
                        Map.Entry<?, ?> entry2 = entry = iterator.next();
                        ? path = entry2.getKey();
                        entry2 = entry;
                        ? charsetName = entry2.getValue();
                        if (!(path instanceof String)) {
                            Object object;
                            RunConfigurationHandlerKt.getLOG().warn("unexpected path type " + ((object = path) != null && (object = object.getClass()) != null ? ((Class)object).getName() : null) + ", skipping");
                            continue;
                        }
                        if (!(charsetName instanceof String)) {
                            Object object;
                            RunConfigurationHandlerKt.getLOG().warn("unexpected type " + ((object = charsetName) != null && (object = object.getClass()) != null ? ((Class)object).getName() : null) + " of " + path + " encoding configuration, skipping");
                            continue;
                        }
                        this.$action.invoke(path, charsetName);
                    }
                }
                {
                    this.$action = function2;
                    super(1);
                }
            });
        }

        private final Map<VirtualFile, Charset> getCharsetProjectMapping(@NotNull Map<?, ?> $receiver, EncodingProjectManagerImpl encodingManager) {
            Map map = encodingManager.getAllMappings();
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"encodingManager.allMappings");
            Map mapping = MapsKt.toMutableMap((Map)map);
            this.forEachCharsetMapping($receiver, (Function2<? super String, ? super String, Unit>)((Function2)new Function2<String, String, Unit>(mapping){
                final /* synthetic */ Map $mapping;

                public final void invoke(@NotNull String path, @NotNull String charsetName) {
                    Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                    Intrinsics.checkParameterIsNotNull((Object)charsetName, (String)"charsetName");
                    String string = VfsUtilCore.pathToUrl((String)FileUtil.toCanonicalPath((String)path));
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"VfsUtilCore.pathToUrl(Fi\u2026il.toCanonicalPath(path))");
                    String url = string;
                    VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileManager, (String)"VirtualFileManager.getInstance()");
                    VirtualFileManager virtualFileManager2 = virtualFileManager;
                    VirtualFile virtualFile = virtualFileManager2.findFileByUrl(url);
                    if (virtualFile == null) {
                        RunConfigurationHandlerKt.getLOG().warn("mappings file " + path + " not found, skipping");
                        return;
                    }
                    if (Intrinsics.areEqual((Object)charsetName, (Object)"<System Default>")) {
                        this.$mapping.remove(virtualFile);
                        return;
                    }
                    Charset charset = CharsetToolkit.forName((String)charsetName);
                    if (charset == null) {
                        RunConfigurationHandlerKt.getLOG().warn("unsupported charset " + charsetName + " of " + path + " encoding configuration, skipping");
                        return;
                    }
                    Map map = this.$mapping;
                    Charset charset2 = charset;
                    map.put(virtualFile, charset2);
                }
                {
                    this.$mapping = map;
                    super(2);
                }
            }));
            return mapping;
        }

        private Companion() {
        }

        public static final /* synthetic */ Map access$getCharsetProjectMapping(Companion $this, Map $receiver, EncodingProjectManagerImpl encodingManager) {
            return $this.getCharsetProjectMapping($receiver, encodingManager);
        }

        public static final /* synthetic */ void access$onCharset(Companion $this, Map $receiver, String name2, Function1 action) {
            $this.onCharset($receiver, name2, (Function1<? super Charset, Unit>)action);
        }

        public static final /* synthetic */ void access$onBomPolicy(Companion $this, Map $receiver, String name2, Function1 action) {
            $this.onBomPolicy($receiver, name2, (Function1<? super EncodingProjectManagerImpl.BOMForNewUTF8Files, Unit>)action);
        }

        public static final /* synthetic */ void access$onMap(Companion $this, Map $receiver, String name2, Function1 action) {
            $this.onMap($receiver, name2, action);
        }

        public static final /* synthetic */ void access$onBoolean(Companion $this, Map $receiver, String name2, Function1 action) {
            $this.onBoolean($receiver, name2, (Function1<? super Boolean, Unit>)action);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

