/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.cmd.CommandLineCompletionProvider;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TextAccessor;
import com.intellij.util.containers.ContainerUtil;
import groovyjarjarcommonscli.Options;
import icons.ExternalSystemIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskCompletionProvider
extends CommandLineCompletionProvider {
    private volatile List<LookupElement> myCachedElements;
    private volatile String myCachedWorkingDir;
    private final Project myProject;
    private final ProjectSystemId mySystemId;
    private final TextAccessor myProjectPathAccessor;

    public TaskCompletionProvider(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @NotNull TextAccessor workDirectoryField) {
        if (project2 == null) {
            TaskCompletionProvider.$$$reportNull$$$0(0);
        }
        if (externalSystemId == null) {
            TaskCompletionProvider.$$$reportNull$$$0(1);
        }
        if (workDirectoryField == null) {
            TaskCompletionProvider.$$$reportNull$$$0(2);
        }
        this(project2, externalSystemId, workDirectoryField, new Options());
    }

    public TaskCompletionProvider(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId, @NotNull TextAccessor workDirectoryField, @NotNull Options options) {
        if (project2 == null) {
            TaskCompletionProvider.$$$reportNull$$$0(3);
        }
        if (externalSystemId == null) {
            TaskCompletionProvider.$$$reportNull$$$0(4);
        }
        if (workDirectoryField == null) {
            TaskCompletionProvider.$$$reportNull$$$0(5);
        }
        if (options == null) {
            TaskCompletionProvider.$$$reportNull$$$0(6);
        }
        super(options);
        this.myProject = project2;
        this.mySystemId = externalSystemId;
        this.myProjectPathAccessor = workDirectoryField;
    }

    @Override
    protected void addArgumentVariants(@NotNull CompletionResultSet result) {
        if (result == null) {
            TaskCompletionProvider.$$$reportNull$$$0(7);
        }
        ArrayList cachedElements = this.myCachedElements;
        String projectPath = this.myProjectPathAccessor.getText();
        if (cachedElements == null || !StringUtil.equals((CharSequence)this.myCachedWorkingDir, (CharSequence)projectPath)) {
            ExternalProjectSettings linkedProjectSettings = ExternalSystemApiUtil.getSettings((Project)this.myProject, (ProjectSystemId)this.mySystemId).getLinkedProjectSettings(projectPath);
            if (linkedProjectSettings == null) {
                return;
            }
            ExternalProjectInfo projectData = ProjectDataManager.getInstance().getExternalProjectData(this.myProject, this.mySystemId, linkedProjectSettings.getExternalProjectPath());
            if (projectData == null || projectData.getExternalProjectStructure() == null) {
                return;
            }
            this.myCachedElements = cachedElements = ContainerUtil.newArrayList(this.getVariants((DataNode<ProjectData>)projectData.getExternalProjectStructure(), projectPath));
            this.myCachedWorkingDir = projectPath;
        }
        result.addAllElements(cachedElements);
    }

    protected List<LookupElement> getVariants(@NotNull DataNode<ProjectData> projectDataNode, @NotNull String modulePath) {
        DataNode<ModuleData> moduleDataNode;
        if (projectDataNode == null) {
            TaskCompletionProvider.$$$reportNull$$$0(8);
        }
        if (modulePath == null) {
            TaskCompletionProvider.$$$reportNull$$$0(9);
        }
        if ((moduleDataNode = TaskCompletionProvider.findModuleDataNode(projectDataNode, modulePath)) == null) {
            return Collections.emptyList();
        }
        Collection tasks = ExternalSystemApiUtil.getChildren(moduleDataNode, (Key)ProjectKeys.TASK);
        ArrayList elements = ContainerUtil.newArrayListWithCapacity((int)tasks.size());
        for (DataNode taskDataNode : tasks) {
            elements.add(LookupElementBuilder.create((String)((TaskData)taskDataNode.getData()).getName()).withIcon(ExternalSystemIcons.Task));
        }
        return elements;
    }

    @Nullable
    public static DataNode<ModuleData> findModuleDataNode(@NotNull DataNode<ProjectData> projectDataNode, @NotNull String projectPath) {
        if (projectDataNode == null) {
            TaskCompletionProvider.$$$reportNull$$$0(10);
        }
        if (projectPath == null) {
            TaskCompletionProvider.$$$reportNull$$$0(11);
        }
        DataNode node = ExternalSystemApiUtil.findFirstRecursively(projectDataNode, node1 -> node1.getKey().equals((Object)ProjectKeys.MODULE) && node1.getData() instanceof ModuleData && ((ModuleData)node1.getData()).getLinkedExternalProjectPath().equals(projectPath));
        return node;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workDirectoryField";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDataNode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/TaskCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addArgumentVariants";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getVariants";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "findModuleDataNode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

