/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.deployment;

import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.descriptors.ConfigFile;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class DeploymentUtilImpl
extends DeploymentUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.deployment.MakeUtilImpl");

    private static void checkPathDoNotNavigatesUpFromFile(File file) {
        String filepath;
        File filepart;
        String path = file.getPath();
        int i = path.indexOf("..");
        if (i != -1 && (filepart = new File(filepath = path.substring(0, i - 1))).exists() && !filepart.isDirectory()) {
            LOG.error("Incorrect file path: '" + path + '\'');
        }
    }

    private static String createCopyErrorMessage(File fromFile, File toFile) {
        return CompilerBundle.message((String)"message.text.error.copying.file.to.file", (Object[])new Object[]{FileUtil.toSystemDependentName((String)fromFile.getPath()), FileUtil.toSystemDependentName((String)toFile.getPath())});
    }

    @Nullable
    public String getConfigFileErrorMessage(ConfigFile configFile) {
        XmlDocument document;
        if (configFile.getVirtualFile() == null) {
            String path = FileUtil.toSystemDependentName((String)VfsUtil.urlToPath((String)configFile.getUrl()));
            return CompilerBundle.message((String)"mesage.text.deployment.descriptor.file.not.exist", (Object[])new Object[]{path});
        }
        PsiFile psiFile = configFile.getPsiFile();
        if (psiFile == null || !psiFile.isValid()) {
            return CompilerBundle.message((String)"message.text.deployment.description.invalid.file", (Object[])new Object[0]);
        }
        if (psiFile instanceof XmlFile && ((document = ((XmlFile)psiFile).getDocument()) == null || document.getRootTag() == null)) {
            return CompilerBundle.message((String)"message.text.xml.file.invalid", (Object[])new Object[]{FileUtil.toSystemDependentName((String)VfsUtil.urlToPath((String)configFile.getUrl()))});
        }
        return null;
    }
}

