/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.jarRepository.settings.RepositoryLibraryPropertiesDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.IdeaModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibrarySupport;
import org.jetbrains.idea.maven.utils.library.propertiesEditor.RepositoryLibraryPropertiesModel;

public class RepositoryAddLibraryAction
extends IntentionAndQuickFixAction {
    private final Module module;
    @NotNull
    private final RepositoryLibraryDescription libraryDescription;

    public RepositoryAddLibraryAction(Module module2, @NotNull RepositoryLibraryDescription libraryDescription) {
        if (libraryDescription == null) {
            RepositoryAddLibraryAction.$$$reportNull$$$0(0);
        }
        this.module = module2;
        this.libraryDescription = libraryDescription;
    }

    @NotNull
    public String getName() {
        String string = "Add " + this.libraryDescription.getDisplayName() + " library to module dependencies";
        if (string == null) {
            RepositoryAddLibraryAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Maven libraries" == null) {
            RepositoryAddLibraryAction.$$$reportNull$$$0(2);
        }
        return "Maven libraries";
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project2, PsiFile file, @Nullable Editor editor) {
        if (project2 == null) {
            RepositoryAddLibraryAction.$$$reportNull$$$0(3);
        }
        RepositoryAddLibraryAction.addLibraryToModule(this.libraryDescription, this.module);
    }

    public static Promise<Void> addLibraryToModule(RepositoryLibraryDescription libraryDescription, Module module2) {
        RepositoryLibraryPropertiesModel model = new RepositoryLibraryPropertiesModel("RELEASE", false, false);
        RepositoryLibraryPropertiesDialog dialog = new RepositoryLibraryPropertiesDialog(module2.getProject(), model, libraryDescription, false, true);
        if (!dialog.showAndGet()) {
            return Promises.rejectedPromise();
        }
        IdeaModifiableModelsProvider modifiableModelsProvider2 = new IdeaModifiableModelsProvider();
        ModifiableRootModel modifiableModel = modifiableModelsProvider2.getModuleModifiableModel(module2);
        RepositoryLibrarySupport librarySupport = new RepositoryLibrarySupport(module2.getProject(), libraryDescription, model);
        assert (modifiableModel != null);
        librarySupport.addSupport(module2, modifiableModel, modifiableModelsProvider2);
        ApplicationManager.getApplication().runWriteAction(() -> ((ModifiableRootModel)modifiableModel).commit());
        return Promises.resolvedPromise(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryDescription";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarRepository/RepositoryAddLibraryAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarRepository/RepositoryAddLibraryAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

