/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ProgressIndicatorWrapper;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.impl.ProjectFromSourcesBuilderImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.text.StringFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleInsight {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.importProject.ModuleInsight");
    @NotNull
    protected final ProgressIndicatorWrapper myProgress;
    private final Set<File> myEntryPointRoots = new HashSet<File>();
    private final List<DetectedSourceRoot> mySourceRoots = new ArrayList<DetectedSourceRoot>();
    private final Set<String> myIgnoredNames = new HashSet<String>();
    private final Map<File, Set<String>> mySourceRootToReferencedPackagesMap = new HashMap<File, Set<String>>();
    private final Map<File, Set<String>> mySourceRootToPackagesMap = new HashMap<File, Set<String>>();
    private final Map<File, Set<String>> myJarToPackagesMap = new HashMap<File, Set<String>>();
    private final StringInterner myInterner = new StringInterner();
    private List<ModuleDescriptor> myModules;
    private List<LibraryDescriptor> myLibraries;
    private final Set<String> myExistingModuleNames;
    private final Set<String> myExistingProjectLibraryNames;

    public ModuleInsight(@Nullable ProgressIndicator progress, Set<String> existingModuleNames, Set<String> existingProjectLibraryNames) {
        this.myExistingModuleNames = existingModuleNames;
        this.myExistingProjectLibraryNames = existingProjectLibraryNames;
        this.myProgress = new ProgressIndicatorWrapper(progress);
        this.setRoots(Collections.emptyList(), Collections.emptyList(), Collections.emptySet());
    }

    public final void setRoots(List<? extends File> contentRoots, List<? extends DetectedSourceRoot> sourceRoots, Set<String> ignoredNames) {
        this.myModules = null;
        this.myLibraries = null;
        this.myEntryPointRoots.clear();
        this.myEntryPointRoots.addAll(contentRoots);
        this.mySourceRoots.clear();
        this.mySourceRoots.addAll(sourceRoots);
        this.myIgnoredNames.clear();
        this.myIgnoredNames.addAll(ignoredNames);
        this.myJarToPackagesMap.clear();
        this.myInterner.clear();
    }

    @Nullable
    public List<LibraryDescriptor> getSuggestedLibraries() {
        return this.myLibraries;
    }

    @Nullable
    public List<ModuleDescriptor> getSuggestedModules() {
        return this.myModules;
    }

    public void scanModules() {
        this.myProgress.setIndeterminate(true);
        HashMap<File, ModuleDescriptor> contentRootToModules = new HashMap<File, ModuleDescriptor>();
        try {
            this.myProgress.pushState();
            ArrayList<DetectedSourceRoot> processedRoots = new ArrayList<DetectedSourceRoot>();
            for (DetectedSourceRoot root : this.getSourceRootsToScan()) {
                File sourceRoot = root.getDirectory();
                if (this.isIgnoredName(sourceRoot)) continue;
                this.myProgress.setText("Scanning " + sourceRoot.getPath());
                HashSet<String> usedPackages = new HashSet<String>();
                this.mySourceRootToReferencedPackagesMap.put(sourceRoot, usedPackages);
                HashSet<String> selfPackages = new HashSet<String>();
                this.addExportedPackages(sourceRoot, selfPackages);
                this.scanSources(sourceRoot, ProjectFromSourcesBuilderImpl.getPackagePrefix(root), usedPackages, selfPackages);
                usedPackages.removeAll(selfPackages);
                processedRoots.add(root);
            }
            this.myProgress.popState();
            this.myProgress.pushState();
            this.myProgress.setText("Building modules layout...");
            for (DetectedSourceRoot sourceRoot : processedRoots) {
                File srcRoot = sourceRoot.getDirectory();
                File moduleContentRoot = this.isEntryPointRoot(srcRoot) ? srcRoot : srcRoot.getParentFile();
                ModuleDescriptor moduleDescriptor = (ModuleDescriptor)contentRootToModules.get(moduleContentRoot);
                if (moduleDescriptor != null) {
                    moduleDescriptor.addSourceRoot(moduleContentRoot, sourceRoot);
                    continue;
                }
                moduleDescriptor = this.createModuleDescriptor(moduleContentRoot, Collections.singletonList(sourceRoot));
                contentRootToModules.put(moduleContentRoot, moduleDescriptor);
            }
            this.buildModuleDependencies(contentRootToModules);
            this.myProgress.popState();
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        this.addModules(contentRootToModules.values());
    }

    protected void addExportedPackages(File sourceRoot, Set<String> packages) {
        this.mySourceRootToPackagesMap.put(sourceRoot, packages);
    }

    protected boolean isIgnoredName(File sourceRoot) {
        return this.myIgnoredNames.contains(sourceRoot.getName());
    }

    protected void addModules(Collection<ModuleDescriptor> newModules) {
        if (this.myModules == null) {
            this.myModules = new ArrayList<ModuleDescriptor>(newModules);
        } else {
            this.myModules.addAll(newModules);
        }
        HashSet<String> moduleNames = new HashSet<String>(this.myExistingModuleNames);
        for (ModuleDescriptor module2 : newModules) {
            String suggested = ModuleInsight.suggestUniqueName(moduleNames, module2.getName());
            module2.setName(suggested);
            moduleNames.add(suggested);
        }
    }

    @NotNull
    protected List<DetectedSourceRoot> getSourceRootsToScan() {
        List<DetectedSourceRoot> list = Collections.unmodifiableList(this.mySourceRoots);
        if (list == null) {
            ModuleInsight.$$$reportNull$$$0(0);
        }
        return list;
    }

    protected boolean isEntryPointRoot(File srcRoot) {
        return this.myEntryPointRoots.contains(srcRoot);
    }

    protected abstract ModuleDescriptor createModuleDescriptor(File var1, Collection<DetectedSourceRoot> var2);

    private void buildModuleDependencies(Map<File, ModuleDescriptor> contentRootToModules) {
        Set<File> moduleContentRoots = contentRootToModules.keySet();
        for (File contentRoot : moduleContentRoots) {
            ModuleDescriptor checkedModule = contentRootToModules.get(contentRoot);
            this.myProgress.setText2("Building library dependencies for module " + checkedModule.getName());
            this.buildJarDependencies(checkedModule);
            this.myProgress.setText2("Building module dependencies for module " + checkedModule.getName());
            block1: for (File aContentRoot : moduleContentRoots) {
                ModuleDescriptor aModule = contentRootToModules.get(aContentRoot);
                if (checkedModule.equals(aModule)) continue;
                Collection<? extends DetectedProjectRoot> aModuleRoots = aModule.getSourceRoots();
                for (DetectedProjectRoot detectedProjectRoot : checkedModule.getSourceRoots()) {
                    Set<String> referencedBySourceRoot = this.mySourceRootToReferencedPackagesMap.get(detectedProjectRoot.getDirectory());
                    for (DetectedProjectRoot detectedProjectRoot2 : aModuleRoots) {
                        if (!ContainerUtil.intersects(referencedBySourceRoot, (Collection)this.mySourceRootToPackagesMap.get(detectedProjectRoot2.getDirectory()))) continue;
                        checkedModule.addDependencyOn(aModule);
                        continue block1;
                    }
                }
            }
        }
    }

    private void buildJarDependencies(ModuleDescriptor module2) {
        block0: for (File jarFile : this.myJarToPackagesMap.keySet()) {
            Set<String> jarPackages = this.myJarToPackagesMap.get(jarFile);
            for (DetectedProjectRoot detectedProjectRoot : module2.getSourceRoots()) {
                if (!ContainerUtil.intersects((Collection)this.mySourceRootToReferencedPackagesMap.get(detectedProjectRoot.getDirectory()), jarPackages)) continue;
                module2.addLibraryFile(jarFile);
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanLibraries() {
        this.myProgress.setIndeterminate(true);
        this.myProgress.pushState();
        try {
            try {
                for (File root : this.myEntryPointRoots) {
                    this.myProgress.setText("Scanning for libraries " + root.getPath());
                    this.scanRootForLibraries(root);
                }
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
            this.myProgress.setText("Building initial libraries layout...");
            List<LibraryDescriptor> libraries2 = ModuleInsight.buildInitialLibrariesLayout(this.myJarToPackagesMap.keySet());
            HashSet<String> libNames = new HashSet<String>(this.myExistingProjectLibraryNames);
            for (LibraryDescriptor library : libraries2) {
                Collection<File> libJars = library.getJars();
                String newName = ModuleInsight.suggestUniqueName(libNames, libJars.size() == 1 ? FileUtil.getNameWithoutExtension((File)libJars.iterator().next()) : library.getName());
                library.setName(newName);
                libNames.add(newName);
            }
            this.myLibraries = libraries2;
        }
        finally {
            this.myProgress.popState();
        }
    }

    public abstract boolean isApplicableRoot(DetectedProjectRoot var1);

    private static String suggestUniqueName(Set<String> existingNames, String baseName) {
        String name2 = baseName;
        int index = 1;
        while (existingNames.contains(name2)) {
            name2 = baseName + index++;
        }
        return name2;
    }

    public void merge(ModuleDescriptor mainModule, ModuleDescriptor module2) {
        for (File contentRoot : module2.getContentRoots()) {
            File _contentRoot = ModuleInsight.appendContentRoot(mainModule, contentRoot);
            Collection<DetectedSourceRoot> sources = module2.getSourceRoots(contentRoot);
            for (DetectedSourceRoot source : sources) {
                mainModule.addSourceRoot(_contentRoot, source);
            }
        }
        for (File jar : module2.getLibraryFiles()) {
            mainModule.addLibraryFile(jar);
        }
        for (ModuleDescriptor dependency : module2.getDependencies()) {
            if (mainModule.equals(dependency)) continue;
            mainModule.addDependencyOn(dependency);
        }
        this.myModules.remove(module2);
        for (ModuleDescriptor moduleDescr : this.myModules) {
            if (!moduleDescr.getDependencies().contains(module2)) continue;
            moduleDescr.removeDependencyOn(module2);
            if (moduleDescr.equals(mainModule)) continue;
            moduleDescr.addDependencyOn(mainModule);
        }
    }

    public LibraryDescriptor splitLibrary(LibraryDescriptor library, String newLibraryName, Collection<File> jarsToExtract) {
        LibraryDescriptor newLibrary = new LibraryDescriptor(newLibraryName, jarsToExtract);
        this.myLibraries.add(newLibrary);
        library.removeJars(jarsToExtract);
        if (library.getJars().size() == 0) {
            this.removeLibrary(library);
        }
        return newLibrary;
    }

    @Nullable
    public ModuleDescriptor splitModule(ModuleDescriptor descriptor2, String newModuleName, Collection<File> contentsToExtract) {
        ModuleDescriptor newModule = null;
        for (File root : contentsToExtract) {
            HashSet sources = descriptor2.removeContentRoot(root);
            if (newModule == null) {
                newModule = this.createModuleDescriptor(root, sources != null ? sources : new HashSet());
                continue;
            }
            if (sources != null && sources.size() > 0) {
                for (DetectedSourceRoot source : sources) {
                    newModule.addSourceRoot(root, source);
                }
                continue;
            }
            newModule.addContentRoot(root);
        }
        if (newModule == null) {
            return null;
        }
        newModule.setName(newModuleName);
        this.myModules.add(newModule);
        HashMap<File, ModuleDescriptor> contentRootToModule = new HashMap<File, ModuleDescriptor>();
        for (ModuleDescriptor module2 : this.myModules) {
            Set<File> roots = module2.getContentRoots();
            for (File root : roots) {
                contentRootToModule.put(root, module2);
            }
            module2.clearModuleDependencies();
            module2.clearLibraryFiles();
        }
        this.buildModuleDependencies(contentRootToModule);
        return newModule;
    }

    public void removeLibrary(LibraryDescriptor lib) {
        this.myLibraries.remove(lib);
    }

    public void moveJarsToLibrary(LibraryDescriptor from, Collection<File> files, LibraryDescriptor to) {
        to.addJars(files);
        from.removeJars(files);
        if (from.getJars().size() == 0) {
            this.removeLibrary(from);
        }
    }

    public Collection<LibraryDescriptor> getLibraryDependencies(ModuleDescriptor module2) {
        return ModuleInsight.getLibraryDependencies(module2, this.myLibraries);
    }

    public static Collection<LibraryDescriptor> getLibraryDependencies(ModuleDescriptor module2, @Nullable List<? extends LibraryDescriptor> allLibraries) {
        HashSet<LibraryDescriptor> libs = new HashSet<LibraryDescriptor>();
        if (allLibraries != null) {
            for (LibraryDescriptor libraryDescriptor : allLibraries) {
                if (!ContainerUtil.intersects(libraryDescriptor.getJars(), module2.getLibraryFiles())) continue;
                libs.add(libraryDescriptor);
            }
        }
        return libs;
    }

    private static File appendContentRoot(ModuleDescriptor module2, File contentRoot) {
        Set<File> moduleRoots = module2.getContentRoots();
        for (File moduleRoot : moduleRoots) {
            if (FileUtil.isAncestor((File)moduleRoot, (File)contentRoot, (boolean)false)) {
                return moduleRoot;
            }
            if (!FileUtil.isAncestor((File)contentRoot, (File)moduleRoot, (boolean)true)) continue;
            Collection<DetectedSourceRoot> currentSources = module2.getSourceRoots(moduleRoot);
            module2.removeContentRoot(moduleRoot);
            module2.addContentRoot(contentRoot);
            for (DetectedSourceRoot source : currentSources) {
                module2.addSourceRoot(contentRoot, source);
            }
            return contentRoot;
        }
        module2.addContentRoot(contentRoot);
        return contentRoot;
    }

    private static List<LibraryDescriptor> buildInitialLibrariesLayout(Set<? extends File> jars) {
        HashMap<File, LibraryDescriptor> rootToLibraryMap = new HashMap<File, LibraryDescriptor>();
        for (File file : jars) {
            File parent = file.getParentFile();
            LibraryDescriptor lib = (LibraryDescriptor)rootToLibraryMap.get(parent);
            if (lib == null) {
                lib = new LibraryDescriptor(parent.getName(), new HashSet<File>());
                rootToLibraryMap.put(parent, lib);
            }
            lib.addJars(Collections.singleton(file));
        }
        return new ArrayList<LibraryDescriptor>(rootToLibraryMap.values());
    }

    private void scanSources(File fromRoot, String parentPackageName, Set<String> usedPackages, Set<String> selfPackages) {
        if (this.isIgnoredName(fromRoot)) {
            return;
        }
        File[] files = fromRoot.listFiles();
        if (files != null) {
            this.myProgress.checkCanceled();
            boolean includeParentName = false;
            for (File file : files) {
                if (file.isDirectory()) {
                    String subPackageName = parentPackageName + (parentPackageName.isEmpty() ? "" : ".") + file.getName();
                    this.scanSources(file, subPackageName, usedPackages, selfPackages);
                    continue;
                }
                if (!this.isSourceFile(file)) continue;
                includeParentName = true;
                this.scanSourceFile(file, usedPackages);
            }
            if (includeParentName) {
                selfPackages.add((String)this.myInterner.intern((Object)parentPackageName));
            }
        }
    }

    protected abstract boolean isSourceFile(File var1);

    private void scanSourceFile(File file, Set<String> usedPackages) {
        this.myProgress.setText2(file.getName());
        try {
            char[] chars = FileUtil.loadFileText((File)file);
            this.scanSourceFileForImportedPackages(StringFactory.createShared((char[])chars), (Consumer<String>)((Consumer)s -> usedPackages.add((String)this.myInterner.intern(s))));
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    protected abstract void scanSourceFileForImportedPackages(CharSequence var1, Consumer<String> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanRootForLibraries(File fromRoot) {
        if (this.isIgnoredName(fromRoot)) {
            return;
        }
        File[] files = fromRoot.listFiles();
        if (files != null) {
            this.myProgress.checkCanceled();
            for (File file : files) {
                if (file.isDirectory()) {
                    this.scanRootForLibraries(file);
                    continue;
                }
                String fileName = file.getName();
                if (!this.isLibraryFile(fileName) || this.myJarToPackagesMap.containsKey(file)) continue;
                HashSet libraryPackages = new HashSet();
                this.myJarToPackagesMap.put(file, libraryPackages);
                this.myProgress.pushState();
                this.myProgress.setText2(file.getName());
                try {
                    this.scanLibraryForDeclaredPackages(file, (Consumer<String>)((Consumer)s -> {
                        if (!libraryPackages.contains(s)) {
                            libraryPackages.add(this.myInterner.intern(s));
                        }
                    }));
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    LOG.info((Throwable)e);
                }
                catch (InternalError e) {
                    LOG.info((Throwable)e);
                }
                finally {
                    this.myProgress.popState();
                }
            }
        }
    }

    protected abstract boolean isLibraryFile(String var1);

    protected abstract void scanLibraryForDeclaredPackages(File var1, Consumer<String> var2) throws IOException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/importProject/ModuleInsight", "getSourceRootsToScan"));
    }
}

