/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries;

import com.intellij.facet.Facet;
import com.intellij.facet.impl.ui.libraries.LibrariesValidatorContext;
import com.intellij.facet.impl.ui.libraries.RequiredLibrariesInfo;
import com.intellij.facet.ui.FacetConfigurationQuickFix;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.facet.ui.libraries.FacetLibrariesValidator;
import com.intellij.facet.ui.libraries.FacetLibrariesValidatorDescription;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.frameworkSupport.OldCustomLibraryDescription;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraries.AddCustomLibraryDialog;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class FacetLibrariesValidatorImpl
extends FacetLibrariesValidator {
    private final LibrariesValidatorContext myContext;
    private final FacetValidatorsManager myValidatorsManager;
    private RequiredLibrariesInfo myRequiredLibraries;
    private FacetLibrariesValidatorDescription myDescription;
    private final List<Library> myAddedLibraries = new ArrayList<Library>();

    public FacetLibrariesValidatorImpl(LibraryInfo[] requiredLibraries, FacetLibrariesValidatorDescription description, LibrariesValidatorContext context, FacetValidatorsManager validatorsManager) {
        this.myContext = context;
        this.myValidatorsManager = validatorsManager;
        this.myRequiredLibraries = new RequiredLibrariesInfo(requiredLibraries);
        this.myDescription = description;
    }

    public void setRequiredLibraries(LibraryInfo[] requiredLibraries) {
        this.myRequiredLibraries = new RequiredLibrariesInfo(requiredLibraries);
        this.onChange();
    }

    public boolean isLibrariesAdded() {
        return false;
    }

    public void setDescription(@NotNull FacetLibrariesValidatorDescription description) {
        if (description == null) {
            FacetLibrariesValidatorImpl.$$$reportNull$$$0(0);
        }
        this.myDescription = description;
        this.onChange();
    }

    @NotNull
    public ValidationResult check() {
        if (this.myRequiredLibraries == null) {
            ValidationResult validationResult = ValidationResult.OK;
            if (validationResult == null) {
                FacetLibrariesValidatorImpl.$$$reportNull$$$0(1);
            }
            return validationResult;
        }
        List<VirtualFile> roots = this.collectRoots(this.myContext.getRootModel());
        RequiredLibrariesInfo.RequiredClassesNotFoundInfo info = this.myRequiredLibraries.checkLibraries(VfsUtil.toVirtualFileArray(roots));
        if (info == null) {
            ValidationResult validationResult = ValidationResult.OK;
            if (validationResult == null) {
                FacetLibrariesValidatorImpl.$$$reportNull$$$0(2);
            }
            return validationResult;
        }
        String missingJars = IdeBundle.message((String)"label.missed.libraries.prefix", (Object[])new Object[0]) + " " + info.getMissingJarsText();
        LibraryInfo[] missingLibraries = info.getLibraryInfos();
        OldCustomLibraryDescription description = new OldCustomLibraryDescription(missingLibraries, this.myDescription.getDefaultLibraryName());
        ValidationResult validationResult = new ValidationResult(missingJars, (FacetConfigurationQuickFix)new LibrariesQuickFix(description));
        if (validationResult == null) {
            FacetLibrariesValidatorImpl.$$$reportNull$$$0(3);
        }
        return validationResult;
    }

    private void onChange() {
        if (this.myValidatorsManager != null) {
            this.myValidatorsManager.validate();
        }
    }

    public void onFacetInitialized(Facet facet) {
        for (Library addedLibrary : this.myAddedLibraries) {
            this.myDescription.onLibraryAdded(facet, addedLibrary);
        }
    }

    private List<VirtualFile> collectRoots(@NotNull ModuleRootModel rootModel) {
        if (rootModel == null) {
            FacetLibrariesValidatorImpl.$$$reportNull$$$0(4);
        }
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        rootModel.orderEntries().using((RootModelProvider)this.myContext.getModulesProvider()).recursively().librariesOnly().forEachLibrary(library -> {
            ContainerUtil.addAll((Collection)roots, (Object[])this.myContext.getLibrariesContainer().getLibraryFiles((Library)library, OrderRootType.CLASSES));
            return true;
        });
        return roots;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/ui/libraries/FacetLibrariesValidatorImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/ui/libraries/FacetLibrariesValidatorImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "check";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LibrariesQuickFix
    extends FacetConfigurationQuickFix {
        private final CustomLibraryDescription myDescription;

        LibrariesQuickFix(CustomLibraryDescription description) {
            super(IdeBundle.message((String)"button.fix", (Object[])new Object[0]));
            this.myDescription = description;
        }

        public void run(JComponent place) {
            AddCustomLibraryDialog dialog = AddCustomLibraryDialog.createDialog(this.myDescription, FacetLibrariesValidatorImpl.this.myContext.getLibrariesContainer(), FacetLibrariesValidatorImpl.this.myContext.getModule(), FacetLibrariesValidatorImpl.this.myContext.getModifiableRootModel(), null);
            dialog.show();
            FacetLibrariesValidatorImpl.this.myAddedLibraries.addAll(dialog.getAddedLibraries());
            FacetLibrariesValidatorImpl.this.onChange();
        }
    }
}

