/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery.indices;

import com.intellij.execution.testDiscovery.indices.DiscoveredTestsIndex;
import com.intellij.execution.testDiscovery.indices.PersistentObjectSeq;
import com.intellij.execution.testDiscovery.indices.TestFilesIndex;
import com.intellij.execution.testDiscovery.indices.TestId;
import com.intellij.execution.testDiscovery.indices.TestModuleIndex;
import com.intellij.execution.testDiscovery.indices.UsedSources;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.PersistentEnumeratorDelegate;
import com.intellij.util.io.PersistentStringEnumerator;
import gnu.trove.TIntArrayList;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DiscoveredTestDataHolder {
    private static final Logger LOG = Logger.getInstance(DiscoveredTestDataHolder.class);
    private final DiscoveredTestsIndex myDiscoveredTestsIndex;
    private final TestFilesIndex myTestFilesIndex;
    private final TestModuleIndex myTestModuleIndex;
    private final PersistentStringEnumerator myClassEnumerator;
    private final PersistentStringEnumerator myMethodEnumerator;
    private final PersistentStringEnumerator myPathEnumerator;
    private final PersistentEnumeratorDelegate<TestId> myTestEnumerator;
    private final PersistentObjectSeq myConstructedDataFiles;
    private boolean myDisposed;
    private final Disposable myDisposable;
    static final int VERSION = 10;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DiscoveredTestDataHolder(@NotNull Path basePath) {
        if (basePath == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(0);
        }
        this.myConstructedDataFiles = new PersistentObjectSeq();
        this.myDisposable = Disposer.newDisposable();
        Path versionFile = DiscoveredTestDataHolder.getVersionFile(basePath);
        PathKt.createDirectories((Path)basePath);
        File discoveredTestsIndexFile = basePath.resolve("discoveredTests.index").toFile();
        File testFilesIndexFile = basePath.resolve("testFiles.index").toFile();
        File classNameEnumeratorFile = basePath.resolve("className.enum").toFile();
        File methodNameEnumeratorFile = basePath.resolve("methodName.enum").toFile();
        File pathEnumeratorFile = basePath.resolve("path.enum").toFile();
        File testNameEnumeratorFile = basePath.resolve("testName.enum").toFile();
        try {
            PersistentEnumeratorDelegate testEnumerator;
            PersistentStringEnumerator pathEnumerator;
            PersistentStringEnumerator methodEnumerator;
            PersistentStringEnumerator classNameEnumerator;
            TestModuleIndex testModuleIndex;
            TestFilesIndex testFilesIndex;
            DiscoveredTestsIndex discoveredTestsIndex;
            int version = DiscoveredTestDataHolder.readVersion(versionFile);
            if (version != 10) {
                LOG.info(version != -1 ? "TestDiscoveryIndex was rewritten due to version change" : "TestDiscoveryIndex is not exist. Empty index is created");
                PathKt.delete((Path)basePath);
                DiscoveredTestDataHolder.writeVersion(versionFile);
            }
            int iterations = 0;
            while (true) {
                ++iterations;
                try {
                    discoveredTestsIndex = new DiscoveredTestsIndex(discoveredTestsIndexFile);
                    this.myConstructedDataFiles.add((InvertedIndex<?, ?, ?>)discoveredTestsIndex);
                    testFilesIndex = new TestFilesIndex(testFilesIndexFile);
                    this.myConstructedDataFiles.add((InvertedIndex<?, ?, ?>)testFilesIndex);
                    testModuleIndex = new TestModuleIndex(basePath, this.myConstructedDataFiles);
                    classNameEnumerator = new PersistentStringEnumerator(classNameEnumeratorFile, true);
                    this.myConstructedDataFiles.add((PersistentEnumeratorDelegate<?>)classNameEnumerator);
                    methodEnumerator = new PersistentStringEnumerator(methodNameEnumeratorFile, true);
                    this.myConstructedDataFiles.add((PersistentEnumeratorDelegate<?>)methodEnumerator);
                    pathEnumerator = new PersistentStringEnumerator(pathEnumeratorFile, true);
                    this.myConstructedDataFiles.add((PersistentEnumeratorDelegate<?>)pathEnumerator);
                    testEnumerator = new PersistentEnumeratorDelegate(testNameEnumeratorFile, TestId.DESCRIPTOR, 4096);
                    this.myConstructedDataFiles.add(testEnumerator);
                }
                catch (Throwable throwable) {
                    LOG.info("TestDiscoveryIndex problem", throwable);
                    this.myConstructedDataFiles.close(true);
                    this.myConstructedDataFiles.clear();
                    PathKt.delete((Path)basePath);
                    if (iterations < 3) continue;
                    LOG.error("Unexpected circular initialization problem");
                    assert (false);
                    continue;
                }
                break;
            }
            this.myDiscoveredTestsIndex = discoveredTestsIndex;
            this.myTestFilesIndex = testFilesIndex;
            this.myTestModuleIndex = testModuleIndex;
            this.myClassEnumerator = classNameEnumerator;
            this.myMethodEnumerator = methodEnumerator;
            this.myPathEnumerator = pathEnumerator;
            this.myTestEnumerator = testEnumerator;
            LowMemoryWatcher.register(() -> this.myConstructedDataFiles.flush(), (Disposable)this.myDisposable);
            return;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void writeVersion(@NotNull Path versionFile) throws IOException {
        if (versionFile == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(1);
        }
        try (DataOutputStream versionOut = new DataOutputStream(PathKt.outputStream((Path)versionFile));){
            DataInputOutputUtil.writeINT((DataOutput)versionOut, (int)10);
        }
    }

    private static int readVersion(@NotNull Path versionFile) throws IOException {
        InputStream inputStream;
        if (versionFile == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(2);
        }
        if ((inputStream = PathKt.inputStreamIfExists((Path)versionFile)) == null) {
            return -1;
        }
        try (DataInputStream versionInput = new DataInputStream(inputStream);){
            int n = DataInputOutputUtil.readINT((DataInput)versionInput);
            return n;
        }
    }

    public void flush() {
        this.myConstructedDataFiles.flush();
    }

    public void dispose() {
        try {
            Disposer.dispose((Disposable)this.myDisposable);
            this.myConstructedDataFiles.close(false);
        }
        finally {
            this.myDisposed = true;
        }
    }

    public boolean hasTestTrace(@NotNull String testClassName, @NotNull String testMethodName, byte frameworkId) throws IOException {
        int testId;
        if (testClassName == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(3);
        }
        if (testMethodName == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(4);
        }
        return (testId = this.myTestEnumerator.tryEnumerate((Object)this.createTestId(testClassName, testMethodName, frameworkId))) != 0 && this.myDiscoveredTestsIndex.containsDataFrom(testId);
    }

    public void removeTestTrace(@NotNull String testClassName, @NotNull String testMethodName, byte frameworkId) throws IOException {
        int testId;
        if (testClassName == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(5);
        }
        if (testMethodName == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(6);
        }
        if ((testId = this.myTestEnumerator.tryEnumerate((Object)this.createTestId(testClassName, testMethodName, frameworkId))) != 0) {
            this.myDiscoveredTestsIndex.update(testId, null).compute();
            this.myTestModuleIndex.removeTest(testId);
        }
    }

    @NotNull
    public Collection<String> getTestModulesByMethodName(@NotNull String testClassName, @NotNull String testMethodName, byte frameworkId) throws IOException {
        int testId;
        if (testClassName == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(7);
        }
        if (testMethodName == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(8);
        }
        if ((testId = this.myTestEnumerator.tryEnumerate((Object)this.createTestId(testClassName, testMethodName, frameworkId))) != 0) {
            Collection<String> collection = this.myTestModuleIndex.getTestRunModules(testId);
            if (collection == null) {
                DiscoveredTestDataHolder.$$$reportNull$$$0(9);
            }
            return collection;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(10);
        }
        return set;
    }

    public void updateTestData(@NotNull String testClassName, @NotNull String testMethodName, @NotNull MultiMap<String, String> usedMethods, @NotNull List<String> usedFiles, @Nullable String moduleName, byte frameworkId) throws IOException {
        if (testClassName == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(11);
        }
        if (testMethodName == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(12);
        }
        if (usedMethods == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(13);
        }
        if (usedFiles == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(14);
        }
        int testNameId = this.myTestEnumerator.enumerate((Object)this.createTestId(testClassName, testMethodName, frameworkId));
        HashMap<Integer, TIntArrayList> result = new HashMap<Integer, TIntArrayList>();
        for (Object e : usedMethods.entrySet()) {
            TIntArrayList methodIds = new TIntArrayList(((Collection)e.getValue()).size());
            result.put(this.myClassEnumerator.enumerate((String)e.getKey()), methodIds);
            for (String methodName : (Collection)e.getValue()) {
                methodIds.add(this.myMethodEnumerator.enumerate(methodName));
            }
        }
        HashMap<Integer, Void> usedVirtualFileIds = new HashMap<Integer, Void>();
        for (String file : usedFiles) {
            if (!file.contains("testData") && !file.contains("test-data") && !file.contains("test_data")) continue;
            int fileId = this.myPathEnumerator.enumerate(file);
            usedVirtualFileIds.put(fileId, null);
        }
        UsedSources usedSources = new UsedSources(result, usedVirtualFileIds);
        this.myDiscoveredTestsIndex.update(testNameId, usedSources).compute();
        this.myTestFilesIndex.update(testNameId, usedSources).compute();
        this.myTestModuleIndex.appendModuleData(testNameId, moduleName);
    }

    @NotNull
    public MultiMap<String, String> getTestsByFile(@NotNull String relativePath, byte frameworkId) throws IOException {
        MultiMap multiMap;
        int fileId;
        if (relativePath == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(15);
        }
        if ((fileId = this.myPathEnumerator.tryEnumerate((Object)relativePath)) == 0) {
            MultiMap multiMap2 = MultiMap.empty();
            if (multiMap2 == null) {
                DiscoveredTestDataHolder.$$$reportNull$$$0(16);
            }
            return multiMap2;
        }
        try {
            MultiMap result = new MultiMap();
            IOException[] exception = new IOException[]{null};
            this.myTestFilesIndex.getData(fileId).forEach((testId, v) -> this.consumeDiscoveredTest(testId, frameworkId, (MultiMap<String, String>)result, exception));
            if (exception[0] != null) {
                throw exception[0];
            }
            multiMap = result;
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
        if (multiMap == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(17);
        }
        return multiMap;
    }

    @NotNull
    public MultiMap<String, String> getTestsByClassName(@NotNull String classFQName, byte frameworkId) throws IOException {
        MultiMap multiMap;
        int classId;
        if (classFQName == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(18);
        }
        if ((classId = this.myClassEnumerator.tryEnumerate((Object)classFQName)) == 0) {
            MultiMap multiMap2 = MultiMap.empty();
            if (multiMap2 == null) {
                DiscoveredTestDataHolder.$$$reportNull$$$0(19);
            }
            return multiMap2;
        }
        try {
            MultiMap result = new MultiMap();
            IOException[] exception = new IOException[]{null};
            this.myDiscoveredTestsIndex.getData(classId).forEach((testId, value) -> this.consumeDiscoveredTest(testId, frameworkId, (MultiMap<String, String>)result, exception));
            if (exception[0] != null) {
                throw exception[0];
            }
            multiMap = result;
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
        if (multiMap == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(20);
        }
        return multiMap;
    }

    @NotNull
    public MultiMap<String, String> getTestsByMethodName(@NotNull String classFQName, @NotNull String methodName, byte frameworkId) throws IOException {
        MultiMap multiMap;
        int methodId;
        if (classFQName == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(21);
        }
        if (methodName == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(22);
        }
        if ((methodId = this.myMethodEnumerator.tryEnumerate((Object)methodName)) == 0) {
            MultiMap multiMap2 = MultiMap.empty();
            if (multiMap2 == null) {
                DiscoveredTestDataHolder.$$$reportNull$$$0(23);
            }
            return multiMap2;
        }
        int classId = this.myClassEnumerator.tryEnumerate((Object)classFQName);
        if (classId == 0) {
            MultiMap multiMap3 = MultiMap.empty();
            if (multiMap3 == null) {
                DiscoveredTestDataHolder.$$$reportNull$$$0(24);
            }
            return multiMap3;
        }
        try {
            MultiMap result = new MultiMap();
            IOException[] exception = new IOException[]{null};
            this.myDiscoveredTestsIndex.getData(classId).forEach((testId, value) -> !value.contains(methodId) || this.consumeDiscoveredTest(testId, frameworkId, (MultiMap<String, String>)result, exception));
            if (exception[0] != null) {
                throw exception[0];
            }
            multiMap = result;
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
        if (multiMap == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(25);
        }
        return multiMap;
    }

    @NotNull
    public Collection<String> getAffectedFiles(@NotNull Couple<String> testQName, byte frameworkId) throws IOException {
        int testId;
        if (testQName == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(26);
        }
        if ((testId = this.myTestEnumerator.tryEnumerate((Object)this.createTestId((String)testQName.getFirst(), (String)testQName.getSecond(), frameworkId))) == 0) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                DiscoveredTestDataHolder.$$$reportNull$$$0(27);
            }
            return set;
        }
        Collection<Integer> affectedFiles = this.myTestFilesIndex.getTestDataFor(testId);
        if (affectedFiles == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                DiscoveredTestDataHolder.$$$reportNull$$$0(28);
            }
            return set;
        }
        ArrayList<String> result = new ArrayList<String>(affectedFiles.size());
        for (Integer fileId : affectedFiles) {
            String filePath2 = this.myPathEnumerator.valueOf(fileId.intValue());
            if (filePath2 != null) {
                result.add(filePath2);
                continue;
            }
            LOG.error("file path is empty for file id =" + fileId);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    @NotNull
    static Path getVersionFile(Path path) {
        Path path2 = path.resolve("index.version");
        if (path2 == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(30);
        }
        return path2;
    }

    @NotNull
    private TestId createTestId(String className, String methodName, byte frameworkPrefix) throws IOException {
        TestId testId = new TestId(this.myClassEnumerator.enumerate(className), this.myMethodEnumerator.enumerate(methodName), frameworkPrefix);
        if (testId == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(31);
        }
        return testId;
    }

    private boolean consumeDiscoveredTest(int testId, byte frameworkId, @NotNull MultiMap<String, String> result, @NotNull IOException[] exceptionRef) {
        if (result == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(32);
        }
        if (exceptionRef == null) {
            DiscoveredTestDataHolder.$$$reportNull$$$0(33);
        }
        try {
            TestId test = (TestId)this.myTestEnumerator.valueOf(testId);
            if (test.getFrameworkId() == frameworkId) {
                String testClassName = this.myClassEnumerator.valueOf(test.getClassId());
                String testMethodName = this.myMethodEnumerator.valueOf(test.getMethodId());
                result.putValue((Object)testClassName, (Object)testMethodName);
            }
        }
        catch (IOException e) {
            exceptionRef[0] = e;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionFile";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClassName";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testMethodName";
                break;
            }
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testDiscovery/indices/DiscoveredTestDataHolder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedMethods";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedFiles";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFQName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testQName";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testDiscovery/indices/DiscoveredTestDataHolder";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestModulesByMethodName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestsByFile";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestsByClassName";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestsByMethodName";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedFiles";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionFile";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeVersion";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readVersion";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasTestTrace";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeTestTrace";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTestModulesByMethodName";
                break;
            }
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateTestData";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTestsByFile";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTestsByClassName";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTestsByMethodName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedFiles";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "consumeDiscoveredTest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

