/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.scratch;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.application.AbstractApplicationConfigurationProducer;
import com.intellij.execution.application.ApplicationConfigurationType;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.scratch.JavaScratchConfiguration;
import com.intellij.execution.scratch.JavaScratchConfigurationType;
import com.intellij.ide.scratch.ScratchFileType;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class JavaScratchConfigurationProducer
extends AbstractApplicationConfigurationProducer<JavaScratchConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        JavaScratchConfigurationType javaScratchConfigurationType = JavaScratchConfigurationType.getInstance();
        if (javaScratchConfigurationType == null) {
            JavaScratchConfigurationProducer.$$$reportNull$$$0(0);
        }
        return javaScratchConfigurationType;
    }

    @Override
    protected boolean setupConfigurationFromContext(JavaScratchConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        PsiFile psiFile;
        VirtualFile vFile;
        Location location = context.getLocation();
        if (location != null && (vFile = location.getVirtualFile()) != null && vFile.getFileType() == ScratchFileType.INSTANCE && (psiFile = location.getPsiElement().getContainingFile()) != null && psiFile.getLanguage() == JavaLanguage.INSTANCE) {
            configuration.setScratchFileUrl(vFile.getUrl());
            return super.setupConfigurationFromContext(configuration, context, sourceElement);
        }
        return false;
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        if (self == null) {
            JavaScratchConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (other == null) {
            JavaScratchConfigurationProducer.$$$reportNull$$$0(2);
        }
        return other.isProducedBy(AbstractApplicationConfigurationProducer.class) && !other.isProducedBy(JavaScratchConfigurationProducer.class);
    }

    @Override
    public boolean isConfigurationFromContext(JavaScratchConfiguration configuration, ConfigurationContext context) {
        PsiFile containingFile;
        VirtualFile scratchFile;
        PsiElement location = context.getPsiLocation();
        PsiClass aClass = ApplicationConfigurationType.getMainClass(location);
        return aClass != null && Comparing.equal((String)JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)aClass), (String)configuration.getMainClassName()) && (scratchFile = configuration.getScratchVirtualFile()) != null && (containingFile = aClass.getContainingFile()) != null && scratchFile.equals(containingFile.getVirtualFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/scratch/JavaScratchConfigurationProducer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/scratch/JavaScratchConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldReplace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

