/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.ClassesByNameProvider;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.debugger.ui.breakpoints.MethodBreakpointBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public class MethodBreakpoint
extends BreakpointWithHighlighter<JavaMethodBreakpointProperties>
implements MethodBreakpointBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.MethodBreakpoint");
    @Nullable
    private JVMName mySignature;
    private boolean myIsStatic;
    @NonNls
    public static final Key<MethodBreakpoint> CATEGORY = BreakpointCategory.lookup("method_breakpoints");

    protected MethodBreakpoint(@NotNull Project project2, XBreakpoint breakpoint) {
        if (project2 == null) {
            MethodBreakpoint.$$$reportNull$$$0(0);
        }
        super(project2, breakpoint);
    }

    public boolean isStatic() {
        return this.myIsStatic;
    }

    @Override
    @NotNull
    public Key<MethodBreakpoint> getCategory() {
        Key<MethodBreakpoint> key = CATEGORY;
        if (key == null) {
            MethodBreakpoint.$$$reportNull$$$0(1);
        }
        return key;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.getMethodName() != null;
    }

    @Override
    public void reload() {
        PsiClass psiClass;
        MethodDescriptor descriptor2;
        super.reload();
        this.setMethodName(null);
        this.mySignature = null;
        SourcePosition sourcePosition = this.getSourcePosition();
        if (sourcePosition != null && (descriptor2 = MethodBreakpoint.getMethodDescriptor(this.myProject, sourcePosition)) != null) {
            this.setMethodName(descriptor2.methodName);
            this.mySignature = descriptor2.methodSignature;
            this.myIsStatic = descriptor2.isStatic;
        }
        if ((psiClass = this.getPsiClass()) != null) {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myClassPattern = psiClass.getQualifiedName();
        }
        if (this.myIsStatic) {
            this.setInstanceFiltersEnabled(false);
        }
    }

    private static void createRequestForSubClasses(final @NotNull MethodBreakpointBase breakpoint, @NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType baseType) {
        if (breakpoint == null) {
            MethodBreakpoint.$$$reportNull$$$0(2);
        }
        if (debugProcess == null) {
            MethodBreakpoint.$$$reportNull$$$0(3);
        }
        if (baseType == null) {
            MethodBreakpoint.$$$reportNull$$$0(4);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        RequestManagerImpl requestsManager = debugProcess.getRequestsManager();
        ClassPrepareRequest request = requestsManager.createClassPrepareRequest((debuggerProcess, referenceType) -> {
            if (DebuggerUtilsImpl.instanceOf(referenceType, baseType)) {
                MethodBreakpoint.createRequestForPreparedClassEmulated(breakpoint, debugProcess, referenceType, false);
            }
        }, null);
        if (request != null) {
            requestsManager.registerRequest(breakpoint, request);
            request.enable();
        }
        AtomicReference indicatorRef = new AtomicReference();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            ProgressWindow progress = new ProgressWindow(true, false, debugProcess.getProject(), "Cancel emulation");
            progress.setDelayInMillis(2000);
            indicatorRef.set(progress);
        });
        final ProgressWindow indicator = (ProgressWindow)indicatorRef.get();
        final AtomicBoolean changed = new AtomicBoolean();
        XBreakpointListener listener = new XBreakpointListener<XBreakpoint<?>>(){

            void changed(@NotNull XBreakpoint b) {
                if (b == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (b == breakpoint.getXBreakpoint()) {
                    changed.set(true);
                    indicator.cancel();
                }
            }

            public void breakpointRemoved(@NotNull XBreakpoint b) {
                if (b == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.changed(b);
            }

            public void breakpointChanged(@NotNull XBreakpoint b) {
                if (b == null) {
                    1.$$$reportNull$$$0(2);
                }
                this.changed(b);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "b";
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/MethodBreakpoint$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "changed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "breakpointChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        debugProcess.getProject().getMessageBus().connect((Disposable)indicator).subscribe(XBreakpointListener.TOPIC, (Object)listener);
        ProgressManager.getInstance().executeProcessUnderProgress(() -> MethodBreakpoint.processPreparedSubTypes(baseType, (subType, classesByName) -> MethodBreakpoint.createRequestForPreparedClassEmulated(breakpoint, debugProcess, subType, classesByName, false), (ProgressIndicator)indicator), (ProgressIndicator)indicator);
        if (indicator.isCanceled() && !changed.get()) {
            breakpoint.disableEmulation();
        }
    }

    @Override
    public void disableEmulation() {
        MethodBreakpointBase.disableEmulation(this);
    }

    static void createRequestForPreparedClassEmulated(@NotNull MethodBreakpointBase breakpoint, @NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType classType, boolean base) {
        if (breakpoint == null) {
            MethodBreakpoint.$$$reportNull$$$0(5);
        }
        if (debugProcess == null) {
            MethodBreakpoint.$$$reportNull$$$0(6);
        }
        if (classType == null) {
            MethodBreakpoint.$$$reportNull$$$0(7);
        }
        MethodBreakpoint.createRequestForPreparedClassEmulated(breakpoint, debugProcess, classType, debugProcess.getVirtualMachineProxy().getClassesByNameProvider(), base);
    }

    static void createRequestForPreparedClassEmulated(final @NotNull MethodBreakpointBase breakpoint, final @NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType classType, @NotNull ClassesByNameProvider classesByName, boolean base) {
        if (breakpoint == null) {
            MethodBreakpoint.$$$reportNull$$$0(8);
        }
        if (debugProcess == null) {
            MethodBreakpoint.$$$reportNull$$$0(9);
        }
        if (classType == null) {
            MethodBreakpoint.$$$reportNull$$$0(10);
        }
        if (classesByName == null) {
            MethodBreakpoint.$$$reportNull$$$0(11);
        }
        if (!MethodBreakpointBase.canBeEmulated(debugProcess)) {
            breakpoint.disableEmulation();
            return;
        }
        if (!base && !MethodBreakpoint.shouldCreateRequest(breakpoint, breakpoint.getXBreakpoint(), debugProcess, true)) {
            return;
        }
        Method lambdaMethod = MethodBytecodeUtil.getLambdaMethod(classType, classesByName);
        if (lambdaMethod != null && !breakpoint.matchingMethods((StreamEx<Method>)StreamEx.of(((ClassType)classType).interfaces()).flatCollection(ReferenceType::allMethods), debugProcess).findFirst().isPresent()) {
            return;
        }
        StreamEx methods = lambdaMethod != null ? StreamEx.of((Object)lambdaMethod) : breakpoint.matchingMethods((StreamEx<Method>)((StreamEx)StreamEx.of(classType.methods()).filter(m -> base || !m.isAbstract())), debugProcess);
        boolean found2 = false;
        for (Method method : methods) {
            List<Location> allLineLocations;
            found2 = true;
            if (method.isNative()) {
                breakpoint.disableEmulation();
                return;
            }
            Method target = MethodBytecodeUtil.getBridgeTargetMethod(method, classesByName);
            if (target != null && !ContainerUtil.isEmpty(DebuggerUtilsEx.allLineLocations(target))) {
                method = target;
            }
            if ((allLineLocations = DebuggerUtilsEx.allLineLocations(method)) == null && !method.isBridge()) {
                breakpoint.disableEmulation();
                return;
            }
            if (ContainerUtil.isEmpty(allLineLocations)) continue;
            if (breakpoint.isWatchEntry()) {
                MethodBreakpoint.createLocationBreakpointRequest(breakpoint, (Location)ContainerUtil.getFirstItem(allLineLocations), debugProcess, true);
            }
            if (!breakpoint.isWatchExit()) continue;
            MethodBytecodeUtil.visit(method, new MethodVisitor(458752){
                int myLastLine;
                {
                    super(x0);
                    this.myLastLine = 0;
                }

                public void visitLineNumber(int line, Label start) {
                    this.myLastLine = line;
                }

                public void visitInsn(int opcode) {
                    switch (opcode) {
                        case 172: 
                        case 173: 
                        case 174: 
                        case 175: 
                        case 176: 
                        case 177: {
                            allLineLocations.stream().filter(l -> l.lineNumber() == this.myLastLine).findFirst().ifPresent(location -> MethodBreakpoint.createLocationBreakpointRequest(breakpoint, location, debugProcess, false));
                        }
                    }
                }
            }, true);
        }
        if (base && found2) {
            MethodBreakpoint.createRequestForSubClasses(breakpoint, debugProcess, classType);
        }
    }

    private static void createLocationBreakpointRequest(@NotNull FilteredRequestor requestor, @Nullable Location location, @NotNull DebugProcessImpl debugProcess, boolean methodEntry) {
        BreakpointRequest request;
        if (requestor == null) {
            MethodBreakpoint.$$$reportNull$$$0(12);
        }
        if (debugProcess == null) {
            MethodBreakpoint.$$$reportNull$$$0(13);
        }
        if ((request = MethodBreakpoint.createLocationBreakpointRequest(requestor, location, debugProcess)) != null) {
            request.putProperty("METHOD_ENTRY_KEY", methodEntry);
        }
    }

    @Override
    protected void createRequestForPreparedClass(@NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType classType) {
        if (debugProcess == null) {
            MethodBreakpoint.$$$reportNull$$$0(14);
        }
        if (classType == null) {
            MethodBreakpoint.$$$reportNull$$$0(15);
        }
        if (this.isEmulated()) {
            MethodBreakpoint.createRequestForPreparedClassEmulated(this, debugProcess, classType, true);
        } else {
            this.createRequestForPreparedClassOriginal(debugProcess, classType);
        }
    }

    private void createRequestForPreparedClassOriginal(@NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType classType) {
        if (debugProcess == null) {
            MethodBreakpoint.$$$reportNull$$$0(16);
        }
        if (classType == null) {
            MethodBreakpoint.$$$reportNull$$$0(17);
        }
        try {
            boolean hasMethod = false;
            for (Method method : classType.allMethods()) {
                String signature = method.signature();
                String name2 = method.name();
                if (!this.getMethodName().equals(name2) || !this.mySignature.getName(debugProcess).equals(signature)) continue;
                hasMethod = true;
                break;
            }
            if (!hasMethod) {
                debugProcess.getRequestsManager().setInvalid(this, DebuggerBundle.message((String)"error.invalid.breakpoint.method.not.found", (Object[])new Object[]{classType.name()}));
                return;
            }
            RequestManagerImpl requestManager = debugProcess.getRequestsManager();
            if (this.isWatchEntry()) {
                MethodEntryRequest entryRequest = MethodBreakpoint.findRequest(debugProcess, MethodEntryRequest.class, this);
                if (entryRequest == null) {
                    entryRequest = requestManager.createMethodEntryRequest(this);
                } else {
                    entryRequest.disable();
                }
                entryRequest.addClassFilter(classType);
                debugProcess.getRequestsManager().enableRequest(entryRequest);
            }
            if (this.isWatchExit()) {
                MethodExitRequest exitRequest = MethodBreakpoint.findRequest(debugProcess, MethodExitRequest.class, this);
                if (exitRequest == null) {
                    exitRequest = requestManager.createMethodExitRequest(this);
                } else {
                    exitRequest.disable();
                }
                exitRequest.addClassFilter(classType);
                debugProcess.getRequestsManager().enableRequest(exitRequest);
            }
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
    }

    @Override
    public String getEventMessage(@NotNull LocatableEvent event) {
        if (event == null) {
            MethodBreakpoint.$$$reportNull$$$0(18);
        }
        return MethodBreakpoint.getEventMessage(event, this.getFileName());
    }

    static String getEventMessage(@NotNull LocatableEvent event, @NotNull String defaultFileName) {
        if (event == null) {
            MethodBreakpoint.$$$reportNull$$$0(19);
        }
        if (defaultFileName == null) {
            MethodBreakpoint.$$$reportNull$$$0(20);
        }
        Location location = event.location();
        if (event instanceof MethodEntryEvent) {
            return MethodBreakpoint.getEventMessage(true, ((MethodEntryEvent)event).method(), location, defaultFileName);
        }
        if (event instanceof MethodExitEvent) {
            return MethodBreakpoint.getEventMessage(false, ((MethodExitEvent)event).method(), location, defaultFileName);
        }
        Object entryProperty = event.request().getProperty("METHOD_ENTRY_KEY");
        if (entryProperty instanceof Boolean) {
            return MethodBreakpoint.getEventMessage((Boolean)entryProperty, location.method(), location, defaultFileName);
        }
        return "";
    }

    private static String getEventMessage(boolean entry, Method method, Location location, String defaultFileName) {
        String locationQName = DebuggerUtilsEx.getLocationMethodQName(location);
        String locationFileName = DebuggerUtilsEx.getSourceName(location, e -> defaultFileName);
        int locationLine = location.lineNumber();
        return DebuggerBundle.message((String)(entry ? "status.method.entry.breakpoint.reached" : "status.method.exit.breakpoint.reached"), (Object[])new Object[]{method.declaringType().name() + "." + method.name() + "()", locationQName, locationFileName, locationLine});
    }

    @Override
    public PsiElement getEvaluationElement() {
        return this.getPsiClass();
    }

    @Override
    protected Icon getDisabledIcon(boolean isMuted) {
        if (DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this) != null && isMuted) {
            return AllIcons.Debugger.Db_muted_dep_method_breakpoint;
        }
        return null;
    }

    @Override
    protected Icon getVerifiedIcon(boolean isMuted) {
        return this.isSuspend() ? AllIcons.Debugger.Db_verified_method_breakpoint : AllIcons.Debugger.Db_verified_no_suspend_method_breakpoint;
    }

    @Override
    @NotNull
    protected Icon getVerifiedWarningsIcon(boolean isMuted) {
        LayeredIcon layeredIcon = new LayeredIcon(new Icon[]{isMuted ? AllIcons.Debugger.Db_muted_method_breakpoint : AllIcons.Debugger.Db_method_breakpoint, AllIcons.General.WarningDecorator});
        if (layeredIcon == null) {
            MethodBreakpoint.$$$reportNull$$$0(21);
        }
        return layeredIcon;
    }

    @Override
    public String getDisplayName() {
        StringBuilder buffer = new StringBuilder();
        if (this.isValid()) {
            boolean classNameExists;
            String className = this.getClassName();
            boolean bl = classNameExists = className != null && className.length() > 0;
            if (classNameExists) {
                buffer.append(className);
            }
            if (this.getMethodName() != null) {
                if (classNameExists) {
                    buffer.append(".");
                }
                buffer.append(this.getMethodName());
            }
        } else {
            buffer.append(DebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]));
        }
        return buffer.toString();
    }

    @Override
    public boolean evaluateCondition(@NotNull EvaluationContextImpl context, @NotNull LocatableEvent event) throws EvaluateException {
        if (context == null) {
            MethodBreakpoint.$$$reportNull$$$0(22);
        }
        if (event == null) {
            MethodBreakpoint.$$$reportNull$$$0(23);
        }
        if (!this.matchesEvent(event, context.getDebugProcess())) {
            return false;
        }
        return super.evaluateCondition(context, event);
    }

    public boolean matchesEvent(@NotNull LocatableEvent event, DebugProcessImpl process2) throws EvaluateException {
        if (event == null) {
            MethodBreakpoint.$$$reportNull$$$0(24);
        }
        if (this.isEmulated()) {
            return true;
        }
        if (this.getMethodName() == null || this.mySignature == null) {
            return false;
        }
        Method method = event.location().method();
        return method != null && method.name().equals(this.getMethodName()) && method.signature().equals(this.mySignature.getName(process2));
    }

    @Nullable
    public static MethodBreakpoint create(@NotNull Project project2, XBreakpoint xBreakpoint) {
        if (project2 == null) {
            MethodBreakpoint.$$$reportNull$$$0(25);
        }
        MethodBreakpoint breakpoint = new MethodBreakpoint(project2, xBreakpoint);
        return (MethodBreakpoint)breakpoint.init();
    }

    @Nullable
    private static MethodDescriptor getMethodDescriptor(@NotNull Project project2, @NotNull SourcePosition sourcePosition) {
        Document document;
        if (project2 == null) {
            MethodBreakpoint.$$$reportNull$$$0(26);
        }
        if (sourcePosition == null) {
            MethodBreakpoint.$$$reportNull$$$0(27);
        }
        if ((document = PsiDocumentManager.getInstance((Project)project2).getDocument(sourcePosition.getFile())) == null) {
            return null;
        }
        MethodDescriptor descriptor2 = (MethodDescriptor)ReadAction.compute(() -> {
            PsiMethod method = PositionUtil.getPsiElementAt(project2, PsiMethod.class, sourcePosition);
            if (method == null) {
                return null;
            }
            int methodOffset = method.getTextOffset();
            if (!DocumentUtil.isValidOffset((int)methodOffset, (Document)document) || document.getLineNumber(methodOffset) < sourcePosition.getLine()) {
                return null;
            }
            PsiIdentifier identifier = method.getNameIdentifier();
            int methodNameOffset = identifier != null ? identifier.getTextOffset() : methodOffset;
            MethodDescriptor res = new MethodDescriptor();
            res.methodName = JVMNameUtil.getJVMMethodName(method);
            try {
                res.methodSignature = JVMNameUtil.getJVMSignature(method);
                res.isStatic = method.hasModifierProperty("static");
            }
            catch (IndexNotReadyException ignored) {
                return null;
            }
            res.methodLine = document.getLineNumber(methodNameOffset);
            return res;
        });
        if (descriptor2 == null || descriptor2.methodName == null || descriptor2.methodSignature == null) {
            return null;
        }
        return descriptor2;
    }

    @Nullable
    static <T extends EventRequest> T findRequest(@NotNull DebugProcessImpl debugProcess, Class<T> requestClass, Requestor requestor) {
        if (debugProcess == null) {
            MethodBreakpoint.$$$reportNull$$$0(28);
        }
        return (T)((EventRequest)StreamEx.of(debugProcess.getRequestsManager().findRequests(requestor)).select(requestClass).findFirst().orElse(null));
    }

    @Override
    public void readExternal(@NotNull Element breakpointNode) throws InvalidDataException {
        if (breakpointNode == null) {
            MethodBreakpoint.$$$reportNull$$$0(29);
        }
        super.readExternal(breakpointNode);
        try {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_ENTRY = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)breakpointNode, (String)"WATCH_ENTRY"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_EXIT = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)breakpointNode, (String)"WATCH_EXIT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isEmulated() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).EMULATED;
    }

    @Override
    public boolean isWatchEntry() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_ENTRY;
    }

    @Override
    public boolean isWatchExit() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).WATCH_EXIT;
    }

    @Override
    public StreamEx matchingMethods(StreamEx<Method> methods, DebugProcessImpl debugProcess) {
        try {
            String methodName = this.getMethodName();
            String signature = this.mySignature != null ? this.mySignature.getName(debugProcess) : null;
            return (StreamEx)((StreamEx)methods.filter(m -> Comparing.equal((String)methodName, (String)m.name()) && Comparing.equal((String)signature, (String)m.signature()))).limit(1L);
        }
        catch (EvaluateException e) {
            LOG.warn((Throwable)e);
            return StreamEx.empty();
        }
    }

    @Nullable
    private String getMethodName() {
        return ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myMethodName;
    }

    private void setMethodName(@Nullable String methodName) {
        ((JavaMethodBreakpointProperties)((Object)this.getProperties())).myMethodName = methodName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processPreparedSubTypes(ReferenceType classType, BiConsumer<ReferenceType, ClassesByNameProvider> consumer, ProgressIndicator progressIndicator) {
        long start = 0L;
        if (LOG.isDebugEnabled()) {
            start = System.currentTimeMillis();
        }
        progressIndicator.setIndeterminate(false);
        progressIndicator.start();
        progressIndicator.setText(DebuggerBundle.message((String)"label.method.breakpoints.processing.classes", (Object[])new Object[0]));
        try {
            MultiMap inheritance = new MultiMap();
            List<ReferenceType> allTypes = classType.virtualMachine().allClasses();
            for (int i = 0; i < allTypes.size(); ++i) {
                if (progressIndicator.isCanceled()) {
                    return;
                }
                ReferenceType type = allTypes.get(i);
                if (type.isPrepared()) {
                    try {
                        DebuggerUtilsImpl.supertypes(type).forEach(st -> inheritance.putValue(st, (Object)type));
                    }
                    catch (ObjectCollectedException objectCollectedException) {
                        // empty catch block
                    }
                }
                progressIndicator.setText2(i + "/" + allTypes.size());
                progressIndicator.setFraction((double)i / (double)allTypes.size());
            }
            List types = ((StreamEx)StreamEx.ofTree((Object)classType, t -> StreamEx.of((Collection)inheritance.get(t))).skip(1L)).toList();
            progressIndicator.setText(DebuggerBundle.message((String)"label.method.breakpoints.setting.breakpoints", (Object[])new Object[0]));
            ClassesByNameProvider classesByName = ClassesByNameProvider.createCache(allTypes);
            for (int i = 0; i < types.size(); ++i) {
                if (progressIndicator.isCanceled()) {
                    return;
                }
                consumer.accept((ReferenceType)types.get(i), classesByName);
                progressIndicator.setText2(i + "/" + types.size());
                progressIndicator.setFraction((double)i / (double)types.size());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processed " + types.size() + " classes in " + (System.currentTimeMillis() - start) + "ms");
            }
        }
        finally {
            progressIndicator.stop();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/breakpoints/MethodBreakpoint";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseType";
                break;
            }
            case 7: 
            case 10: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesByName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 18: 
            case 19: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultFileName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePosition";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpointNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/breakpoints/MethodBreakpoint";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCategory";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getVerifiedWarningsIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 21: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createRequestForSubClasses";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createRequestForPreparedClassEmulated";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createLocationBreakpointRequest";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createRequestForPreparedClass";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createRequestForPreparedClassOriginal";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getEventMessage";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "evaluateCondition";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "matchesEvent";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getMethodDescriptor";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findRequest";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MethodDescriptor {
        String methodName;
        JVMName methodSignature;
        boolean isStatic;
        int methodLine;

        private MethodDescriptor() {
        }
    }
}

