/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.concurrency.ResultConsumer;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.ValueHint;
import com.intellij.debugger.ui.impl.InspectDebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeCreator;
import org.jetbrains.annotations.NotNull;

class DebuggerTreeCreatorImpl
implements DebuggerTreeCreator<Pair<NodeDescriptorImpl, String>> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.ValueHintTreeComponent");
    private final Project myProject;

    DebuggerTreeCreatorImpl(Project project2) {
        this.myProject = project2;
    }

    @NotNull
    public String getTitle(@NotNull Pair<NodeDescriptorImpl, String> descriptor2) {
        if (descriptor2 == null) {
            DebuggerTreeCreatorImpl.$$$reportNull$$$0(0);
        }
        String string = (String)descriptor2.getSecond();
        if (string == null) {
            DebuggerTreeCreatorImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void createDescriptorByNode(Object node, final ResultConsumer<Pair<NodeDescriptorImpl, String>> resultConsumer) {
        if (node instanceof DebuggerTreeNodeImpl) {
            final DebuggerTreeNodeImpl debuggerTreeNode = (DebuggerTreeNodeImpl)node;
            final DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(this.myProject).getContext();
            context.getDebugProcess().getManagerThread().schedule(new DebuggerContextCommandImpl(context){

                @Override
                public void threadAction(@NotNull SuspendContextImpl suspendContext) {
                    if (suspendContext == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        TextWithImports evaluationText = DebuggerTreeNodeExpression.createEvaluationText(debuggerTreeNode, context);
                        resultConsumer.onSuccess((Object)Pair.create((Object)debuggerTreeNode.getDescriptor(), (Object)evaluationText.getText()));
                    }
                    catch (EvaluateException e) {
                        resultConsumer.onFailure((Throwable)e);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ui/DebuggerTreeCreatorImpl$1", "threadAction"));
                }
            });
        }
    }

    @NotNull
    public Tree createTree(@NotNull Pair<NodeDescriptorImpl, String> descriptor2) {
        if (descriptor2 == null) {
            DebuggerTreeCreatorImpl.$$$reportNull$$$0(2);
        }
        InspectDebuggerTree inspectDebuggerTree = ValueHint.createInspectTree((NodeDescriptorImpl)descriptor2.first, this.myProject);
        if (inspectDebuggerTree == null) {
            DebuggerTreeCreatorImpl.$$$reportNull$$$0(3);
        }
        return inspectDebuggerTree;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/ui/DebuggerTreeCreatorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/ui/DebuggerTreeCreatorImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTree";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

