/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.utils;

import com.intellij.openapi.util.text.StringUtil;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

class NamesUtils {
    NamesUtils() {
    }

    @NotNull
    static String getUniqueName(@NotNull ObjectReference ref) {
        if (ref == null) {
            NamesUtils.$$$reportNull$$$0(0);
        }
        String shortName = StringUtil.getShortName((String)ref.referenceType().name());
        String name2 = shortName.replace("[]", "Array");
        String string = String.format("%s@%d", name2, ref.uniqueID());
        if (string == null) {
            NamesUtils.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    static String getArrayUniqueName(@NotNull ArrayReference ref) {
        if (ref == null) {
            NamesUtils.$$$reportNull$$$0(2);
        }
        String shortName = StringUtil.getShortName((String)ref.referenceType().name());
        int length = ref.length();
        String name2 = shortName.replaceFirst(Pattern.quote("[]"), String.format("[%d]", length));
        String string = String.format("%s@%d", name2, ref.uniqueID());
        if (string == null) {
            NamesUtils.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/utils/NamesUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/utils/NamesUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayUniqueName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueName";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getArrayUniqueName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

