/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.jdi.VirtualMachineProxy;
import com.intellij.debugger.impl.ClassLoadingUtils;
import com.intellij.debugger.memory.agent.MemoryAgent;
import com.intellij.debugger.memory.agent.MemoryAgentImpl;
import com.intellij.debugger.memory.agent.ReferringObjectsInfo;
import com.intellij.debugger.memory.agent.extractor.ProxyExtractor;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.ObjectReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AgentLoader {
    public static final MemoryAgent DEFAULT_PROXY = new MyDisabledMemoryAgent();
    private static final Logger LOG = Logger.getInstance(AgentLoader.class);

    @NotNull
    public MemoryAgent load(@NotNull EvaluationContextImpl evaluationContext, @NotNull VirtualMachineProxy virtualMachine) {
        block6: {
            MemoryAgent memoryAgent;
            if (evaluationContext == null) {
                AgentLoader.$$$reportNull$$$0(0);
            }
            if (virtualMachine == null) {
                AgentLoader.$$$reportNull$$$0(1);
            }
            DebuggerManagerThreadImpl.assertIsManagerThread();
            try {
                ClassType classType = AgentLoader.ensureClassLoaded(evaluationContext, virtualMachine);
                if (classType == null) break block6;
                MemoryAgentImpl agent = new MemoryAgentImpl(evaluationContext.getDebugProcess(), classType);
                agent.initializeCapabilities();
                memoryAgent = agent.isLoaded() ? agent : DEFAULT_PROXY;
            }
            catch (EvaluateException e) {
                LOG.info("Could not load proxy class", (Throwable)e);
            }
            if (memoryAgent == null) {
                AgentLoader.$$$reportNull$$$0(2);
            }
            return memoryAgent;
        }
        MemoryAgent memoryAgent = DEFAULT_PROXY;
        if (memoryAgent == null) {
            AgentLoader.$$$reportNull$$$0(3);
        }
        return memoryAgent;
    }

    @Nullable
    private static ClassType ensureClassLoaded(@NotNull EvaluationContextImpl context, @NotNull VirtualMachineProxy vm) throws EvaluateException {
        List classes;
        if (context == null) {
            AgentLoader.$$$reportNull$$$0(4);
        }
        if (vm == null) {
            AgentLoader.$$$reportNull$$$0(5);
        }
        if ((classes = vm.classesByName("com.intellij.memory.agent.proxy.IdeaNativeAgentProxy")).isEmpty()) {
            ClassType classType = AgentLoader.loadUtilityClass(context);
            if (classType == null) {
                LOG.error("Could not load proxy class");
            }
            return classType;
        }
        LOG.assertTrue(classes.size() == 1, (Object)("Too many utility classes loaded: " + classes.size()));
        return (ClassType)classes.get(0);
    }

    @Nullable
    private static ClassType loadUtilityClass(@NotNull EvaluationContextImpl context) throws EvaluateException {
        if (context == null) {
            AgentLoader.$$$reportNull$$$0(6);
        }
        DebugProcessImpl debugProcess = context.getDebugProcess();
        byte[] bytes = AgentLoader.readUtilityClass();
        ClassLoaderReference classLoader = ClassLoadingUtils.getClassLoader(context, debugProcess);
        ClassLoadingUtils.defineClass("com.intellij.memory.agent.proxy.IdeaNativeAgentProxy", bytes, context, debugProcess, classLoader);
        return (ClassType)debugProcess.findClass(context, "com.intellij.memory.agent.proxy.IdeaNativeAgentProxy", classLoader);
    }

    @NotNull
    private static byte[] readUtilityClass() {
        byte[] byArray = new ProxyExtractor().extractProxy();
        if (byArray == null) {
            AgentLoader.$$$reportNull$$$0(7);
        }
        return byArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualMachine";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/memory/agent/AgentLoader";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/memory/agent/AgentLoader";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readUtilityClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "ensureClassLoaded";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadUtilityClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDisabledMemoryAgent
    implements MemoryAgent {
        private MyDisabledMemoryAgent() {
        }

        @Override
        public boolean isLoaded() {
            return false;
        }

        @Override
        public boolean canEvaluateObjectSize() {
            return false;
        }

        @Override
        public long evaluateObjectSize(@NotNull ObjectReference reference) {
            if (reference == null) {
                MyDisabledMemoryAgent.$$$reportNull$$$0(0);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean canEvaluateObjectsSizes() {
            return false;
        }

        @Override
        public long[] evaluateObjectsSizes(@NotNull List<ObjectReference> references) {
            if (references == null) {
                MyDisabledMemoryAgent.$$$reportNull$$$0(1);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean canFindGcRoots() {
            return false;
        }

        @Override
        @NotNull
        public ReferringObjectsInfo findGcRoots(@NotNull ObjectReference reference, int limit) {
            if (reference == null) {
                MyDisabledMemoryAgent.$$$reportNull$$$0(2);
            }
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "references";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/debugger/memory/agent/AgentLoader$MyDisabledMemoryAgent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "evaluateObjectSize";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "evaluateObjectsSizes";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findGcRoots";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

