/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.JdiProxy;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InconsistentDebugInfoException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackFrameProxyImpl
extends JdiProxy
implements StackFrameProxy {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.jdi.StackFrameProxyImpl");
    private final ThreadReferenceProxyImpl myThreadProxy;
    private final int myFrameFromBottomIndex;
    private int myFrameIndex;
    private StackFrame myStackFrame;
    private ObjectReference myThisReference;
    private ClassLoaderReference myClassLoader;
    private ThreeState myIsObsolete;
    private Map<LocalVariable, Value> myAllValues;

    public StackFrameProxyImpl(@NotNull ThreadReferenceProxyImpl threadProxy, @NotNull StackFrame frame, int fromBottomIndex) {
        if (threadProxy == null) {
            StackFrameProxyImpl.$$$reportNull$$$0(0);
        }
        if (frame == null) {
            StackFrameProxyImpl.$$$reportNull$$$0(1);
        }
        super(threadProxy.getVirtualMachine());
        this.myFrameIndex = -1;
        this.myIsObsolete = ThreeState.UNSURE;
        this.myThreadProxy = threadProxy;
        this.myFrameFromBottomIndex = fromBottomIndex;
        this.myStackFrame = frame;
    }

    public boolean isObsolete() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.myIsObsolete != ThreeState.UNSURE) {
            return this.myIsObsolete.toBoolean();
        }
        Throwable error = null;
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                Method method = DebuggerUtilsEx.getMethod(this.location());
                boolean isObsolete = this.getVirtualMachine().canRedefineClasses() && (method == null || method.isObsolete());
                this.myIsObsolete = ThreeState.fromBoolean((boolean)isObsolete);
                return isObsolete;
            }
            catch (InvalidStackFrameException e) {
                error = e;
                this.clearCaches();
                continue;
            }
            catch (InternalException e) {
                if (e.errorCode() == 23) {
                    this.myIsObsolete = ThreeState.YES;
                    return true;
                }
                throw e;
            }
        }
        throw new EvaluateException(error.getMessage(), error);
    }

    @Override
    public boolean isValid() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (!super.isValid()) {
            return false;
        }
        try {
            if (this.myStackFrame != null) {
                this.myStackFrame.location();
            }
            return true;
        }
        catch (InvalidStackFrameException e) {
            return false;
        }
    }

    @Override
    protected void clearCaches() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (LOG.isDebugEnabled()) {
            LOG.debug("caches cleared " + super.toString());
        }
        this.myFrameIndex = -1;
        this.myStackFrame = null;
        this.myIsObsolete = ThreeState.UNSURE;
        this.myThisReference = null;
        this.myClassLoader = null;
        this.myAllValues = null;
    }

    public StackFrame getStackFrame() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.myStackFrame == null) {
            try {
                ThreadReference threadRef = this.myThreadProxy.getThreadReference();
                this.myStackFrame = threadRef.frame(this.getFrameIndex());
            }
            catch (IndexOutOfBoundsException e) {
                throw new EvaluateException(e.getMessage(), (Throwable)e);
            }
            catch (ObjectCollectedException ignored) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.thread.collected", (Object[])new Object[0]));
            }
            catch (IncompatibleThreadStateException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
        }
        return this.myStackFrame;
    }

    public int getFrameIndex() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.myFrameIndex == -1) {
            int count = this.myThreadProxy.frameCount();
            if (this.myFrameFromBottomIndex > count) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)new IncompatibleThreadStateException());
            }
            this.myFrameIndex = count - this.myFrameFromBottomIndex;
        }
        return this.myFrameIndex;
    }

    @NotNull
    public VirtualMachineProxyImpl getVirtualMachine() {
        VirtualMachineProxyImpl virtualMachineProxyImpl = (VirtualMachineProxyImpl)this.myTimer;
        if (virtualMachineProxyImpl == null) {
            StackFrameProxyImpl.$$$reportNull$$$0(2);
        }
        return virtualMachineProxyImpl;
    }

    public Location location() throws EvaluateException {
        Throwable error = null;
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                return this.getStackFrame().location();
            }
            catch (InvalidStackFrameException e) {
                error = e;
                this.clearCaches();
                continue;
            }
        }
        throw new EvaluateException(error.getMessage(), error);
    }

    @NotNull
    public ThreadReferenceProxyImpl threadProxy() {
        ThreadReferenceProxyImpl threadReferenceProxyImpl = this.myThreadProxy;
        if (threadReferenceProxyImpl == null) {
            StackFrameProxyImpl.$$$reportNull$$$0(3);
        }
        return threadReferenceProxyImpl;
    }

    @NonNls
    public String toString() {
        try {
            return "StackFrameProxyImpl: " + this.getStackFrame().toString();
        }
        catch (EvaluateException e) {
            return "StackFrameProxyImpl: " + e.getMessage() + "; frameFromBottom = " + this.myFrameFromBottomIndex + " threadName = " + this.threadProxy().name();
        }
    }

    @Nullable
    public ObjectReference thisObject() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        try {
            for (int attempt = 0; attempt < 2; ++attempt) {
                try {
                    if (this.myThisReference == null) {
                        this.myThisReference = this.getStackFrame().thisObject();
                    }
                    break;
                }
                catch (InvalidStackFrameException ignored) {
                    this.clearCaches();
                    continue;
                }
            }
        }
        catch (InternalException e) {
            if (e.errorCode() != 23 && e.errorCode() != 35) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            LOG.info("Exception while getting this object", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Exception while getting this object", (Throwable)e);
        }
        catch (Exception e) {
            if (!this.getVirtualMachine().canBeModified()) {
                LOG.debug((Throwable)e);
            }
            throw e;
        }
        return this.myThisReference;
    }

    @NotNull
    public List<LocalVariableProxyImpl> visibleVariables() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Throwable error = null;
        for (int attempt = 0; attempt < 2; ++attempt) {
            ArrayList<LocalVariableProxyImpl> arrayList;
            try {
                List<LocalVariable> list = this.getStackFrame().visibleVariables();
                ArrayList<LocalVariableProxyImpl> locals = new ArrayList<LocalVariableProxyImpl>(list.size());
                for (LocalVariable localVariable : list) {
                    LOG.assertTrue(localVariable != null);
                    locals.add(new LocalVariableProxyImpl(this, localVariable));
                }
                arrayList = locals;
            }
            catch (InvalidStackFrameException | IllegalArgumentException e) {
                error = e;
                this.clearCaches();
                continue;
            }
            catch (AbsentInformationException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            if (arrayList == null) {
                StackFrameProxyImpl.$$$reportNull$$$0(4);
            }
            return arrayList;
        }
        throw new EvaluateException(error.getMessage(), error);
    }

    public LocalVariableProxyImpl visibleVariableByName(String name2) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        LocalVariable variable = this.visibleVariableByNameInt(name2);
        return variable != null ? new LocalVariableProxyImpl(this, variable) : null;
    }

    @Nullable
    public Value visibleValueByName(@NotNull String name2) throws EvaluateException {
        LocalVariable variable;
        if (name2 == null) {
            StackFrameProxyImpl.$$$reportNull$$$0(5);
        }
        return (variable = this.visibleVariableByNameInt(name2)) != null ? this.getValue(new LocalVariableProxyImpl(this, variable)) : null;
    }

    protected LocalVariable visibleVariableByNameInt(String name2) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Throwable error = null;
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                return this.getStackFrame().visibleVariableByName(name2);
            }
            catch (InvalidStackFrameException e) {
                try {
                    error = e;
                    this.clearCaches();
                    continue;
                }
                catch (AbsentInformationException | InvalidStackFrameException e2) {
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)e2);
                }
            }
        }
        throw new EvaluateException(error.getMessage(), error);
    }

    public Value getValue(LocalVariableProxyImpl localVariable) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Throwable error = null;
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                Map<LocalVariable, Value> values = this.getAllValues();
                LocalVariable variable = localVariable.getVariable();
                if (values.containsKey(variable)) {
                    return values.get(variable);
                }
                return this.getStackFrame().getValue(variable);
            }
            catch (InvalidStackFrameException e) {
                error = e;
                this.clearCaches();
                continue;
            }
            catch (InconsistentDebugInfoException ignored) {
                this.clearCaches();
                throw EvaluateExceptionUtil.INCONSISTEND_DEBUG_INFO;
            }
            catch (InternalException e) {
                if (e.errorCode() == 35 || e.errorCode() == 101) {
                    throw new EvaluateException(DebuggerBundle.message((String)"error.corrupt.debug.info", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                }
                throw e;
            }
            catch (Exception e) {
                if (!this.getVirtualMachine().canBeModified()) {
                    LOG.debug((Throwable)e);
                    throw new EvaluateException("Debug data corrupted");
                }
                throw e;
            }
        }
        throw new EvaluateException(error.getMessage(), error);
    }

    @NotNull
    public List<Value> getArgumentValues() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Throwable error = null;
        for (int attempt = 0; attempt < 2; ++attempt) {
            List list;
            try {
                StackFrame stackFrame = this.getStackFrame();
                list = stackFrame != null ? ContainerUtil.notNullize(DebuggerUtilsEx.getArgumentValues(stackFrame)) : Collections.emptyList();
            }
            catch (InvalidStackFrameException e) {
                error = e;
                this.clearCaches();
                continue;
            }
            if (list == null) {
                StackFrameProxyImpl.$$$reportNull$$$0(6);
            }
            return list;
        }
        throw new EvaluateException(error.getMessage(), error);
    }

    private Map<LocalVariable, Value> getAllValues() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.myAllValues == null) {
            try {
                StackFrame stackFrame = this.getStackFrame();
                this.myAllValues = new THashMap(stackFrame.getValues(stackFrame.visibleVariables()));
            }
            catch (AbsentInformationException e) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)e);
            }
            catch (InternalException e) {
                if (e.errorCode() == 35 || e.errorCode() == 101) {
                    LOG.info((Throwable)e);
                    this.myAllValues = new THashMap();
                }
                throw e;
            }
            catch (Exception e) {
                if (!this.getVirtualMachine().canBeModified()) {
                    LOG.debug((Throwable)e);
                    this.myAllValues = new THashMap();
                }
                throw e;
            }
        }
        return this.myAllValues;
    }

    public void setValue(LocalVariableProxyImpl localVariable, Value value) throws EvaluateException, ClassNotLoadedException, InvalidTypeException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Throwable error = null;
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                LocalVariable variable = localVariable.getVariable();
                StackFrame stackFrame = this.getStackFrame();
                stackFrame.setValue(variable, value instanceof ObjectReference ? (ObjectReference)value : value);
                if (this.myAllValues != null) {
                    this.myAllValues.put(variable, stackFrame.getValue(variable));
                }
                return;
            }
            catch (InvalidStackFrameException e) {
                error = e;
                this.clearCaches();
                continue;
            }
        }
        throw new EvaluateException(error.getMessage(), error);
    }

    public int hashCode() {
        return 31 * this.myThreadProxy.hashCode() + this.myFrameFromBottomIndex;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StackFrameProxyImpl)) {
            return false;
        }
        StackFrameProxyImpl frameProxy = (StackFrameProxyImpl)obj;
        if (frameProxy == this) {
            return true;
        }
        return this.myFrameFromBottomIndex == frameProxy.myFrameFromBottomIndex && this.myThreadProxy.equals(frameProxy.myThreadProxy);
    }

    public boolean isLocalVariableVisible(LocalVariableProxyImpl var) throws EvaluateException {
        try {
            return var.getVariable().isVisible(this.getStackFrame());
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
    }

    public ClassLoaderReference getClassLoader() throws EvaluateException {
        if (this.myClassLoader == null) {
            this.myClassLoader = this.location().declaringType().classLoader();
        }
        return this.myClassLoader;
    }

    public boolean isBottom() {
        return this.myFrameFromBottomIndex == 1;
    }

    public int getIndexFromBottom() {
        return this.myFrameFromBottomIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadProxy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/debugger/jdi/StackFrameProxyImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/debugger/jdi/StackFrameProxyImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualMachine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "threadProxy";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "visibleVariables";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visibleValueByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

