/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.PopFrameAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.ArrayUtil;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import org.jetbrains.annotations.NotNull;

public class AddSteppingFilterAction
extends DebuggerAction {
    public void actionPerformed(final @NotNull AnActionEvent e) {
        DebuggerContextImpl debuggerContext;
        DebugProcessImpl process2;
        if (e == null) {
            AddSteppingFilterAction.$$$reportNull$$$0(0);
        }
        if ((process2 = (debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext())).getDebugProcess()) == null) {
            return;
        }
        final StackFrameProxyImpl proxy = PopFrameAction.getStackFrameProxy(e);
        process2.getManagerThread().schedule(new DebuggerCommandImpl(){

            @Override
            protected void action() {
                String name2 = AddSteppingFilterAction.getClassName(proxy != null ? proxy : debuggerContext.getFrameProxy());
                if (name2 == null) {
                    return;
                }
                Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
                ApplicationManager.getApplication().invokeLater(() -> {
                    String filter = Messages.showInputDialog((Project)project2, (String)"", (String)"Add Stepping Filter", null, (String)name2, null);
                    if (filter != null) {
                        ClassFilter[] newFilters = (ClassFilter[])ArrayUtil.append((Object[])DebuggerSettings.getInstance().getSteppingFilters(), (Object)new ClassFilter(filter));
                        DebuggerSettings.getInstance().setSteppingFilters(newFilters);
                    }
                });
            }
        });
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AddSteppingFilterAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(PopFrameAction.getStackFrameProxy(e) != null);
    }

    private static String getClassName(StackFrameProxyImpl stackFrameProxy) {
        if (stackFrameProxy != null) {
            try {
                ReferenceType type;
                Location location = stackFrameProxy.location();
                if (location != null && (type = location.declaringType()) != null) {
                    return type.name();
                }
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/debugger/actions/AddSteppingFilterAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

