/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.server;

import com.google.protobuf.MessageLite;
import com.intellij.ProjectTopics;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.impl.CompilerUtil;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.impl.javaCompiler.eclipse.EclipseCompilerConfiguration;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.compiler.server.AutoMakeMessageHandler;
import com.intellij.compiler.server.BuildManagerListener;
import com.intellij.compiler.server.BuildMessageDispatcher;
import com.intellij.compiler.server.BuildProcessParametersProvider;
import com.intellij.compiler.server.BuilderMessageHandler;
import com.intellij.compiler.server.DefaultMessageHandler;
import com.intellij.compiler.server.DelegatingMessageHandler;
import com.intellij.compiler.server.PreloadedProcessMessageHandler;
import com.intellij.compiler.server.impl.BuildProcessClasspathManager;
import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.DataManager;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.idea.StartupUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.compiler.CompilationStatusListener;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.CompilerTopics;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.FileNameCache;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.io.NettyKt;
import com.intellij.util.io.PathKt;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.net.NetUtils;
import com.intellij.util.text.DateFormatUtil;
import gnu.trove.THashSet;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import io.netty.util.internal.ThreadLocalRandom;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.ChannelRegistrar;
import org.jetbrains.jps.api.CmdlineProtoUtil;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.api.RequestFuture;
import org.jetbrains.jps.api.TaskFuture;
import org.jetbrains.jps.api.TaskFutureAdapter;
import org.jetbrains.jps.cmdline.BuildMain;
import org.jetbrains.jps.cmdline.ClasspathBootstrap;
import org.jetbrains.jps.cmdline.Launcher;
import org.jetbrains.jps.incremental.Utils;

public class BuildManager
implements Disposable {
    public static final Key<Boolean> ALLOW_AUTOMAKE = Key.create((String)"_allow_automake_when_process_is_active_");
    private static final Key<Integer> COMPILER_PROCESS_DEBUG_PORT = Key.create((String)"_compiler_process_debug_port_");
    private static final Key<String> FORCE_MODEL_LOADING_PARAMETER = Key.create((String)"_force_model_loading");
    private static final Key<CharSequence> STDERR_OUTPUT = Key.create((String)"_process_launch_errors_");
    private static final SimpleDateFormat USAGE_STAMP_DATE_FORMAT = new SimpleDateFormat("dd.MM.yyyy");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.server.BuildManager");
    private static final String COMPILER_PROCESS_JDK_PROPERTY = "compiler.process.jdk";
    public static final String SYSTEM_ROOT = "compile-server";
    public static final String TEMP_DIR_NAME = "_temp_";
    private final boolean IS_UNIT_TEST_MODE;
    private static final String IWS_EXTENSION = ".iws";
    private static final String IPR_EXTENSION = ".ipr";
    private static final String IDEA_PROJECT_DIR_PATTERN = "/.idea/";
    private static final Function<String, Boolean> PATH_FILTER = SystemInfo.isFileSystemCaseSensitive ? s -> !s.contains(IDEA_PROJECT_DIR_PATTERN) && !s.endsWith(IWS_EXTENSION) && !s.endsWith(IPR_EXTENSION) : s -> !StringUtil.endsWithIgnoreCase((String)s, (String)IWS_EXTENSION) && !StringUtil.endsWithIgnoreCase((String)s, (String)IPR_EXTENSION) && !StringUtil.containsIgnoreCase((String)s, (String)IDEA_PROJECT_DIR_PATTERN);
    private final List<String> myFallbackJdkParams = new SmartList();
    private final ProjectManager myProjectManager;
    private final Map<TaskFuture, Project> myAutomakeFutures = Collections.synchronizedMap(new HashMap());
    private final Map<String, RequestFuture> myBuildsInProgress = Collections.synchronizedMap(new HashMap());
    private final Map<String, Future<Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler>>> myPreloadedBuilds = Collections.synchronizedMap(new HashMap());
    private final BuildProcessClasspathManager myClasspathManager = new BuildProcessClasspathManager();
    private final ExecutorService myRequestsProcessor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"BuildManager RequestProcessor Pool");
    private final List<VFileEvent> myUnprocessedEvents = new ArrayList<VFileEvent>();
    private final ExecutorService myAutomakeTrigger = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"BuildManager Auto-Make Trigger");
    private final Map<String, ProjectData> myProjectDataMap = Collections.synchronizedMap(new HashMap());
    private volatile int myFileChangeCounter;
    private final BuildManagerPeriodicTask myAutoMakeTask = new BuildManagerPeriodicTask(){

        @Override
        protected int getDelay() {
            return Registry.intValue((String)"compiler.automake.trigger.delay");
        }

        @Override
        protected void runTask() {
            BuildManager.this.runAutoMake();
        }

        @Override
        protected boolean shouldPostpone() {
            return BuildManager.shouldPostponeAutomake();
        }
    };
    private final BuildManagerPeriodicTask myDocumentSaveTask = new BuildManagerPeriodicTask(){

        @Override
        protected int getDelay() {
            return Registry.intValue((String)"compiler.document.save.trigger.delay");
        }

        @Override
        public void runTask() {
            if (this.shouldSaveDocuments()) {
                TransactionGuard.getInstance().submitTransactionAndWait(() -> ((FileDocumentManagerImpl)FileDocumentManager.getInstance()).saveAllDocuments(false));
            }
        }

        private boolean shouldSaveDocuments() {
            Project contextProject = BuildManager.this.getCurrentContextProject();
            return contextProject != null && BuildManager.canStartAutoMake(contextProject);
        }
    };
    private final Runnable myGCTask = () -> {
        int unusedThresholdDays = Registry.intValue((String)"compiler.build.data.unused.threshold", (int)-1);
        if (unusedThresholdDays <= 0) {
            return;
        }
        File buildSystemDir = this.getBuildSystemDirectory().toFile();
        File[] dirs = buildSystemDir.listFiles(pathname -> pathname.isDirectory() && !TEMP_DIR_NAME.equals(pathname.getName()));
        if (dirs != null) {
            Date now = new Date();
            for (File buildDataProjectDir : dirs) {
                File usageFile = BuildManager.getUsageFile(buildDataProjectDir);
                if (usageFile.exists()) {
                    File projectFile;
                    Pair<Date, File> usageData = BuildManager.readUsageFile(usageFile);
                    if (usageData == null || ((projectFile = (File)usageData.second) == null || projectFile.exists()) && DateFormatUtil.getDifferenceInDays((Date)((Date)usageData.first), (Date)now) <= (long)unusedThresholdDays) continue;
                    LOG.info("Clearing project build data because the project does not exist or was not opened for more than " + unusedThresholdDays + " days: " + buildDataProjectDir);
                    FileUtil.delete((File)buildDataProjectDir);
                    continue;
                }
                BuildManager.updateUsageFile(null, buildDataProjectDir);
            }
        }
    };
    private final ChannelRegistrar myChannelRegistrar = new ChannelRegistrar();
    private final BuildMessageDispatcher myMessageDispatcher = new BuildMessageDispatcher();
    private volatile int myListenPort = -1;
    @NotNull
    private final Charset mySystemCharset = CharsetToolkit.getDefaultSystemCharset();
    private volatile boolean myBuildProcessDebuggingEnabled;

    public BuildManager(ProjectManager projectManager) {
        final Application application = ApplicationManager.getApplication();
        this.IS_UNIT_TEST_MODE = application.isUnitTestMode();
        this.myProjectManager = projectManager;
        String fallbackSdkHome = BuildManager.getFallbackSdkHome();
        if (fallbackSdkHome != null) {
            this.myFallbackJdkParams.add("-Djps.fallback.jdk.home=" + fallbackSdkHome);
            this.myFallbackJdkParams.add("-Djps.fallback.jdk.version=" + SystemInfo.JAVA_VERSION);
        }
        MessageBusConnection connection = application.getMessageBus().connect();
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectWatcher());
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!BuildManager.this.IS_UNIT_TEST_MODE) {
                    List list = BuildManager.this.myUnprocessedEvents;
                    synchronized (list) {
                        BuildManager.this.myUnprocessedEvents.addAll(events);
                    }
                    BuildManager.this.myAutomakeTrigger.submit(() -> {
                        if (!application.isDisposed()) {
                            ReadAction.run(() -> {
                                ArrayList snapshot;
                                List list = BuildManager.this.myUnprocessedEvents;
                                synchronized (list) {
                                    if (BuildManager.this.myUnprocessedEvents.isEmpty()) {
                                        return;
                                    }
                                    snapshot = new ArrayList(BuildManager.this.myUnprocessedEvents);
                                    BuildManager.this.myUnprocessedEvents.clear();
                                }
                                if (this.shouldTriggerMake(snapshot)) {
                                    BuildManager.this.scheduleAutoMake();
                                }
                            });
                        } else {
                            List list = BuildManager.this.myUnprocessedEvents;
                            synchronized (list) {
                                BuildManager.this.myUnprocessedEvents.clear();
                            }
                        }
                    });
                }
            }

            private boolean shouldTriggerMake(List<? extends VFileEvent> events) {
                if (PowerSaveMode.isEnabled()) {
                    return false;
                }
                Project project2 = null;
                ProjectFileIndex fileIndex = null;
                for (VFileEvent vFileEvent : events) {
                    VirtualFile eventFile = vFileEvent.getFile();
                    if (eventFile == null) continue;
                    if (!eventFile.isValid()) {
                        return true;
                    }
                    if (project2 == null) {
                        project2 = BuildManager.this.getCurrentContextProject();
                        if (project2 == null) {
                            return false;
                        }
                        fileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
                    }
                    if (!fileIndex.isInContent(eventFile) || ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)eventFile) || GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)eventFile, (Project)project2)) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/compiler/server/BuildManager$3", "after"));
            }
        });
        connection.subscribe(BatchFileChangeListener.TOPIC, (Object)new BatchFileChangeListener(){

            public void batchChangeStarted(@NotNull Project project2, @Nullable String activityName) {
                if (project2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                BuildManager.this.myFileChangeCounter++;
                BuildManager.this.cancelAutoMakeTasks(project2);
            }

            public void batchChangeCompleted(@NotNull Project project2) {
                if (project2 == null) {
                    4.$$$reportNull$$$0(1);
                }
                BuildManager.this.myFileChangeCounter--;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/compiler/server/BuildManager$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "batchChangeStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "batchChangeCompleted";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (Registry.is((String)"compiler.document.save.enabled", (boolean)false)) {
                    VirtualFile file;
                    Document document = e.getDocument();
                    if (FileDocumentManager.getInstance().isDocumentUnsaved(document) && (file = FileDocumentManager.getInstance().getFile(document)) != null && file.isInLocalFileSystem()) {
                        BuildManager.this.scheduleProjectSave();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/compiler/server/BuildManager$5", "documentChanged"));
            }
        });
        ShutDownTracker.getInstance().registerShutdownTask(this::stopListening);
        if (!this.IS_UNIT_TEST_MODE) {
            ScheduledFuture<?> future = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> this.runCommand(this.myGCTask), 3L, 180L, TimeUnit.MINUTES);
            Disposer.register((Disposable)this, () -> future.cancel(false));
        }
    }

    @Nullable
    private static String getFallbackSdkHome() {
        String parent;
        String home = SystemProperties.getJavaHome();
        if (home == null) {
            return null;
        }
        if (!JdkUtil.checkForJdk((String)home) && (parent = new File(home).getParent()) != null && JdkUtil.checkForJdk((String)parent)) {
            home = parent;
        }
        return FileUtil.toSystemIndependentName((String)home);
    }

    private List<Project> getOpenProjects() {
        Project[] projects = this.myProjectManager.getOpenProjects();
        if (projects.length == 0) {
            return Collections.emptyList();
        }
        SmartList projectList = new SmartList();
        for (Project project2 : projects) {
            if (!BuildManager.isValidProject(project2)) continue;
            projectList.add(project2);
        }
        return projectList;
    }

    private static boolean isValidProject(@Nullable Project project2) {
        return project2 != null && !project2.isDisposed() && !project2.isDefault() && project2.isInitialized();
    }

    public static BuildManager getInstance() {
        return (BuildManager)ApplicationManager.getApplication().getComponent(BuildManager.class);
    }

    public void notifyFilesChanged(Collection<? extends File> paths) {
        this.doNotify(paths, false);
    }

    public void notifyFilesDeleted(Collection<? extends File> paths) {
        this.doNotify(paths, true);
    }

    public void runCommand(@NotNull Runnable command) {
        if (command == null) {
            BuildManager.$$$reportNull$$$0(0);
        }
        this.myRequestsProcessor.submit(command);
    }

    private void doNotify(Collection<? extends File> paths, boolean notifyDeletion) {
        this.runCommand(() -> {
            ArrayList<String> filtered = new ArrayList<String>(paths.size());
            for (File file : paths) {
                String path = FileUtil.toSystemIndependentName((String)file.getPath());
                if (!((Boolean)PATH_FILTER.fun((Object)path)).booleanValue()) continue;
                filtered.add(path);
            }
            if (filtered.isEmpty()) {
                return;
            }
            Map<String, ProjectData> map = this.myProjectDataMap;
            synchronized (map) {
                for (Map.Entry<String, ProjectData> entry : this.myProjectDataMap.entrySet()) {
                    UUID sessionId;
                    Channel channel;
                    RequestFuture future;
                    ProjectData data = entry.getValue();
                    if (notifyDeletion) {
                        data.addDeleted(filtered);
                    } else {
                        data.addChanged(filtered);
                    }
                    if ((future = this.myBuildsInProgress.get(entry.getKey())) == null || future.isCancelled() || future.isDone() || (channel = this.myMessageDispatcher.getConnectedChannel(sessionId = future.getRequestID())) == null) continue;
                    CmdlineRemoteProto.Message.ControllerMessage message = (CmdlineRemoteProto.Message.ControllerMessage)CmdlineRemoteProto.Message.ControllerMessage.newBuilder().setType(CmdlineRemoteProto.Message.ControllerMessage.Type.FS_EVENT).setFsEvent(data.createNextEvent()).build();
                    channel.writeAndFlush((Object)CmdlineProtoUtil.toMessage((UUID)sessionId, (CmdlineRemoteProto.Message.ControllerMessage)message));
                }
            }
        });
    }

    public static void forceModelLoading(CompileContext context) {
        context.getCompileScope().putUserData(FORCE_MODEL_LOADING_PARAMETER, (Object)Boolean.TRUE.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearState(Project project2) {
        String projectPath = BuildManager.getProjectPath(project2);
        this.cancelPreloadedBuilds(projectPath);
        Map<String, ProjectData> map = this.myProjectDataMap;
        synchronized (map) {
            ProjectData data = this.myProjectDataMap.get(projectPath);
            if (data != null) {
                data.dropChanges();
            }
        }
        this.scheduleAutoMake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearState() {
        boolean cleared;
        Map<String, ProjectData> map = this.myProjectDataMap;
        synchronized (map) {
            cleared = !this.myProjectDataMap.isEmpty();
            for (Map.Entry<String, ProjectData> entry : this.myProjectDataMap.entrySet()) {
                this.cancelPreloadedBuilds(entry.getKey());
                entry.getValue().dropChanges();
            }
        }
        if (cleared) {
            this.scheduleAutoMake();
        }
    }

    public boolean isProjectWatched(Project project2) {
        return this.myProjectDataMap.containsKey(BuildManager.getProjectPath(project2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<String> getFilesChangedSinceLastCompilation(Project project2) {
        String projectPath = BuildManager.getProjectPath(project2);
        Map<String, ProjectData> map = this.myProjectDataMap;
        synchronized (map) {
            ProjectData data = this.myProjectDataMap.get(projectPath);
            if (data != null && !data.myNeedRescan) {
                return BuildManager.convertToStringPaths(data.myChanged);
            }
            return null;
        }
    }

    private static List<String> convertToStringPaths(Collection<? extends InternedPath> interned) {
        ArrayList<String> list = new ArrayList<String>(interned.size());
        for (InternedPath internedPath : interned) {
            list.add(internedPath.getValue());
        }
        return list;
    }

    @Nullable
    private static String getProjectPath(Project project2) {
        String url = project2.getPresentableUrl();
        if (url == null) {
            return null;
        }
        return VirtualFileManager.extractPath((String)url);
    }

    public void scheduleAutoMake() {
        if (!this.IS_UNIT_TEST_MODE && !PowerSaveMode.isEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Automake scheduled:\n" + BuildManager.getThreadTrace(Thread.currentThread(), 10));
            }
            this.myAutoMakeTask.schedule();
        }
    }

    @NotNull
    private static String getThreadTrace(Thread thread, int depth) {
        StringBuilder buf = new StringBuilder();
        StackTraceElement[] trace = thread.getStackTrace();
        for (int i = 0; i < depth && i < trace.length; ++i) {
            StackTraceElement element = trace[i];
            buf.append("\tat ").append(element).append("\n");
        }
        String string = buf.toString();
        if (string == null) {
            BuildManager.$$$reportNull$$$0(1);
        }
        return string;
    }

    private void scheduleProjectSave() {
        if (!this.IS_UNIT_TEST_MODE && !PowerSaveMode.isEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Automake canceled; reason: project save scheduled");
            }
            this.myAutoMakeTask.cancelPendingExecution();
            this.myDocumentSaveTask.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAutoMake() {
        Project project2 = this.getCurrentContextProject();
        if (project2 == null || !BuildManager.canStartAutoMake(project2)) {
            return;
        }
        List scopes = CmdlineProtoUtil.createAllModulesScopes((boolean)false);
        AutoMakeMessageHandler handler = new AutoMakeMessageHandler(project2);
        TaskFuture future = this.scheduleBuild(project2, false, true, false, scopes, Collections.emptyList(), Collections.singletonMap("is_automake", "true"), handler);
        if (future != null) {
            this.myAutomakeFutures.put(future, project2);
            try {
                future.waitFor();
            }
            finally {
                this.myAutomakeFutures.remove(future);
                if (handler.unprocessedFSChangesDetected()) {
                    this.scheduleAutoMake();
                }
            }
        }
    }

    private static boolean canStartAutoMake(@NotNull Project project2) {
        if (project2 == null) {
            BuildManager.$$$reportNull$$$0(2);
        }
        if (project2.isDisposed()) {
            return false;
        }
        CompilerWorkspaceConfiguration config = CompilerWorkspaceConfiguration.getInstance((Project)project2);
        if (!config.MAKE_PROJECT_ON_SAVE) {
            return false;
        }
        return config.allowAutoMakeWhileRunningApplication() || !BuildManager.hasRunningProcess(project2);
    }

    private static boolean shouldPostponeAutomake() {
        if (FileDocumentManager.getInstance().getUnsavedDocuments().length > 0) {
            return true;
        }
        long threshold = Registry.intValue((String)"compiler.automake.postpone.when.idle.less.than", (int)3000);
        long idleSinceLastActivity = ApplicationManager.getApplication().getIdleTime();
        return idleSinceLastActivity < threshold;
    }

    @Nullable
    private Project getCurrentContextProject() {
        Container _parent;
        List<Project> openProjects = this.getOpenProjects();
        if (openProjects.isEmpty()) {
            return null;
        }
        if (openProjects.size() == 1) {
            return openProjects.get(0);
        }
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (window == null) {
            return null;
        }
        Container comp = window;
        while ((_parent = comp.getParent()) != null) {
            comp = _parent;
        }
        Project project2 = null;
        if (comp instanceof IdeFrame) {
            project2 = ((IdeFrame)comp).getProject();
        }
        if (project2 == null) {
            project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)comp));
        }
        return BuildManager.isValidProject(project2) ? project2 : null;
    }

    private static boolean hasRunningProcess(Project project2) {
        for (ProcessHandler handler : ExecutionManager.getInstance((Project)project2).getRunningProcesses()) {
            if (handler.isProcessTerminated() || ((Boolean)ALLOW_AUTOMAKE.get((UserDataHolder)handler, (Object)Boolean.FALSE)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TaskFuture> cancelAutoMakeTasks(Project project2) {
        SmartList futures = new SmartList();
        Map<TaskFuture, Project> map = this.myAutomakeFutures;
        synchronized (map) {
            for (Map.Entry<TaskFuture, Project> entry : this.myAutomakeFutures.entrySet()) {
                if (!entry.getValue().equals(project2)) continue;
                TaskFuture future = entry.getKey();
                future.cancel(false);
                futures.add(future);
            }
        }
        if (LOG.isDebugEnabled() && !futures.isEmpty()) {
            LOG.debug("Automake cancel (all tasks):\n" + BuildManager.getThreadTrace(Thread.currentThread(), 10));
        }
        return futures;
    }

    private void cancelAllPreloadedBuilds() {
        String[] paths;
        for (String path : paths = ArrayUtil.toStringArray(this.myPreloadedBuilds.keySet())) {
            this.cancelPreloadedBuilds(path);
        }
    }

    private void cancelPreloadedBuilds(String projectPath) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cancel preloaded build for " + projectPath + "\n" + BuildManager.getThreadTrace(Thread.currentThread(), 50));
        }
        this.runCommand(() -> {
            Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler> pair2 = this.takePreloadedProcess(projectPath);
            if (pair2 != null) {
                RequestFuture future = (RequestFuture)pair2.first;
                OSProcessHandler processHandler = (OSProcessHandler)pair2.second;
                this.myMessageDispatcher.cancelSession(future.getRequestID());
                this.getProjectData((String)projectPath).taskQueue.submit(() -> {
                    Throwable error = null;
                    try {
                        while (!processHandler.waitFor()) {
                            LOG.info("processHandler.waitFor() returned false for session " + future.getRequestID() + ", continue waiting");
                        }
                    }
                    catch (Throwable e) {
                        error = e;
                    }
                    finally {
                        this.notifySessionTerminationIfNeeded(future.getRequestID(), error);
                    }
                });
            }
        });
    }

    @Nullable
    private Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler> takePreloadedProcess(String projectPath) {
        Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler> result;
        Future<Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler>> preloadProgress = this.myPreloadedBuilds.remove(projectPath);
        try {
            result = preloadProgress != null ? preloadProgress.get() : null;
        }
        catch (Throwable e) {
            LOG.info(e);
            result = null;
        }
        return result != null && !((RequestFuture)result.first).isDone() ? result : null;
    }

    @Nullable
    public TaskFuture scheduleBuild(Project project2, boolean isRebuild, boolean isMake, boolean onlyCheckUpToDate, List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes, Collection<String> paths, Map<String, String> userData, DefaultMessageHandler messageHandler) {
        String projectPath = BuildManager.getProjectPath(project2);
        boolean isAutomake = messageHandler instanceof AutoMakeMessageHandler;
        NotifyingMessageHandler handler = new NotifyingMessageHandler(project2, messageHandler, isAutomake);
        try {
            this.ensureListening();
        }
        catch (Exception e) {
            UUID sessionId = UUID.randomUUID();
            handler.handleFailure(sessionId, CmdlineProtoUtil.createFailure((String)e.getMessage(), null));
            handler.sessionTerminated(sessionId);
            return null;
        }
        DelegateFuture _future = new DelegateFuture();
        this.runCommand(() -> {
            UUID sessionId;
            boolean usingPreloadedProcess;
            Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler> preloaded = this.takePreloadedProcess(projectPath);
            RequestFuture preloadedFuture = (RequestFuture)Pair.getFirst(preloaded);
            boolean bl = usingPreloadedProcess = preloadedFuture != null;
            if (usingPreloadedProcess) {
                LOG.info("Using preloaded build process to compile " + projectPath);
                sessionId = preloadedFuture.getRequestID();
                ((PreloadedProcessMessageHandler)preloadedFuture.getMessageHandler()).setDelegateHandler(handler);
            } else {
                sessionId = UUID.randomUUID();
            }
            RequestFuture future = usingPreloadedProcess ? preloadedFuture : new RequestFuture((Object)handler, sessionId, new CancelBuildSessionAction());
            TaskFuture[] delegatesToWait = new TaskFuture[]{future};
            if (!usingPreloadedProcess && (future.isCancelled() || project2.isDisposed())) {
                handler.sessionTerminated(sessionId);
                future.setDone();
            } else {
                ExecutorService projectTaskQueue;
                CmdlineRemoteProto.Message.ControllerMessage.FSEvent currentFSChanges;
                boolean needRescan;
                CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings globals = (CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings)CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings.newBuilder().setGlobalOptionsPath(PathManager.getOptionsPath()).build();
                Map<String, ProjectData> map = this.myProjectDataMap;
                synchronized (map) {
                    ProjectData data = this.getProjectData(projectPath);
                    if (isRebuild) {
                        data.dropChanges();
                    }
                    if (this.IS_UNIT_TEST_MODE) {
                        LOG.info("Scheduling build for " + projectPath + "; CHANGED: " + new HashSet<String>(BuildManager.convertToStringPaths(data.myChanged)) + "; DELETED: " + new HashSet<String>(BuildManager.convertToStringPaths(data.myDeleted)));
                    }
                    currentFSChanges = (needRescan = data.getAndResetRescanFlag()) ? null : data.createNextEvent();
                    projectTaskQueue = data.taskQueue;
                }
                CmdlineRemoteProto.Message.ControllerMessage params = isRebuild ? CmdlineProtoUtil.createBuildRequest((String)projectPath, (List)scopes, Collections.emptyList(), (Map)userData, (CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings)globals, null) : (onlyCheckUpToDate ? CmdlineProtoUtil.createUpToDateCheckRequest((String)projectPath, (List)scopes, (Collection)paths, (Map)userData, (CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings)globals, (CmdlineRemoteProto.Message.ControllerMessage.FSEvent)currentFSChanges) : CmdlineProtoUtil.createBuildRequest((String)projectPath, (List)scopes, isMake ? Collections.emptyList() : paths, (Map)userData, (CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings)globals, (CmdlineRemoteProto.Message.ControllerMessage.FSEvent)currentFSChanges));
                if (!usingPreloadedProcess) {
                    this.myMessageDispatcher.registerBuildMessageHandler((RequestFuture<? extends BuilderMessageHandler>)future, params);
                }
                try {
                    Future<?> buildFuture = projectTaskQueue.submit(() -> {
                        Throwable execFailure = null;
                        try {
                            CharSequence errorsOnLaunch;
                            OSProcessHandler processHandler;
                            if (project2.isDisposed()) {
                                if (usingPreloadedProcess) {
                                    future.cancel(false);
                                } else {
                                    return;
                                }
                            }
                            this.myBuildsInProgress.put(projectPath, future);
                            if (usingPreloadedProcess) {
                                boolean paramsSent = this.myMessageDispatcher.sendBuildParameters(future.getRequestID(), params);
                                if (!paramsSent) {
                                    this.myMessageDispatcher.cancelSession(future.getRequestID());
                                }
                                processHandler = (OSProcessHandler)preloaded.second;
                                errorsOnLaunch = (CharSequence)STDERR_OUTPUT.get((UserDataHolder)processHandler);
                            } else {
                                if (isAutomake && needRescan) {
                                    try {
                                        TransactionGuard.getInstance().submitTransactionAndWait(() -> ((Project)project2).save());
                                    }
                                    catch (Throwable e) {
                                        LOG.info(e);
                                    }
                                }
                                processHandler = this.launchBuildProcess(project2, this.myListenPort, sessionId, false);
                                errorsOnLaunch = new StringBuffer();
                                processHandler.addProcessListener((ProcessListener)new StdOutputCollector((Appendable)((Object)errorsOnLaunch)));
                                processHandler.startNotify();
                            }
                            Integer debugPort = (Integer)processHandler.getUserData(COMPILER_PROCESS_DEBUG_PORT);
                            if (debugPort != null) {
                                String message = "Build: waiting for debugger connection on port " + debugPort;
                                messageHandler.handleCompileMessage(sessionId, CmdlineProtoUtil.createCompileProgressMessageResponse((String)message).getCompileMessage());
                            }
                            while (!processHandler.waitFor()) {
                                LOG.info("processHandler.waitFor() returned false for session " + sessionId + ", continue waiting");
                            }
                            int exitValue = processHandler.getProcess().exitValue();
                            if (exitValue != 0) {
                                StringBuilder msg = new StringBuilder();
                                msg.append("Abnormal build process termination: ");
                                if (errorsOnLaunch != null && errorsOnLaunch.length() > 0) {
                                    msg.append("\n").append(errorsOnLaunch);
                                    if (StringUtil.contains((CharSequence)errorsOnLaunch, (CharSequence)"java.lang.NoSuchMethodError")) {
                                        msg.append("\nThe error may be caused by JARs in Java Extensions directory which conflicts with libraries used by the external build process.").append("\nTry adding -Djava.ext.dirs=\"\" argument to 'Build process VM options' in File | Settings | Build, Execution, Deployment | Compiler to fix the problem.");
                                    }
                                } else {
                                    msg.append("unknown error");
                                }
                                handler.handleFailure(sessionId, CmdlineProtoUtil.createFailure((String)msg.toString(), null));
                            }
                        }
                        catch (Throwable e) {
                            execFailure = e;
                        }
                        finally {
                            this.myBuildsInProgress.remove(projectPath);
                            this.notifySessionTerminationIfNeeded(sessionId, execFailure);
                            if (this.isProcessPreloadingEnabled(project2)) {
                                this.runCommand(() -> {
                                    if (!this.myPreloadedBuilds.containsKey(projectPath)) {
                                        try {
                                            Future<Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler>> preloadResult = this.launchPreloadedBuildProcess(project2, projectTaskQueue);
                                            this.myPreloadedBuilds.put(projectPath, preloadResult);
                                        }
                                        catch (Throwable e) {
                                            LOG.info("Error pre-loading build process for project " + projectPath, e);
                                        }
                                    }
                                });
                            }
                        }
                    });
                    delegatesToWait = new TaskFuture[]{future, new TaskFutureAdapter(buildFuture)};
                }
                catch (Throwable e) {
                    this.handleProcessExecutionFailure(sessionId, e);
                }
            }
            boolean set = _future.setDelegates(delegatesToWait);
            assert (set);
        });
        return _future;
    }

    private boolean isProcessPreloadingEnabled(Project project2) {
        if (this.IS_UNIT_TEST_MODE || !Registry.is((String)"compiler.process.preload") || this.myBuildProcessDebuggingEnabled) {
            return false;
        }
        if (project2.isDisposed()) {
            return true;
        }
        for (BuildProcessParametersProvider provider : BuildProcessParametersProvider.EP_NAME.getExtensionList((AreaInstance)project2)) {
            if (provider.isProcessPreloadingEnabled()) continue;
            return false;
        }
        return true;
    }

    private void notifySessionTerminationIfNeeded(@NotNull UUID sessionId, @Nullable Throwable execFailure) {
        BuilderMessageHandler unregistered;
        if (sessionId == null) {
            BuildManager.$$$reportNull$$$0(3);
        }
        if (this.myMessageDispatcher.getAssociatedChannel(sessionId) == null && (unregistered = this.myMessageDispatcher.unregisterBuildMessageHandler(sessionId)) != null) {
            if (execFailure != null) {
                unregistered.handleFailure(sessionId, CmdlineProtoUtil.createFailure((String)execFailure.getMessage(), (Throwable)execFailure));
            }
            unregistered.sessionTerminated(sessionId);
        }
    }

    private void handleProcessExecutionFailure(@NotNull UUID sessionId, Throwable e) {
        BuilderMessageHandler unregistered;
        if (sessionId == null) {
            BuildManager.$$$reportNull$$$0(4);
        }
        if ((unregistered = this.myMessageDispatcher.unregisterBuildMessageHandler(sessionId)) != null) {
            unregistered.handleFailure(sessionId, CmdlineProtoUtil.createFailure((String)e.getMessage(), (Throwable)e));
            unregistered.sessionTerminated(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private ProjectData getProjectData(String projectPath) {
        Map<String, ProjectData> map = this.myProjectDataMap;
        // MONITORENTER : map
        ProjectData projectData = this.myProjectDataMap.computeIfAbsent(projectPath, k -> new ProjectData(SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"BuildManager Pool")));
        // MONITOREXIT : map
        if (projectData != null) return projectData;
        BuildManager.$$$reportNull$$$0(5);
        return projectData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureListening() {
        if (this.myListenPort < 0) {
            BuildManager buildManager = this;
            synchronized (buildManager) {
                if (this.myListenPort < 0) {
                    this.myListenPort = this.startListening();
                }
            }
        }
    }

    public void dispose() {
        this.stopListening();
    }

    @NotNull
    public static Pair<Sdk, JavaSdkVersion> getBuildProcessRuntimeSdk(@NotNull Project project2) {
        if (project2 == null) {
            BuildManager.$$$reportNull$$$0(6);
        }
        Pair<Sdk, JavaSdkVersion> pair2 = BuildManager.getRuntimeSdk(project2, 8);
        if (pair2 == null) {
            BuildManager.$$$reportNull$$$0(7);
        }
        return pair2;
    }

    @NotNull
    public static Pair<Sdk, JavaSdkVersion> getJavacRuntimeSdk(@NotNull Project project2) {
        if (project2 == null) {
            BuildManager.$$$reportNull$$$0(8);
        }
        Pair<Sdk, JavaSdkVersion> pair2 = BuildManager.getRuntimeSdk(project2, 6);
        if (pair2 == null) {
            BuildManager.$$$reportNull$$$0(9);
        }
        return pair2;
    }

    private static Pair<Sdk, JavaSdkVersion> getRuntimeSdk(Project project2, int oldestPossibleVersion) {
        LinkedHashSet<Sdk> candidates = new LinkedHashSet<Sdk>();
        Sdk defaultSdk = ProjectRootManager.getInstance((Project)project2).getProjectSdk();
        if (defaultSdk != null && defaultSdk.getSdkType() instanceof JavaSdkType) {
            candidates.add(defaultSdk);
        }
        for (Module module2 : ModuleManager.getInstance((Project)project2).getModules()) {
            Sdk sdk2 = ModuleRootManager.getInstance((Module)module2).getSdk();
            if (sdk2 == null || !(sdk2.getSdkType() instanceof JavaSdkType)) continue;
            candidates.add(sdk2);
        }
        JavaSdk javaSdkType = JavaSdk.getInstance();
        return candidates.stream().map(sdk -> Pair.pair((Object)sdk, (Object)JavaVersion.tryParse((String)sdk.getVersionString()))).filter(p -> p.second != null && ((JavaVersion)p.second).isAtLeast(oldestPossibleVersion)).max(Comparator.comparing(p -> (JavaVersion)p.second)).map(p -> Pair.pair((Object)p.first, (Object)JavaSdkVersion.fromJavaVersion((JavaVersion)((JavaVersion)p.second)))).orElseGet(() -> {
            Sdk internalJdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
            return Pair.pair((Object)internalJdk, (Object)javaSdkType.getVersion(internalJdk));
        });
    }

    private Future<Pair<RequestFuture<PreloadedProcessMessageHandler>, OSProcessHandler>> launchPreloadedBuildProcess(Project project2, ExecutorService projectTaskQueue) {
        this.ensureListening();
        return projectTaskQueue.submit(() -> {
            if (project2.isDisposed()) {
                return null;
            }
            RequestFuture future = new RequestFuture((Object)new PreloadedProcessMessageHandler(), UUID.randomUUID(), new CancelBuildSessionAction());
            try {
                this.myMessageDispatcher.registerBuildMessageHandler((RequestFuture<? extends BuilderMessageHandler>)future, null);
                OSProcessHandler processHandler = this.launchBuildProcess(project2, this.myListenPort, future.getRequestID(), true);
                StringBuffer errors = new StringBuffer();
                processHandler.addProcessListener((ProcessListener)new StdOutputCollector(errors));
                STDERR_OUTPUT.set((UserDataHolder)processHandler, (Object)errors);
                processHandler.startNotify();
                return Pair.create((Object)future, (Object)processHandler);
            }
            catch (Throwable e) {
                this.handleProcessExecutionFailure(future.getRequestID(), e);
                throw e instanceof Exception ? (Exception)e : new RuntimeException(e);
            }
        });
    }

    private OSProcessHandler launchBuildProcess(@NotNull Project project2, int port, @NotNull UUID sessionId, boolean requestProjectPreload) throws com.intellij.execution.ExecutionException {
        String path;
        String[] propertiesToPass;
        boolean allowParallelAutomake;
        String shouldGenerateIndex;
        String additionalOptions;
        String vmExecutablePath;
        String compilerPath;
        if (project2 == null) {
            BuildManager.$$$reportNull$$$0(10);
        }
        if (sessionId == null) {
            BuildManager.$$$reportNull$$$0(11);
        }
        JavaSdkVersion sdkVersion = null;
        String forcedCompiledJdkHome = Registry.stringValue((String)COMPILER_PROCESS_JDK_PROPERTY);
        if (StringUtil.isEmptyOrSpaces((String)forcedCompiledJdkHome)) {
            Pair<Sdk, JavaSdkVersion> pair2 = BuildManager.getBuildProcessRuntimeSdk(project2);
            Sdk projectJdk = (Sdk)pair2.first;
            sdkVersion = (JavaSdkVersion)pair2.second;
            Sdk internalJdk = JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
            JavaSdkType projectJdkType = (JavaSdkType)projectJdk.getSdkType();
            if (FileUtil.pathsEqual((String)projectJdk.getHomePath(), (String)internalJdk.getHomePath())) {
                JavaCompiler systemCompiler = ToolProvider.getSystemJavaCompiler();
                if (systemCompiler == null) {
                    try {
                        compilerPath = ClasspathBootstrap.getResourcePath(Class.forName("com.sun.tools.javac.api.JavacTool", false, BuildManager.class.getClassLoader()));
                    }
                    catch (Throwable t) {
                        LOG.info(t);
                        compilerPath = null;
                    }
                    if (compilerPath == null) {
                        throw new com.intellij.execution.ExecutionException("No system java compiler is provided by the JRE. Make sure tools.jar is present in IntelliJ IDEA classpath.");
                    }
                } else {
                    compilerPath = ClasspathBootstrap.getResourcePath(systemCompiler.getClass());
                }
            } else {
                compilerPath = projectJdkType.getToolsPath(projectJdk);
                if (compilerPath == null && !JavaSdkUtil.isJdkAtLeast((Sdk)projectJdk, (JavaSdkVersion)JavaSdkVersion.JDK_1_9)) {
                    throw new com.intellij.execution.ExecutionException("Cannot determine path to 'tools.jar' library for " + projectJdk.getName() + " (" + projectJdk.getHomePath() + ")");
                }
            }
            vmExecutablePath = projectJdkType.getVMExecutablePath(projectJdk);
        } else {
            compilerPath = new File(forcedCompiledJdkHome, "lib/tools.jar").getAbsolutePath();
            vmExecutablePath = new File(forcedCompiledJdkHome, "bin/java").getAbsolutePath();
        }
        CompilerConfiguration projectConfig = CompilerConfiguration.getInstance((Project)project2);
        CompilerWorkspaceConfiguration config = CompilerWorkspaceConfiguration.getInstance((Project)project2);
        GeneralCommandLine cmdLine = new GeneralCommandLine();
        cmdLine.setExePath(vmExecutablePath);
        boolean isProfilingMode = false;
        String userDefinedHeapSize = null;
        SmartList userAdditionalOptionsList = new SmartList();
        String userAdditionalVMOptions = config.COMPILER_PROCESS_ADDITIONAL_VM_OPTIONS;
        boolean userLocalOptionsActive = !StringUtil.isEmptyOrSpaces((String)userAdditionalVMOptions);
        String string = additionalOptions = userLocalOptionsActive ? userAdditionalVMOptions : projectConfig.getBuildProcessVMOptions();
        if (!StringUtil.isEmptyOrSpaces((String)additionalOptions)) {
            StringTokenizer tokenizer = new StringTokenizer(additionalOptions, " ", false);
            while (tokenizer.hasMoreTokens()) {
                String option = tokenizer.nextToken();
                if (StringUtil.startsWithIgnoreCase((String)option, (String)"-Xmx")) {
                    if (!userLocalOptionsActive) continue;
                    userDefinedHeapSize = option;
                    continue;
                }
                if ("-Dprofiling.mode=true".equals(option)) {
                    isProfilingMode = true;
                }
                userAdditionalOptionsList.add(option);
            }
        }
        if (userDefinedHeapSize != null) {
            cmdLine.addParameter(userDefinedHeapSize);
        } else {
            int heapSize = projectConfig.getBuildProcessHeapSize(JavacConfiguration.getOptions((Project)project2, JavacConfiguration.class).MAXIMUM_HEAP_SIZE);
            cmdLine.addParameter("-Xmx" + heapSize + "m");
        }
        if (SystemInfo.isMac && sdkVersion != null && JavaSdkVersion.JDK_1_6.equals((Object)sdkVersion) && Registry.is((String)"compiler.process.32bit.vm.on.mac")) {
            cmdLine.addParameter("-d32");
        }
        cmdLine.addParameter("-Djava.awt.headless=true");
        if (sdkVersion != null && sdkVersion.ordinal() < JavaSdkVersion.JDK_1_9.ordinal()) {
            cmdLine.addParameter("-Djava.endorsed.dirs=\"\"");
        }
        if (this.IS_UNIT_TEST_MODE) {
            cmdLine.addParameter("-Dtest.mode=true");
        }
        cmdLine.addParameter("-Djdt.compiler.useSingleThread=true");
        if (requestProjectPreload) {
            cmdLine.addParameter("-Dpreload.project.path=" + FileUtil.toCanonicalPath((String)BuildManager.getProjectPath(project2)));
            cmdLine.addParameter("-Dpreload.config.path=" + FileUtil.toCanonicalPath((String)PathManager.getOptionsPath()));
        }
        if (ProjectUtilCore.isExternalStorageEnabled((Project)project2)) {
            cmdLine.addParameter("-Dexternal.project.config=" + ProjectUtil.getExternalConfigurationDir((Project)project2));
        }
        if ((shouldGenerateIndex = System.getProperty("generate.classpath.index")) != null) {
            cmdLine.addParameter("-Dgenerate.classpath.index=" + shouldGenerateIndex);
        }
        cmdLine.addParameter("-Dcompile.parallel=" + config.PARALLEL_COMPILATION);
        if (config.PARALLEL_COMPILATION && !(allowParallelAutomake = Registry.is((String)"compiler.automake.allow.parallel", (boolean)true))) {
            cmdLine.addParameter("-Dallow.parallel.automake=false");
        }
        cmdLine.addParameter("-Drebuild.on.dependency.change=" + config.REBUILD_ON_DEPENDENCY_CHANGE);
        if (Registry.is((String)"compiler.build.report.statistics")) {
            cmdLine.addParameter("-Djps.report.build.statistics=true");
        }
        if (Boolean.TRUE.equals(Boolean.valueOf(System.getProperty("java.net.preferIPv4Stack", "false")))) {
            cmdLine.addParameter("-Djava.net.preferIPv4Stack=true");
        }
        cmdLine.addParameter("-Dio.netty.initialSeedUniquifier=" + ThreadLocalRandom.getInitialSeedUniquifier());
        for (String option : userAdditionalOptionsList) {
            cmdLine.addParameter(option);
        }
        if (isProfilingMode) {
            cmdLine.addParameter("-agentlib:yjpagent=disablealloc,delay=10000,sessionname=ExternalBuild");
        }
        int debugPort = -1;
        if (this.myBuildProcessDebuggingEnabled) {
            debugPort = Registry.intValue((String)"compiler.process.debug.port");
            if (debugPort <= 0) {
                try {
                    debugPort = NetUtils.findAvailableSocketPort();
                }
                catch (IOException e) {
                    throw new com.intellij.execution.ExecutionException("Cannot find free port to debug build process", (Throwable)e);
                }
            }
            if (debugPort > 0) {
                cmdLine.addParameter("-XX:+HeapDumpOnOutOfMemoryError");
                cmdLine.addParameter("-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=" + debugPort);
            }
        }
        cmdLine.setCharset(this.mySystemCharset);
        cmdLine.addParameter("-Dfile.encoding=" + this.mySystemCharset.name());
        for (String name2 : propertiesToPass = new String[]{"user.language", "user.country", "user.region", "idea.paths.selector", "idea.case.sensitive.fs"}) {
            String value = System.getProperty(name2);
            if (value == null) continue;
            cmdLine.addParameter("-D" + name2 + "=" + value);
        }
        cmdLine.addParameter("-Didea.home.path=" + PathManager.getHomePath());
        cmdLine.addParameter("-Didea.config.path=" + PathManager.getConfigPath());
        cmdLine.addParameter("-Didea.plugins.path=" + PathManager.getPluginsPath());
        cmdLine.addParameter("-Djps.log.dir=" + FileUtil.toSystemIndependentName((String)BuildManager.getBuildLogDirectory().getAbsolutePath()));
        cmdLine.addParameters(this.myFallbackJdkParams);
        cmdLine.addParameter("-Dio.netty.noUnsafe=true");
        Path workDirectory = this.getBuildSystemDirectory();
        try {
            Files.createDirectories(workDirectory, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
        File projectSystemRoot = this.getProjectSystemDirectory(project2);
        if (projectSystemRoot != null) {
            cmdLine.addParameter("-Djava.io.tmpdir=" + FileUtil.toSystemIndependentName((String)projectSystemRoot.getPath()) + "/" + TEMP_DIR_NAME);
        }
        for (BuildProcessParametersProvider provider : BuildProcessParametersProvider.EP_NAME.getExtensionList((AreaInstance)project2)) {
            List<String> args = provider.getVMArguments();
            cmdLine.addParameters(args);
        }
        Class<Launcher> launcherClass = Launcher.class;
        ArrayList<String> launcherCp = new ArrayList<String>();
        launcherCp.add(ClasspathBootstrap.getResourcePath(launcherClass));
        launcherCp.addAll(BuildProcessClasspathManager.getLauncherClasspath(project2));
        if (compilerPath != null) {
            launcherCp.add(compilerPath);
        }
        boolean includeBundledEcj = BuildManager.shouldIncludeEclipseCompiler(projectConfig);
        File customEcjPath = null;
        if (includeBundledEcj && !StringUtil.isEmptyOrSpaces((String)(path = EclipseCompilerConfiguration.getOptions((Project)project2, EclipseCompilerConfiguration.class).ECJ_TOOL_PATH))) {
            customEcjPath = new File(path);
            if (customEcjPath.exists()) {
                includeBundledEcj = false;
            } else {
                throw new com.intellij.execution.ExecutionException("Path to eclipse ecj compiler does not exist: " + customEcjPath.getAbsolutePath());
            }
        }
        ClasspathBootstrap.appendJavaCompilerClasspath(launcherCp, (boolean)includeBundledEcj);
        if (customEcjPath != null) {
            launcherCp.add(customEcjPath.getAbsolutePath());
        }
        cmdLine.addParameter("-classpath");
        cmdLine.addParameter(BuildManager.classpathToString(launcherCp));
        cmdLine.addParameter(launcherClass.getName());
        List cp = ClasspathBootstrap.getBuildProcessApplicationClasspath();
        cp.addAll(this.myClasspathManager.getBuildProcessPluginsClasspath(project2));
        if (isProfilingMode) {
            cp.add(workDirectory.resolve("yjp-controller-api-redist.jar").toString());
        }
        cmdLine.addParameter(BuildManager.classpathToString(cp));
        cmdLine.addParameter(BuildMain.class.getName());
        cmdLine.addParameter(Boolean.valueOf(System.getProperty("java.net.preferIPv6Addresses", "false")) != false ? "::1" : "127.0.0.1");
        cmdLine.addParameter(Integer.toString(port));
        cmdLine.addParameter(sessionId.toString());
        cmdLine.addParameter(PathKt.getSystemIndependentPath((Path)workDirectory));
        cmdLine.setWorkDirectory(workDirectory.toFile());
        try {
            ((BuildManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BuildManagerListener.TOPIC)).beforeBuildProcessStarted(project2, sessionId);
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        OSProcessHandler processHandler = new OSProcessHandler(cmdLine){

            protected boolean shouldDestroyProcessRecursively() {
                return true;
            }

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = BaseOutputReader.Options.BLOCKING;
                if (options == null) {
                    6.$$$reportNull$$$0(0);
                }
                return options;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/server/BuildManager$6", "readerOptions"));
            }
        };
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                String text;
                if (event == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    7.$$$reportNull$$$0(1);
                }
                if (!StringUtil.isEmptyOrSpaces((String)(text = event.getText()))) {
                    if (ProcessOutputTypes.SYSTEM.equals((Object)outputType)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("BUILDER_PROCESS [" + outputType + "]: " + text.trim());
                        }
                    } else {
                        LOG.info("BUILDER_PROCESS [" + outputType + "]: " + text.trim());
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/compiler/server/BuildManager$7";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (debugPort > 0) {
            processHandler.putUserData(COMPILER_PROCESS_DEBUG_PORT, (Object)debugPort);
        }
        return processHandler;
    }

    private static boolean shouldIncludeEclipseCompiler(CompilerConfiguration config) {
        if (config instanceof CompilerConfigurationImpl) {
            BackendCompiler javaCompiler = ((CompilerConfigurationImpl)config).getDefaultCompiler();
            String compilerId = javaCompiler != null ? javaCompiler.getId() : null;
            return "Eclipse".equals(compilerId) || "EclipseEmbedded".equals(compilerId);
        }
        return true;
    }

    @NotNull
    public Path getBuildSystemDirectory() {
        Path path = PathManagerEx.getAppSystemDir().resolve(SYSTEM_ROOT);
        if (path == null) {
            BuildManager.$$$reportNull$$$0(12);
        }
        return path;
    }

    @NotNull
    public static File getBuildLogDirectory() {
        File file = new File(PathManager.getLogPath(), "build-log");
        if (file == null) {
            BuildManager.$$$reportNull$$$0(13);
        }
        return file;
    }

    @Nullable
    public File getProjectSystemDirectory(Project project2) {
        String projectPath = BuildManager.getProjectPath(project2);
        return projectPath != null ? Utils.getDataStorageRoot((File)this.getBuildSystemDirectory().toFile(), (String)projectPath) : null;
    }

    private static File getUsageFile(@NotNull File projectSystemDir) {
        if (projectSystemDir == null) {
            BuildManager.$$$reportNull$$$0(14);
        }
        return new File(projectSystemDir, "ustamp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateUsageFile(@Nullable Project project2, @NotNull File projectSystemDir) {
        if (projectSystemDir == null) {
            BuildManager.$$$reportNull$$$0(15);
        }
        File usageFile = BuildManager.getUsageFile(projectSystemDir);
        StringBuilder content = new StringBuilder();
        try {
            String projectFilePath;
            SimpleDateFormat simpleDateFormat = USAGE_STAMP_DATE_FORMAT;
            synchronized (simpleDateFormat) {
                content.append(USAGE_STAMP_DATE_FORMAT.format(System.currentTimeMillis()));
            }
            if (project2 != null && !project2.isDisposed() && !StringUtil.isEmptyOrSpaces((String)(projectFilePath = project2.getProjectFilePath()))) {
                content.append("\n").append(FileUtil.toCanonicalPath((String)projectFilePath));
            }
            FileUtil.writeToFile((File)usageFile, (String)content.toString());
        }
        catch (Throwable e) {
            LOG.info(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Pair<Date, File> readUsageFile(File usageFile) {
        block5: {
            try {
                Date date;
                List lines = FileUtil.loadLines((File)usageFile, (String)CharsetToolkit.UTF8_CHARSET.name());
                if (lines.isEmpty()) break block5;
                String dateString = (String)lines.get(0);
                SimpleDateFormat simpleDateFormat = USAGE_STAMP_DATE_FORMAT;
                synchronized (simpleDateFormat) {
                    date = USAGE_STAMP_DATE_FORMAT.parse(dateString);
                }
                File projectFile = lines.size() > 1 ? new File((String)lines.get(1)) : null;
                return Pair.create((Object)date, (Object)projectFile);
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
        return null;
    }

    private void stopListening() {
        this.myListenPort = -1;
        this.myChannelRegistrar.close();
    }

    private int startListening() {
        BuiltInServer mainServer = StartupUtil.getServer();
        boolean isOwnEventLoopGroup = mainServer == null || mainServer.getEventLoopGroup() instanceof OioEventLoopGroup;
        EventLoopGroup group = isOwnEventLoopGroup ? NettyKt.MultiThreadEventLoopGroup((int)1, (ThreadFactory)ConcurrencyUtil.newNamedThreadFactory((String)"External compiler")) : mainServer.getEventLoopGroup();
        ServerBootstrap bootstrap = NettyKt.serverBootstrap((EventLoopGroup)group);
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer(){

            protected void initChannel(@NotNull Channel channel) {
                if (channel == null) {
                    8.$$$reportNull$$$0(0);
                }
                channel.pipeline().addLast(new ChannelHandler[]{BuildManager.this.myChannelRegistrar, new ProtobufVarint32FrameDecoder(), new ProtobufDecoder((MessageLite)CmdlineRemoteProto.Message.getDefaultInstance()), new ProtobufVarint32LengthFieldPrepender(), new ProtobufEncoder(), BuildManager.this.myMessageDispatcher});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "com/intellij/compiler/server/BuildManager$8", "initChannel"));
            }
        });
        Channel serverChannel = bootstrap.bind(InetAddress.getLoopbackAddress(), 0).syncUninterruptibly().channel();
        this.myChannelRegistrar.setServerChannel(serverChannel, isOwnEventLoopGroup);
        return ((InetSocketAddress)serverChannel.localAddress()).getPort();
    }

    private static String classpathToString(List<String> cp) {
        StringBuilder builder = new StringBuilder();
        for (String file : cp) {
            if (builder.length() > 0) {
                builder.append(File.pathSeparator);
            }
            builder.append(FileUtil.toCanonicalPath((String)file));
        }
        return builder.toString();
    }

    public boolean isBuildProcessDebuggingEnabled() {
        return this.myBuildProcessDebuggingEnabled;
    }

    public void setBuildProcessDebuggingEnabled(boolean buildProcessDebuggingEnabled) {
        this.myBuildProcessDebuggingEnabled = buildProcessDebuggingEnabled;
        if (this.myBuildProcessDebuggingEnabled) {
            this.cancelAllPreloadedBuilds();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/compiler/server/BuildManager";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionId";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/compiler/server/BuildManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadTrace";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectData";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildProcessRuntimeSdk";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavacRuntimeSdk";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildSystemDirectory";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildLogDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runCommand";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canStartAutoMake";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "notifySessionTerminationIfNeeded";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleProcessExecutionFailure";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBuildProcessRuntimeSdk";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getJavacRuntimeSdk";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "launchBuildProcess";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getUsageFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updateUsageFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CancelBuildSessionAction<T extends BuilderMessageHandler>
    implements RequestFuture.CancelAction<T> {
        private CancelBuildSessionAction() {
        }

        public void cancel(RequestFuture<T> future) {
            BuildManager.this.myMessageDispatcher.cancelSession(future.getRequestID());
            BuildManager.this.notifySessionTerminationIfNeeded(future.getRequestID(), null);
        }
    }

    private static final class DelegateFuture
    implements TaskFuture {
        @Nullable
        private TaskFuture[] myDelegates;
        private Boolean myRequestedCancelState;

        private DelegateFuture() {
        }

        @NotNull
        private synchronized TaskFuture[] getDelegates() {
            TaskFuture[] delegates = this.myDelegates;
            while (delegates == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                delegates = this.myDelegates;
            }
            if (delegates == null) {
                DelegateFuture.$$$reportNull$$$0(0);
            }
            return delegates;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized boolean setDelegates(TaskFuture ... delegates) {
            if (delegates == null) {
                DelegateFuture.$$$reportNull$$$0(1);
            }
            if (this.myDelegates == null) {
                try {
                    this.myDelegates = delegates;
                    if (this.myRequestedCancelState != null) {
                        for (TaskFuture delegate : delegates) {
                            delegate.cancel(this.myRequestedCancelState.booleanValue());
                        }
                    }
                }
                finally {
                    this.notifyAll();
                }
                return true;
            }
            return false;
        }

        public synchronized boolean cancel(boolean mayInterruptIfRunning) {
            TaskFuture[] delegates = this.myDelegates;
            if (delegates == null) {
                this.myRequestedCancelState = mayInterruptIfRunning;
                return true;
            }
            Stream.of(delegates).forEach(delegate -> delegate.cancel(mayInterruptIfRunning));
            return this.isDone();
        }

        public void waitFor() {
            Stream.of(this.getDelegates()).forEach(TaskFuture::waitFor);
        }

        public boolean waitFor(long timeout, TimeUnit unit) {
            Stream.of(this.getDelegates()).forEach(delegate -> delegate.waitFor(timeout, unit));
            return this.isDone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCancelled() {
            TaskFuture[] delegates;
            DelegateFuture delegateFuture = this;
            synchronized (delegateFuture) {
                delegates = this.myDelegates;
                if (delegates == null) {
                    return this.myRequestedCancelState != null;
                }
            }
            return Stream.of(delegates).anyMatch(Future::isCancelled);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDone() {
            TaskFuture[] delegates;
            DelegateFuture delegateFuture = this;
            synchronized (delegateFuture) {
                delegates = this.myDelegates;
                if (delegates == null) {
                    return false;
                }
            }
            return Stream.of(delegates).allMatch(Future::isDone);
        }

        public Object get() throws InterruptedException, ExecutionException {
            for (TaskFuture delegate : this.getDelegates()) {
                delegate.get();
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public Object get(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            if (timeUnit == null) {
                DelegateFuture.$$$reportNull$$$0(2);
            }
            for (TaskFuture delegate : this.getDelegates()) {
                void unit;
                delegate.get(timeout, (TimeUnit)unit);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/compiler/server/BuildManager$DelegateFuture";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegates";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unit";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDelegates";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/compiler/server/BuildManager$DelegateFuture";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setDelegates";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class XInternedPath
    extends InternedPath {
        private XInternedPath(String path) {
            super(path);
        }

        @Override
        public String getValue() {
            if (this.myPath.length > 0) {
                StringBuilder buf = new StringBuilder();
                for (int element : this.myPath) {
                    buf.append("/").append(FileNameCache.getVFileName((int)element));
                }
                return buf.toString();
            }
            return "/";
        }
    }

    private static class WinInternedPath
    extends InternedPath {
        private WinInternedPath(String path) {
            super(path);
        }

        @Override
        public String getValue() {
            if (this.myPath.length == 1) {
                String name2 = FileNameCache.getVFileName((int)this.myPath[0]).toString();
                return name2.length() == 2 && name2.endsWith(":") ? name2 + "/" : name2;
            }
            StringBuilder buf = new StringBuilder();
            for (int element : this.myPath) {
                if (buf.length() > 0) {
                    buf.append("/");
                }
                buf.append(FileNameCache.getVFileName((int)element));
            }
            return buf.toString();
        }
    }

    private static abstract class InternedPath {
        protected final int[] myPath;

        InternedPath(String path) {
            IntArrayList list = new IntArrayList();
            StringTokenizer tokenizer = new StringTokenizer(path, "/", false);
            while (tokenizer.hasMoreTokens()) {
                String element = tokenizer.nextToken();
                list.add(FileNameCache.storeName((String)element));
            }
            this.myPath = list.toArray();
        }

        public abstract String getValue();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InternedPath path = (InternedPath)o;
            return Arrays.equals(this.myPath, path.myPath);
        }

        public int hashCode() {
            return Arrays.hashCode(this.myPath);
        }

        public static InternedPath create(String path) {
            return path.startsWith("/") ? new XInternedPath(path) : new WinInternedPath(path);
        }
    }

    private static class ProjectData {
        @NotNull
        final ExecutorService taskQueue;
        private final Set<InternedPath> myChanged;
        private final Set<InternedPath> myDeleted;
        private long myNextEventOrdinal;
        private boolean myNeedRescan;

        private ProjectData(@NotNull ExecutorService taskQueue) {
            if (taskQueue == null) {
                ProjectData.$$$reportNull$$$0(0);
            }
            this.myChanged = new THashSet();
            this.myDeleted = new THashSet();
            this.myNeedRescan = true;
            this.taskQueue = taskQueue;
        }

        void addChanged(Collection<String> paths) {
            if (!this.myNeedRescan) {
                for (String path : paths) {
                    InternedPath _path = InternedPath.create(path);
                    this.myDeleted.remove(_path);
                    this.myChanged.add(_path);
                }
            }
        }

        void addDeleted(Collection<String> paths) {
            if (!this.myNeedRescan) {
                for (String path : paths) {
                    InternedPath _path = InternedPath.create(path);
                    this.myChanged.remove(_path);
                    this.myDeleted.add(_path);
                }
            }
        }

        CmdlineRemoteProto.Message.ControllerMessage.FSEvent createNextEvent() {
            CmdlineRemoteProto.Message.ControllerMessage.FSEvent.Builder builder = CmdlineRemoteProto.Message.ControllerMessage.FSEvent.newBuilder();
            builder.setOrdinal(++this.myNextEventOrdinal);
            for (InternedPath path : this.myChanged) {
                builder.addChangedPaths(path.getValue());
            }
            this.myChanged.clear();
            for (InternedPath path : this.myDeleted) {
                builder.addDeletedPaths(path.getValue());
            }
            this.myDeleted.clear();
            return (CmdlineRemoteProto.Message.ControllerMessage.FSEvent)builder.build();
        }

        boolean getAndResetRescanFlag() {
            boolean rescan = this.myNeedRescan;
            this.myNeedRescan = false;
            return rescan;
        }

        void dropChanges() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Project build state cleared: " + BuildManager.getThreadTrace(Thread.currentThread(), 20));
            }
            this.myNeedRescan = true;
            this.myNextEventOrdinal = 0L;
            this.myChanged.clear();
            this.myDeleted.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskQueue", "com/intellij/compiler/server/BuildManager$ProjectData", "<init>"));
        }
    }

    private class ProjectWatcher
    implements ProjectManagerListener {
        private final Map<Project, MessageBusConnection> myConnections = new HashMap<Project, MessageBusConnection>();

        private ProjectWatcher() {
        }

        public void projectOpened(final @NotNull Project project2) {
            if (project2 == null) {
                ProjectWatcher.$$$reportNull$$$0(0);
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            MessageBusConnection conn = project2.getMessageBus().connect();
            this.myConnections.put(project2, conn);
            conn.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

                public void rootsChanged(@NotNull ModuleRootEvent event) {
                    Object source;
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((source = event.getSource()) instanceof Project) {
                        BuildManager.this.clearState((Project)source);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/compiler/server/BuildManager$ProjectWatcher$1", "rootsChanged"));
                }
            });
            conn.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

                public void processStarting(@NotNull String executorId, @NotNull ExecutionEnvironment env) {
                    if (executorId == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (env == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    BuildManager.this.cancelAutoMakeTasks(env.getProject());
                }

                public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
                    if (executorId == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if (env == null) {
                        2.$$$reportNull$$$0(3);
                    }
                    if (handler == null) {
                        2.$$$reportNull$$$0(4);
                    }
                    BuildManager.this.cancelAutoMakeTasks(env.getProject());
                }

                public void processNotStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env) {
                    if (executorId == null) {
                        2.$$$reportNull$$$0(5);
                    }
                    if (env == null) {
                        2.$$$reportNull$$$0(6);
                    }
                    BuildManager.this.scheduleAutoMake();
                }

                public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler, int exitCode) {
                    if (executorId == null) {
                        2.$$$reportNull$$$0(7);
                    }
                    if (env == null) {
                        2.$$$reportNull$$$0(8);
                    }
                    if (handler == null) {
                        2.$$$reportNull$$$0(9);
                    }
                    BuildManager.this.scheduleAutoMake();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "executorId";
                            break;
                        }
                        case 1: 
                        case 3: 
                        case 6: 
                        case 8: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "env";
                            break;
                        }
                        case 4: 
                        case 9: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "handler";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/compiler/server/BuildManager$ProjectWatcher$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processStarting";
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processStarted";
                            break;
                        }
                        case 5: 
                        case 6: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processNotStarted";
                            break;
                        }
                        case 7: 
                        case 8: 
                        case 9: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            conn.subscribe(CompilerTopics.COMPILATION_STATUS, (Object)new CompilationStatusListener(){
                private final Set<String> myRootsToRefresh = new THashSet(FileUtil.PATH_HASHING_STRATEGY);

                public void automakeCompilationFinished(int errors, int warnings, @NotNull CompileContext compileContext) {
                    if (compileContext == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (!compileContext.getProgressIndicator().isCanceled()) {
                        this.refreshSources(compileContext);
                    }
                }

                public void compilationFinished(boolean aborted, int errors, int warnings, @NotNull CompileContext compileContext) {
                    if (compileContext == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    this.refreshSources(compileContext);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void refreshSources(CompileContext compileContext) {
                    if (project2.isDisposed()) {
                        return;
                    }
                    THashSet candidates = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
                    Set<String> set = this.myRootsToRefresh;
                    synchronized (set) {
                        candidates.addAll(this.myRootsToRefresh);
                        this.myRootsToRefresh.clear();
                    }
                    if (compileContext.isAnnotationProcessorsEnabled()) {
                        CompilerConfiguration config = CompilerConfiguration.getInstance((Project)project2);
                        for (Module module2 : compileContext.getCompileScope().getAffectedModules()) {
                            String testsPath;
                            if (!config.getAnnotationProcessingConfiguration(module2).isEnabled()) continue;
                            String productionPath = CompilerPaths.getAnnotationProcessorsGenerationPath((Module)module2, (boolean)false);
                            if (productionPath != null) {
                                candidates.add(productionPath);
                            }
                            if ((testsPath = CompilerPaths.getAnnotationProcessorsGenerationPath((Module)module2, (boolean)true)) == null) continue;
                            candidates.add(testsPath);
                        }
                    }
                    if (!candidates.isEmpty()) {
                        ApplicationManager.getApplication().executeOnPooledThread(() -> 3.lambda$refreshSources$2(project2, (Set)candidates));
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fileGenerated(@NotNull String outputRoot, @NotNull String relativePath) {
                    if (outputRoot == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    if (relativePath == null) {
                        3.$$$reportNull$$$0(3);
                    }
                    Set<String> set = this.myRootsToRefresh;
                    synchronized (set) {
                        this.myRootsToRefresh.add(outputRoot);
                    }
                }

                private static /* synthetic */ void lambda$refreshSources$2(Project project22, Set candidates) {
                    if (project22.isDisposed()) {
                        return;
                    }
                    CompilerUtil.refreshOutputRoots(candidates);
                    LocalFileSystem lfs = LocalFileSystem.getInstance();
                    Set toRefresh = (Set)ReadAction.compute(() -> {
                        if (project22.isDisposed()) {
                            return Collections.emptySet();
                        }
                        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project22).getFileIndex();
                        return candidates.stream().map(arg_0 -> ((LocalFileSystem)lfs).findFileByPath(arg_0)).filter(root -> root != null && fileIndex.isInSourceContent(root)).collect(Collectors.toSet());
                    });
                    if (!toRefresh.isEmpty()) {
                        lfs.refreshFiles((Iterable)toRefresh, true, true, null);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "compileContext";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputRoot";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "relativePath";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/compiler/server/BuildManager$ProjectWatcher$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "automakeCompilationFinished";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "compilationFinished";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "fileGenerated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            String projectPath = BuildManager.getProjectPath(project2);
            Disposer.register((Disposable)project2, () -> {
                BuildManager.this.cancelPreloadedBuilds(projectPath);
                BuildManager.this.myProjectDataMap.remove(projectPath);
            });
            StartupManager.getInstance((Project)project2).registerPostStartupActivity(() -> {
                BuildManager.this.runCommand(() -> {
                    File projectSystemDir = BuildManager.this.getProjectSystemDirectory(project2);
                    if (projectSystemDir != null) {
                        BuildManager.updateUsageFile(project2, projectSystemDir);
                    }
                });
                BuildManager.this.scheduleAutoMake();
            });
        }

        public void projectClosingBeforeSave(@NotNull Project project2) {
            if (project2 == null) {
                ProjectWatcher.$$$reportNull$$$0(1);
            }
            BuildManager.this.cancelAutoMakeTasks(project2);
        }

        public void projectClosing(@NotNull Project project2) {
            if (project2 == null) {
                ProjectWatcher.$$$reportNull$$$0(2);
            }
            BuildManager.this.cancelPreloadedBuilds(BuildManager.getProjectPath(project2));
            for (TaskFuture future : BuildManager.this.cancelAutoMakeTasks(project2)) {
                future.waitFor(500L, TimeUnit.MILLISECONDS);
            }
        }

        public void projectClosed(@NotNull Project project2) {
            if (project2 == null) {
                ProjectWatcher.$$$reportNull$$$0(3);
            }
            BuildManager.this.myProjectDataMap.remove(BuildManager.getProjectPath(project2));
            MessageBusConnection conn = this.myConnections.remove(project2);
            if (conn != null) {
                conn.disconnect();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/intellij/compiler/server/BuildManager$ProjectWatcher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectOpened";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectClosingBeforeSave";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectClosing";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectClosed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class StdOutputCollector
    extends ProcessAdapter {
        private final Appendable myOutput;
        private int myStoredLength;

        StdOutputCollector(@NotNull Appendable outputSink) {
            if (outputSink == null) {
                StdOutputCollector.$$$reportNull$$$0(0);
            }
            this.myOutput = outputSink;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
            String text;
            if (event == null) {
                StdOutputCollector.$$$reportNull$$$0(1);
            }
            if (outputType == null) {
                StdOutputCollector.$$$reportNull$$$0(2);
            }
            StdOutputCollector stdOutputCollector = this;
            synchronized (stdOutputCollector) {
                if (this.myStoredLength > 16384) {
                    return;
                }
                text = event.getText();
                if (StringUtil.isEmptyOrSpaces((String)text)) {
                    return;
                }
                this.myStoredLength += text.length();
            }
            try {
                this.myOutput.append(text);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputSink";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/compiler/server/BuildManager$StdOutputCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onTextAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NotifyingMessageHandler
    extends DelegatingMessageHandler {
        private final Project myProject;
        private final BuilderMessageHandler myDelegateHandler;
        private final boolean myIsAutomake;

        NotifyingMessageHandler(@NotNull Project project2, @NotNull BuilderMessageHandler delegateHandler, boolean isAutomake) {
            if (project2 == null) {
                NotifyingMessageHandler.$$$reportNull$$$0(0);
            }
            if (delegateHandler == null) {
                NotifyingMessageHandler.$$$reportNull$$$0(1);
            }
            this.myProject = project2;
            this.myDelegateHandler = delegateHandler;
            this.myIsAutomake = isAutomake;
        }

        @Override
        protected BuilderMessageHandler getDelegateHandler() {
            return this.myDelegateHandler;
        }

        @Override
        public void buildStarted(@NotNull UUID sessionId) {
            if (sessionId == null) {
                NotifyingMessageHandler.$$$reportNull$$$0(2);
            }
            super.buildStarted(sessionId);
            try {
                ((BuildManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BuildManagerListener.TOPIC)).buildStarted(this.myProject, sessionId, this.myIsAutomake);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }

        @Override
        public void sessionTerminated(@NotNull UUID sessionId) {
            if (sessionId == null) {
                NotifyingMessageHandler.$$$reportNull$$$0(3);
            }
            try {
                super.sessionTerminated(sessionId);
            }
            finally {
                try {
                    ((BuildManagerListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(BuildManagerListener.TOPIC)).buildFinished(this.myProject, sessionId, this.myIsAutomake);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegateHandler";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sessionId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/compiler/server/BuildManager$NotifyingMessageHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "buildStarted";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sessionTerminated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class BuildManagerPeriodicTask
    implements Runnable {
        private final Alarm myAlarm;
        private final AtomicBoolean myInProgress = new AtomicBoolean(false);
        private final Runnable myTaskRunnable = () -> {
            try {
                this.runTask();
            }
            finally {
                this.myInProgress.set(false);
            }
        };

        BuildManagerPeriodicTask() {
            this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)BuildManager.this);
        }

        final void schedule() {
            this.cancelPendingExecution();
            int delay = Math.max(100, this.getDelay());
            this.myAlarm.addRequest((Runnable)this, delay);
        }

        void cancelPendingExecution() {
            this.myAlarm.cancelAllRequests();
        }

        protected boolean shouldPostpone() {
            return false;
        }

        protected abstract int getDelay();

        protected abstract void runTask();

        @Override
        public final void run() {
            if (!(HeavyProcessLatch.INSTANCE.isRunning() || BuildManager.this.myFileChangeCounter > 0 || this.shouldPostpone() || this.myInProgress.getAndSet(true))) {
                try {
                    ApplicationManager.getApplication().executeOnPooledThread(this.myTaskRunnable);
                }
                catch (RejectedExecutionException ignored) {
                    this.myInProgress.set(false);
                }
                catch (Throwable e) {
                    this.myInProgress.set(false);
                    throw new RuntimeException(e);
                }
            } else {
                this.schedule();
            }
        }
    }
}

