/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.backwardRefs;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

class ExcludedFromCompileFilesUtil {
    ExcludedFromCompileFilesUtil() {
    }

    static GlobalSearchScope getExcludedFilesScope(@NotNull ExcludeEntryDescription[] descriptions, @NotNull Set<FileType> fileTypes, @NotNull Project project2, @NotNull ProjectFileIndex fileIndex) {
        if (descriptions == null) {
            ExcludedFromCompileFilesUtil.$$$reportNull$$$0(0);
        }
        if (fileTypes == null) {
            ExcludedFromCompileFilesUtil.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            ExcludedFromCompileFilesUtil.$$$reportNull$$$0(2);
        }
        if (fileIndex == null) {
            ExcludedFromCompileFilesUtil.$$$reportNull$$$0(3);
        }
        ManagingFS fs = ManagingFS.getInstance();
        Collection excludedFiles = Stream.of(descriptions).flatMap(description -> {
            VirtualFile file = description.getVirtualFile();
            if (file == null) {
                return Stream.empty();
            }
            if (description.isFile()) {
                return Stream.of(file);
            }
            if (description.isIncludeSubdirectories()) {
                Stream.Builder builder = Stream.builder();
                VfsUtilCore.iterateChildrenRecursively((VirtualFile)file, f -> !f.isDirectory() || fs.areChildrenLoaded(f), f -> {
                    builder.accept(f);
                    return true;
                });
                return builder.build();
            }
            return fs.areChildrenLoaded(file) ? Stream.of(file.getChildren()) : Stream.empty();
        }).filter(f -> !f.isDirectory() && fileTypes.contains(f.getFileType()) && (Boolean)ReadAction.compute(() -> !project2.isDisposed() && fileIndex.isInSourceContent(f)) != false).collect(Collectors.toList());
        return GlobalSearchScope.filesWithoutLibrariesScope((Project)project2, (Collection)excludedFiles);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptions";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "fileTypes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "fileIndex";
                break;
            }
        }
        objectArray[1] = "com/intellij/compiler/backwardRefs/ExcludedFromCompileFilesUtil";
        objectArray[2] = "getExcludedFilesScope";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

