/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.GenerationUtils;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.taskdefs.Include;
import com.intellij.compiler.ant.taskdefs.PatternSet;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public class LibraryPatterns
extends Generator {
    private final PatternSet myPatternSet = new PatternSet("library.patterns");

    public LibraryPatterns(Project project2, GenerationOptions genOptions) {
        ArchiveFileType type = ArchiveFileType.INSTANCE;
        List matchers = FileTypeManager.getInstance().getAssociations((FileType)type);
        for (FileNameMatcher m : matchers) {
            if (m instanceof ExactFileNameMatcher) {
                String path = GenerationUtils.toRelativePath((String)m.getPresentableString(), (File)BuildProperties.getProjectBaseDir((Project)project2), (String)BuildProperties.getProjectBaseDirProperty(), (GenerationOptions)genOptions);
                this.myPatternSet.add((Generator)new Include(path));
                continue;
            }
            this.myPatternSet.add((Generator)new Include(m.getPresentableString()));
        }
    }

    public void generate(PrintWriter out) throws IOException {
        this.myPatternSet.generate(out);
    }
}

