/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea;

import com.intellij.dvcs.ignore.VcsRepositoryIgnoredFilesHolder;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.VcsVFSListener;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.ui.SelectFilePathsDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.VcsBackgroundTask;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.swing.Action;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgChange;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.command.HgAddCommand;
import org.zmlx.hg4idea.command.HgCopyCommand;
import org.zmlx.hg4idea.command.HgMoveCommand;
import org.zmlx.hg4idea.command.HgRemoveCommand;
import org.zmlx.hg4idea.command.HgStatusCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgVFSListener
extends VcsVFSListener {
    private final VcsDirtyScopeManager dirtyScopeManager;
    private static final Logger LOG = Logger.getInstance(HgVFSListener.class);

    protected HgVFSListener(Project project, HgVcs vcs) {
        super(project, (AbstractVcs)vcs);
        this.dirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
    }

    @NotNull
    protected String getAddTitle() {
        String string = HgVcsMessages.message("hg4idea.add.title", new Object[0]);
        if (string == null) {
            HgVFSListener.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected String getSingleFileAddTitle() {
        String string = HgVcsMessages.message("hg4idea.add.single.title", new Object[0]);
        if (string == null) {
            HgVFSListener.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    protected String getSingleFileAddPromptTemplate() {
        String string = HgVcsMessages.message("hg4idea.add.body", new Object[0]);
        if (string == null) {
            HgVFSListener.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected void executeAdd(@NotNull List<VirtualFile> addedFiles, @NotNull Map<VirtualFile, VirtualFile> copyFromMap) {
        if (addedFiles == null) {
            HgVFSListener.$$$reportNull$$$0(3);
        }
        if (copyFromMap == null) {
            HgVFSListener.$$$reportNull$$$0(4);
        }
        this.executeAddWithoutIgnores(addedFiles, copyFromMap, (notIgnoredAddedFiles, copiedFilesMap) -> this.originalExecuteAdd(notIgnoredAddedFiles, copiedFilesMap));
    }

    protected void executeAddWithoutIgnores(final @NotNull List<VirtualFile> addedFiles, final @NotNull Map<VirtualFile, VirtualFile> copyFromMap, final @NotNull VcsVFSListener.ExecuteAddCallback executeAddCallback) {
        if (addedFiles == null) {
            HgVFSListener.$$$reportNull$$$0(5);
        }
        if (copyFromMap == null) {
            HgVFSListener.$$$reportNull$$$0(6);
        }
        if (executeAddCallback == null) {
            HgVFSListener.$$$reportNull$$$0(7);
        }
        this.saveUnsavedVcsIgnoreFiles();
        Iterator<Map.Entry<VirtualFile, VirtualFile>> it = copyFromMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<VirtualFile, VirtualFile> entry = it.next();
            VirtualFile rootFrom = HgUtil.getHgRootOrNull(this.myProject, entry.getKey());
            VirtualFile rootTo = HgUtil.getHgRootOrNull(this.myProject, entry.getValue());
            if (rootTo != null && rootTo.equals(rootFrom)) continue;
            it.remove();
        }
        it = addedFiles.iterator();
        while (it.hasNext()) {
            if (HgUtil.getHgRootOrNull(this.myProject, (VirtualFile)it.next()) != null) continue;
            it.remove();
        }
        final Map<VirtualFile, Collection<VirtualFile>> sortedFiles = HgUtil.sortByHgRoots(this.myProject, addedFiles);
        final HashSet untrackedFiles = new HashSet();
        new Task.Backgroundable(this.myProject, HgVcsMessages.message("hg4idea.progress.checking.ignored", new Object[0]), false){

            public void run(@NotNull ProgressIndicator pi) {
                if (pi == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (Map.Entry e : sortedFiles.entrySet()) {
                    VirtualFile repo = (VirtualFile)e.getKey();
                    Collection files = (Collection)e.getValue();
                    pi.setText(repo.getPresentableUrl());
                    Collection<VirtualFile> untrackedForRepo = new HgStatusCommand.Builder(false).unknown(true).removed(true).build(this.myProject).getFiles(repo, (List<VirtualFile>)new ArrayList<VirtualFile>(files));
                    untrackedFiles.addAll(untrackedForRepo);
                }
                addedFiles.retainAll(untrackedFiles);
                if (!addedFiles.isEmpty() || !copyFromMap.isEmpty()) {
                    AppUIUtil.invokeLaterIfProjectAlive((Project)this.myProject, () -> executeAddCallback.executeAdd(addedFiles, copyFromMap));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "org/zmlx/hg4idea/HgVFSListener$1", "run"));
            }
        }.queue();
    }

    @NotNull
    VcsRepositoryIgnoredFilesHolder getIgnoreRepoHolder(@NotNull VirtualFile repoRoot) {
        if (repoRoot == null) {
            HgVFSListener.$$$reportNull$$$0(8);
        }
        VcsRepositoryIgnoredFilesHolder vcsRepositoryIgnoredFilesHolder = ((HgRepository)ObjectUtils.assertNotNull((Object)HgUtil.getRepositoryManager(this.myProject).getRepositoryForRootQuick(repoRoot))).getIgnoredFilesHolder();
        if (vcsRepositoryIgnoredFilesHolder == null) {
            HgVFSListener.$$$reportNull$$$0(9);
        }
        return vcsRepositoryIgnoredFilesHolder;
    }

    private void originalExecuteAdd(List<VirtualFile> addedFiles, Map<VirtualFile, VirtualFile> copiedFiles) {
        super.executeAdd(addedFiles, copiedFiles);
    }

    protected void performAdding(final @NotNull Collection<VirtualFile> addedFiles, @NotNull Map<VirtualFile, VirtualFile> copiedFilesFrom) {
        if (addedFiles == null) {
            HgVFSListener.$$$reportNull$$$0(10);
        }
        if (copiedFilesFrom == null) {
            HgVFSListener.$$$reportNull$$$0(11);
        }
        final HashMap<VirtualFile, VirtualFile> copyFromMap = new HashMap<VirtualFile, VirtualFile>(copiedFilesFrom);
        new Task.ConditionalModal(this.myProject, HgVcsMessages.message("hg4idea.add.progress", new Object[0]), false, VcsConfiguration.getInstance((Project)this.myProject).getAddRemoveOption()){

            public void run(@NotNull ProgressIndicator aProgressIndicator) {
                if (aProgressIndicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                ArrayList<VirtualFile> adds = new ArrayList<VirtualFile>();
                HashMap<VirtualFile, VirtualFile> copies = new HashMap<VirtualFile, VirtualFile>();
                LOG.assertTrue(this.myProject != null, (Object)"Project is null");
                ArrayList<VirtualFile> unversionedAndIgnoredFiles = new ArrayList<VirtualFile>();
                Map<VirtualFile, Collection<VirtualFile>> sortedSourceFilesByRepos = HgUtil.sortByHgRoots(this.myProject, copyFromMap.values());
                HgStatusCommand statusCommand = new HgStatusCommand.Builder(false).unknown(true).ignored(true).build(this.myProject);
                for (Map.Entry<VirtualFile, Collection<VirtualFile>> entry : sortedSourceFilesByRepos.entrySet()) {
                    Set<HgChange> changes = statusCommand.executeInCurrentThread(entry.getKey(), ContainerUtil.map(entry.getValue(), virtualFile -> VcsUtil.getFilePath((VirtualFile)virtualFile)));
                    for (HgChange change : changes) {
                        unversionedAndIgnoredFiles.add(change.afterFile().toFilePath().getVirtualFile());
                    }
                }
                copyFromMap.values().removeAll(unversionedAndIgnoredFiles);
                for (VirtualFile virtualFile2 : addedFiles) {
                    VirtualFile copyFrom = (VirtualFile)copyFromMap.get(virtualFile2);
                    if (copyFrom != null) {
                        copies.put(copyFrom, virtualFile2);
                        continue;
                    }
                    adds.add(virtualFile2);
                }
                if (!adds.isEmpty()) {
                    new HgAddCommand(this.myProject).executeInCurrentThread(adds);
                }
                if (!copies.isEmpty()) {
                    for (Map.Entry<Object, Collection<Object>> entry : copies.entrySet()) {
                        new HgCopyCommand(this.myProject).executeInCurrentThread((VirtualFile)entry.getKey(), (VirtualFile)entry.getValue());
                    }
                }
                for (VirtualFile virtualFile3 : addedFiles) {
                    if (virtualFile3.isDirectory()) {
                        HgVFSListener.this.dirtyScopeManager.dirDirtyRecursively(virtualFile3);
                        continue;
                    }
                    HgVFSListener.this.dirtyScopeManager.fileDirty(virtualFile3);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aProgressIndicator", "org/zmlx/hg4idea/HgVFSListener$2", "run"));
            }
        }.queue();
    }

    @NotNull
    protected String getDeleteTitle() {
        String string = HgVcsMessages.message("hg4idea.remove.multiple.title", new Object[0]);
        if (string == null) {
            HgVFSListener.$$$reportNull$$$0(12);
        }
        return string;
    }

    protected String getSingleFileDeleteTitle() {
        return HgVcsMessages.message("hg4idea.remove.single.title", new Object[0]);
    }

    protected String getSingleFileDeletePromptTemplate() {
        return HgVcsMessages.message("hg4idea.remove.single.body", new Object[0]);
    }

    @NotNull
    protected VcsVFSListener.VcsDeleteType needConfirmDeletion(@NotNull VirtualFile file) {
        if (file == null) {
            HgVFSListener.$$$reportNull$$$0(13);
        }
        VcsVFSListener.VcsDeleteType vcsDeleteType = ChangeListManagerImpl.getInstanceImpl((Project)this.myProject).getUnversionedFiles().contains(file) ? VcsVFSListener.VcsDeleteType.IGNORE : VcsVFSListener.VcsDeleteType.CONFIRM;
        if (vcsDeleteType == null) {
            HgVFSListener.$$$reportNull$$$0(14);
        }
        return vcsDeleteType;
    }

    protected void executeDelete() {
        final ArrayList<FilePath> filesToDelete = new ArrayList<FilePath>(this.myDeletedWithoutConfirmFiles);
        final ArrayList<FilePath> filesToConfirmDeletion = new ArrayList<FilePath>(this.myDeletedFiles);
        this.myDeletedWithoutConfirmFiles.clear();
        this.myDeletedFiles.clear();
        this.skipNotUnderHg(filesToDelete);
        this.skipNotUnderHg(filesToConfirmDeletion);
        filesToDelete.removeAll(this.processAndGetVcsIgnored(filesToDelete));
        filesToConfirmDeletion.removeAll(this.processAndGetVcsIgnored(filesToConfirmDeletion));
        Iterator it = filesToConfirmDeletion.iterator();
        while (it.hasNext()) {
            FilePath filePath = (FilePath)it.next();
            Change fileChange = ChangeListManager.getInstance((Project)this.myProject).getChange(filePath);
            if (fileChange == null || !fileChange.getFileStatus().equals(FileStatus.ADDED)) continue;
            filesToDelete.add(filePath);
            it.remove();
        }
        new Task.ConditionalModal(this.myProject, HgVcsMessages.message("hg4idea.remove.progress", new Object[0]), false, VcsConfiguration.getInstance((Project)this.myProject).getAddRemoveOption()){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (HgVFSListener.this.myRemoveOption.getValue() != VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
                    if (HgVFSListener.this.myRemoveOption.getValue() == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY || filesToConfirmDeletion.isEmpty()) {
                        filesToDelete.addAll(filesToConfirmDeletion);
                    } else {
                        AtomicReference filePaths = new AtomicReference();
                        ApplicationManager.getApplication().invokeAndWait(() -> filePaths.set(HgVFSListener.this.selectFilePathsToDelete(filesToConfirmDeletion)));
                        if (filePaths.get() != null) {
                            filesToDelete.addAll((Collection)filePaths.get());
                        }
                    }
                }
                if (!filesToDelete.isEmpty()) {
                    HgVFSListener.this.performDeletion(filesToDelete);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/HgVFSListener$3", "run"));
            }
        }.queue();
    }

    @NotNull
    private List<FilePath> processAndGetVcsIgnored(@NotNull List<FilePath> filePaths) {
        if (filePaths == null) {
            HgVFSListener.$$$reportNull$$$0(15);
        }
        Map<VirtualFile, Collection<FilePath>> groupFilePathsByHgRoots = HgUtil.groupFilePathsByHgRoots(this.myProject, filePaths);
        List<FilePath> list = groupFilePathsByHgRoots.entrySet().stream().map(entry -> this.getIgnoreRepoHolder((VirtualFile)entry.getKey()).removeIgnoredFiles((Collection)entry.getValue())).flatMap(Collection::stream).collect(Collectors.toList());
        if (list == null) {
            HgVFSListener.$$$reportNull$$$0(16);
        }
        return list;
    }

    private void skipNotUnderHg(Collection<FilePath> filesToFilter) {
        Iterator<FilePath> iter = filesToFilter.iterator();
        while (iter.hasNext()) {
            FilePath filePath = iter.next();
            if (HgUtil.getHgRootOrNull(this.myProject, filePath) != null) continue;
            iter.remove();
        }
    }

    protected void performDeletion(@NotNull List<FilePath> filesToDelete) {
        if (filesToDelete == null) {
            HgVFSListener.$$$reportNull$$$0(17);
        }
        ArrayList<HgFile> deletes = new ArrayList<HgFile>();
        for (FilePath filePath : filesToDelete) {
            VirtualFile root;
            if (filePath.isDirectory() || (root = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)filePath)) == null) continue;
            deletes.add(new HgFile(root, filePath));
        }
        if (!deletes.isEmpty()) {
            new HgRemoveCommand(this.myProject).executeInCurrentThread(deletes);
        }
        for (HgFile hgFile : deletes) {
            this.dirtyScopeManager.fileDirty(hgFile.toFilePath());
        }
    }

    protected void performMoveRename(@NotNull List<VcsVFSListener.MovedFileInfo> movedFiles) {
        if (movedFiles == null) {
            HgVFSListener.$$$reportNull$$$0(18);
        }
        final ArrayList failedToMove = new ArrayList();
        new VcsBackgroundTask<VcsVFSListener.MovedFileInfo>(this.myProject, HgVcsMessages.message("hg4idea.move.progress", new Object[0]), VcsConfiguration.getInstance((Project)this.myProject).getAddRemoveOption(), movedFiles){

            public void onFinished() {
                if (!failedToMove.isEmpty()) {
                    this.handleRenameError();
                }
            }

            private void handleRenameError() {
                NotificationAction viewFilesAction = NotificationAction.createSimple((String)"View Files...", () -> {
                    ProcessedFilePathsDialog dialog = new ProcessedFilePathsDialog(this.myProject, ContainerUtil.map2List((Collection)failedToMove, movedInfo -> VcsUtil.getFilePath((String)movedInfo.myOldPath)));
                    dialog.setTitle("Failed to Rename");
                    dialog.show();
                });
                NotificationAction retryAction = NotificationAction.create((String)"Retry", (e, notification) -> {
                    notification.expire();
                    HgVFSListener.this.performMoveRename(failedToMove);
                });
                VcsNotifier.getInstance((Project)this.myProject).notifyError("Rename Failed", "Couldn't mark some files as renamed", new NotificationAction[]{viewFilesAction, retryAction});
            }

            protected void process(VcsVFSListener.MovedFileInfo file) {
                FilePath source = VcsUtil.getFilePath((String)file.myOldPath);
                FilePath target = VcsUtil.getFilePath((String)file.myNewPath);
                VirtualFile sourceRoot = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)source);
                VirtualFile targetRoot = VcsUtil.getVcsRootFor((Project)this.myProject, (FilePath)target);
                if (sourceRoot != null && sourceRoot.equals(targetRoot)) {
                    HgCommandResult result;
                    int attempt = 0;
                    while (HgErrorUtil.isWLockError(result = new HgMoveCommand(this.myProject).execute(sourceRoot, source, target)) && attempt++ < 2) {
                    }
                    if (!HgErrorUtil.hasErrorsInCommandExecution(result)) {
                        HgVFSListener.this.dirtyScopeManager.fileDirty(source);
                        HgVFSListener.this.dirtyScopeManager.fileDirty(target);
                    } else {
                        failedToMove.add(file);
                        LOG.warn("Hg rename failed:" + result.getRawError());
                    }
                }
            }
        }.queue();
    }

    protected boolean isDirectoryVersioningSupported() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/HgVFSListener";
                break;
            }
            case 3: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedFiles";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFromMap";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executeAddCallback";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoRoot";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copiedFilesFrom";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToDelete";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "movedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddTitle";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleFileAddTitle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSingleFileAddPromptTemplate";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/HgVFSListener";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoreRepoHolder";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeleteTitle";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "needConfirmDeletion";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "processAndGetVcsIgnored";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeAdd";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executeAddWithoutIgnores";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoreRepoHolder";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "performAdding";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "needConfirmDeletion";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processAndGetVcsIgnored";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "performDeletion";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "performMoveRename";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ProcessedFilePathsDialog
    extends SelectFilePathsDialog {
        ProcessedFilePathsDialog(@NotNull Project project, @NotNull List<FilePath> files) {
            if (project == null) {
                ProcessedFilePathsDialog.$$$reportNull$$$0(0);
            }
            if (files == null) {
                ProcessedFilePathsDialog.$$$reportNull$$$0(1);
            }
            super(project, files, null, null, null, null, false);
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{this.getOKAction()};
            if (actionArray == null) {
                ProcessedFilePathsDialog.$$$reportNull$$$0(2);
            }
            return actionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/zmlx/hg4idea/HgVFSListener$ProcessedFilePathsDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/zmlx/hg4idea/HgVFSListener$ProcessedFilePathsDialog";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

