/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubFullPath;
import org.jetbrains.plugins.github.api.GithubRepositoryPath;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.util.GitRemoteUrlCoordinates;
import org.jetbrains.plugins.github.util.GithubAccountsMigrationHelper;
import org.jetbrains.plugins.github.util.GithubSettings;
import org.jetbrains.plugins.github.util.GithubUrlUtil;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000f2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bJ\u0016\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u000bH\u0002J\u001a\u0010\"\u001a\u0010\u0012\f\u0012\n #*\u0004\u0018\u00010\u000b0\u000b0\n*\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/plugins/github/util/GithubGitHelper;", "", "githubSettings", "Lorg/jetbrains/plugins/github/util/GithubSettings;", "authenticationManager", "Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;", "migrationHelper", "Lorg/jetbrains/plugins/github/util/GithubAccountsMigrationHelper;", "(Lorg/jetbrains/plugins/github/util/GithubSettings;Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;Lorg/jetbrains/plugins/github/util/GithubAccountsMigrationHelper;)V", "getAccessibleRemoteUrls", "", "", "repository", "Lgit4idea/repo/GitRepository;", "getKnownGithubServers", "", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "getPossibleRemoteUrlCoordinates", "Lorg/jetbrains/plugins/github/util/GitRemoteUrlCoordinates;", "project", "Lcom/intellij/openapi/project/Project;", "getPossibleRepositories", "Lorg/jetbrains/plugins/github/api/GithubRepositoryPath;", "getRemoteUrl", "server", "user", "repo", "repoPath", "Lorg/jetbrains/plugins/github/api/GithubFullPath;", "hasAccessibleRemotes", "", "havePossibleRemotes", "isRemoteUrlAccessible", "url", "getRemoteUrls", "kotlin.jvm.PlatformType", "Companion", "intellij.vcs.github"})
public final class GithubGitHelper {
    private final GithubSettings githubSettings;
    private final GithubAuthenticationManager authenticationManager;
    private final GithubAccountsMigrationHelper migrationHelper;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getRemoteUrl(@NotNull GithubServerPath server, @NotNull GithubFullPath repoPath) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        Intrinsics.checkParameterIsNotNull((Object)repoPath, (String)"repoPath");
        String string = repoPath.getUser();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"repoPath.user");
        String string2 = repoPath.getRepository();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"repoPath.repository");
        return this.getRemoteUrl(server, string, string2);
    }

    @NotNull
    public final String getRemoteUrl(@NotNull GithubServerPath server, @NotNull String user, @NotNull String repo) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        Intrinsics.checkParameterIsNotNull((Object)repo, (String)"repo");
        if (this.githubSettings.isCloneGitUsingSsh()) {
            String string2;
            String string3;
            StringBuilder stringBuilder;
            String string4;
            StringBuilder stringBuilder2 = new StringBuilder().append("git@").append(server.getHost()).append(':');
            String string5 = server.getSuffix();
            if (string5 != null) {
                string4 = string5;
                int n = 1;
                stringBuilder = stringBuilder2;
                String string6 = string4;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                string3 = string7;
                stringBuilder2 = stringBuilder;
                string2 = string3;
            } else {
                string2 = null;
            }
            string4 = string2;
            stringBuilder = stringBuilder2;
            String string8 = string4;
            if (string8 == null) {
                string8 = "";
            }
            string3 = string8;
            string = stringBuilder.append(string3).append('/').append(user).append('/').append(repo).append(".git").toString();
        } else {
            String string9 = server.getSuffix();
            StringBuilder stringBuilder = new StringBuilder().append("https://").append(server.getHost());
            String string10 = string9;
            if (string10 == null) {
                string10 = "";
            }
            String string11 = string10;
            string = stringBuilder.append(string11).append('/').append(user).append('/').append(repo).append(".git").toString();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getAccessibleRemoteUrls(@NotNull GitRepository repository) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Iterable iterable = this.getRemoteUrls(repository);
        GithubGitHelper githubGitHelper = this;
        void var4_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String p1 = (String)element$iv$iv;
            boolean bl = false;
            if (!githubGitHelper.isRemoteUrlAccessible(p1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasAccessibleRemotes(@NotNull GitRepository repository) {
        boolean bl;
        block3: {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
            Iterable iterable = this.getRemoteUrls(repository);
            GithubGitHelper githubGitHelper = this;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    String p1 = (String)element$iv;
                    boolean bl2 = false;
                    if (!githubGitHelper.isRemoteUrlAccessible(p1)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isRemoteUrlAccessible(String url) {
        Object v0;
        block1: {
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)this.authenticationManager.getAccounts();
            for (Object t : iterable2) {
                GithubAccount it = (GithubAccount)t;
                boolean bl = false;
                if (!it.getServer().matches(url)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0 != null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<GithubRepositoryPath> getPossibleRepositories(@NotNull GitRepository repository) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Set<GithubServerPath> knownServers = this.getKnownGithubServers();
        Iterable iterable = $receiver$iv = (Iterable)this.getRemoteUrls(repository);
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator = $receiver$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GithubRepositoryPath githubRepositoryPath;
            GithubRepositoryPath githubRepositoryPath2;
            Object v0;
            Object it;
            Object object;
            String url;
            block6: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                url = (String)element$iv$iv;
                boolean bl = false;
                object = knownServers;
                Iterable iterable2 = object;
                for (Object object2 : iterable2) {
                    it = (GithubServerPath)object2;
                    boolean bl2 = false;
                    if (!((GithubServerPath)it).matches(url)) continue;
                    v0 = object2;
                    break block6;
                }
                v0 = null;
            }
            GithubServerPath githubServerPath = v0;
            if (githubServerPath != null) {
                Object server = object = githubServerPath;
                boolean bl = false;
                if (GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(url) != null) {
                    Object object2;
                    it = object2;
                    boolean bl3 = false;
                    Object object3 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"it");
                    githubRepositoryPath2 = new GithubRepositoryPath((GithubServerPath)server, (GithubFullPath)object3);
                } else {
                    githubRepositoryPath2 = null;
                }
            } else {
                githubRepositoryPath2 = null;
            }
            if (githubRepositoryPath2 == null) continue;
            GithubRepositoryPath it$iv$iv = githubRepositoryPath = githubRepositoryPath2;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<GitRemoteUrlCoordinates> getPossibleRemoteUrlCoordinates(@NotNull Project project) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Project $receiver$iv2 = project;
        boolean $i$f$service = false;
        Object object = ServiceManager.getService((Project)$receiver$iv2, GitRepositoryManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(this, T::class.java)");
        List list2 = ((GitRepositoryManager)object).getRepositories();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"project.service<GitRepos\u2026ryManager>().repositories");
        List repositories = list2;
        if (repositories.isEmpty()) {
            return SetsKt.emptySet();
        }
        Set<GithubServerPath> knownServers = this.getKnownGithubServers();
        Iterable iterable = $receiver$iv = (Iterable)repositories;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            void $receiver$iv$iv2;
            Iterable $receiver$iv3;
            GitRepository repo = (GitRepository)element$iv$iv;
            boolean bl = false;
            GitRepository gitRepository = repo;
            Intrinsics.checkExpressionValueIsNotNull((Object)gitRepository, (String)"repo");
            Collection collection = gitRepository.getRemotes();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"repo.remotes");
            Iterable iterable2 = $receiver$iv3 = (Iterable)collection;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv2) {
                void $receiver$iv$iv3;
                Iterable $receiver$iv4;
                GitRemote remote = (GitRemote)element$iv$iv2;
                boolean bl2 = false;
                GitRemote gitRemote = remote;
                Intrinsics.checkExpressionValueIsNotNull((Object)gitRemote, (String)"remote");
                List list3 = gitRemote.getUrls();
                Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"remote.urls");
                Iterable iterable3 = $receiver$iv4 = (Iterable)list3;
                Collection destination$iv$iv3 = new ArrayList();
                void $receiver$iv$iv$iv = $receiver$iv$iv3;
                Iterator iterator = $receiver$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    GitRemoteUrlCoordinates gitRemoteUrlCoordinates;
                    GitRemoteUrlCoordinates gitRemoteUrlCoordinates2;
                    boolean bl3;
                    String url;
                    block9: {
                        Object element$iv$iv$iv;
                        Object element$iv$iv3 = element$iv$iv$iv = iterator.next();
                        url = (String)element$iv$iv3;
                        boolean bl4 = false;
                        Iterable $receiver$iv5 = knownServers;
                        if ($receiver$iv5 instanceof Collection && ((Collection)$receiver$iv5).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv : $receiver$iv5) {
                                GithubServerPath it = (GithubServerPath)element$iv;
                                boolean bl5 = false;
                                if (!it.matches(url)) continue;
                                bl3 = true;
                                break block9;
                            }
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        String string = url;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url");
                        gitRemoteUrlCoordinates2 = new GitRemoteUrlCoordinates(string, remote, repo);
                    } else {
                        gitRemoteUrlCoordinates2 = null;
                    }
                    if (gitRemoteUrlCoordinates2 == null) continue;
                    GitRemoteUrlCoordinates it$iv$iv = gitRemoteUrlCoordinates = gitRemoteUrlCoordinates2;
                    destination$iv$iv3.add(it$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv3;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public final boolean havePossibleRemotes(@NotNull Project project) {
        boolean bl;
        block12: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Project $receiver$iv = project;
            boolean $i$f$service = false;
            Object object = ServiceManager.getService((Project)$receiver$iv, GitRepositoryManager.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(this, T::class.java)");
            List list2 = ((GitRepositoryManager)object).getRepositories();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"project.service<GitRepos\u2026ryManager>().repositories");
            List repositories = list2;
            if (repositories.isEmpty()) {
                return false;
            }
            Set<GithubServerPath> knownServers = this.getKnownGithubServers();
            Iterable $receiver$iv2 = repositories;
            if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv2) {
                    boolean bl2;
                    block11: {
                        GitRepository repo = (GitRepository)element$iv;
                        boolean bl3 = false;
                        GitRepository gitRepository = repo;
                        Intrinsics.checkExpressionValueIsNotNull((Object)gitRepository, (String)"repo");
                        Iterable $receiver$iv3 = this.getRemoteUrls(gitRepository);
                        if ($receiver$iv3 instanceof Collection && ((Collection)$receiver$iv3).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $receiver$iv3) {
                                boolean bl4;
                                block10: {
                                    String url = (String)element$iv2;
                                    boolean bl5 = false;
                                    Iterable $receiver$iv4 = knownServers;
                                    if ($receiver$iv4 instanceof Collection && ((Collection)$receiver$iv4).isEmpty()) {
                                        bl4 = false;
                                    } else {
                                        for (Object element$iv3 : $receiver$iv4) {
                                            GithubServerPath it = (GithubServerPath)element$iv3;
                                            boolean bl6 = false;
                                            if (!it.matches(url)) continue;
                                            bl4 = true;
                                            break block10;
                                        }
                                        bl4 = false;
                                    }
                                }
                                if (!bl4) continue;
                                bl2 = true;
                                break block11;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<GithubServerPath> getKnownGithubServers() {
        Set registeredServers = SetsKt.mutableSetOf((Object[])new GithubServerPath[]{GithubServerPath.DEFAULT_SERVER});
        GithubServerPath githubServerPath = this.migrationHelper.getOldServer$intellij_vcs_github();
        if (githubServerPath != null) {
            GithubServerPath githubServerPath2;
            GithubServerPath p1 = githubServerPath2 = githubServerPath;
            boolean bl = false;
            registeredServers.add(p1);
        }
        Iterable $receiver$iv = this.authenticationManager.getAccounts();
        for (Object item$iv : $receiver$iv) {
            void it;
            GithubAccount githubAccount = (GithubAccount)item$iv;
            Collection collection = registeredServers;
            boolean bl = false;
            GithubServerPath githubServerPath3 = it.getServer();
            collection.add(githubServerPath3);
        }
        return registeredServers;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getRemoteUrls(@NotNull GitRepository $receiver) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Collection collection = $receiver.getRemotes();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"remotes");
        Iterable iterable = $receiver$iv = (Iterable)collection;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            GitRemote gitRemote = (GitRemote)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            List list2 = v1.getUrls();
            collection2.add(list2);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    public GithubGitHelper(@NotNull GithubSettings githubSettings, @NotNull GithubAuthenticationManager authenticationManager, @NotNull GithubAccountsMigrationHelper migrationHelper) {
        Intrinsics.checkParameterIsNotNull((Object)githubSettings, (String)"githubSettings");
        Intrinsics.checkParameterIsNotNull((Object)authenticationManager, (String)"authenticationManager");
        Intrinsics.checkParameterIsNotNull((Object)migrationHelper, (String)"migrationHelper");
        this.githubSettings = githubSettings;
        this.authenticationManager = authenticationManager;
        this.migrationHelper = migrationHelper;
    }

    @JvmStatic
    @Nullable
    public static final GitRepository findGitRepository(@NotNull Project project, @Nullable VirtualFile file) {
        return Companion.findGitRepository(project, file);
    }

    @JvmStatic
    @NotNull
    public static final GithubGitHelper getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\b\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/util/GithubGitHelper$Companion;", "", "()V", "findGitRepository", "Lgit4idea/repo/GitRepository;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getInstance", "Lorg/jetbrains/plugins/github/util/GithubGitHelper;", "intellij.vcs.github"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final GitRepository findGitRepository(@NotNull Project project, @Nullable VirtualFile file) {
            GitRepository repository;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)gitRepositoryManager, (String)"GitUtil.getRepositoryManager(project)");
            GitRepositoryManager manager = gitRepositoryManager;
            List list2 = manager.getRepositories();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"manager.repositories");
            List repositories = list2;
            if (repositories.size() == 0) {
                return null;
            }
            if (repositories.size() == 1) {
                return (GitRepository)repositories.get(0);
            }
            if (file != null && (repository = (GitRepository)manager.getRepositoryForFileQuick(file)) != null) {
                return repository;
            }
            return (GitRepository)manager.getRepositoryForFileQuick(project.getBaseDir());
        }

        @JvmStatic
        @Nullable
        public static /* synthetic */ GitRepository findGitRepository$default(Companion companion, Project project, VirtualFile virtualFile, int n, Object object) {
            if ((n & 2) != 0) {
                virtualFile = null;
            }
            return companion.findGitRepository(project, virtualFile);
        }

        @JvmStatic
        @NotNull
        public final GithubGitHelper getInstance() {
            boolean $i$f$service = false;
            Object object = ServiceManager.getService(GithubGitHelper.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
            return (GithubGitHelper)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

