/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.ui.frame.ProgressStripe;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GithubIssueState;
import org.jetbrains.plugins.github.api.data.GithubPullRequestDetailedWithHtml;
import org.jetbrains.plugins.github.pullrequest.avatars.CachingGithubAvatarIconsProvider;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestsBusyStateTracker;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestsDataLoader;
import org.jetbrains.plugins.github.pullrequest.data.service.GithubPullRequestsMetadataService;
import org.jetbrains.plugins.github.pullrequest.data.service.GithubPullRequestsSecurityService;
import org.jetbrains.plugins.github.pullrequest.data.service.GithubPullRequestsStateService;
import org.jetbrains.plugins.github.pullrequest.ui.GithubDataLoadingComponent;
import org.jetbrains.plugins.github.pullrequest.ui.details.GithubPullRequestDetailsModel;
import org.jetbrains.plugins.github.pullrequest.ui.details.GithubPullRequestDetailsPanel;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 %2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001%B5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u0002H\u0014J\b\u0010 \u001a\u00020\u001aH\u0014J\u0010\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#H\u0014J\b\u0010$\u001a\u00020\u001aH\u0016R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestDetailsComponent;", "Lorg/jetbrains/plugins/github/pullrequest/ui/GithubDataLoadingComponent;", "Lorg/jetbrains/plugins/github/api/data/GithubPullRequestDetailedWithHtml;", "Lcom/intellij/openapi/Disposable;", "dataLoader", "Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsDataLoader;", "securityService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GithubPullRequestsSecurityService;", "busyStateTracker", "Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsBusyStateTracker;", "metadataService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GithubPullRequestsMetadataService;", "stateService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GithubPullRequestsStateService;", "iconProviderFactory", "Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider$Factory;", "(Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsDataLoader;Lorg/jetbrains/plugins/github/pullrequest/data/service/GithubPullRequestsSecurityService;Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestsBusyStateTracker;Lorg/jetbrains/plugins/github/pullrequest/data/service/GithubPullRequestsMetadataService;Lorg/jetbrains/plugins/github/pullrequest/data/service/GithubPullRequestsStateService;Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider$Factory;)V", "backgroundLoadingPanel", "Lcom/intellij/vcs/log/ui/frame/ProgressStripe;", "detailsModel", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GithubPullRequestDetailsModel;", "detailsPanel", "Lorg/jetbrains/plugins/github/pullrequest/ui/details/GithubPullRequestDetailsPanel;", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "dispose", "", "handleError", "error", "", "handleResult", "result", "reset", "setBusy", "busy", "", "updateUI", "Companion", "intellij.vcs.github"})
public final class GithubPullRequestDetailsComponent
extends GithubDataLoadingComponent<GithubPullRequestDetailedWithHtml>
implements Disposable {
    private final GithubPullRequestDetailsModel detailsModel;
    private final GithubPullRequestDetailsPanel detailsPanel;
    private final JBLoadingPanel loadingPanel;
    private final ProgressStripe backgroundLoadingPanel;
    private final GithubPullRequestsDataLoader dataLoader;
    private static final String DEFAULT_EMPTY_TEXT = "Select pull request to view details";
    public static final Companion Companion = new Companion(null);

    @Override
    protected void reset() {
        this.detailsPanel.getEmptyText().setText(DEFAULT_EMPTY_TEXT);
        this.detailsModel.setDetails(null);
    }

    @Override
    protected void handleResult(@NotNull GithubPullRequestDetailedWithHtml result) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        this.detailsModel.setDetails(result);
        if (!result.getMerged() && result.getState() == GithubIssueState.open && result.getMergeable() == null) {
            ApplicationManager.getApplication().invokeLater(new Runnable(this, result){
                final /* synthetic */ GithubPullRequestDetailsComponent this$0;
                final /* synthetic */ GithubPullRequestDetailedWithHtml $result;

                public final void run() {
                    GithubPullRequestDetailsComponent.access$getDataLoader$p(this.this$0).reloadDetails(this.$result.getNumber());
                }
                {
                    this.this$0 = githubPullRequestDetailsComponent;
                    this.$result = githubPullRequestDetailedWithHtml;
                }
            });
        }
        this.validate();
        this.repaint();
    }

    @Override
    protected void handleError(@NotNull Throwable error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        StatusText statusText = this.detailsPanel.getEmptyText().clear().appendText("Can't load details", SimpleTextAttributes.ERROR_ATTRIBUTES);
        String string = error.getMessage();
        if (string == null) {
            string = "Unknown error";
        }
        statusText.appendSecondaryText(string, SimpleTextAttributes.ERROR_ATTRIBUTES, null);
    }

    @Override
    protected void setBusy(boolean busy) {
        if (busy) {
            if (this.detailsModel.getDetails() == null) {
                this.detailsPanel.getEmptyText().clear();
                this.loadingPanel.startLoading();
            } else {
                this.backgroundLoadingPanel.startLoading();
            }
        } else {
            this.loadingPanel.stopLoading();
            this.backgroundLoadingPanel.stopLoading();
        }
    }

    public void updateUI() {
        super.updateUI();
        this.setBackground(UIUtil.getListBackground());
    }

    public void dispose() {
    }

    public GithubPullRequestDetailsComponent(@NotNull GithubPullRequestsDataLoader dataLoader, @NotNull GithubPullRequestsSecurityService securityService, @NotNull GithubPullRequestsBusyStateTracker busyStateTracker, @NotNull GithubPullRequestsMetadataService metadataService, @NotNull GithubPullRequestsStateService stateService, @NotNull CachingGithubAvatarIconsProvider.Factory iconProviderFactory) {
        JBLoadingPanel jBLoadingPanel;
        Intrinsics.checkParameterIsNotNull((Object)dataLoader, (String)"dataLoader");
        Intrinsics.checkParameterIsNotNull((Object)securityService, (String)"securityService");
        Intrinsics.checkParameterIsNotNull((Object)busyStateTracker, (String)"busyStateTracker");
        Intrinsics.checkParameterIsNotNull((Object)metadataService, (String)"metadataService");
        Intrinsics.checkParameterIsNotNull((Object)stateService, (String)"stateService");
        Intrinsics.checkParameterIsNotNull((Object)iconProviderFactory, (String)"iconProviderFactory");
        this.dataLoader = dataLoader;
        this.detailsModel = new GithubPullRequestDetailsModel();
        this.detailsPanel = new GithubPullRequestDetailsPanel(this.detailsModel, securityService, busyStateTracker, metadataService, stateService, iconProviderFactory);
        JBLoadingPanel jBLoadingPanel2 = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 300);
        GithubPullRequestDetailsComponent githubPullRequestDetailsComponent = this;
        JBLoadingPanel $receiver = jBLoadingPanel2;
        boolean bl = false;
        $receiver.setOpaque(false);
        githubPullRequestDetailsComponent.loadingPanel = jBLoadingPanel = jBLoadingPanel2;
        jBLoadingPanel2 = new ProgressStripe((JComponent)this.loadingPanel, (Disposable)this, 300);
        githubPullRequestDetailsComponent = this;
        $receiver = jBLoadingPanel2;
        boolean bl2 = false;
        $receiver.setOpaque(false);
        jBLoadingPanel = jBLoadingPanel2;
        githubPullRequestDetailsComponent.backgroundLoadingPanel = jBLoadingPanel;
        this.setOpaque(true);
        this.detailsPanel.getEmptyText().setText(DEFAULT_EMPTY_TEXT);
        this.loadingPanel.add((Component)this.detailsPanel);
        this.setContent((JComponent)this.backgroundLoadingPanel);
        Disposer.register((Disposable)this, (Disposable)this.detailsPanel);
        this.detailsModel.setDetails(null);
    }

    public static final /* synthetic */ GithubPullRequestsDataLoader access$getDataLoader$p(GithubPullRequestDetailsComponent $this) {
        return $this.dataLoader;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GithubPullRequestDetailsComponent$Companion;", "", "()V", "DEFAULT_EMPTY_TEXT", "", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

