/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import git4idea.GitCommit;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.history.GitLogUtil;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubPullRequest;
import org.jetbrains.plugins.github.api.data.GithubPullRequestDetailedWithHtml;
import org.jetbrains.plugins.github.pullrequest.data.GithubPullRequestDataProvider;
import org.jetbrains.plugins.github.util.GithubAsyncUtil;
import org.jetbrains.plugins.github.util.GithubAsyncUtilKt;
import org.jetbrains.plugins.github.util.NonReusableEmptyProgressIndicator;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002BU\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000200H\u0016J\b\u00105\u001a\u000203H\u0016J2\u00106\u001a\u0002032\u0012\u00107\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00190\u00182\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0\u00182\u0006\u00108\u001a\u000209H\u0002J\u0010\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u0012H\u0002J\r\u0010=\u001a\u000203H\u0000\u00a2\u0006\u0002\b>J8\u0010?\u001a\u0002032\u0012\u00107\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(0\u00182\u0012\u0010@\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00190\u00182\u0006\u00108\u001a\u000209H\u0002J\u001e\u0010A\u001a\u0002032\f\u00107\u001a\b\u0012\u0004\u0012\u00020\"0\u00182\u0006\u00108\u001a\u000209H\u0002J\b\u0010B\u001a\u000203H\u0016J\b\u0010C\u001a\u000203H\u0016J\u0010\u0010D\u001a\u0002032\u0006\u00104\u001a\u000200H\u0016J\b\u0010E\u001a\u000203H\u0002J\b\u0010F\u001a\u000203H\u0002J5\u0010G\u001a\u000203\"\u0004\b\u0000\u0010H2\f\u0010I\u001a\b\u0012\u0004\u0012\u0002HH0\u00182\u0006\u00108\u001a\u0002092\u000e\b\u0004\u0010J\u001a\b\u0012\u0004\u0012\u0002HH0KH\u0082\bJ\u001d\u0010L\u001a\u0002HH\"\u0004\b\u0000\u0010H*\b\u0012\u0004\u0012\u0002HH0\u0018H\u0002\u00a2\u0006\u0002\u0010MR&\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00190\u0018X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R7\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0\u00182\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00188V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b&\u0010'\u001a\u0004\b$\u0010\u001b\"\u0004\b%\u0010\u001dR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000RC\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(0\u00182\u0012\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0(0\u00188V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b-\u0010'\u001a\u0004\b+\u0010\u001b\"\u0004\b,\u0010\u001dR\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010.\u001a\u0010\u0012\f\u0012\n 1*\u0004\u0018\u000100000/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestDataProviderImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestDataProvider;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "git", "Lgit4idea/commands/Git;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "repository", "Lgit4idea/repo/GitRepository;", "remote", "Lgit4idea/repo/GitRemote;", "serverPath", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "", "repositoryName", "number", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/progress/ProgressManager;Lgit4idea/commands/Git;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lgit4idea/repo/GitRepository;Lgit4idea/repo/GitRemote;Lorg/jetbrains/plugins/github/api/GithubServerPath;Ljava/lang/String;Ljava/lang/String;J)V", "branchFetchRequest", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/openapi/util/Couple;", "getBranchFetchRequest", "()Ljava/util/concurrent/CompletableFuture;", "setBranchFetchRequest", "(Ljava/util/concurrent/CompletableFuture;)V", "changesLoadingIndicator", "Lorg/jetbrains/plugins/github/util/NonReusableEmptyProgressIndicator;", "detailsLoadingIndicator", "<set-?>", "Lorg/jetbrains/plugins/github/api/data/GithubPullRequestDetailedWithHtml;", "detailsRequest", "getDetailsRequest", "setDetailsRequest", "detailsRequest$delegate", "Lkotlin/properties/ReadWriteProperty;", "", "Lgit4idea/GitCommit;", "logCommitsRequest", "getLogCommitsRequest", "setLogCommitsRequest", "logCommitsRequest$delegate", "requestsChangesEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/plugins/github/pullrequest/data/GithubPullRequestDataProvider$RequestsChangedListener;", "kotlin.jvm.PlatformType", "addRequestsChangesListener", "", "listener", "dispose", "fetchBranch", "result", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "isCommitFetched", "", "commitHash", "load", "load$intellij_vcs_github", "loadCommits", "fetchRequest", "loadDetails", "reloadCommits", "reloadDetails", "removeRequestsChangesListener", "requestCommits", "requestDetails", "runPartialTask", "T", "resultFuture", "task", "Lkotlin/Function0;", "joinCancellable", "(Ljava/util/concurrent/CompletableFuture;)Ljava/lang/Object;", "intellij.vcs.github"})
public final class GithubPullRequestDataProviderImpl
implements GithubPullRequestDataProvider,
Disposable {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private NonReusableEmptyProgressIndicator detailsLoadingIndicator;
    private NonReusableEmptyProgressIndicator changesLoadingIndicator;
    private final EventDispatcher<GithubPullRequestDataProvider.RequestsChangedListener> requestsChangesEventDispatcher;
    @NotNull
    private final ReadWriteProperty detailsRequest$delegate;
    @NotNull
    private CompletableFuture<Couple<String>> branchFetchRequest;
    @NotNull
    private final ReadWriteProperty logCommitsRequest$delegate;
    private final Project project;
    private final ProgressManager progressManager;
    private final Git git;
    private final GithubApiRequestExecutor requestExecutor;
    private final GitRepository repository;
    private final GitRemote remote;
    private final GithubServerPath serverPath;
    private final String username;
    private final String repositoryName;
    private final long number;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(GithubPullRequestDataProviderImpl.class), "detailsRequest", "getDetailsRequest()Ljava/util/concurrent/CompletableFuture;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(GithubPullRequestDataProviderImpl.class), "logCommitsRequest", "getLogCommitsRequest()Ljava/util/concurrent/CompletableFuture;"))};
    }

    @Override
    @NotNull
    public CompletableFuture<GithubPullRequestDetailedWithHtml> getDetailsRequest() {
        return (CompletableFuture)this.detailsRequest$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    public void setDetailsRequest(@NotNull CompletableFuture<GithubPullRequestDetailedWithHtml> completableFuture) {
        Intrinsics.checkParameterIsNotNull(completableFuture, (String)"<set-?>");
        this.detailsRequest$delegate.setValue((Object)this, $$delegatedProperties[0], completableFuture);
    }

    @Override
    @NotNull
    public CompletableFuture<Couple<String>> getBranchFetchRequest() {
        return this.branchFetchRequest;
    }

    public void setBranchFetchRequest(@NotNull CompletableFuture<Couple<String>> completableFuture) {
        Intrinsics.checkParameterIsNotNull(completableFuture, (String)"<set-?>");
        this.branchFetchRequest = completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<List<GitCommit>> getLogCommitsRequest() {
        return (CompletableFuture)this.logCommitsRequest$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    public void setLogCommitsRequest(@NotNull CompletableFuture<List<GitCommit>> completableFuture) {
        Intrinsics.checkParameterIsNotNull(completableFuture, (String)"<set-?>");
        this.logCommitsRequest$delegate.setValue((Object)this, $$delegatedProperties[1], completableFuture);
    }

    public final void load$intellij_vcs_github() {
        this.requestDetails();
        this.requestCommits();
    }

    @Override
    public void reloadDetails() {
        this.requestDetails();
    }

    @Override
    public void reloadCommits() {
        this.requestCommits();
    }

    private final void requestDetails() {
        this.detailsLoadingIndicator.cancel();
        this.detailsLoadingIndicator = new NonReusableEmptyProgressIndicator();
        CompletableFuture<GithubPullRequestDetailedWithHtml> oldDetailsRequest = this.getDetailsRequest();
        CompletableFuture<GithubPullRequestDetailedWithHtml> newDetailsRequest = new CompletableFuture<GithubPullRequestDetailedWithHtml>();
        GithubAsyncUtilKt.handleOnEdt(newDetailsRequest, (Function2)new Function2<GithubPullRequestDetailedWithHtml, Throwable, Unit>(this, oldDetailsRequest){
            final /* synthetic */ GithubPullRequestDataProviderImpl this$0;
            final /* synthetic */ CompletableFuture $oldDetailsRequest;

            public final void invoke(@Nullable GithubPullRequestDetailedWithHtml details, @Nullable Throwable $noName_1) {
                block6: {
                    block7: {
                        GithubPullRequestDetailedWithHtml githubPullRequestDetailedWithHtml;
                        if (details == null) {
                            return;
                        }
                        if (!this.$oldDetailsRequest.isDone()) break block6;
                        try {
                            githubPullRequestDetailedWithHtml = (GithubPullRequestDetailedWithHtml)GithubPullRequestDataProviderImpl.access$joinCancellable(this.this$0, this.$oldDetailsRequest);
                        }
                        catch (Exception e) {
                            githubPullRequestDetailedWithHtml = null;
                        }
                        GithubPullRequestDetailedWithHtml oldDetails = githubPullRequestDetailedWithHtml;
                        if (oldDetails == null) break block7;
                        GithubPullRequest.Tag tag = oldDetails.getBase();
                        Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"oldDetails.base");
                        String string = tag.getSha();
                        GithubPullRequest.Tag tag2 = details.getBase();
                        Intrinsics.checkExpressionValueIsNotNull((Object)tag2, (String)"details.base");
                        if (Intrinsics.areEqual((Object)string, (Object)tag2.getSha()) ^ true) break block7;
                        GithubPullRequest.Tag tag3 = oldDetails.getHead();
                        Intrinsics.checkExpressionValueIsNotNull((Object)tag3, (String)"oldDetails.head");
                        String string2 = tag3.getSha();
                        GithubPullRequest.Tag tag4 = details.getHead();
                        Intrinsics.checkExpressionValueIsNotNull((Object)tag4, (String)"details.head");
                        if (!(Intrinsics.areEqual((Object)string2, (Object)tag4.getSha()) ^ true)) break block6;
                    }
                    this.this$0.reloadCommits();
                }
            }
            {
                this.this$0 = githubPullRequestDataProviderImpl;
                this.$oldDetailsRequest = completableFuture;
                super(2);
            }
        });
        this.progressManager.runProcessWithProgressAsynchronously(new Task.Backgroundable(this, newDetailsRequest, this.project, "Load Pull Request Details", true){
            final /* synthetic */ GithubPullRequestDataProviderImpl this$0;
            final /* synthetic */ CompletableFuture $newDetailsRequest;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                GithubPullRequestDataProviderImpl.access$loadDetails(this.this$0, this.$newDetailsRequest, indicator);
            }
            {
                this.this$0 = $outer;
                this.$newDetailsRequest = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        }, (ProgressIndicator)this.detailsLoadingIndicator);
        this.setDetailsRequest(newDetailsRequest);
    }

    private final void requestCommits() {
        this.changesLoadingIndicator.cancel();
        this.changesLoadingIndicator = new NonReusableEmptyProgressIndicator();
        CompletableFuture<GithubPullRequestDetailedWithHtml> detailsRequest = this.getDetailsRequest();
        CompletableFuture<Couple<String>> newBranchFetchRequest = new CompletableFuture<Couple<String>>();
        CompletableFuture<List<GitCommit>> newLogCommitsRequest = new CompletableFuture<List<GitCommit>>();
        this.progressManager.runProcessWithProgressAsynchronously(new Task.Backgroundable(this, newBranchFetchRequest, detailsRequest, newLogCommitsRequest, this.project, "Load Pull Request Changes", true){
            final /* synthetic */ GithubPullRequestDataProviderImpl this$0;
            final /* synthetic */ CompletableFuture $newBranchFetchRequest;
            final /* synthetic */ CompletableFuture $detailsRequest;
            final /* synthetic */ CompletableFuture $newLogCommitsRequest;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                GithubPullRequestDataProviderImpl.access$fetchBranch(this.this$0, this.$newBranchFetchRequest, this.$detailsRequest, indicator);
                GithubPullRequestDataProviderImpl.access$loadCommits(this.this$0, this.$newLogCommitsRequest, this.$newBranchFetchRequest, indicator);
            }
            {
                this.this$0 = $outer;
                this.$newBranchFetchRequest = $captured_local_variable$1;
                this.$detailsRequest = $captured_local_variable$2;
                this.$newLogCommitsRequest = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        }, (ProgressIndicator)this.changesLoadingIndicator);
        this.setBranchFetchRequest(newBranchFetchRequest);
        this.setLogCommitsRequest(newLogCommitsRequest);
    }

    public void dispose() {
        this.detailsLoadingIndicator.cancel();
        this.changesLoadingIndicator.cancel();
    }

    private final void loadDetails(CompletableFuture<GithubPullRequestDetailedWithHtml> result, ProgressIndicator indicator) {
        GithubPullRequestDataProviderImpl this_$iv = this;
        boolean $i$f$runPartialTask = false;
        try {
            if (!result.isCancelled()) {
                indicator.checkCanceled();
                boolean bl = false;
                GithubPullRequestDetailedWithHtml result$iv = this.requestExecutor.execute(indicator, GithubApiRequests.Repos.PullRequests.getHtml(this.serverPath, this.username, this.repositoryName, this.number));
                result.complete(result$iv);
            }
        }
        catch (ProcessCanceledException pce$iv) {
            result.cancel(true);
        }
        catch (Exception e$iv) {
            result.completeExceptionally(e$iv);
        }
    }

    private final void fetchBranch(CompletableFuture<Couple<String>> result, CompletableFuture<GithubPullRequestDetailedWithHtml> detailsRequest, ProgressIndicator indicator) {
        GithubPullRequestDataProviderImpl this_$iv = this;
        boolean $i$f$runPartialTask = false;
        try {
            if (!result.isCancelled()) {
                indicator.checkCanceled();
                boolean bl = false;
                GithubPullRequestDetailedWithHtml details = (GithubPullRequestDetailedWithHtml)this.joinCancellable(detailsRequest);
                this.git.fetch(this.repository, this.remote, CollectionsKt.emptyList(), new String[]{"refs/pull/" + details.getNumber() + "/head:"}).throwOnError(new int[0]);
                GithubPullRequest.Tag tag = details.getBase();
                Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"details.base");
                String string = tag.getSha();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"details.base.sha");
                if (!this.isCommitFetched(string)) {
                    throw (Throwable)new IllegalStateException("Pull request base is not available after fetch");
                }
                GithubPullRequest.Tag tag2 = details.getHead();
                Intrinsics.checkExpressionValueIsNotNull((Object)tag2, (String)"details.head");
                String string2 = tag2.getSha();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"details.head.sha");
                if (!this.isCommitFetched(string2)) {
                    throw (Throwable)new IllegalStateException("Pull request head is not available after fetch");
                }
                GithubPullRequest.Tag tag3 = details.getBase();
                Intrinsics.checkExpressionValueIsNotNull((Object)tag3, (String)"details.base");
                String string3 = tag3.getSha();
                GithubPullRequest.Tag tag4 = details.getHead();
                Intrinsics.checkExpressionValueIsNotNull((Object)tag4, (String)"details.head");
                Couple couple = Couple.of((Object)string3, (Object)tag4.getSha());
                Intrinsics.checkExpressionValueIsNotNull((Object)couple, (String)"Couple.of(details.base.sha, details.head.sha)");
                Couple result$iv = couple;
                result.complete((Couple<String>)result$iv);
            }
        }
        catch (ProcessCanceledException pce$iv) {
            result.cancel(true);
        }
        catch (Exception e$iv) {
            result.completeExceptionally(e$iv);
        }
    }

    private final boolean isCommitFetched(String commitHash) {
        GitCommandResult gitCommandResult = this.git.getObjectType(this.repository, commitHash);
        Intrinsics.checkExpressionValueIsNotNull((Object)gitCommandResult, (String)"git.getObjectType(repository, commitHash)");
        GitCommandResult result = gitCommandResult;
        return result.success() && Intrinsics.areEqual((Object)result.getOutputAsJoinedString(), (Object)"commit");
    }

    private final void loadCommits(CompletableFuture<List<GitCommit>> result, CompletableFuture<Couple<String>> fetchRequest, ProgressIndicator indicator) {
        GithubPullRequestDataProviderImpl this_$iv = this;
        boolean $i$f$runPartialTask = false;
        try {
            if (!result.isCancelled()) {
                indicator.checkCanceled();
                boolean bl = false;
                Couple hashes = (Couple)this.joinCancellable(fetchRequest);
                List list2 = GitLogUtil.collectFullDetails((Project)this.project, (VirtualFile)this.repository.getRoot(), (String[])new String[]{(String)hashes.first + ".." + (String)hashes.second});
                Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"GitLogUtil.collectFullDe\u2026irst}..${hashes.second}\")");
                List result$iv = list2;
                result.complete(result$iv);
            }
        }
        catch (ProcessCanceledException pce$iv) {
            result.cancel(true);
        }
        catch (Exception e$iv) {
            result.completeExceptionally(e$iv);
        }
    }

    private final <T> T joinCancellable(@NotNull CompletableFuture<T> $receiver) throws ProcessCanceledException {
        try {
            return $receiver.join();
        }
        catch (CancellationException e) {
            throw (Throwable)new ProcessCanceledException((Throwable)e);
        }
        catch (CompletionException e) {
            if (GithubAsyncUtil.INSTANCE.isCancellation(e)) {
                throw (Throwable)new ProcessCanceledException((Throwable)e);
            }
            Throwable throwable = e.getCause();
            if (throwable == null) {
                throwable = e;
            }
            throw throwable;
        }
    }

    private final <T> void runPartialTask(CompletableFuture<T> resultFuture, ProgressIndicator indicator, Function0<? extends T> task) {
        int $i$f$runPartialTask = 0;
        try {
            if (resultFuture.isCancelled()) {
                return;
            }
            indicator.checkCanceled();
            Object result = task.invoke();
            resultFuture.complete(result);
        }
        catch (ProcessCanceledException pce) {
            resultFuture.cancel(true);
        }
        catch (Exception e) {
            resultFuture.completeExceptionally(e);
        }
    }

    @Override
    public void addRequestsChangesListener(@NotNull GithubPullRequestDataProvider.RequestsChangedListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.requestsChangesEventDispatcher.addListener((EventListener)listener);
    }

    @Override
    public void removeRequestsChangesListener(@NotNull GithubPullRequestDataProvider.RequestsChangedListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.requestsChangesEventDispatcher.removeListener((EventListener)listener);
    }

    public GithubPullRequestDataProviderImpl(@NotNull Project project, @NotNull ProgressManager progressManager, @NotNull Git git, @NotNull GithubApiRequestExecutor requestExecutor, @NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull GithubServerPath serverPath, @NotNull String username, @NotNull String repositoryName, long number) {
        CompletableFuture initialValue$iv;
        ReadWriteProperty readWriteProperty;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)progressManager, (String)"progressManager");
        Intrinsics.checkParameterIsNotNull((Object)git, (String)"git");
        Intrinsics.checkParameterIsNotNull((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull((Object)remote, (String)"remote");
        Intrinsics.checkParameterIsNotNull((Object)serverPath, (String)"serverPath");
        Intrinsics.checkParameterIsNotNull((Object)username, (String)"username");
        Intrinsics.checkParameterIsNotNull((Object)repositoryName, (String)"repositoryName");
        this.project = project;
        this.progressManager = progressManager;
        this.git = git;
        this.requestExecutor = requestExecutor;
        this.repository = repository;
        this.remote = remote;
        this.serverPath = serverPath;
        this.username = username;
        this.repositoryName = repositoryName;
        this.number = number;
        this.detailsLoadingIndicator = new NonReusableEmptyProgressIndicator();
        this.changesLoadingIndicator = new NonReusableEmptyProgressIndicator();
        EventDispatcher eventDispatcher = EventDispatcher.create(GithubPullRequestDataProvider.RequestsChangedListener.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)eventDispatcher, (String)"EventDispatcher.create(G\u2026ngedListener::class.java)");
        this.requestsChangesEventDispatcher = eventDispatcher;
        Delegates delegates = Delegates.INSTANCE;
        CompletableFuture completableFuture = new CompletableFuture();
        GithubPullRequestDataProviderImpl githubPullRequestDataProviderImpl = this;
        githubPullRequestDataProviderImpl.detailsRequest$delegate = readWriteProperty = (ReadWriteProperty)new ObservableProperty<CompletableFuture<GithubPullRequestDetailedWithHtml>>((Object)initialValue$iv, (Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ GithubPullRequestDataProviderImpl this$0;
            {
                this.$initialValue = $captured_local_variable$1;
                this.this$0 = githubPullRequestDataProviderImpl;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
                CompletableFuture completableFuture = (CompletableFuture)newValue;
                CompletableFuture completableFuture2 = (CompletableFuture)oldValue;
                KProperty $noName_0 = property;
                boolean bl = false;
                ((GithubPullRequestDataProvider.RequestsChangedListener)GithubPullRequestDataProviderImpl.access$getRequestsChangesEventDispatcher$p(this.this$0).getMulticaster()).detailsRequestChanged();
            }
        };
        this.branchFetchRequest = new CompletableFuture();
        Delegates this_$iv = Delegates.INSTANCE;
        initialValue$iv = new CompletableFuture();
        githubPullRequestDataProviderImpl = this;
        githubPullRequestDataProviderImpl.logCommitsRequest$delegate = readWriteProperty = (ReadWriteProperty)new ObservableProperty<CompletableFuture<List<? extends GitCommit>>>(initialValue$iv, initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ GithubPullRequestDataProviderImpl this$0;
            {
                this.$initialValue = $captured_local_variable$1;
                this.this$0 = githubPullRequestDataProviderImpl;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
                CompletableFuture completableFuture = (CompletableFuture)newValue;
                CompletableFuture completableFuture2 = (CompletableFuture)oldValue;
                KProperty $noName_0 = property;
                boolean bl = false;
                ((GithubPullRequestDataProvider.RequestsChangedListener)GithubPullRequestDataProviderImpl.access$getRequestsChangesEventDispatcher$p(this.this$0).getMulticaster()).commitsRequestChanged();
            }
        };
    }

    public static final /* synthetic */ void access$loadDetails(GithubPullRequestDataProviderImpl $this, CompletableFuture result, ProgressIndicator indicator) {
        $this.loadDetails(result, indicator);
    }

    public static final /* synthetic */ void access$fetchBranch(GithubPullRequestDataProviderImpl $this, CompletableFuture result, CompletableFuture detailsRequest, ProgressIndicator indicator) {
        $this.fetchBranch(result, detailsRequest, indicator);
    }

    public static final /* synthetic */ void access$loadCommits(GithubPullRequestDataProviderImpl $this, CompletableFuture result, CompletableFuture fetchRequest, ProgressIndicator indicator) {
        $this.loadCommits(result, fetchRequest, indicator);
    }

    public static final /* synthetic */ EventDispatcher access$getRequestsChangesEventDispatcher$p(GithubPullRequestDataProviderImpl $this) {
        return $this.requestsChangesEventDispatcher;
    }
}

