/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.AuthData;
import git4idea.remote.GitHttpAuthDataProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorManager;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountInformationProvider;
import org.jetbrains.plugins.github.extensions.GithubAccountGitAuthenticationFailureManager;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0012H\u0016J&\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u0012R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/github/extensions/GithubHttpAuthDataProvider;", "Lgit4idea/remote/GitHttpAuthDataProvider;", "authenticationManager", "Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;", "requestExecutorFactory", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "requestExecutorManager", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutorManager;", "accountInformationProvider", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountInformationProvider;", "(Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutorManager;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountInformationProvider;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "forgetPassword", "", "project", "Lcom/intellij/openapi/project/Project;", "url", "", "authData", "Lcom/intellij/util/AuthData;", "getAuthData", "Lorg/jetbrains/plugins/github/extensions/GithubHttpAuthDataProvider$GithubAccountAuthData;", "login", "getSuitableAccounts", "", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "GithubAccountAuthData", "intellij.vcs.github"})
public final class GithubHttpAuthDataProvider
implements GitHttpAuthDataProvider {
    private final Logger LOG;
    private final GithubAuthenticationManager authenticationManager;
    private final GithubApiRequestExecutor.Factory requestExecutorFactory;
    private final GithubApiRequestExecutorManager requestExecutorManager;
    private final GithubAccountInformationProvider accountInformationProvider;

    @Nullable
    public GithubAccountAuthData getAuthData(@NotNull Project project, @NotNull String url) {
        GithubAccountAuthData githubAccountAuthData;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        GithubAccount githubAccount = (GithubAccount)CollectionsKt.singleOrNull((Iterable)this.getSuitableAccounts(project, url, null));
        if (githubAccount != null) {
            GithubAccountAuthData githubAccountAuthData2;
            GithubAccount githubAccount2;
            GithubAccount account = githubAccount2 = githubAccount;
            boolean bl = false;
            try {
                String string = this.authenticationManager.getTokenForAccount$intellij_vcs_github(account);
                if (string == null) {
                    return null;
                }
                String token2 = string;
                String string2 = this.accountInformationProvider.getInformation(this.requestExecutorFactory.create(token2), (ProgressIndicator)new DumbProgressIndicator(), account).getLogin();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"accountInformationProvid\u2026           account).login");
                String username = string2;
                githubAccountAuthData2 = new GithubAccountAuthData(account, username, token2);
            }
            catch (IOException e) {
                this.LOG.info("Cannot load username for " + account, (Throwable)e);
                githubAccountAuthData2 = null;
            }
            githubAccountAuthData = githubAccountAuthData2;
        } else {
            githubAccountAuthData = null;
        }
        return githubAccountAuthData;
    }

    @Nullable
    public GithubAccountAuthData getAuthData(@NotNull Project project, @NotNull String url, @NotNull String login2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)login2, (String)"login");
        GithubAccount githubAccount = (GithubAccount)CollectionsKt.singleOrNull((Iterable)this.getSuitableAccounts(project, url, login2));
        if (githubAccount != null) {
            GithubAccountAuthData githubAccountAuthData;
            GithubAccount githubAccount2;
            GithubAccount account = githubAccount2 = githubAccount;
            boolean bl = false;
            String string = this.authenticationManager.getTokenForAccount$intellij_vcs_github(account);
            if (string != null) {
                String string2;
                String it = string2 = string;
                boolean bl2 = false;
                githubAccountAuthData = new GithubAccountAuthData(account, login2, it);
            } else {
                githubAccountAuthData = null;
            }
            return githubAccountAuthData;
        }
        return null;
    }

    public void forgetPassword(@NotNull Project project, @NotNull String url, @NotNull AuthData authData) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)authData, (String)"authData");
        if (authData instanceof GithubAccountAuthData) {
            Project $receiver$iv = project;
            boolean $i$f$service = false;
            Object object = ServiceManager.getService((Project)$receiver$iv, GithubAccountGitAuthenticationFailureManager.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(this, T::class.java)");
            ((GithubAccountGitAuthenticationFailureManager)object).ignoreAccount(url, ((GithubAccountAuthData)authData).getAccount());
        }
    }

    @NotNull
    public final Set<GithubAccount> getSuitableAccounts(@NotNull Project project, @NotNull String url, @Nullable String login2) {
        GithubAccount defaultAccount;
        GithubAccount it;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Project $receiver$iv2 = project;
        boolean $i$f$service22 = false;
        Object object = ServiceManager.getService((Project)$receiver$iv2, GithubAccountGitAuthenticationFailureManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(this, T::class.java)");
        GithubAccountGitAuthenticationFailureManager authenticationFailureManager = (GithubAccountGitAuthenticationFailureManager)object;
        Iterable $i$f$service22 = this.authenticationManager.getAccounts();
        void var7_8 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (GithubAccount)element$iv$iv;
            boolean bl = false;
            if (!it.getServer().matches(url)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (GithubAccount)element$iv$iv;
            boolean bl = false;
            if (!(!authenticationFailureManager.isAccountIgnored(url, it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List potentialAccounts = (List)destination$iv$iv;
        if (login2 != null) {
            $receiver$iv$iv = $receiver$iv = (Iterable)potentialAccounts;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                boolean bl;
                it = (GithubAccount)element$iv$iv;
                boolean bl2 = false;
                try {
                    bl = Intrinsics.areEqual((Object)this.accountInformationProvider.getInformation(this.requestExecutorManager.getExecutor(it), (ProgressIndicator)new DumbProgressIndicator(), it).getLogin(), (Object)login2);
                }
                catch (IOException e) {
                    this.LOG.info("Cannot load username for " + it, (Throwable)e);
                    bl = false;
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            potentialAccounts = (List)destination$iv$iv;
        }
        if ((defaultAccount = this.authenticationManager.getDefaultAccount(project)) != null && potentialAccounts.contains(defaultAccount)) {
            return SetsKt.setOf((Object)defaultAccount);
        }
        return CollectionsKt.toSet((Iterable)potentialAccounts);
    }

    public GithubHttpAuthDataProvider(@NotNull GithubAuthenticationManager authenticationManager, @NotNull GithubApiRequestExecutor.Factory requestExecutorFactory, @NotNull GithubApiRequestExecutorManager requestExecutorManager, @NotNull GithubAccountInformationProvider accountInformationProvider) {
        Logger logger;
        Intrinsics.checkParameterIsNotNull((Object)authenticationManager, (String)"authenticationManager");
        Intrinsics.checkParameterIsNotNull((Object)requestExecutorFactory, (String)"requestExecutorFactory");
        Intrinsics.checkParameterIsNotNull((Object)requestExecutorManager, (String)"requestExecutorManager");
        Intrinsics.checkParameterIsNotNull((Object)accountInformationProvider, (String)"accountInformationProvider");
        this.authenticationManager = authenticationManager;
        this.requestExecutorFactory = requestExecutorFactory;
        this.requestExecutorManager = requestExecutorManager;
        this.accountInformationProvider = accountInformationProvider;
        GithubHttpAuthDataProvider githubHttpAuthDataProvider = this;
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(GithubHttpAuthDataProvider.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        githubHttpAuthDataProvider.LOG = logger = logger2;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/extensions/GithubHttpAuthDataProvider$GithubAccountAuthData;", "Lcom/intellij/util/AuthData;", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "login", "", "password", "(Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;Ljava/lang/String;Ljava/lang/String;)V", "getAccount", "()Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "intellij.vcs.github"})
    public static final class GithubAccountAuthData
    extends AuthData {
        @NotNull
        private final GithubAccount account;

        @NotNull
        public final GithubAccount getAccount() {
            return this.account;
        }

        public GithubAccountAuthData(@NotNull GithubAccount account, @NotNull String login2, @NotNull String password) {
            Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
            Intrinsics.checkParameterIsNotNull((Object)login2, (String)"login");
            Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
            super(login2, password);
            this.account = account;
        }
    }
}

