/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.accounts;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.authentication.accounts.AccountRemovedListener;
import org.jetbrains.plugins.github.authentication.accounts.AccountState;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManager;
import org.jetbrains.plugins.github.util.GithubNotifications;

@State(name="GithubDefaultAccount", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/authentication/accounts/GithubProjectDefaultAccountHolder;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jetbrains/plugins/github/authentication/accounts/AccountState;", "project", "Lcom/intellij/openapi/project/Project;", "accountManager", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountManager;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountManager;)V", "account", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "getAccount", "()Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "setAccount", "(Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;)V", "findAccountById", "id", "", "getState", "loadState", "", "state", "intellij.vcs.github"})
public final class GithubProjectDefaultAccountHolder
implements PersistentStateComponent<AccountState> {
    @Nullable
    private GithubAccount account;
    private final Project project;
    private final GithubAccountManager accountManager;

    @Nullable
    public final GithubAccount getAccount() {
        return this.account;
    }

    public final void setAccount(@Nullable GithubAccount githubAccount) {
        this.account = githubAccount;
    }

    @NotNull
    public AccountState getState() {
        AccountState accountState;
        AccountState $receiver = accountState = new AccountState();
        boolean bl = false;
        GithubAccount githubAccount = this.account;
        $receiver.setDefaultAccountId(githubAccount != null ? githubAccount.getId() : null);
        return accountState;
    }

    public void loadState(@NotNull AccountState state2) {
        GithubAccount githubAccount;
        Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
        GithubProjectDefaultAccountHolder githubProjectDefaultAccountHolder = this;
        String string = state2.getDefaultAccountId();
        if (string != null) {
            String string2 = string;
            GithubProjectDefaultAccountHolder githubProjectDefaultAccountHolder2 = this;
            GithubProjectDefaultAccountHolder githubProjectDefaultAccountHolder3 = githubProjectDefaultAccountHolder;
            String p1 = string2;
            boolean bl = false;
            GithubAccount githubAccount2 = githubProjectDefaultAccountHolder2.findAccountById(p1);
            githubProjectDefaultAccountHolder = githubProjectDefaultAccountHolder3;
            githubAccount = githubAccount2;
        } else {
            githubAccount = null;
        }
        githubProjectDefaultAccountHolder.account = githubAccount;
    }

    private final GithubAccount findAccountById(String id) {
        Object v0;
        block4: {
            Iterable iterable;
            Iterable iterable2 = iterable = (Iterable)this.accountManager.getAccounts();
            for (Object t : iterable2) {
                GithubAccount it = (GithubAccount)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        GithubAccount account = v0;
        if (account == null) {
            Application app$iv;
            ModalityState modalityState$iv = null;
            boolean $i$f$runInEdt = false;
            Application application = app$iv = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"app");
            if (application.isDispatchThread()) {
                boolean bl = false;
                GithubNotifications.showWarning(this.project, "Missing Default GitHub Account", "", GithubNotifications.getConfigureAction(this.project));
            } else {
                app$iv.invokeLater(new Runnable(this){
                    final /* synthetic */ GithubProjectDefaultAccountHolder this$0;
                    {
                        this.this$0 = githubProjectDefaultAccountHolder;
                    }

                    public final void run() {
                        boolean bl = false;
                        GithubNotifications.showWarning(GithubProjectDefaultAccountHolder.access$getProject$p(this.this$0), "Missing Default GitHub Account", "", GithubNotifications.getConfigureAction(GithubProjectDefaultAccountHolder.access$getProject$p(this.this$0)));
                    }
                }, ModalityState.defaultModalityState());
            }
        }
        return account;
    }

    public GithubProjectDefaultAccountHolder(@NotNull Project project, @NotNull GithubAccountManager accountManager) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)accountManager, (String)"accountManager");
        this.project = project;
        this.accountManager = accountManager;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        application.getMessageBus().connect((Disposable)this.project).subscribe(GithubAccountManager.Companion.getACCOUNT_REMOVED_TOPIC(), (Object)new AccountRemovedListener(){

            @Override
            public void accountRemoved(@NotNull GithubAccount removedAccount) {
                Intrinsics.checkParameterIsNotNull((Object)removedAccount, (String)"removedAccount");
                if (Intrinsics.areEqual((Object)this.getAccount(), (Object)removedAccount)) {
                    this.setAccount(null);
                }
            }
        });
    }
}

