/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import git4idea.DialogManager;
import java.awt.Component;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubProjectDefaultAccountHolder;
import org.jetbrains.plugins.github.authentication.ui.GithubLoginDialog;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 %2\u00020\u0001:\u0001%B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\fJ\u0017\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0017J\u0006\u0010\u0018\u001a\u00020\nJ\u0018\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0015J \u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0015H\u0002J \u0010 \u001a\u0004\u0018\u00010\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J(\u0010!\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J-\u0010\"\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00112\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0001\u00a2\u0006\u0002\b#J\u0018\u0010$\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;", "", "accountManager", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountManager;", "executorFactory", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;", "(Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccountManager;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor$Factory;)V", "clearAccounts", "", "ensureHasAccounts", "", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "getAccounts", "", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "getDefaultAccount", "getSingleOrDefaultAccount", "getTokenForAccount", "", "account", "getTokenForAccount$intellij_vcs_github", "hasAccounts", "isAccountUnique", "name", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "registerAccount", "host", "token", "requestNewAccount", "requestNewAccountForServer", "requestNewToken", "requestNewToken$intellij_vcs_github", "setDefaultAccount", "Companion", "intellij.vcs.github"})
public final class GithubAuthenticationManager {
    private final GithubAccountManager accountManager;
    private final GithubApiRequestExecutor.Factory executorFactory;
    public static final Companion Companion = new Companion(null);

    public final boolean hasAccounts() {
        Collection collection = this.accountManager.getAccounts();
        return !collection.isEmpty();
    }

    @NotNull
    public final Set<GithubAccount> getAccounts() {
        return this.accountManager.getAccounts();
    }

    @Nullable
    public final String getTokenForAccount$intellij_vcs_github(@NotNull GithubAccount account) {
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        return this.accountManager.getTokenForAccount(account);
    }

    @JvmOverloads
    @Nullable
    public final String requestNewToken$intellij_vcs_github(@NotNull GithubAccount account, @Nullable Project project, @Nullable Component parentComponent) {
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        GithubLoginDialog githubLoginDialog = new GithubLoginDialog(this.executorFactory, project, parentComponent, null, null, "Missing access token for " + account, 24, null);
        String string = account.getServer().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"account.server.toString()");
        GithubLoginDialog dialog2 = GithubLoginDialog.withToken$default(GithubLoginDialog.withCredentials$default(githubLoginDialog.withServer(string, false), account.getName(), null, 2, null), null, 1, null);
        DialogManager.show((DialogWrapper)dialog2);
        if (!dialog2.isOK()) {
            return null;
        }
        String token2 = dialog2.getToken();
        account.setName(dialog2.getLogin());
        this.accountManager.updateAccountToken(account, token2);
        return token2;
    }

    @JvmOverloads
    @Nullable
    public static /* synthetic */ String requestNewToken$intellij_vcs_github$default(GithubAuthenticationManager githubAuthenticationManager, GithubAccount githubAccount, Project project, Component component, int n, Object object) {
        if ((n & 4) != 0) {
            component = null;
        }
        return githubAuthenticationManager.requestNewToken$intellij_vcs_github(githubAccount, project, component);
    }

    @JvmOverloads
    @Nullable
    public final String requestNewToken$intellij_vcs_github(@NotNull GithubAccount account, @Nullable Project project) {
        return GithubAuthenticationManager.requestNewToken$intellij_vcs_github$default(this, account, project, null, 4, null);
    }

    @JvmOverloads
    @Nullable
    public final GithubAccount requestNewAccount(@Nullable Project project, @Nullable Component parentComponent) {
        GithubLoginDialog dialog2 = new GithubLoginDialog(this.executorFactory, project, parentComponent, (Function2)new Function2<String, GithubServerPath, Boolean>(this){

            public final boolean invoke(@NotNull String p1, @NotNull GithubServerPath p2) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                return GithubAuthenticationManager.access$isAccountUnique((GithubAuthenticationManager)this.receiver, p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(GithubAuthenticationManager.class);
            }

            public final String getName() {
                return "isAccountUnique";
            }

            public final String getSignature() {
                return "isAccountUnique(Ljava/lang/String;Lorg/jetbrains/plugins/github/api/GithubServerPath;)Z";
            }
        }, null, null, 48, null);
        DialogManager.show((DialogWrapper)dialog2);
        if (!dialog2.isOK()) {
            return null;
        }
        return this.registerAccount(dialog2.getLogin(), dialog2.getServer(), dialog2.getToken());
    }

    @JvmOverloads
    @Nullable
    public static /* synthetic */ GithubAccount requestNewAccount$default(GithubAuthenticationManager githubAuthenticationManager, Project project, Component component, int n, Object object) {
        if ((n & 2) != 0) {
            component = null;
        }
        return githubAuthenticationManager.requestNewAccount(project, component);
    }

    @JvmOverloads
    @Nullable
    public final GithubAccount requestNewAccount(@Nullable Project project) {
        return GithubAuthenticationManager.requestNewAccount$default(this, project, null, 2, null);
    }

    @JvmOverloads
    @Nullable
    public final GithubAccount requestNewAccountForServer(@NotNull GithubServerPath server, @Nullable Project project, @Nullable Component parentComponent) {
        Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
        GithubLoginDialog githubLoginDialog = new GithubLoginDialog(this.executorFactory, project, parentComponent, (Function2)new Function2<String, GithubServerPath, Boolean>(this){

            public final boolean invoke(@NotNull String p1, @NotNull GithubServerPath p2) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                return GithubAuthenticationManager.access$isAccountUnique((GithubAuthenticationManager)this.receiver, p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(GithubAuthenticationManager.class);
            }

            public final String getName() {
                return "isAccountUnique";
            }

            public final String getSignature() {
                return "isAccountUnique(Ljava/lang/String;Lorg/jetbrains/plugins/github/api/GithubServerPath;)Z";
            }
        }, null, null, 48, null);
        String string = server.toUrl();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"server.toUrl()");
        GithubLoginDialog dialog2 = githubLoginDialog.withServer(string, false);
        DialogManager.show((DialogWrapper)dialog2);
        if (!dialog2.isOK()) {
            return null;
        }
        return this.registerAccount(dialog2.getLogin(), dialog2.getServer(), dialog2.getToken());
    }

    @JvmOverloads
    @Nullable
    public static /* synthetic */ GithubAccount requestNewAccountForServer$default(GithubAuthenticationManager githubAuthenticationManager, GithubServerPath githubServerPath, Project project, Component component, int n, Object object) {
        if ((n & 4) != 0) {
            component = null;
        }
        return githubAuthenticationManager.requestNewAccountForServer(githubServerPath, project, component);
    }

    @JvmOverloads
    @Nullable
    public final GithubAccount requestNewAccountForServer(@NotNull GithubServerPath server, @Nullable Project project) {
        return GithubAuthenticationManager.requestNewAccountForServer$default(this, server, project, null, 4, null);
    }

    private final boolean isAccountUnique(String name, GithubServerPath server) {
        boolean bl;
        block3: {
            Iterable $receiver$iv = this.accountManager.getAccounts();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    GithubAccount it = (GithubAccount)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)name) && Intrinsics.areEqual((Object)it.getServer(), (Object)server))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final GithubAccount registerAccount(String name, GithubServerPath server, String token2) {
        GithubAccount account = GithubAccountManager.Companion.createAccount(name, server);
        GithubAccountManager githubAccountManager = this.accountManager;
        githubAccountManager.setAccounts(SetsKt.plus(githubAccountManager.getAccounts(), (Object)account));
        this.accountManager.updateAccountToken(account, token2);
        return account;
    }

    @NotNull
    public final GithubAccount registerAccount(@NotNull String name, @NotNull String host, @NotNull String token2) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)token2, (String)"token");
        GithubServerPath githubServerPath = GithubServerPath.from(host);
        Intrinsics.checkExpressionValueIsNotNull((Object)githubServerPath, (String)"GithubServerPath.from(host)");
        return this.registerAccount(name, githubServerPath, token2);
    }

    public final void clearAccounts() {
        for (GithubAccount account : this.accountManager.getAccounts()) {
            this.accountManager.updateAccountToken(account, null);
        }
        this.accountManager.setAccounts(SetsKt.emptySet());
    }

    @Nullable
    public final GithubAccount getDefaultAccount(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Project $receiver$iv = project;
        boolean $i$f$service = false;
        Object object = ServiceManager.getService((Project)$receiver$iv, GithubProjectDefaultAccountHolder.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(this, T::class.java)");
        return ((GithubProjectDefaultAccountHolder)object).getAccount();
    }

    public final void setDefaultAccount(@NotNull Project project, @Nullable GithubAccount account) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Project $receiver$iv = project;
        boolean $i$f$service = false;
        Object object = ServiceManager.getService((Project)$receiver$iv, GithubProjectDefaultAccountHolder.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(this, T::class.java)");
        ((GithubProjectDefaultAccountHolder)object).setAccount(account);
    }

    @JvmOverloads
    public final boolean ensureHasAccounts(@Nullable Project project, @Nullable Component parentComponent) {
        return this.hasAccounts() || this.requestNewAccount(project, parentComponent) != null;
    }

    @JvmOverloads
    public static /* synthetic */ boolean ensureHasAccounts$default(GithubAuthenticationManager githubAuthenticationManager, Project project, Component component, int n, Object object) {
        if ((n & 2) != 0) {
            component = null;
        }
        return githubAuthenticationManager.ensureHasAccounts(project, component);
    }

    @JvmOverloads
    public final boolean ensureHasAccounts(@Nullable Project project) {
        return GithubAuthenticationManager.ensureHasAccounts$default(this, project, null, 2, null);
    }

    @Nullable
    public final GithubAccount getSingleOrDefaultAccount(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Object $receiver$iv = project;
        boolean $i$f$service = false;
        Object object = ServiceManager.getService((Project)$receiver$iv, GithubProjectDefaultAccountHolder.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(this, T::class.java)");
        GithubAccount githubAccount = ((GithubProjectDefaultAccountHolder)object).getAccount();
        if (githubAccount != null) {
            Object it = $receiver$iv = githubAccount;
            boolean bl = false;
            return it;
        }
        Set<GithubAccount> accounts = this.accountManager.getAccounts();
        if (accounts.size() == 1) {
            return (GithubAccount)CollectionsKt.first((Iterable)accounts);
        }
        return null;
    }

    public GithubAuthenticationManager(@NotNull GithubAccountManager accountManager, @NotNull GithubApiRequestExecutor.Factory executorFactory) {
        Intrinsics.checkParameterIsNotNull((Object)accountManager, (String)"accountManager");
        Intrinsics.checkParameterIsNotNull((Object)executorFactory, (String)"executorFactory");
        this.accountManager = accountManager;
        this.executorFactory = executorFactory;
    }

    public static final /* synthetic */ boolean access$isAccountUnique(GithubAuthenticationManager $this, String name, GithubServerPath server) {
        return $this.isAccountUnique(name, server);
    }

    @JvmStatic
    @NotNull
    public static final GithubAuthenticationManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/plugins/github/authentication/GithubAuthenticationManager;", "intellij.vcs.github"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final GithubAuthenticationManager getInstance() {
            boolean $i$f$service = false;
            Object object = ServiceManager.getService(GithubAuthenticationManager.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getService(T::class.java)");
            return (GithubAuthenticationManager)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

