/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.themes;

import com.google.common.collect.Lists;
import com.intellij.ide.ui.UIThemeMetadata;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.themes.metadata.UIThemeMetadataService;

class ThemeJsonUtil {
    @NonNls
    private static final String UI_PROPERTY_NAME = "ui";

    ThemeJsonUtil() {
    }

    static boolean isInsideUiProperty(@NotNull JsonProperty property) {
        if (property == null) {
            ThemeJsonUtil.$$$reportNull$$$0(0);
        }
        JsonProperty parent = property;
        while ((parent = parent.getParent()) != null) {
            if (!(parent instanceof JsonProperty) || !UI_PROPERTY_NAME.equals(parent.getName())) continue;
            return true;
        }
        return false;
    }

    static String getParentNames(@NotNull JsonProperty property) {
        if (property == null) {
            ThemeJsonUtil.$$$reportNull$$$0(1);
        }
        List parentProperties = PsiTreeUtil.collectParents((PsiElement)property, JsonProperty.class, (boolean)false, e -> e instanceof JsonProperty && UI_PROPERTY_NAME.equals(((JsonProperty)e).getName()));
        return Lists.reverse((List)parentProperties).stream().map(p -> p.getName()).collect(Collectors.joining("."));
    }

    static boolean isThemeFilename(@NotNull String fileName) {
        if (fileName == null) {
            ThemeJsonUtil.$$$reportNull$$$0(2);
        }
        return StringUtil.endsWithIgnoreCase((String)fileName, (String)".theme.json");
    }

    @Nullable
    static Pair<UIThemeMetadata, UIThemeMetadata.UIKeyMetadata> findMetadata(@NotNull JsonProperty property) {
        if (property == null) {
            ThemeJsonUtil.$$$reportNull$$$0(3);
        }
        String key = property.getName();
        Pair<UIThemeMetadata, UIThemeMetadata.UIKeyMetadata> byName = UIThemeMetadataService.getInstance().findByKey(key);
        if (byName != null) {
            return byName;
        }
        return UIThemeMetadataService.getInstance().findByKey(ThemeJsonUtil.getParentNames(property) + "." + key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/themes/ThemeJsonUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsideUiProperty";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentNames";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isThemeFilename";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findMetadata";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

