/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.themes;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.ide.ui.UIThemeMetadata;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.themes.ThemeJsonUtil;

public class ThemeAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            ThemeAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            ThemeAnnotator.$$$reportNull$$$0(1);
        }
        if (!(element instanceof JsonProperty)) {
            return;
        }
        if (!ThemeJsonUtil.isThemeFilename(holder.getCurrentAnnotationSession().getFile().getName())) {
            return;
        }
        JsonProperty property = (JsonProperty)element;
        if (property.getValue() instanceof JsonObject) {
            return;
        }
        if (!ThemeJsonUtil.isInsideUiProperty(property)) {
            return;
        }
        Pair<UIThemeMetadata, UIThemeMetadata.UIKeyMetadata> pair = ThemeJsonUtil.findMetadata(property);
        if (pair == null) {
            String parentNames = ThemeJsonUtil.getParentNames(property);
            if (parentNames.startsWith("*")) {
                return;
            }
            String fullKey = parentNames.isEmpty() ? property.getName() : parentNames + "." + property.getName();
            holder.createWarningAnnotation(property.getNameElement().getTextRange(), "Unresolved key '" + fullKey + "'").setHighlightType(ProblemHighlightType.WARNING);
            return;
        }
        if (((UIThemeMetadata.UIKeyMetadata)pair.second).isDeprecated()) {
            holder.createWarningAnnotation(property.getNameElement().getTextRange(), "Deprecated key '" + ((UIThemeMetadata.UIKeyMetadata)pair.second).getKey() + "'").setHighlightType(ProblemHighlightType.LIKE_DEPRECATED);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/devkit/themes/ThemeAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

