/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.projectRoots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithStoredHistory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.projectRoots.IdeaJdk;
import org.jetbrains.idea.devkit.projectRoots.Sandbox;

public class IdeaJdkConfigurable
implements AdditionalDataConfigurable {
    private final JLabel mySandboxHomeLabel;
    private final TextFieldWithStoredHistory mySandboxHome;
    private final JLabel myInternalJreLabel;
    private final DefaultComboBoxModel<Sdk> myJdksModel;
    private final JComboBox<Sdk> myInternalJres;
    private Sdk myIdeaJdk;
    private boolean myModified;
    @NonNls
    private static final String SANDBOX_HISTORY = "DEVKIT_SANDBOX_HISTORY";
    private final SdkModel mySdkModel;
    private final SdkModificator mySdkModificator;
    private boolean myFreeze;
    private final SdkModel.Listener myListener;

    IdeaJdkConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            IdeaJdkConfigurable.$$$reportNull$$$0(0);
        }
        if (sdkModificator == null) {
            IdeaJdkConfigurable.$$$reportNull$$$0(1);
        }
        this.mySandboxHomeLabel = new JLabel(DevKitBundle.message("sandbox.home.label", new Object[0]));
        this.mySandboxHome = new TextFieldWithStoredHistory(SANDBOX_HISTORY);
        this.myInternalJreLabel = new JLabel("Internal Java Platform:");
        this.myJdksModel = new DefaultComboBoxModel();
        this.myInternalJres = new JComboBox<Sdk>(this.myJdksModel);
        this.mySdkModel = sdkModel;
        this.mySdkModificator = sdkModificator;
        this.myListener = new SdkModel.Listener(){

            public void sdkAdded(@NotNull Sdk sdk) {
                if (sdk == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (sdk.getSdkType().equals(JavaSdk.getInstance())) {
                    IdeaJdkConfigurable.this.addJavaSdk(sdk);
                }
            }

            public void beforeSdkRemove(@NotNull Sdk sdk) {
                if (sdk == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (sdk.getSdkType().equals(JavaSdk.getInstance())) {
                    IdeaJdkConfigurable.this.removeJavaSdk(sdk);
                }
            }

            public void sdkChanged(@NotNull Sdk sdk, String previousName) {
                if (sdk == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (sdk.getSdkType().equals(JavaSdk.getInstance())) {
                    IdeaJdkConfigurable.this.updateJavaSdkList(sdk, previousName);
                }
            }

            public void sdkHomeSelected(@NotNull Sdk sdk, @NotNull String newSdkHome) {
                if (sdk == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (newSdkHome == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (sdk.getSdkType() instanceof IdeaJdk) {
                    IdeaJdkConfigurable.this.internalJdkUpdate(sdk);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sdk";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newSdkHome";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/idea/devkit/projectRoots/IdeaJdkConfigurable$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sdkAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeSdkRemove";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sdkChanged";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sdkHomeSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.mySdkModel.addListener(this.myListener);
    }

    private void updateJdkList() {
        this.myJdksModel.removeAllElements();
        for (Sdk sdk : this.mySdkModel.getSdks()) {
            if (!IdeaJdk.isValidInternalJdk(this.myIdeaJdk, sdk)) continue;
            this.myJdksModel.addElement(sdk);
        }
    }

    public void setSdk(Sdk sdk) {
        this.myIdeaJdk = sdk;
    }

    public JComponent createComponent() {
        this.mySandboxHome.setHistorySize(5);
        JPanel wholePanel = new JPanel(new GridBagLayout());
        wholePanel.add((Component)this.mySandboxHomeLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 17, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        wholePanel.add((Component)GuiUtils.constructFieldWithBrowseButton((TextFieldWithHistory)this.mySandboxHome, e -> {
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            descriptor.setTitle(DevKitBundle.message("sandbox.home", new Object[0]));
            descriptor.setDescription(DevKitBundle.message("sandbox.purpose", new Object[0]));
            VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)this.mySandboxHome, null, null);
            if (file != null) {
                this.mySandboxHome.setText(FileUtil.toSystemDependentName((String)file.getPath()));
            }
            this.myModified = true;
        }), new GridBagConstraints(1, -1, 1, 1, 1.0, 1.0, 13, 2, (Insets)JBUI.insets((int)0, (int)30, (int)0, (int)0), 0, 0));
        wholePanel.add((Component)this.myInternalJreLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 17, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        wholePanel.add(this.myInternalJres, new GridBagConstraints(1, -1, 1, 1, 1.0, 1.0, 13, 2, (Insets)JBUI.insets((int)0, (int)30, (int)0, (int)0), 0, 0));
        this.myInternalJres.setRenderer((ListCellRenderer<Sdk>)new ListCellRendererWrapper<Sdk>(){

            public void customize(JList list, Sdk value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setText(value.getName());
                }
            }
        });
        this.myInternalJres.addItemListener(e -> {
            if (this.myFreeze) {
                return;
            }
            Sdk javaJdk = (Sdk)e.getItem();
            for (OrderRootType type : OrderRootType.getAllTypes()) {
                if (!((SdkType)javaJdk.getSdkType()).isRootTypeApplicable(type)) continue;
                VirtualFile[] internalRoots = javaJdk.getRootProvider().getFiles(type);
                Object[] configuredRoots = this.mySdkModificator.getRoots(type);
                for (VirtualFile file : internalRoots) {
                    if (e.getStateChange() == 2) {
                        this.mySdkModificator.removeRoot(file, type);
                        continue;
                    }
                    if (ArrayUtil.find((Object[])configuredRoots, (Object)file) != -1) continue;
                    this.mySdkModificator.addRoot(file, type);
                }
            }
        });
        this.mySandboxHome.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                IdeaJdkConfigurable.this.myModified = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/devkit/projectRoots/IdeaJdkConfigurable$3", "textChanged"));
            }
        });
        this.mySandboxHome.addActionListener(e -> {
            this.myModified = true;
        });
        this.mySandboxHome.setText("");
        this.myModified = true;
        return wholePanel;
    }

    private void internalJdkUpdate(Sdk sdk) {
        Sdk javaSdk = ((Sandbox)sdk.getSdkAdditionalData()).getJavaSdk();
        if (this.myJdksModel.getIndexOf(javaSdk) == -1) {
            this.myJdksModel.addElement(javaSdk);
        } else {
            this.myJdksModel.setSelectedItem(javaSdk);
        }
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void apply() {
        this.mySandboxHome.addCurrentTextToHistory();
        Sandbox additionalData = (Sandbox)this.myIdeaJdk.getSdkAdditionalData();
        if (additionalData != null) {
            additionalData.cleanupWatchedRoots();
        }
        Sandbox sandbox = new Sandbox(this.mySandboxHome.getText(), (Sdk)this.myInternalJres.getSelectedItem(), this.myIdeaJdk);
        SdkModificator modificator = this.myIdeaJdk.getSdkModificator();
        modificator.setSdkAdditionalData((SdkAdditionalData)sandbox);
        ApplicationManager.getApplication().runWriteAction(() -> ((SdkModificator)modificator).commitChanges());
        ((ProjectJdkImpl)this.myIdeaJdk).resetVersionString();
        this.myModified = false;
    }

    public void reset() {
        this.myFreeze = true;
        this.updateJdkList();
        this.myFreeze = false;
        this.mySandboxHome.reset();
        if (this.myIdeaJdk != null && this.myIdeaJdk.getSdkAdditionalData() instanceof Sandbox) {
            Sandbox sandbox = (Sandbox)this.myIdeaJdk.getSdkAdditionalData();
            String sandboxHome = sandbox.getSandboxHome();
            this.mySandboxHome.setText(sandboxHome);
            this.mySandboxHome.setSelectedItem((Object)sandboxHome);
            Sdk internalJava = sandbox.getJavaSdk();
            if (internalJava != null) {
                for (int i = 0; i < this.myJdksModel.getSize(); ++i) {
                    if (!Comparing.strEqual((String)this.myJdksModel.getElementAt(i).getName(), (String)internalJava.getName())) continue;
                    this.myInternalJres.setSelectedIndex(i);
                    break;
                }
            }
            this.myModified = false;
        } else {
            this.mySandboxHome.setText(IdeaJdk.getDefaultSandbox());
        }
    }

    public void disposeUIResources() {
        this.mySdkModel.removeListener(this.myListener);
    }

    private void addJavaSdk(Sdk sdk) {
        this.myJdksModel.addElement(sdk);
    }

    private void removeJavaSdk(Sdk sdk) {
        this.myJdksModel.removeElement(sdk);
    }

    private void updateJavaSdkList(Sdk sdk, String previousName) {
        Sdk[] sdks;
        for (Sdk currentSdk : sdks = this.mySdkModel.getSdks()) {
            Sandbox sandbox;
            Sdk internalJava;
            if (!(currentSdk.getSdkType() instanceof IdeaJdk) || (internalJava = (sandbox = (Sandbox)currentSdk.getSdkAdditionalData()).getJavaSdk()) == null || !Comparing.equal((String)internalJava.getName(), (String)previousName)) continue;
            sandbox.setJavaSdk(sdk);
        }
        this.updateJdkList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sdkModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sdkModificator";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/devkit/projectRoots/IdeaJdkConfigurable";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

