/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.missingApi.resolve;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.missingApi.resolve.IdeExternalAnnotations;
import org.jetbrains.idea.devkit.inspections.missingApi.resolve.IdeExternalAnnotationsKt;
import org.jetbrains.idea.devkit.inspections.missingApi.resolve.IdeExternalAnnotationsRepository;
import org.jetbrains.idea.maven.aether.ArtifactKind;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J0\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J0\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/devkit/inspections/missingApi/resolve/PublicIdeExternalAnnotationsRepository;", "Lorg/jetbrains/idea/devkit/inspections/missingApi/resolve/IdeExternalAnnotationsRepository;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "downloadExternalAnnotations", "Lorg/jetbrains/idea/devkit/inspections/missingApi/resolve/IdeExternalAnnotations;", "ideBuildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "tryDownload", "groupId", "", "artifactId", "version", "repos", "", "Lcom/intellij/jarRepository/RemoteRepositoryDescription;", "tryDownloadAnnotationsArtifact", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.devkit"})
public final class PublicIdeExternalAnnotationsRepository
implements IdeExternalAnnotationsRepository {
    private final Project project;
    @NotNull
    public static final String RELEASES_REPO_URL = "https://www.jetbrains.com/intellij-repository/releases/";
    @NotNull
    public static final String SNAPSHOTS_REPO_URL = "https://www.jetbrains.com/intellij-repository/snapshots/";
    @NotNull
    private static final RemoteRepositoryDescription RELEASES_REPO_DESCRIPTION;
    @NotNull
    private static final RemoteRepositoryDescription SNAPSHOTS_REPO_DESCRIPTION;
    private static final List<String> allProductCodes;
    private static final Pair<String, String> ideaIUAnnotationsCoordinates;
    private static final Map<String, Pair<String, String>> productCodeToAnnotationsCoordinates;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public IdeExternalAnnotations downloadExternalAnnotations(@NotNull BuildNumber ideBuildNumber) {
        Object v3;
        void groupId;
        String string;
        Intrinsics.checkParameterIsNotNull((Object)ideBuildNumber, (String)"ideBuildNumber");
        String it = string = ideBuildNumber.getProductCode();
        boolean $i$a$-takeIf-PublicIdeExternalAnnotationsRepository$downloadExternalAnnotations$productCode$22 = false;
        String string2 = it;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it");
        CharSequence charSequence = string2;
        String string3 = charSequence.length() > 0 ? string : null;
        if (string3 == null) {
            string3 = "IU";
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"ideBuildNumber.productCo\u2026it.isNotEmpty() } ?: \"IU\"");
        String productCode = string3;
        Pair<String, String> pair = productCodeToAnnotationsCoordinates.get(productCode);
        if (pair == null) {
            return null;
        }
        Pair<String, String> $i$a$-takeIf-PublicIdeExternalAnnotationsRepository$downloadExternalAnnotations$productCode$22 = pair;
        string = (String)$i$a$-takeIf-PublicIdeExternalAnnotationsRepository$downloadExternalAnnotations$productCode$22.component1();
        String artifactId = (String)$i$a$-takeIf-PublicIdeExternalAnnotationsRepository$downloadExternalAnnotations$productCode$22.component2();
        String lastReleaseVersion = ideBuildNumber.getBaselineVersion() + ".999999";
        IdeExternalAnnotations lastReleaseAnnotations = this.tryDownload((String)groupId, artifactId, lastReleaseVersion, CollectionsKt.listOf((Object)RELEASES_REPO_DESCRIPTION));
        if (lastReleaseAnnotations != null && lastReleaseAnnotations.getAnnotationsBuild().compareTo(ideBuildNumber) >= 0) {
            return lastReleaseAnnotations;
        }
        String snapshotVersion = ideBuildNumber.getBaselineVersion() + "-SNAPSHOT";
        IdeExternalAnnotations snapshotAnnotations = this.tryDownload((String)groupId, artifactId, snapshotVersion, CollectionsKt.listOf((Object)SNAPSHOTS_REPO_DESCRIPTION));
        if (snapshotAnnotations != null && snapshotAnnotations.getAnnotationsBuild().compareTo(ideBuildNumber) >= 0) {
            return snapshotAnnotations;
        }
        String latestTrunkSnapshot = "LATEST-TRUNK-SNAPSHOT";
        IdeExternalAnnotations latestTrunkSnapshotAnnotations = this.tryDownload((String)groupId, artifactId, latestTrunkSnapshot, CollectionsKt.listOf((Object)SNAPSHOTS_REPO_DESCRIPTION));
        if (latestTrunkSnapshotAnnotations != null && latestTrunkSnapshotAnnotations.getAnnotationsBuild().compareTo(ideBuildNumber) >= 0) {
            return latestTrunkSnapshotAnnotations;
        }
        Sequence $receiver$iv = SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])new IdeExternalAnnotations[]{lastReleaseAnnotations, snapshotAnnotations, latestTrunkSnapshotAnnotations}));
        Iterator iterator$iv = $receiver$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v3 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            IdeExternalAnnotations it2 = (IdeExternalAnnotations)maxElem$iv;
            boolean bl = false;
            Comparable maxValue$iv = (Comparable)it2.getAnnotationsBuild();
            while (iterator$iv.hasNext()) {
                Object e$iv = iterator$iv.next();
                IdeExternalAnnotations it3 = (IdeExternalAnnotations)e$iv;
                $i$a$-maxBy-PublicIdeExternalAnnotationsRepository$downloadExternalAnnotations$1 = false;
                Comparable v$iv = (Comparable)it3.getAnnotationsBuild();
                if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            }
            v3 = maxElem$iv;
        }
        return v3;
    }

    private final IdeExternalAnnotations tryDownload(String groupId, String artifactId, String version, List<? extends RemoteRepositoryDescription> repos) {
        BuildNumber buildNumber;
        VirtualFile annotations = this.tryDownloadAnnotationsArtifact(groupId, artifactId, version, repos);
        if (annotations != null && (buildNumber = IdeExternalAnnotationsKt.getAnnotationsBuildNumber(annotations)) != null) {
            return new IdeExternalAnnotations(buildNumber, annotations);
        }
        return null;
    }

    private final VirtualFile tryDownloadAnnotationsArtifact(String groupId, String artifactId, String version, List<? extends RemoteRepositoryDescription> repos) {
        List list = JarRepositoryManager.loadDependenciesSync((Project)this.project, (JpsMavenRepositoryLibraryDescriptor)new JpsMavenRepositoryLibraryDescriptor(groupId, artifactId, version), (Set)SetsKt.setOf((Object)ArtifactKind.ANNOTATIONS), repos, null);
        return list != null && (list = (OrderRoot)CollectionsKt.firstOrNull((List)list)) != null ? list.getFile() : null;
    }

    public PublicIdeExternalAnnotationsRepository(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $receiver$iv$iv;
        Companion = new Companion(null);
        RELEASES_REPO_DESCRIPTION = new RemoteRepositoryDescription("IntelliJ Artifacts Repository (Releases)", "IntelliJ Artifacts Repository (Releases)", RELEASES_REPO_URL);
        SNAPSHOTS_REPO_DESCRIPTION = new RemoteRepositoryDescription("IntelliJ Artifacts Repository (Snapshots)", "IntelliJ Artifacts Repository (Snapshots)", SNAPSHOTS_REPO_URL);
        allProductCodes = CollectionsKt.listOf((Object[])new String[]{"IU", "IC", "RM", "PY", "PC", "PE", "PS", "WS", "OC", "CL", "DB", "RD", "GO", "MPS", "AI"});
        ideaIUAnnotationsCoordinates = TuplesKt.to((Object)"com.jetbrains.intellij.idea", (Object)"ideaIU");
        Iterable $receiver$iv = allProductCodes;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10)), (int)16);
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        for (Object element$iv$iv : $receiver$iv$iv) {
            Map map = destination$iv$iv;
            String it = (String)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it, ideaIUAnnotationsCoordinates);
            map.put(pair.getFirst(), pair.getSecond());
        }
        productCodeToAnnotationsCoordinates = var3_3;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0010\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/idea/devkit/inspections/missingApi/resolve/PublicIdeExternalAnnotationsRepository$Companion;", "", "()V", "RELEASES_REPO_DESCRIPTION", "Lcom/intellij/jarRepository/RemoteRepositoryDescription;", "getRELEASES_REPO_DESCRIPTION", "()Lcom/intellij/jarRepository/RemoteRepositoryDescription;", "RELEASES_REPO_URL", "", "SNAPSHOTS_REPO_DESCRIPTION", "getSNAPSHOTS_REPO_DESCRIPTION", "SNAPSHOTS_REPO_URL", "allProductCodes", "", "ideaIUAnnotationsCoordinates", "Lkotlin/Pair;", "productCodeToAnnotationsCoordinates", "", "hasAnnotationsForProduct", "", "productCode", "intellij.devkit"})
    public static final class Companion {
        @NotNull
        public final RemoteRepositoryDescription getRELEASES_REPO_DESCRIPTION() {
            return RELEASES_REPO_DESCRIPTION;
        }

        @NotNull
        public final RemoteRepositoryDescription getSNAPSHOTS_REPO_DESCRIPTION() {
            return SNAPSHOTS_REPO_DESCRIPTION;
        }

        public final boolean hasAnnotationsForProduct(@NotNull String productCode) {
            Map map;
            Intrinsics.checkParameterIsNotNull((Object)productCode, (String)"productCode");
            Map map2 = map = productCodeToAnnotationsCoordinates;
            return map2.containsKey(productCode);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

