/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.impl.ExtensionDomExtender;

public class PluginFieldNameConverter
extends ResolvingConverter<PsiField> {
    @NotNull
    public Collection<? extends PsiField> getVariants(ConvertContext context) {
        PsiClass aClass = PluginFieldNameConverter.getEPBeanClass(context);
        if (aClass == null) {
            List list = Collections.emptyList();
            if (list == null) {
                PluginFieldNameConverter.$$$reportNull$$$0(0);
            }
            return list;
        }
        ArrayList<PsiField> result = new ArrayList<PsiField>();
        for (PsiField field : aClass.getAllFields()) {
            PsiClass resolved;
            PsiType type;
            if (field.hasModifierProperty("static") || !((type = field.getType()) instanceof PsiClassType) || (resolved = ((PsiClassType)type).resolve()) == null || !"java.lang.String".equals(resolved.getQualifiedName())) continue;
            result.add(field);
        }
        ArrayList<PsiField> arrayList = result;
        if (arrayList == null) {
            PluginFieldNameConverter.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Nullable
    public PsiField fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        PsiClass value = PluginFieldNameConverter.getEPBeanClass(context);
        if (value == null) {
            return null;
        }
        PsiField field = value.findFieldByName(s, true);
        if (field != null) {
            return field;
        }
        return PluginFieldNameConverter.findFieldByAttributeValue(value, s);
    }

    private static PsiField findFieldByAttributeValue(PsiClass psiClass, @NotNull String attrNameToFind) {
        if (attrNameToFind == null) {
            PluginFieldNameConverter.$$$reportNull$$$0(2);
        }
        for (PsiField psiField : psiClass.getAllFields()) {
            if (!attrNameToFind.equals(PluginFieldNameConverter.getAttributeAnnotationValue(psiField))) continue;
            return psiField;
        }
        return null;
    }

    public static String getAttributeAnnotationValue(PsiField psiField) {
        return PluginFieldNameConverter.getAnnotationValue(psiField, Attribute.class);
    }

    public static String getAnnotationValue(PsiField psiField, Class annotationClass) {
        PsiConstantEvaluationHelper evalHelper = JavaPsiFacade.getInstance((Project)psiField.getProject()).getConstantEvaluationHelper();
        PsiMethod getter = PropertyUtilBase.findGetterForField((PsiField)psiField);
        PsiMethod setter = PropertyUtilBase.findSetterForField((PsiField)psiField);
        PsiAnnotation attrAnno = ExtensionDomExtender.findAnnotation(annotationClass, new PsiMember[]{psiField, getter, setter});
        if (attrAnno != null) {
            return ExtensionDomExtender.getStringAttribute(attrAnno, "value", evalHelper, null);
        }
        return null;
    }

    @Nullable
    public String toString(@Nullable PsiField field, ConvertContext context) {
        return field == null ? null : field.getName();
    }

    @Nullable
    private static PsiClass getEPBeanClass(ConvertContext context) {
        ExtensionPoint ep = (ExtensionPoint)context.getInvocationElement().getParentOfType(ExtensionPoint.class, true);
        if (ep == null) {
            return null;
        }
        return (PsiClass)ep.getBeanClass().getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/dom/impl/PluginFieldNameConverter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrNameToFind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/dom/impl/PluginFieldNameConverter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findFieldByAttributeValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

