/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.CopyableIcon;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.Function;
import com.intellij.util.LazyInitializer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import gnu.trove.TDoubleObjectHashMap;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBUI {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.ui.JBUI");
    public static final String USER_SCALE_FACTOR_PROPERTY = "JBUI.userScaleFactor";
    private static final PropertyChangeSupport PCS = new PropertyChangeSupport(new JBUI());
    private static final float DISCRETE_SCALE_RESOLUTION = 0.25f;
    public static final boolean SCALE_VERBOSE = Boolean.getBoolean("ide.ui.scale.verbose");
    private static final LazyInitializer.NotNullValue<Float> SYSTEM_SCALE_FACTOR = new LazyInitializer.NotNullValue<Float>(){

        @Override
        @NotNull
        public Float initialize() {
            if (!SystemProperties.getBooleanProperty("hidpi", true)) {
                Float f = Float.valueOf(1.0f);
                if (f == null) {
                    1.$$$reportNull$$$0(0);
                }
                return f;
            }
            if (UIUtil.isJreHiDPIEnabled()) {
                GraphicsDevice gd = null;
                try {
                    gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                }
                catch (HeadlessException headlessException) {
                    // empty catch block
                }
                if (gd != null && gd.getDefaultConfiguration() != null) {
                    Float f = Float.valueOf(JBUI.sysScale(gd.getDefaultConfiguration()));
                    if (f == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return f;
                }
                Float f = Float.valueOf(1.0f);
                if (f == null) {
                    1.$$$reportNull$$$0(2);
                }
                return f;
            }
            UIUtil.initSystemFontData();
            Pair<String, Integer> fdata = UIUtil.getSystemFontData();
            int size = fdata == null ? Fonts.label().getSize() : fdata.getSecond().intValue();
            Float f = Float.valueOf(JBUI.getFontScale(size));
            if (f == null) {
                1.$$$reportNull$$$0(3);
            }
            return f;
        }

        @Override
        protected void onInitialized(@NotNull Float scale) {
            if (scale == null) {
                1.$$$reportNull$$$0(4);
            }
            LOG.info("System scale factor: " + scale + " (" + (UIUtil.isJreHiDPIEnabled() ? "JRE" : "IDE") + "-managed HiDPI)");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/JBUI$1";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scale";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "initialize";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/JBUI$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "onInitialized";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    public static final LazyInitializer.NullableValue<Float> DEBUG_USER_SCALE_FACTOR = new LazyInitializer.NullableValue<Float>(){

        @Override
        @Nullable
        public Float initialize() {
            String prop = System.getProperty("ide.ui.scale");
            if (prop != null) {
                try {
                    return Float.valueOf(Float.parseFloat(prop));
                }
                catch (NumberFormatException e) {
                    LOG.error("ide.ui.scale system property is not a float value: " + prop);
                }
            } else if (Registry.is("ide.ui.scale.override")) {
                return Float.valueOf((float)Registry.get("ide.ui.scale").asDouble());
            }
            return null;
        }

        @Override
        protected void onInitialized(@Nullable Float scale) {
            if (this.isNotNull()) {
                JBUI.setUserScaleFactor(ObjectUtils.notNull(scale).floatValue());
            }
        }
    };
    private static float userScaleFactor = JBUI.setUserScaleFactor(UIUtil.isJreHiDPIEnabled() ? 1.0f : SYSTEM_SCALE_FACTOR.get().floatValue());
    private static final JBEmptyBorder SHARED_EMPTY_INSTANCE = new JBEmptyBorder(0);

    public static void addPropertyChangeListener(@NotNull String propertyName, @NotNull PropertyChangeListener listener) {
        if (propertyName == null) {
            JBUI.$$$reportNull$$$0(0);
        }
        if (listener == null) {
            JBUI.$$$reportNull$$$0(1);
        }
        PCS.addPropertyChangeListener(propertyName, listener);
    }

    public static void removePropertyChangeListener(@NotNull String propertyName, @NotNull PropertyChangeListener listener) {
        if (propertyName == null) {
            JBUI.$$$reportNull$$$0(2);
        }
        if (listener == null) {
            JBUI.$$$reportNull$$$0(3);
        }
        PCS.removePropertyChangeListener(propertyName, listener);
    }

    public static float sysScale() {
        return SYSTEM_SCALE_FACTOR.get().floatValue();
    }

    public static float sysScale(@Nullable GraphicsConfiguration gc) {
        if (UIUtil.isJreHiDPIEnabled() && gc != null && gc.getDevice().getType() == 0) {
            if (SystemInfo.isMac && UIUtil.isJreHiDPI_earlierVersion()) {
                return UIUtil.DetectRetinaKit.isOracleMacRetinaDevice(gc.getDevice()) ? 2.0f : 1.0f;
            }
            return (float)gc.getDefaultTransform().getScaleX();
        }
        return JBUI.sysScale();
    }

    public static float sysScale(@Nullable Graphics2D g) {
        if (UIUtil.isJreHiDPIEnabled() && g != null) {
            GraphicsConfiguration gc = g.getDeviceConfiguration();
            if (gc == null || gc.getDevice().getType() == 2 || gc.getDevice().getType() == 1) {
                return (float)g.getTransform().getScaleX();
            }
            return JBUI.sysScale(gc);
        }
        return JBUI.sysScale();
    }

    public static float sysScale(@Nullable Component comp) {
        if (comp != null) {
            return JBUI.sysScale(comp.getGraphicsConfiguration());
        }
        return JBUI.sysScale();
    }

    public static double sysScale(@Nullable ScaleContext ctx) {
        if (ctx != null) {
            return ctx.getScale(ScaleType.SYS_SCALE);
        }
        return JBUI.sysScale();
    }

    public static float pixScale() {
        return UIUtil.isJreHiDPIEnabled() ? JBUI.sysScale() * JBUI.scale(1.0f) : JBUI.scale(1.0f);
    }

    public static float pixScale(float f) {
        return JBUI.pixScale() * f;
    }

    public static float pixScale(@Nullable GraphicsConfiguration gc, float f) {
        return JBUI.pixScale(gc) * f;
    }

    public static float pixScale(@Nullable GraphicsConfiguration gc) {
        return UIUtil.isJreHiDPIEnabled() ? JBUI.sysScale(gc) * JBUI.scale(1.0f) : JBUI.scale(1.0f);
    }

    public static float pixScale(@Nullable Graphics2D g) {
        return UIUtil.isJreHiDPIEnabled() ? JBUI.sysScale(g) * JBUI.scale(1.0f) : JBUI.scale(1.0f);
    }

    public static float pixScale(@Nullable Component comp) {
        return JBUI.pixScale(comp != null ? comp.getGraphicsConfiguration() : null);
    }

    public static <T extends BaseScaleContext> double pixScale(@Nullable T ctx) {
        if (ctx != null) {
            double usrScale = ctx.getScale(ScaleType.USR_SCALE);
            return UIUtil.isJreHiDPIEnabled() ? ctx.getScale(ScaleType.SYS_SCALE) * usrScale : usrScale;
        }
        return JBUI.pixScale();
    }

    private static void setUserScaleFactorProperty(float scale) {
        if (userScaleFactor == scale) {
            return;
        }
        Float f = Float.valueOf(userScaleFactor);
        userScaleFactor = scale;
        PCS.firePropertyChange(USER_SCALE_FACTOR_PROPERTY, f, Float.valueOf(userScaleFactor));
        LOG.info("User scale factor: " + userScaleFactor);
    }

    public static float setUserScaleFactor(float scale) {
        Float factor = DEBUG_USER_SCALE_FACTOR.get();
        if (factor != null) {
            float debugScale = factor.floatValue();
            if (scale == debugScale) {
                JBUI.setUserScaleFactorProperty(debugScale);
            }
            return debugScale;
        }
        if (!SystemProperties.getBooleanProperty("hidpi", true)) {
            JBUI.setUserScaleFactorProperty(1.0f);
            return 1.0f;
        }
        if ((scale = JBUI.discreteScale(scale)) < 1.0f && JBUI.sysScale() >= 1.0f) {
            scale = 1.0f;
        }
        if (SystemInfo.isLinux && scale == 1.25f && UIUtil.DEF_SYSTEM_FONT_SIZE == 12.0f) {
            scale = 1.0f;
        }
        JBUI.setUserScaleFactorProperty(scale);
        return scale;
    }

    static float discreteScale(float scale) {
        return (float)Math.round(scale / 0.25f) * 0.25f;
    }

    public static float scale(float f) {
        return f * userScaleFactor;
    }

    public static int scale(int i) {
        return Math.round(userScaleFactor * (float)i);
    }

    public static int scaleFontSize(float fontSize) {
        if (userScaleFactor == 1.25f) {
            return (int)(fontSize * 1.34f);
        }
        if (userScaleFactor == 1.75f) {
            return (int)(fontSize * 1.67f);
        }
        return (int)JBUI.scale(fontSize);
    }

    public static float getFontScale(float fontSize) {
        return fontSize / UIUtil.DEF_SYSTEM_FONT_SIZE;
    }

    @NotNull
    public static JBValue value(float value) {
        JBValue.Float float_ = new JBValue.Float(value);
        if (float_ == null) {
            JBUI.$$$reportNull$$$0(4);
        }
        return float_;
    }

    @NotNull
    public static JBValue uiIntValue(@NotNull String key, int defValue) {
        if (key == null) {
            JBUI.$$$reportNull$$$0(5);
        }
        JBValue.UIInteger uIInteger = new JBValue.UIInteger(key, defValue);
        if (uIInteger == null) {
            JBUI.$$$reportNull$$$0(6);
        }
        return uIInteger;
    }

    @NotNull
    public static JBDimension size(int width, int height) {
        JBDimension jBDimension = new JBDimension(width, height);
        if (jBDimension == null) {
            JBUI.$$$reportNull$$$0(7);
        }
        return jBDimension;
    }

    @NotNull
    public static JBDimension size(int widthAndHeight) {
        JBDimension jBDimension = new JBDimension(widthAndHeight, widthAndHeight);
        if (jBDimension == null) {
            JBUI.$$$reportNull$$$0(8);
        }
        return jBDimension;
    }

    @NotNull
    public static JBDimension size(Dimension size) {
        if (size instanceof JBDimension) {
            JBDimension newSize = ((JBDimension)size).newSize();
            JBDimension jBDimension = size instanceof UIResource ? newSize.asUIResource() : newSize;
            if (jBDimension == null) {
                JBUI.$$$reportNull$$$0(9);
            }
            return jBDimension;
        }
        JBDimension jBDimension = new JBDimension(size.width, size.height);
        if (jBDimension == null) {
            JBUI.$$$reportNull$$$0(10);
        }
        return jBDimension;
    }

    @NotNull
    public static JBInsets insets(int top, int left, int bottom, int right) {
        JBInsets jBInsets = new JBInsets(top, left, bottom, right);
        if (jBInsets == null) {
            JBUI.$$$reportNull$$$0(11);
        }
        return jBInsets;
    }

    @NotNull
    public static JBInsets insets(int all) {
        JBInsets jBInsets = JBUI.insets(all, all, all, all);
        if (jBInsets == null) {
            JBUI.$$$reportNull$$$0(12);
        }
        return jBInsets;
    }

    @NotNull
    public static JBInsets insets(String propName, JBInsets defaultValue) {
        Insets i = UIManager.getInsets(propName);
        JBInsets jBInsets = i != null ? JBInsets.create(i) : defaultValue;
        if (jBInsets == null) {
            JBUI.$$$reportNull$$$0(13);
        }
        return jBInsets;
    }

    @NotNull
    public static JBInsets insets(int topBottom, int leftRight) {
        JBInsets jBInsets = JBUI.insets(topBottom, leftRight, topBottom, leftRight);
        if (jBInsets == null) {
            JBUI.$$$reportNull$$$0(14);
        }
        return jBInsets;
    }

    @NotNull
    public static JBInsets emptyInsets() {
        JBInsets jBInsets = new JBInsets(0, 0, 0, 0);
        if (jBInsets == null) {
            JBUI.$$$reportNull$$$0(15);
        }
        return jBInsets;
    }

    @NotNull
    public static JBInsets insetsTop(int t) {
        JBInsets jBInsets = JBUI.insets(t, 0, 0, 0);
        if (jBInsets == null) {
            JBUI.$$$reportNull$$$0(16);
        }
        return jBInsets;
    }

    @NotNull
    public static JBInsets insetsLeft(int l) {
        JBInsets jBInsets = JBUI.insets(0, l, 0, 0);
        if (jBInsets == null) {
            JBUI.$$$reportNull$$$0(17);
        }
        return jBInsets;
    }

    @NotNull
    public static JBInsets insetsBottom(int b) {
        JBInsets jBInsets = JBUI.insets(0, 0, b, 0);
        if (jBInsets == null) {
            JBUI.$$$reportNull$$$0(18);
        }
        return jBInsets;
    }

    @NotNull
    public static JBInsets insetsRight(int r) {
        JBInsets jBInsets = JBUI.insets(0, 0, 0, r);
        if (jBInsets == null) {
            JBUI.$$$reportNull$$$0(19);
        }
        return jBInsets;
    }

    @NotNull
    public static <T extends JBIcon> T scale(@NotNull T icon) {
        if (icon == null) {
            JBUI.$$$reportNull$$$0(20);
        }
        JBIcon jBIcon = icon.withIconPreScaled(false);
        if (jBIcon == null) {
            JBUI.$$$reportNull$$$0(21);
        }
        return (T)jBIcon;
    }

    @NotNull
    public static JBDimension emptySize() {
        JBDimension jBDimension = new JBDimension(0, 0);
        if (jBDimension == null) {
            JBUI.$$$reportNull$$$0(22);
        }
        return jBDimension;
    }

    @NotNull
    public static JBInsets insets(@NotNull Insets insets) {
        if (insets == null) {
            JBUI.$$$reportNull$$$0(23);
        }
        JBInsets jBInsets = JBInsets.create(insets);
        if (jBInsets == null) {
            JBUI.$$$reportNull$$$0(24);
        }
        return jBInsets;
    }

    @Deprecated
    public static boolean isHiDPI() {
        return JBUI.isUsrHiDPI();
    }

    public static boolean isUsrHiDPI() {
        return JBUI.isHiDPI(JBUI.scale(1.0f));
    }

    public static boolean isPixHiDPI(@Nullable GraphicsConfiguration gc) {
        return JBUI.isHiDPI(JBUI.pixScale(gc));
    }

    public static boolean isPixHiDPI(@Nullable Graphics2D g) {
        return JBUI.isHiDPI(JBUI.pixScale(g));
    }

    public static boolean isPixHiDPI(@Nullable Component comp) {
        return JBUI.isHiDPI(JBUI.pixScale(comp));
    }

    public static boolean isHiDPI(double scale) {
        return scale > 1.0;
    }

    public static Border asUIResource(@NotNull Border border) {
        if (border == null) {
            JBUI.$$$reportNull$$$0(25);
        }
        if (border instanceof UIResource) {
            return border;
        }
        return new BorderUIResource(border);
    }

    public static int getInt(@NotNull String propertyName, int defaultValue) {
        Object value;
        if (propertyName == null) {
            JBUI.$$$reportNull$$$0(26);
        }
        return (value = UIManager.get(propertyName)) instanceof Integer ? (Integer)value : defaultValue;
    }

    @NotNull
    private static Icon getIcon(@NotNull String propertyName, @NotNull Icon defaultIcon) {
        Icon icon;
        if (propertyName == null) {
            JBUI.$$$reportNull$$$0(27);
        }
        if (defaultIcon == null) {
            JBUI.$$$reportNull$$$0(28);
        }
        Icon icon2 = (icon = UIManager.getIcon(propertyName)) == null ? defaultIcon : icon;
        if (icon2 == null) {
            JBUI.$$$reportNull$$$0(29);
        }
        return icon2;
    }

    @NotNull
    private static Border getBorder(@NotNull String propertyName, @NotNull Border defaultBorder) {
        Border border;
        if (propertyName == null) {
            JBUI.$$$reportNull$$$0(30);
        }
        if (defaultBorder == null) {
            JBUI.$$$reportNull$$$0(31);
        }
        Border border2 = (border = UIManager.getBorder(propertyName)) == null ? defaultBorder : border;
        if (border2 == null) {
            JBUI.$$$reportNull$$$0(32);
        }
        return border2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 29: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 29: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/JBUI";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "border";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultIcon";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultBorder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/JBUI";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "value";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "uiIntValue";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "size";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "insets";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyInsets";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "insetsTop";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "insetsLeft";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "insetsBottom";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "insetsRight";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "scale";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "emptySize";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getBorder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 29: 
            case 32: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "uiIntValue";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "scale";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "insets";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "asUIResource";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getInt";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getBorder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 29: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CurrentTheme {

        public static class Link {
            @NotNull
            public static Color linkColor() {
                JBColor jBColor = JBColor.namedColor("Link.activeForeground", JBColor.namedColor("link.foreground", 5807606));
                if (jBColor == null) {
                    Link.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color linkHoverColor() {
                JBColor jBColor = JBColor.namedColor("Link.hoverForeground", JBColor.namedColor("link.hover.foreground", Link.linkColor()));
                if (jBColor == null) {
                    Link.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color linkPressedColor() {
                JBColor jBColor = JBColor.namedColor("Link.pressedForeground", JBColor.namedColor("link.pressed.foreground", new JBColor(0xF00000, 12218149)));
                if (jBColor == null) {
                    Link.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            @NotNull
            public static Color linkVisitedColor() {
                JBColor jBColor = JBColor.namedColor("Link.visitedForeground", JBColor.namedColor("link.visited.foreground", new JBColor(0x800080, 9926313)));
                if (jBColor == null) {
                    Link.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$Link";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "linkColor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "linkHoverColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "linkPressedColor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "linkVisitedColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static class Validator {
            @NotNull
            public static Color errorBorderColor() {
                JBColor jBColor = JBColor.namedColor("ValidationTooltip.errorBorderColor", 14723241);
                if (jBColor == null) {
                    Validator.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color errorBackgroundColor() {
                JBColor jBColor = JBColor.namedColor("ValidationTooltip.errorBackground", JBColor.namedColor("ValidationTooltip.errorBackgroundColor", 16115431));
                if (jBColor == null) {
                    Validator.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color warningBorderColor() {
                JBColor jBColor = JBColor.namedColor("ValidationTooltip.warningBorderColor", 14732968);
                if (jBColor == null) {
                    Validator.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            @NotNull
            public static Color warningBackgroundColor() {
                JBColor jBColor = JBColor.namedColor("ValidationTooltip.warningBackground", JBColor.namedColor("ValidationTooltip.warningBackgroundColor", 16117990));
                if (jBColor == null) {
                    Validator.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$Validator";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "errorBorderColor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "errorBackgroundColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "warningBorderColor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "warningBackgroundColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static class Advertiser {
            private static final JBInsets DEFAULT_AD_INSETS = JBUI.insets(1, 5);

            @NotNull
            public static Color foreground() {
                Color foreground = BigPopup.advertiserForeground();
                JBColor jBColor = JBColor.namedColor("Popup.Advertiser.foreground", foreground);
                if (jBColor == null) {
                    Advertiser.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color background() {
                Color background = BigPopup.advertiserBackground();
                JBColor jBColor = JBColor.namedColor("Popup.Advertiser.background", background);
                if (jBColor == null) {
                    Advertiser.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Border border() {
                JBEmptyBorder jBEmptyBorder = new JBEmptyBorder(JBUI.insets("Popup.Advertiser.borderInsets", DEFAULT_AD_INSETS));
                if (jBEmptyBorder == null) {
                    Advertiser.$$$reportNull$$$0(2);
                }
                return jBEmptyBorder;
            }

            @NotNull
            public static Color borderColor() {
                JBColor jBColor = JBColor.namedColor("Popup.Advertiser.borderColor", Gray._135);
                if (jBColor == null) {
                    Advertiser.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$Advertiser";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "foreground";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "background";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "border";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "borderColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static class BigPopup {
            @NotNull
            public static Color headerBackground() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.Header.background", 0xF2F2F2);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Insets tabInsets() {
                JBInsets jBInsets = JBUI.insets(0, 12);
                if (jBInsets == null) {
                    BigPopup.$$$reportNull$$$0(1);
                }
                return jBInsets;
            }

            @NotNull
            public static Color selectedTabColor() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.Tab.selectedBackground", 0xDEDEDE);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            @NotNull
            public static Color selectedTabTextColor() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.Tab.selectedForeground", 0);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            @NotNull
            public static Color searchFieldBackground() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.SearchField.background", 0xFFFFFF);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(4);
                }
                return jBColor;
            }

            @NotNull
            public static Color searchFieldBorderColor() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.SearchField.borderColor", 0xBDBDBD);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(5);
                }
                return jBColor;
            }

            @NotNull
            public static Insets searchFieldInsets() {
                JBInsets jBInsets = JBUI.insets(0, 6, 0, 5);
                if (jBInsets == null) {
                    BigPopup.$$$reportNull$$$0(6);
                }
                return jBInsets;
            }

            public static int maxListHeight() {
                return JBUI.scale(600);
            }

            @NotNull
            public static Color listSeparatorColor() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.List.separatorColor", Gray.xDC);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(7);
                }
                return jBColor;
            }

            @NotNull
            public static Color listTitleLabelForeground() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.List.separatorForeground", UIUtil.getLabelDisabledForeground());
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(8);
                }
                return jBColor;
            }

            @NotNull
            public static Color searchFieldGrayForeground() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.SearchField.infoForeground", JBColor.GRAY);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(9);
                }
                return jBColor;
            }

            @NotNull
            public static Color advertiserForeground() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.Advertiser.foreground", JBColor.GRAY);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(10);
                }
                return jBColor;
            }

            @NotNull
            public static Border advertiserBorder() {
                JBEmptyBorder jBEmptyBorder = new JBEmptyBorder(JBUI.insets("SearchEverywhere.Advertiser.foreground", JBUI.insetsLeft(8)));
                if (jBEmptyBorder == null) {
                    BigPopup.$$$reportNull$$$0(11);
                }
                return jBEmptyBorder;
            }

            @NotNull
            public static Color advertiserBackground() {
                JBColor jBColor = JBColor.namedColor("SearchEverywhere.Advertiser.background", 0xF2F2F2);
                if (jBColor == null) {
                    BigPopup.$$$reportNull$$$0(12);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$BigPopup";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "headerBackground";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "tabInsets";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "selectedTabColor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "selectedTabTextColor";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "searchFieldBackground";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "searchFieldBorderColor";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "searchFieldInsets";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "listSeparatorColor";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "listTitleLabelForeground";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "searchFieldGrayForeground";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[1] = "advertiserForeground";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[1] = "advertiserBorder";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[1] = "advertiserBackground";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static class TabbedPane {
            public static final Color ENABLED_SELECTED_COLOR = JBColor.namedColor("TabbedPane.underlineColor", JBColor.namedColor("TabbedPane.selectedColor", 4228041));
            public static final Color DISABLED_SELECTED_COLOR = JBColor.namedColor("TabbedPane.disabledUnderlineColor", JBColor.namedColor("TabbedPane.selectedDisabledColor", Gray.xAB));
            public static final Color DISABLED_TEXT_COLOR = JBColor.namedColor("TabbedPane.disabledForeground", JBColor.namedColor("TabbedPane.disabledText", Gray.x99));
            public static final Color HOVER_COLOR = JBColor.namedColor("TabbedPane.hoverColor", Gray.xD9);
            public static final Color FOCUS_COLOR = JBColor.namedColor("TabbedPane.focusColor", 14345453);
            public static final JBValue TAB_HEIGHT = new JBValue.UIInteger("TabbedPane.tabHeight", 32);
            public static final JBValue SELECTION_HEIGHT = new JBValue.UIInteger("TabbedPane.tabSelectionHeight", 3);
        }

        public static class Focus {
            private static final Color GRAPHITE_COLOR = new JBColor(new Color(-2137417827, true), new Color(6776937));

            @NotNull
            public static Color focusColor() {
                Color color = UIUtil.isGraphite() ? GRAPHITE_COLOR : JBColor.namedColor("Component.focusColor", JBColor.namedColor("Focus.borderColor", 9089771));
                if (color == null) {
                    Focus.$$$reportNull$$$0(0);
                }
                return color;
            }

            @NotNull
            public static Color defaultButtonColor() {
                Color color = UIUtil.isUnderDarcula() ? JBColor.namedColor("Button.default.focusColor", JBColor.namedColor("Focus.defaultButtonBorderColor", 9946099)) : Focus.focusColor();
                if (color == null) {
                    Focus.$$$reportNull$$$0(1);
                }
                return color;
            }

            @NotNull
            public static Color errorColor(boolean active) {
                JBColor jBColor = active ? JBColor.namedColor("Component.errorFocusColor", JBColor.namedColor("Focus.activeErrorBorderColor", 15023693)) : JBColor.namedColor("Component.inactiveErrorFocusColor", JBColor.namedColor("Focus.inactiveErrorBorderColor", 0xEBBCBC));
                if (jBColor == null) {
                    Focus.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            @NotNull
            public static Color warningColor(boolean active) {
                JBColor jBColor = active ? JBColor.namedColor("Component.warningFocusColor", JBColor.namedColor("Focus.activeWarningBorderColor", 14853434)) : JBColor.namedColor("Component.inactiveWarningFocusColor", JBColor.namedColor("Focus.inactiveWarningBorderColor", 16765829));
                if (jBColor == null) {
                    Focus.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$Focus";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "focusColor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "defaultButtonColor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "errorColor";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "warningColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static class Popup {
            public static Color headerBackground(boolean active) {
                return active ? JBColor.namedColor("Popup.Header.activeBackground", 0xE6E6E6) : JBColor.namedColor("Popup.Header.inactiveBackground", 0xEDEDED);
            }

            public static int headerHeight(boolean hasControls) {
                return hasControls ? JBUI.scale(28) : JBUI.scale(24);
            }

            public static Color borderColor(boolean active) {
                return active ? JBColor.namedColor("Popup.borderColor", JBColor.namedColor("Popup.Border.color", 0x808080)) : JBColor.namedColor("Popup.inactiveBorderColor", JBColor.namedColor("Popup.inactiveBorderColor", 0xAAAAAA));
            }

            public static Color toolbarPanelColor() {
                return JBColor.namedColor("Popup.Toolbar.background", 0xF7F7F7);
            }

            public static Color toolbarBorderColor() {
                return JBColor.namedColor("Popup.Toolbar.borderColor", JBColor.namedColor("Popup.Toolbar.Border.color", 0xF7F7F7));
            }

            public static int toolbarHeight() {
                return JBUI.scale(28);
            }

            public static Color separatorColor() {
                return JBColor.namedColor("Popup.separatorColor", new JBColor(Color.gray.brighter(), Gray.x51));
            }

            public static Color separatorTextColor() {
                return JBColor.namedColor("Popup.separatorForeground", Color.gray);
            }
        }

        public static class Label {
            @NotNull
            public static Color foreground(boolean selected) {
                JBColor jBColor = selected ? JBColor.namedColor("Label.selectedForeground", 0xFFFFFF) : JBColor.namedColor("Label.foreground", 0);
                if (jBColor == null) {
                    Label.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color foreground() {
                Color color = Label.foreground(false);
                if (color == null) {
                    Label.$$$reportNull$$$0(1);
                }
                return color;
            }

            @NotNull
            public static Color disabledForeground(boolean selected) {
                JBColor jBColor = selected ? JBColor.namedColor("Label.selectedDisabledForeground", 0x999999) : JBColor.namedColor("Label.disabledForeground", JBColor.namedColor("Label.disabledText", 0x999999));
                if (jBColor == null) {
                    Label.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            @NotNull
            public static Color disabledForeground() {
                Color color = Label.disabledForeground(false);
                if (color == null) {
                    Label.$$$reportNull$$$0(3);
                }
                return color;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$Label";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "foreground";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "disabledForeground";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static class ToolWindow {
            @NotNull
            public static Color tabSelectedBackground() {
                Color color = Registry.is("toolwindow.active.tab.use.contrast.background") ? Registry.getColor("toolwindow.active.tab.contrast.background.color", JBColor.GRAY) : JBColor.namedColor("ToolWindow.HeaderTab.selectedInactiveBackground", JBColor.namedColor("ToolWindow.header.tab.selected.background", 0xDEDEDE));
                if (color == null) {
                    ToolWindow.$$$reportNull$$$0(0);
                }
                return color;
            }

            @NotNull
            public static Color tabSelectedActiveBackground() {
                Color color = Registry.is("toolwindow.active.tab.use.contrast.background") ? Registry.getColor("toolwindow.active.tab.contrast.background.color", JBColor.GRAY) : JBColor.namedColor("ToolWindow.HeaderTab.selectedBackground", JBColor.namedColor("ToolWindow.header.tab.selected.active.background", 13685976));
                if (color == null) {
                    ToolWindow.$$$reportNull$$$0(1);
                }
                return color;
            }

            @NotNull
            public static Color tabHoveredBackground() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.HeaderTab.hoverInactiveBackground", JBColor.namedColor("ToolWindow.header.tab.hovered.background", ToolWindow.tabSelectedBackground()));
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            @NotNull
            public static Color tabHoveredActiveBackground() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.HeaderTab.hoverBackground", JBColor.namedColor("ToolWindow.header.tab.hovered.active.background", ToolWindow.tabSelectedActiveBackground()));
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            @NotNull
            public static Color tabSelectedBackground(boolean active) {
                Color color = active ? ToolWindow.tabSelectedActiveBackground() : ToolWindow.tabSelectedBackground();
                if (color == null) {
                    ToolWindow.$$$reportNull$$$0(4);
                }
                return color;
            }

            @NotNull
            public static Color tabHoveredBackground(boolean active) {
                Color color = active ? ToolWindow.tabHoveredActiveBackground() : ToolWindow.tabHoveredBackground();
                if (color == null) {
                    ToolWindow.$$$reportNull$$$0(5);
                }
                return color;
            }

            @NotNull
            public static Color headerBackground(boolean active) {
                Color color = active ? ToolWindow.headerActiveBackground() : ToolWindow.headerBackground();
                if (color == null) {
                    ToolWindow.$$$reportNull$$$0(6);
                }
                return color;
            }

            @NotNull
            public static Color headerBackground() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.Header.inactiveBackground", JBColor.namedColor("ToolWindow.header.background", 0xECECEC));
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(7);
                }
                return jBColor;
            }

            @NotNull
            public static Color headerBorderBackground() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.Header.borderColor", JBColor.namedColor("ToolWindow.header.border.background", 0xC9C9C9));
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(8);
                }
                return jBColor;
            }

            @NotNull
            public static Color headerActiveBackground() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.Header.background", JBColor.namedColor("ToolWindow.header.active.background", 14870252));
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(9);
                }
                return jBColor;
            }

            public static int tabVerticalPadding() {
                return JBUI.getInt("ToolWindow.tab.verticalPadding", 0);
            }

            @NotNull
            public static Border tabBorder() {
                Border border = JBUI.getBorder("ToolWindow.tabBorder", Borders.empty(1));
                if (border == null) {
                    ToolWindow.$$$reportNull$$$0(10);
                }
                return border;
            }

            @NotNull
            public static Font headerFont() {
                JBFont font = Fonts.label();
                Object size = UIManager.get("ToolWindow.header.font.size");
                if (size instanceof Integer) {
                    JBFont jBFont = font.deriveFont(((Integer)size).floatValue());
                    if (jBFont == null) {
                        ToolWindow.$$$reportNull$$$0(11);
                    }
                    return jBFont;
                }
                JBFont jBFont = font;
                if (jBFont == null) {
                    ToolWindow.$$$reportNull$$$0(12);
                }
                return jBFont;
            }

            public static float overrideHeaderFontSizeOffset() {
                Object offset = UIManager.get("ToolWindow.overridden.header.font.size.offset");
                if (offset instanceof Integer) {
                    return ((Integer)offset).floatValue();
                }
                return 0.0f;
            }

            @NotNull
            public static Color hoveredIconBackground() {
                JBColor jBColor = JBColor.namedColor("ToolWindow.HeaderCloseButton.background", JBColor.namedColor("ToolWindow.header.closeButton.background", 0xB9B9B9));
                if (jBColor == null) {
                    ToolWindow.$$$reportNull$$$0(13);
                }
                return jBColor;
            }

            @NotNull
            public static Icon closeTabIcon(boolean hovered) {
                Icon icon = hovered ? JBUI.getIcon("ToolWindow.header.closeButton.hovered.icon", AllIcons.Actions.CloseHovered) : JBUI.getIcon("ToolWindow.header.closeButton.icon", AllIcons.Actions.Close);
                if (icon == null) {
                    ToolWindow.$$$reportNull$$$0(14);
                }
                return icon;
            }

            @NotNull
            public static Icon comboTabIcon(boolean hovered) {
                Icon icon = hovered ? JBUI.getIcon("ToolWindow.header.comboButton.hovered.icon", AllIcons.General.ArrowDown) : JBUI.getIcon("ToolWindow.header.comboButton.icon", AllIcons.General.ArrowDown);
                if (icon == null) {
                    ToolWindow.$$$reportNull$$$0(15);
                }
                return icon;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$ToolWindow";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "tabSelectedBackground";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "tabSelectedActiveBackground";
                        break;
                    }
                    case 2: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "tabHoveredBackground";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "tabHoveredActiveBackground";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "headerBackground";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "headerBorderBackground";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[1] = "headerActiveBackground";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[1] = "tabBorder";
                        break;
                    }
                    case 11: 
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[1] = "headerFont";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray2;
                        objectArray2[1] = "hoveredIconBackground";
                        break;
                    }
                    case 14: {
                        objectArray = objectArray2;
                        objectArray2[1] = "closeTabIcon";
                        break;
                    }
                    case 15: {
                        objectArray = objectArray2;
                        objectArray2[1] = "comboTabIcon";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static class CustomFrameDecorations {
            @NotNull
            public static Color separatorForeground() {
                JBColor jBColor = JBColor.namedColor("Separator.separatorColor", new JBColor(0xCDCDCD, 0x515151));
                if (jBColor == null) {
                    CustomFrameDecorations.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color titlePaneBackground() {
                JBColor jBColor = JBColor.namedColor("TitlePane.background", CustomFrameDecorations.paneBackground());
                if (jBColor == null) {
                    CustomFrameDecorations.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color paneBackground() {
                JBColor jBColor = JBColor.namedColor("Panel.background", 0xCDCDCD);
                if (jBColor == null) {
                    CustomFrameDecorations.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$CustomFrameDecorations";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "separatorForeground";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "titlePaneBackground";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "paneBackground";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }

        public static class ActionButton {
            @NotNull
            public static Color pressedBackground() {
                JBColor jBColor = JBColor.namedColor("ActionButton.pressedBackground", Gray.xCF);
                if (jBColor == null) {
                    ActionButton.$$$reportNull$$$0(0);
                }
                return jBColor;
            }

            @NotNull
            public static Color pressedBorder() {
                JBColor jBColor = JBColor.namedColor("ActionButton.pressedBorderColor", Gray.xCF);
                if (jBColor == null) {
                    ActionButton.$$$reportNull$$$0(1);
                }
                return jBColor;
            }

            @NotNull
            public static Color hoverBackground() {
                JBColor jBColor = JBColor.namedColor("ActionButton.hoverBackground", Gray.xDF);
                if (jBColor == null) {
                    ActionButton.$$$reportNull$$$0(2);
                }
                return jBColor;
            }

            @NotNull
            public static Color hoverBorder() {
                JBColor jBColor = JBColor.namedColor("ActionButton.hoverBorderColor", Gray.xDF);
                if (jBColor == null) {
                    ActionButton.$$$reportNull$$$0(3);
                }
                return jBColor;
            }

            @NotNull
            public static Color hoverSeparatorColor() {
                JBColor jBColor = JBColor.namedColor("ActionButton.hoverSeparatorColor", new JBColor(Gray.xB3, Gray.x6B));
                if (jBColor == null) {
                    ActionButton.$$$reportNull$$$0(4);
                }
                return jBColor;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/util/ui/JBUI$CurrentTheme$ActionButton";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "pressedBackground";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "pressedBorder";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "hoverBackground";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "hoverBorder";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "hoverSeparatorColor";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }
    }

    public static abstract class RasterJBIcon
    extends ScaleContextSupport<ScaleContext>
    implements CopyableIcon {
        public RasterJBIcon() {
            super(ScaleContext.create());
        }
    }

    public static abstract class CachingScalableJBIcon<T extends CachingScalableJBIcon>
    extends ScalableJBIcon
    implements CopyableIcon {
        private T myScaledIconCache;

        protected CachingScalableJBIcon() {
        }

        protected CachingScalableJBIcon(@NotNull CachingScalableJBIcon icon) {
            if (icon == null) {
                CachingScalableJBIcon.$$$reportNull$$$0(0);
            }
            super(icon);
        }

        @NotNull
        public T scale(float scale) {
            if (scale == this.getScale()) {
                CachingScalableJBIcon cachingScalableJBIcon = this;
                if (cachingScalableJBIcon == null) {
                    CachingScalableJBIcon.$$$reportNull$$$0(1);
                }
                return (T)cachingScalableJBIcon;
            }
            if (this.myScaledIconCache == null || ((ScalableJBIcon)this.myScaledIconCache).getScale() != scale) {
                this.myScaledIconCache = this.copy();
                ((ScaleContextSupport)this.myScaledIconCache).updateScale(ScaleType.OBJ_SCALE.of(scale));
            }
            T t = this.myScaledIconCache;
            if (t == null) {
                CachingScalableJBIcon.$$$reportNull$$$0(2);
            }
            return t;
        }

        @NotNull
        public abstract T copy();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/JBUI$CachingScalableJBIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/JBUI$CachingScalableJBIcon";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "scale";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class ScalableJBIcon
    extends JBIcon
    implements ScalableIcon {
        protected ScalableJBIcon() {
        }

        protected ScalableJBIcon(@NotNull ScalableJBIcon icon) {
            if (icon == null) {
                ScalableJBIcon.$$$reportNull$$$0(0);
            }
            super(icon);
        }

        @Override
        public float getScale() {
            return (float)this.getScale(ScaleType.OBJ_SCALE);
        }

        @Override
        @NotNull
        public Icon scale(float scale) {
            this.updateScale(ScaleType.OBJ_SCALE.of(scale));
            ScalableJBIcon scalableJBIcon = this;
            if (scalableJBIcon == null) {
                ScalableJBIcon.$$$reportNull$$$0(1);
            }
            return scalableJBIcon;
        }

        @Override
        protected double scaleVal(double value) {
            return this.scaleVal(value, ScaleType.PIX_SCALE);
        }

        /*
         * WARNING - void declaration
         */
        protected double scaleVal(double value, @NotNull ScaleType scaleType) {
            void type;
            if (scaleType == null) {
                ScalableJBIcon.$$$reportNull$$$0(2);
            }
            switch (3.$SwitchMap$com$intellij$util$ui$JBUI$ScaleType[type.ordinal()]) {
                case 1: {
                    return super.scaleVal(value);
                }
                case 2: {
                    return value * this.getScale(ScaleType.SYS_SCALE);
                }
                case 3: {
                    return value * this.getScale(ScaleType.OBJ_SCALE);
                }
                case 4: {
                    return super.scaleVal(value * this.getScale(ScaleType.OBJ_SCALE));
                }
            }
            return value;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/JBUI$ScalableJBIcon";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/JBUI$ScalableJBIcon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "scale";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "scaleVal";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class JBIcon
    extends ScaleContextSupport<BaseScaleContext>
    implements Icon {
        private final Scaler myScaler;
        private boolean autoUpdateScaleContext;

        protected JBIcon() {
            super(BaseScaleContext.create());
            this.myScaler = new Scaler(){

                @Override
                protected double currentScale() {
                    if (autoUpdateScaleContext) {
                        ((BaseScaleContext)this.getScaleContext()).update();
                    }
                    return this.getScale(ScaleType.USR_SCALE);
                }
            };
            this.autoUpdateScaleContext = true;
        }

        protected JBIcon(@NotNull JBIcon icon) {
            if (icon == null) {
                JBIcon.$$$reportNull$$$0(0);
            }
            this();
            this.updateScaleContext((BaseScaleContext)icon.getScaleContext());
            this.myScaler.update(icon.myScaler);
            this.autoUpdateScaleContext = icon.autoUpdateScaleContext;
        }

        protected boolean isIconPreScaled() {
            return this.myScaler.isPreScaled();
        }

        protected void setIconPreScaled(boolean preScaled) {
            this.myScaler.setPreScaled(preScaled);
        }

        @NotNull
        public JBIcon withIconPreScaled(boolean preScaled) {
            this.setIconPreScaled(preScaled);
            JBIcon jBIcon = this;
            if (jBIcon == null) {
                JBIcon.$$$reportNull$$$0(1);
            }
            return jBIcon;
        }

        protected double scaleVal(double value) {
            return this.myScaler.scaleVal(value);
        }

        protected void setAutoUpdateScaleContext(boolean autoUpdate) {
            this.autoUpdateScaleContext = autoUpdate;
        }

        public String toString() {
            return this.getClass().getName() + " " + this.getIconWidth() + "x" + this.getIconHeight();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/JBUI$JBIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/JBUI$JBIcon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withIconPreScaled";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ScaleContextSupport<T extends BaseScaleContext>
    implements ScaleContextAware {
        @NotNull
        private final T myScaleContext;

        public ScaleContextSupport(@NotNull T ctx) {
            if (ctx == null) {
                ScaleContextSupport.$$$reportNull$$$0(0);
            }
            this.myScaleContext = ctx;
        }

        @NotNull
        public T getScaleContext() {
            T t = this.myScaleContext;
            if (t == null) {
                ScaleContextSupport.$$$reportNull$$$0(1);
            }
            return t;
        }

        @Override
        public boolean updateScaleContext(@Nullable BaseScaleContext ctx) {
            return ((BaseScaleContext)this.myScaleContext).update(ctx);
        }

        @Override
        public double getScale(@NotNull ScaleType type) {
            if (type == null) {
                ScaleContextSupport.$$$reportNull$$$0(2);
            }
            return ((BaseScaleContext)this.getScaleContext()).getScale(type);
        }

        @Override
        public boolean updateScale(@NotNull Scale scale) {
            if (scale == null) {
                ScaleContextSupport.$$$reportNull$$$0(3);
            }
            return ((BaseScaleContext)this.getScaleContext()).update(scale);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ctx";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/JBUI$ScaleContextSupport";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scale";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/JBUI$ScaleContextSupport";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScaleContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getScale";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "updateScale";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface ScaleContextAware {
        @NotNull
        public BaseScaleContext getScaleContext();

        public boolean updateScaleContext(@Nullable BaseScaleContext var1);

        public double getScale(@NotNull ScaleType var1);

        public boolean updateScale(@NotNull Scale var1);
    }

    public static class ScaleContext
    extends BaseScaleContext {
        protected Scale sysScale;
        @Nullable
        private WeakReference<Component> compRef;

        private ScaleContext() {
            this.sysScale = ScaleType.SYS_SCALE.of(JBUI.sysScale());
            this.pixScale = this.derivePixScale();
        }

        private ScaleContext(@NotNull Scale scale) {
            if (scale == null) {
                ScaleContext.$$$reportNull$$$0(0);
            }
            this();
            this.update(scale);
        }

        @NotNull
        public static ScaleContext createIdentity() {
            ScaleContext scaleContext = ScaleContext.create(ScaleType.USR_SCALE.of(1.0), ScaleType.SYS_SCALE.of(1.0));
            if (scaleContext == null) {
                ScaleContext.$$$reportNull$$$0(1);
            }
            return scaleContext;
        }

        @NotNull
        public static ScaleContext create(@Nullable BaseScaleContext ctx) {
            ScaleContext c = ScaleContext.createIdentity();
            c.update(ctx);
            ScaleContext scaleContext = c;
            if (scaleContext == null) {
                ScaleContext.$$$reportNull$$$0(2);
            }
            return scaleContext;
        }

        @NotNull
        public static ScaleContext create(@Nullable Component comp) {
            ScaleContext ctx = new ScaleContext(ScaleType.SYS_SCALE.of(JBUI.sysScale(comp)));
            if (comp != null) {
                ctx.compRef = new WeakReference<Component>(comp);
            }
            ScaleContext scaleContext = ctx;
            if (scaleContext == null) {
                ScaleContext.$$$reportNull$$$0(3);
            }
            return scaleContext;
        }

        @NotNull
        public static ScaleContext create(@Nullable Component component, @Nullable Graphics2D graphics) {
            ScaleContext scaleContext = ScaleContext.create(graphics);
            if (scaleContext == null) {
                ScaleContext.$$$reportNull$$$0(4);
            }
            return scaleContext;
        }

        @NotNull
        public static ScaleContext create(@Nullable GraphicsConfiguration gc) {
            ScaleContext scaleContext = new ScaleContext(ScaleType.SYS_SCALE.of(JBUI.sysScale(gc)));
            if (scaleContext == null) {
                ScaleContext.$$$reportNull$$$0(5);
            }
            return scaleContext;
        }

        @NotNull
        public static ScaleContext create(Graphics2D g) {
            ScaleContext scaleContext = new ScaleContext(ScaleType.SYS_SCALE.of(JBUI.sysScale(g)));
            if (scaleContext == null) {
                ScaleContext.$$$reportNull$$$0(6);
            }
            return scaleContext;
        }

        @NotNull
        public static ScaleContext create(@NotNull Scale scale) {
            if (scale == null) {
                ScaleContext.$$$reportNull$$$0(7);
            }
            ScaleContext scaleContext = new ScaleContext(scale);
            if (scaleContext == null) {
                ScaleContext.$$$reportNull$$$0(8);
            }
            return scaleContext;
        }

        @NotNull
        public static ScaleContext create(Scale ... scales) {
            if (scales == null) {
                ScaleContext.$$$reportNull$$$0(9);
            }
            ScaleContext ctx = ScaleContext.create();
            for (Scale s : scales) {
                ctx.update(s);
            }
            ScaleContext scaleContext = ctx;
            if (scaleContext == null) {
                ScaleContext.$$$reportNull$$$0(10);
            }
            return scaleContext;
        }

        @NotNull
        public static ScaleContext create() {
            ScaleContext scaleContext = new ScaleContext();
            if (scaleContext == null) {
                ScaleContext.$$$reportNull$$$0(11);
            }
            return scaleContext;
        }

        @Override
        protected double derivePixScale() {
            return UIUtil.isJreHiDPIEnabled() ? this.sysScale.value * super.derivePixScale() : super.derivePixScale();
        }

        @Override
        public double getScale(@NotNull ScaleType type) {
            if (type == null) {
                ScaleContext.$$$reportNull$$$0(12);
            }
            if (type == ScaleType.SYS_SCALE) {
                return this.sysScale.value;
            }
            return super.getScale(type);
        }

        @Override
        public boolean update() {
            Component comp;
            boolean updated = this.update(ScaleType.USR_SCALE.of(JBUI.scale(1.0f)));
            if (this.compRef != null && (comp = (Component)this.compRef.get()) != null) {
                updated = this.update(ScaleType.SYS_SCALE.of(JBUI.sysScale(comp))) || updated;
            }
            return this.onUpdated(updated);
        }

        @Override
        public boolean update(@NotNull Scale scale) {
            if (scale == null) {
                ScaleContext.$$$reportNull$$$0(13);
            }
            if (this.isScaleOverridden(scale)) {
                return false;
            }
            if (scale.type == ScaleType.SYS_SCALE) {
                boolean updated = !this.sysScale.equals(scale);
                this.sysScale = scale;
                return this.onUpdated(updated);
            }
            return super.update(scale);
        }

        @Override
        protected <T extends BaseScaleContext> boolean updateAll(@NotNull T ctx) {
            if (ctx == null) {
                ScaleContext.$$$reportNull$$$0(14);
            }
            boolean updated = super.updateAll(ctx);
            if (!(ctx instanceof ScaleContext)) {
                return updated;
            }
            ScaleContext context = (ScaleContext)ctx;
            if (this.compRef != null) {
                this.compRef.clear();
            }
            this.compRef = context.compRef;
            return this.update(context.sysScale) || updated;
        }

        @Override
        public boolean equals(Object obj) {
            if (super.equals(obj) && obj instanceof ScaleContext) {
                ScaleContext that = (ScaleContext)obj;
                return that.sysScale.value == this.sysScale.value;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Double.valueOf(this.sysScale.value).hashCode() * 100 + super.hashCode();
        }

        @Override
        public void dispose() {
            super.dispose();
            if (this.compRef != null) {
                this.compRef.clear();
            }
        }

        @Override
        @NotNull
        public <T extends BaseScaleContext> T copy() {
            ScaleContext ctx = ScaleContext.createIdentity();
            ctx.updateAll(this);
            ScaleContext scaleContext = ctx;
            if (scaleContext == null) {
                ScaleContext.$$$reportNull$$$0(15);
            }
            return (T)scaleContext;
        }

        @Override
        public String toString() {
            return this.usrScale + ", " + this.sysScale + ", " + this.objScale + ", " + this.pixScale;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 15: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scale";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/JBUI$ScaleContext";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scales";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ctx";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/JBUI$ScaleContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createIdentity";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 15: {
                    break;
                }
                case 7: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "getScale";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "updateAll";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 11: 
                case 15: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static class Cache<D>
        extends BaseScaleContext.Cache<D, ScaleContext> {
            public Cache(@NotNull Function<? super ScaleContext, ? extends D> dataProvider) {
                if (dataProvider == null) {
                    Cache.$$$reportNull$$$0(0);
                }
                super(dataProvider);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataProvider", "com/intellij/util/ui/JBUI$ScaleContext$Cache", "<init>"));
            }
        }
    }

    public static class BaseScaleContext {
        protected Scale usrScale = ScaleType.USR_SCALE.of(JBUI.scale(1.0f));
        protected Scale objScale = ScaleType.OBJ_SCALE.of(1.0);
        protected double pixScale = Scale.access$200(this.usrScale);
        private List<UpdateListener> listeners;
        private EnumSet<ScaleType> overriddenScales;

        private BaseScaleContext() {
        }

        @NotNull
        public static BaseScaleContext createIdentity() {
            BaseScaleContext baseScaleContext = BaseScaleContext.create(ScaleType.USR_SCALE.of(1.0));
            if (baseScaleContext == null) {
                BaseScaleContext.$$$reportNull$$$0(0);
            }
            return baseScaleContext;
        }

        @NotNull
        public static BaseScaleContext create(Scale ... scales) {
            if (scales == null) {
                BaseScaleContext.$$$reportNull$$$0(1);
            }
            BaseScaleContext ctx = BaseScaleContext.create();
            for (Scale s : scales) {
                ctx.update(s);
            }
            BaseScaleContext baseScaleContext = ctx;
            if (baseScaleContext == null) {
                BaseScaleContext.$$$reportNull$$$0(2);
            }
            return baseScaleContext;
        }

        @NotNull
        public static BaseScaleContext create() {
            BaseScaleContext baseScaleContext = new BaseScaleContext();
            if (baseScaleContext == null) {
                BaseScaleContext.$$$reportNull$$$0(3);
            }
            return baseScaleContext;
        }

        @NotNull
        public static BaseScaleContext create(@Nullable BaseScaleContext ctx) {
            BaseScaleContext c = BaseScaleContext.createIdentity();
            c.update(ctx);
            BaseScaleContext baseScaleContext = c;
            if (baseScaleContext == null) {
                BaseScaleContext.$$$reportNull$$$0(4);
            }
            return baseScaleContext;
        }

        protected double derivePixScale() {
            return this.usrScale.value * this.objScale.value;
        }

        public boolean overrideScale(@NotNull Scale scale) {
            if (scale == null) {
                BaseScaleContext.$$$reportNull$$$0(5);
            }
            if (this.overriddenScales != null) {
                this.overriddenScales.remove((Object)scale.type);
            }
            boolean updated = this.update(scale);
            if (this.overriddenScales == null) {
                this.overriddenScales = EnumSet.of(scale.type);
            } else {
                this.overriddenScales.add(scale.type);
            }
            return updated;
        }

        protected boolean isScaleOverridden(@NotNull Scale scale) {
            if (scale == null) {
                BaseScaleContext.$$$reportNull$$$0(6);
            }
            return this.overriddenScales != null && this.overriddenScales.contains((Object)scale.type);
        }

        public double getScale(@NotNull ScaleType type) {
            if (type == null) {
                BaseScaleContext.$$$reportNull$$$0(7);
            }
            switch (type) {
                case USR_SCALE: {
                    return this.usrScale.value;
                }
                case SYS_SCALE: {
                    return 1.0;
                }
                case OBJ_SCALE: {
                    return this.objScale.value;
                }
                case PIX_SCALE: {
                    return this.pixScale;
                }
            }
            return 1.0;
        }

        /*
         * WARNING - void declaration
         */
        public double apply(double value, ScaleType ... scaleTypeArray) {
            void types;
            if (scaleTypeArray == null) {
                BaseScaleContext.$$$reportNull$$$0(8);
            }
            for (void t : types) {
                value *= this.getScale((ScaleType)t);
            }
            return value;
        }

        public double apply(double value) {
            return value * this.getScale(ScaleType.PIX_SCALE);
        }

        protected boolean onUpdated(boolean updated) {
            if (updated) {
                this.pixScale = this.derivePixScale();
                this.notifyUpdateListeners();
            }
            return updated;
        }

        public boolean update() {
            return this.onUpdated(this.update(ScaleType.USR_SCALE.of(JBUI.scale(1.0f))));
        }

        public boolean update(@NotNull Scale scale) {
            if (scale == null) {
                BaseScaleContext.$$$reportNull$$$0(9);
            }
            if (this.isScaleOverridden(scale)) {
                return false;
            }
            boolean updated = false;
            switch (scale.type) {
                case USR_SCALE: {
                    updated = !this.usrScale.equals(scale);
                    this.usrScale = scale;
                    break;
                }
                case OBJ_SCALE: {
                    updated = !this.objScale.equals(scale);
                    this.objScale = scale;
                    break;
                }
                case SYS_SCALE: {
                    return false;
                }
            }
            return this.onUpdated(updated);
        }

        public boolean update(@Nullable BaseScaleContext ctx) {
            if (ctx == null) {
                return this.update();
            }
            return this.onUpdated(this.updateAll(ctx));
        }

        protected <T extends BaseScaleContext> boolean updateAll(@NotNull T ctx) {
            if (ctx == null) {
                BaseScaleContext.$$$reportNull$$$0(10);
            }
            boolean updated = this.update(ctx.usrScale);
            return this.update(ctx.objScale) || updated;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof BaseScaleContext)) {
                return false;
            }
            BaseScaleContext that = (BaseScaleContext)obj;
            return that.usrScale.value == this.usrScale.value && that.objScale.value == this.objScale.value;
        }

        public int hashCode() {
            return BaseScaleContext.hash(this.usrScale.value) * 31 + BaseScaleContext.hash(this.objScale.value);
        }

        private static int hash(double value) {
            long bits = Double.doubleToLongBits(value);
            return (int)(bits ^ bits >>> 32);
        }

        public void dispose() {
            this.listeners = null;
        }

        public void addUpdateListener(@NotNull UpdateListener l) {
            if (l == null) {
                BaseScaleContext.$$$reportNull$$$0(11);
            }
            if (this.listeners == null) {
                this.listeners = new ArrayList<UpdateListener>(1);
            }
            this.listeners.add(l);
        }

        public void removeUpdateListener(@NotNull UpdateListener l) {
            if (l == null) {
                BaseScaleContext.$$$reportNull$$$0(12);
            }
            if (this.listeners != null) {
                this.listeners.remove(l);
            }
        }

        protected void notifyUpdateListeners() {
            if (this.listeners == null) {
                return;
            }
            for (UpdateListener l : this.listeners) {
                l.contextUpdated();
            }
        }

        @NotNull
        public <T extends BaseScaleContext> T copy() {
            BaseScaleContext ctx = BaseScaleContext.createIdentity();
            ctx.updateAll(this);
            BaseScaleContext baseScaleContext = ctx;
            if (baseScaleContext == null) {
                BaseScaleContext.$$$reportNull$$$0(13);
            }
            return (T)baseScaleContext;
        }

        public String toString() {
            return this.usrScale + ", " + this.objScale + ", " + this.pixScale;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/JBUI$BaseScaleContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scales";
                    break;
                }
                case 5: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scale";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ctx";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "l";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createIdentity";
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/JBUI$BaseScaleContext";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "overrideScale";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isScaleOverridden";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getScale";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "updateAll";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "addUpdateListener";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "removeUpdateListener";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static class Cache<D, S extends BaseScaleContext> {
            private final Function<? super S, ? extends D> myDataProvider;
            private final AtomicReference<Pair<Double, D>> myData;

            public Cache(@NotNull Function<? super S, ? extends D> dataProvider) {
                if (dataProvider == null) {
                    Cache.$$$reportNull$$$0(0);
                }
                this.myData = new AtomicReference<Object>(null);
                this.myDataProvider = dataProvider;
            }

            @Nullable
            public D getOrProvide(@NotNull S ctx) {
                if (ctx == null) {
                    Cache.$$$reportNull$$$0(1);
                }
                Pair<Double, D> data = this.myData.get();
                double scale = ((BaseScaleContext)ctx).getScale(ScaleType.PIX_SCALE);
                if (data == null || Double.compare(scale, (Double)data.first) != 0) {
                    data = Pair.create(scale, this.myDataProvider.fun(ctx));
                    this.myData.set(data);
                }
                return (D)data.second;
            }

            public void clear() {
                this.myData.set(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataProvider";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ctx";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/util/ui/JBUI$BaseScaleContext$Cache";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getOrProvide";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        public static interface UpdateListener {
            public void contextUpdated();
        }
    }

    public static abstract class Scaler {
        protected double initialScale = this.currentScale();

        private double alignedScale() {
            return this.currentScale() / this.initialScale;
        }

        protected boolean isPreScaled() {
            return this.initialScale != 1.0;
        }

        protected void setPreScaled(boolean preScaled) {
            this.initialScale = preScaled ? this.currentScale() : 1.0;
        }

        public double scaleVal(double value) {
            return value * this.alignedScale();
        }

        protected abstract double currentScale();

        public boolean update(@NotNull Scaler scaler) {
            if (scaler == null) {
                Scaler.$$$reportNull$$$0(0);
            }
            boolean updated = this.initialScale != scaler.initialScale;
            this.initialScale = scaler.initialScale;
            return updated;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scaler", "com/intellij/util/ui/JBUI$Scaler", "update"));
        }
    }

    public static class Panels {
        @NotNull
        public static BorderLayoutPanel simplePanel() {
            BorderLayoutPanel borderLayoutPanel = new BorderLayoutPanel();
            if (borderLayoutPanel == null) {
                Panels.$$$reportNull$$$0(0);
            }
            return borderLayoutPanel;
        }

        @NotNull
        public static BorderLayoutPanel simplePanel(Component comp) {
            BorderLayoutPanel borderLayoutPanel = Panels.simplePanel().addToCenter(comp);
            if (borderLayoutPanel == null) {
                Panels.$$$reportNull$$$0(1);
            }
            return borderLayoutPanel;
        }

        @NotNull
        public static BorderLayoutPanel simplePanel(int hgap, int vgap) {
            BorderLayoutPanel borderLayoutPanel = new BorderLayoutPanel(hgap, vgap);
            if (borderLayoutPanel == null) {
                Panels.$$$reportNull$$$0(2);
            }
            return borderLayoutPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBUI$Panels", "simplePanel"));
        }
    }

    public static class Borders {
        @NotNull
        public static JBEmptyBorder empty(int top, int left, int bottom, int right) {
            if (top == 0 && left == 0 && bottom == 0 && right == 0) {
                JBEmptyBorder jBEmptyBorder = SHARED_EMPTY_INSTANCE;
                if (jBEmptyBorder == null) {
                    Borders.$$$reportNull$$$0(0);
                }
                return jBEmptyBorder;
            }
            JBEmptyBorder jBEmptyBorder = new JBEmptyBorder(top, left, bottom, right);
            if (jBEmptyBorder == null) {
                Borders.$$$reportNull$$$0(1);
            }
            return jBEmptyBorder;
        }

        @NotNull
        public static JBEmptyBorder empty(int topAndBottom, int leftAndRight) {
            JBEmptyBorder jBEmptyBorder = Borders.empty(topAndBottom, leftAndRight, topAndBottom, leftAndRight);
            if (jBEmptyBorder == null) {
                Borders.$$$reportNull$$$0(2);
            }
            return jBEmptyBorder;
        }

        @NotNull
        public static JBEmptyBorder emptyTop(int offset) {
            JBEmptyBorder jBEmptyBorder = Borders.empty(offset, 0, 0, 0);
            if (jBEmptyBorder == null) {
                Borders.$$$reportNull$$$0(3);
            }
            return jBEmptyBorder;
        }

        @NotNull
        public static JBEmptyBorder emptyLeft(int offset) {
            JBEmptyBorder jBEmptyBorder = Borders.empty(0, offset, 0, 0);
            if (jBEmptyBorder == null) {
                Borders.$$$reportNull$$$0(4);
            }
            return jBEmptyBorder;
        }

        @NotNull
        public static JBEmptyBorder emptyBottom(int offset) {
            JBEmptyBorder jBEmptyBorder = Borders.empty(0, 0, offset, 0);
            if (jBEmptyBorder == null) {
                Borders.$$$reportNull$$$0(5);
            }
            return jBEmptyBorder;
        }

        @NotNull
        public static JBEmptyBorder emptyRight(int offset) {
            JBEmptyBorder jBEmptyBorder = Borders.empty(0, 0, 0, offset);
            if (jBEmptyBorder == null) {
                Borders.$$$reportNull$$$0(6);
            }
            return jBEmptyBorder;
        }

        @NotNull
        public static JBEmptyBorder empty() {
            JBEmptyBorder jBEmptyBorder = Borders.empty(0, 0, 0, 0);
            if (jBEmptyBorder == null) {
                Borders.$$$reportNull$$$0(7);
            }
            return jBEmptyBorder;
        }

        @NotNull
        public static Border empty(int offsets) {
            JBEmptyBorder jBEmptyBorder = Borders.empty(offsets, offsets, offsets, offsets);
            if (jBEmptyBorder == null) {
                Borders.$$$reportNull$$$0(8);
            }
            return jBEmptyBorder;
        }

        @NotNull
        public static Border customLine(Color color, int top, int left, int bottom, int right) {
            CustomLineBorder customLineBorder = new CustomLineBorder(color, JBUI.insets(top, left, bottom, right));
            if (customLineBorder == null) {
                Borders.$$$reportNull$$$0(9);
            }
            return customLineBorder;
        }

        @NotNull
        public static Border customLine(Color color, int thickness) {
            Border border = Borders.customLine(color, thickness, thickness, thickness, thickness);
            if (border == null) {
                Borders.$$$reportNull$$$0(10);
            }
            return border;
        }

        @NotNull
        public static Border customLine(Color color) {
            Border border = Borders.customLine(color, 1);
            if (border == null) {
                Borders.$$$reportNull$$$0(11);
            }
            return border;
        }

        @NotNull
        public static Border merge(@Nullable Border source, @NotNull Border extra, boolean extraIsOutside) {
            if (extra == null) {
                Borders.$$$reportNull$$$0(12);
            }
            if (source == null) {
                Border border = extra;
                if (border == null) {
                    Borders.$$$reportNull$$$0(13);
                }
                return border;
            }
            CompoundBorder compoundBorder = new CompoundBorder(extraIsOutside ? extra : source, extraIsOutside ? source : extra);
            if (compoundBorder == null) {
                Borders.$$$reportNull$$$0(14);
            }
            return compoundBorder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 12: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 12: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/JBUI$Borders";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extra";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "empty";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "emptyTop";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "emptyLeft";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "emptyBottom";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "emptyRight";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "customLine";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/JBUI$Borders";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "merge";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "merge";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 12: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Fonts {
        @NotNull
        public static JBFont label() {
            JBFont jBFont = JBFont.create(UIManager.getFont("Label.font"), false);
            if (jBFont == null) {
                Fonts.$$$reportNull$$$0(0);
            }
            return jBFont;
        }

        @NotNull
        public static JBFont label(float size) {
            JBFont jBFont = Fonts.label().deriveFont(JBUI.scale(size));
            if (jBFont == null) {
                Fonts.$$$reportNull$$$0(1);
            }
            return jBFont;
        }

        @NotNull
        public static JBFont smallFont() {
            JBFont jBFont = Fonts.label().deriveFont(UIUtil.getFontSize(UIUtil.FontSize.SMALL));
            if (jBFont == null) {
                Fonts.$$$reportNull$$$0(2);
            }
            return jBFont;
        }

        @NotNull
        public static JBFont miniFont() {
            JBFont jBFont = Fonts.label().deriveFont(UIUtil.getFontSize(UIUtil.FontSize.MINI));
            if (jBFont == null) {
                Fonts.$$$reportNull$$$0(3);
            }
            return jBFont;
        }

        @NotNull
        public static JBFont create(String fontFamily, int size) {
            JBFont jBFont = JBFont.create(new Font(fontFamily, 0, size));
            if (jBFont == null) {
                Fonts.$$$reportNull$$$0(4);
            }
            return jBFont;
        }

        @NotNull
        public static JBFont toolbarFont() {
            JBFont jBFont = SystemInfo.isMac ? Fonts.smallFont() : Fonts.label();
            if (jBFont == null) {
                Fonts.$$$reportNull$$$0(5);
            }
            return jBFont;
        }

        @NotNull
        public static JBFont toolbarSmallComboBoxFont() {
            JBFont jBFont = Fonts.label(11.0f);
            if (jBFont == null) {
                Fonts.$$$reportNull$$$0(6);
            }
            return jBFont;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/util/ui/JBUI$Fonts";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "label";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "smallFont";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "miniFont";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toolbarFont";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toolbarSmallComboBoxFont";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class Scale {
        private final double value;
        private final ScaleType type;
        private static final ThreadLocal<EnumMap<ScaleType, TDoubleObjectHashMap<Scale>>> cache = ThreadLocal.withInitial(() -> new EnumMap(ScaleType.class));

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Scale create(double value, @NotNull ScaleType scaleType) {
            Scale scale;
            void type;
            EnumMap<ScaleType, TDoubleObjectHashMap<Scale>> emap;
            TDoubleObjectHashMap map;
            if (scaleType == null) {
                Scale.$$$reportNull$$$0(0);
            }
            if ((map = (emap = cache.get()).get(type)) == null) {
                map = new TDoubleObjectHashMap();
                emap.put((ScaleType)type, (TDoubleObjectHashMap<Scale>)map);
            }
            if ((scale = (Scale)map.get(value)) != null) {
                Scale scale2 = scale;
                if (scale2 == null) {
                    Scale.$$$reportNull$$$0(1);
                }
                return scale2;
            }
            scale = new Scale(value, (ScaleType)type);
            map.put(value, (Object)scale);
            Scale scale3 = scale;
            if (scale3 == null) {
                Scale.$$$reportNull$$$0(2);
            }
            return scale3;
        }

        /*
         * WARNING - void declaration
         */
        private Scale(double value, @NotNull ScaleType scaleType) {
            void type;
            if (scaleType == null) {
                Scale.$$$reportNull$$$0(3);
            }
            this.value = value;
            this.type = type;
        }

        public double value() {
            return this.value;
        }

        @NotNull
        public ScaleType type() {
            ScaleType scaleType = this.type;
            if (scaleType == null) {
                Scale.$$$reportNull$$$0(4);
            }
            return scaleType;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public String toString() {
            return "[" + this.type.name() + " " + this.value + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/ui/JBUI$Scale";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/ui/JBUI$Scale";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum ScaleType {
        USR_SCALE,
        SYS_SCALE,
        OBJ_SCALE,
        PIX_SCALE;


        @NotNull
        public Scale of(double value) {
            Scale scale = Scale.create(value, this);
            if (scale == null) {
                ScaleType.$$$reportNull$$$0(0);
            }
            return scale;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/JBUI$ScaleType", "of"));
        }
    }
}

