/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.io.URLUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ResourceUtil {
    private ResourceUtil() {
    }

    public static URL getResource(@NotNull Class loaderClass, @NonNls @NotNull String basePath, @NonNls @NotNull String fileName) {
        if (loaderClass == null) {
            ResourceUtil.$$$reportNull$$$0(0);
        }
        if (basePath == null) {
            ResourceUtil.$$$reportNull$$$0(1);
        }
        if (fileName == null) {
            ResourceUtil.$$$reportNull$$$0(2);
        }
        return ResourceUtil.getResource(loaderClass.getClassLoader(), basePath, fileName);
    }

    public static URL getResource(@NotNull ClassLoader loader, @NonNls @NotNull String basePath, @NonNls @NotNull String fileName) {
        if (loader == null) {
            ResourceUtil.$$$reportNull$$$0(3);
        }
        if (basePath == null) {
            ResourceUtil.$$$reportNull$$$0(4);
        }
        if (fileName == null) {
            ResourceUtil.$$$reportNull$$$0(5);
        }
        String fixedPath = StringUtil.trimStart(StringUtil.trimEnd(basePath, "/"), "/");
        List<String> bundles = ResourceUtil.calculateBundleNames(fixedPath, Locale.getDefault());
        for (String bundle : bundles) {
            URL url = loader.getResource(bundle + "/" + fileName);
            if (url == null) continue;
            try {
                url.openConnection();
            }
            catch (IOException e) {
                continue;
            }
            return url;
        }
        return loader.getResource(fixedPath + "/" + fileName);
    }

    @NotNull
    private static List<String> calculateBundleNames(@NotNull String baseName, @NotNull Locale locale) {
        if (baseName == null) {
            ResourceUtil.$$$reportNull$$$0(6);
        }
        if (locale == null) {
            ResourceUtil.$$$reportNull$$$0(7);
        }
        ArrayList<String> result = new ArrayList<String>(3);
        result.add(0, baseName);
        String language = locale.getLanguage();
        int languageLength = language.length();
        String country = locale.getCountry();
        int countryLength = country.length();
        String variant = locale.getVariant();
        int variantLength = variant.length();
        if (languageLength + countryLength + variantLength == 0) {
            ArrayList<String> arrayList = result;
            if (arrayList == null) {
                ResourceUtil.$$$reportNull$$$0(8);
            }
            return arrayList;
        }
        StringBuilder temp = new StringBuilder(baseName);
        temp.append('_');
        temp.append(language);
        if (languageLength > 0) {
            result.add(0, temp.toString());
        }
        if (countryLength + variantLength == 0) {
            ArrayList<String> arrayList = result;
            if (arrayList == null) {
                ResourceUtil.$$$reportNull$$$0(9);
            }
            return arrayList;
        }
        temp.append('_');
        temp.append(country);
        if (countryLength > 0) {
            result.add(0, temp.toString());
        }
        if (variantLength == 0) {
            ArrayList<String> arrayList = result;
            if (arrayList == null) {
                ResourceUtil.$$$reportNull$$$0(10);
            }
            return arrayList;
        }
        temp.append('_');
        temp.append(variant);
        result.add(0, temp.toString());
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            ResourceUtil.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    public static String loadText(@NotNull URL url) throws IOException {
        String string;
        if (url == null) {
            ResourceUtil.$$$reportNull$$$0(12);
        }
        BufferedInputStream inputStream = new BufferedInputStream(URLUtil.openStream(url));
        try (InputStreamReader reader = new InputStreamReader((InputStream)inputStream, CharsetToolkit.UTF8_CHARSET);){
            int length;
            StringBuilder text = new StringBuilder();
            char[] buf = new char[5000];
            while (reader.ready() && (length = reader.read(buf)) != -1) {
                text.append(buf, 0, length);
            }
            String string2 = text.toString();
            string = string2;
        }
        if (string == null) {
            ResourceUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loaderClass";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ResourceUtil";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ResourceUtil";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateBundleNames";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResource";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calculateBundleNames";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

