/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.CaptionPanel;
import com.intellij.ui.EngravedLabel;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.plaf.basic.BasicHTML;

public class TitlePanel
extends CaptionPanel {
    private final JLabel myLabel;
    private final Icon myRegular;
    private final Icon myInactive;
    private boolean myHtml;

    public TitlePanel() {
        this(null, null);
    }

    public TitlePanel(Icon regular, Icon inactive) {
        this.myRegular = regular;
        this.myInactive = inactive;
        this.myLabel = new EngravedLabel();
        this.myLabel.setForeground(JBColor.foreground());
        this.myLabel.setHorizontalAlignment(0);
        this.myLabel.setVerticalAlignment(0);
        this.myLabel.setBorder(JBUI.Borders.empty(1, 10, 2, 10));
        this.add((Component)this.myLabel, "Center");
        this.setActive(false);
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        this.myLabel.setIcon(active ? this.myRegular : this.myInactive);
        this.myLabel.setForeground(active ? UIUtil.getLabelForeground() : UIUtil.getLabelDisabledForeground());
    }

    public void setText(String titleText) {
        this.myHtml = BasicHTML.isHTMLString(titleText);
        this.myLabel.setText(titleText);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(10, this.getPreferredSize().height);
    }

    @Override
    public Dimension getPreferredSize() {
        String text = this.myLabel.getText();
        if (text == null || text.trim().isEmpty()) {
            return JBUI.emptySize();
        }
        Dimension preferredSize = super.getPreferredSize();
        preferredSize.height = JBUI.CurrentTheme.Popup.headerHeight(this.containsSettingsControls());
        int maxWidth = JBUI.scale(350);
        if (!this.myHtml && preferredSize.width > maxWidth) {
            return new Dimension(maxWidth, preferredSize.height);
        }
        return preferredSize;
    }
}

