/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.JBColor;
import com.intellij.ui.MixedColorProducer;
import com.intellij.util.NotNullProducer;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorUtil {
    private ColorUtil() {
    }

    @NotNull
    public static Color marker(final @NotNull String name) {
        if (name == null) {
            ColorUtil.$$$reportNull$$$0(0);
        }
        JBColor jBColor = new JBColor(() -> {
            throw new AssertionError((Object)name);
        }){

            @Override
            public boolean equals(Object obj) {
                return this == obj;
            }

            @Override
            public String toString() {
                return name;
            }
        };
        if (jBColor == null) {
            ColorUtil.$$$reportNull$$$0(1);
        }
        return jBColor;
    }

    @NotNull
    public static Color softer(@NotNull Color color) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(2);
        }
        if (color.getBlue() > 220 && color.getRed() > 220 && color.getGreen() > 220) {
            Color color2 = color;
            if (color2 == null) {
                ColorUtil.$$$reportNull$$$0(3);
            }
            return color2;
        }
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        Color color3 = Color.getHSBColor(hsb[0], 0.6f * hsb[1], hsb[2]);
        if (color3 == null) {
            ColorUtil.$$$reportNull$$$0(4);
        }
        return color3;
    }

    @NotNull
    public static Color darker(@NotNull Color color, int tones) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(5);
        }
        Color color2 = ColorUtil.hackBrightness(color, tones, 0.9090909f);
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(6);
        }
        return color2;
    }

    @NotNull
    public static Color brighter(@NotNull Color color, int tones) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(7);
        }
        Color color2 = ColorUtil.hackBrightness(color, tones, 1.1f);
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(8);
        }
        return color2;
    }

    @NotNull
    public static Color hackBrightness(@NotNull Color color, int howMuch, float hackValue) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(9);
        }
        Color color2 = ColorUtil.hackBrightness(color.getRed(), color.getGreen(), color.getBlue(), howMuch, hackValue);
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(10);
        }
        return color2;
    }

    @NotNull
    public static Color hackBrightness(int r, int g, int b, int howMuch, float hackValue) {
        float[] hsb = Color.RGBtoHSB(r, g, b, null);
        float brightness = hsb[2];
        for (int i = 0; i < howMuch && (brightness = Math.min(1.0f, Math.max(0.0f, brightness * hackValue))) != 0.0f && brightness != 1.0f; ++i) {
        }
        Color color = Color.getHSBColor(hsb[0], hsb[1], brightness);
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(11);
        }
        return color;
    }

    @NotNull
    public static Color saturate(@NotNull Color color, int tones) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(12);
        }
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float saturation = hsb[1];
        for (int i = 0; i < tones && (saturation = Math.min(1.0f, saturation * 1.1f)) != 1.0f; ++i) {
        }
        Color color2 = Color.getHSBColor(hsb[0], saturation, hsb[2]);
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(13);
        }
        return color2;
    }

    @NotNull
    public static Color desaturate(@NotNull Color color, int tones) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(14);
        }
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float saturation = hsb[1];
        for (int i = 0; i < tones && (saturation = Math.max(0.0f, saturation / 1.1f)) != 0.0f; ++i) {
        }
        Color color2 = Color.getHSBColor(hsb[0], saturation, hsb[2]);
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(15);
        }
        return color2;
    }

    @NotNull
    public static Color dimmer(@NotNull Color color) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(16);
        }
        NotNullProducer<Color> func = () -> {
            float[] rgb = color.getRGBColorComponents(null);
            float alpha = 0.8f;
            float rem = 1.0f - alpha;
            return new Color(rgb[0] * alpha + rem, rgb[1] * alpha + rem, rgb[2] * alpha + rem);
        };
        Color color2 = ColorUtil.wrap(color, func);
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(17);
        }
        return color2;
    }

    private static Color wrap(@NotNull Color color, NotNullProducer<Color> func) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(18);
        }
        return color instanceof JBColor ? new JBColor(func) : func.produce();
    }

    private static int shift(int colorComponent, double d) {
        int n = (int)((double)colorComponent * d);
        return n > 255 ? 255 : (n < 0 ? 0 : n);
    }

    @NotNull
    public static Color shift(@NotNull Color c, double d) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(19);
        }
        NotNullProducer<Color> func = () -> new Color(ColorUtil.shift(c.getRed(), d), ColorUtil.shift(c.getGreen(), d), ColorUtil.shift(c.getBlue(), d), c.getAlpha());
        Color color = ColorUtil.wrap(c, func);
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(20);
        }
        return color;
    }

    @NotNull
    public static Color withAlpha(@NotNull Color c, double a) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(21);
        }
        Color color = ColorUtil.toAlpha(c, (int)(255.0 * a));
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(22);
        }
        return color;
    }

    @NotNull
    static Color srcOver(@NotNull Color c, @NotNull Color b) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(23);
        }
        if (b == null) {
            ColorUtil.$$$reportNull$$$0(24);
        }
        float[] rgba = new float[4];
        rgba = c.getRGBComponents(rgba);
        float[] brgba = new float[4];
        brgba = b.getRGBComponents(brgba);
        float dsta = 1.0f - rgba[3];
        Color color = new Color(rgba[0] * rgba[3] + dsta * brgba[0], rgba[1] * rgba[3] + dsta * brgba[1], rgba[2] * rgba[3] + dsta * brgba[2], 1.0f);
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(25);
        }
        return color;
    }

    @NotNull
    public static Color withPreAlpha(@NotNull Color c, double a) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(26);
        }
        float[] rgba = new float[4];
        rgba = ColorUtil.withAlpha(c, a).getRGBComponents(rgba);
        Color color = new Color(rgba[0] * rgba[3], rgba[1] * rgba[3], rgba[2] * rgba[3], 1.0f);
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(27);
        }
        return color;
    }

    @NotNull
    public static Color toAlpha(@Nullable Color color, int a) {
        Color c = color == null ? Color.black : color;
        NotNullProducer<Color> func = () -> new Color(c.getRed(), c.getGreen(), c.getBlue(), a);
        Color color2 = ColorUtil.wrap(c, func);
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(28);
        }
        return color2;
    }

    @NotNull
    public static String toHex(@NotNull Color c) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(29);
        }
        String string = ColorUtil.toHex(c, false);
        if (string == null) {
            ColorUtil.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    public static String toHex(@NotNull Color c, boolean withAlpha) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(31);
        }
        String R = Integer.toHexString(c.getRed());
        String G = Integer.toHexString(c.getGreen());
        String B = Integer.toHexString(c.getBlue());
        String rgbHex = (R.length() < 2 ? "0" : "") + R + (G.length() < 2 ? "0" : "") + G + (B.length() < 2 ? "0" : "") + B;
        if (!withAlpha) {
            String string = rgbHex;
            if (string == null) {
                ColorUtil.$$$reportNull$$$0(32);
            }
            return string;
        }
        String A = Integer.toHexString(c.getAlpha());
        String string = rgbHex + (A.length() < 2 ? "0" : "") + A;
        if (string == null) {
            ColorUtil.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    public static String toHtmlColor(@NotNull Color c) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(34);
        }
        String string = "#" + ColorUtil.toHex(c);
        if (string == null) {
            ColorUtil.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    public static Color fromHex(@NotNull String str) {
        if (str == null) {
            ColorUtil.$$$reportNull$$$0(36);
        }
        int pos = str.startsWith("#") ? 1 : (str.startsWith("0x") ? 2 : 0);
        int len = str.length() - pos;
        if (len == 3) {
            Color color = new Color(ColorUtil.fromHex1(str, pos), ColorUtil.fromHex1(str, pos + 1), ColorUtil.fromHex1(str, pos + 2), 255);
            if (color == null) {
                ColorUtil.$$$reportNull$$$0(37);
            }
            return color;
        }
        if (len == 4) {
            Color color = new Color(ColorUtil.fromHex1(str, pos), ColorUtil.fromHex1(str, pos + 1), ColorUtil.fromHex1(str, pos + 2), ColorUtil.fromHex1(str, pos + 3));
            if (color == null) {
                ColorUtil.$$$reportNull$$$0(38);
            }
            return color;
        }
        if (len == 6) {
            Color color = new Color(ColorUtil.fromHex2(str, pos), ColorUtil.fromHex2(str, pos + 2), ColorUtil.fromHex2(str, pos + 4), 255);
            if (color == null) {
                ColorUtil.$$$reportNull$$$0(39);
            }
            return color;
        }
        if (len == 8) {
            Color color = new Color(ColorUtil.fromHex2(str, pos), ColorUtil.fromHex2(str, pos + 2), ColorUtil.fromHex2(str, pos + 4), ColorUtil.fromHex2(str, pos + 6));
            if (color == null) {
                ColorUtil.$$$reportNull$$$0(40);
            }
            return color;
        }
        throw new IllegalArgumentException("unsupported length:" + str);
    }

    private static int fromHex(@NotNull String str, int pos) {
        char ch;
        if (str == null) {
            ColorUtil.$$$reportNull$$$0(41);
        }
        if ((ch = str.charAt(pos)) >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        throw new IllegalArgumentException("unsupported char at " + pos + ":" + str);
    }

    private static int fromHex1(@NotNull String str, int pos) {
        if (str == null) {
            ColorUtil.$$$reportNull$$$0(42);
        }
        return 17 * ColorUtil.fromHex(str, pos);
    }

    private static int fromHex2(@NotNull String str, int pos) {
        if (str == null) {
            ColorUtil.$$$reportNull$$$0(43);
        }
        return 16 * ColorUtil.fromHex(str, pos) + ColorUtil.fromHex(str, pos + 1);
    }

    @Nullable
    public static Color fromHex(@Nullable String str, @Nullable Color defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return ColorUtil.fromHex(str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean isDark(@NotNull Color c) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(44);
        }
        return (ColorUtil.getLuminance(c) + 0.05) / 0.05 < 4.5;
    }

    public static boolean areContrasting(@NotNull Color c1, @NotNull Color c2) {
        if (c1 == null) {
            ColorUtil.$$$reportNull$$$0(45);
        }
        if (c2 == null) {
            ColorUtil.$$$reportNull$$$0(46);
        }
        return Double.compare(ColorUtil.getContrast(c1, c2), 4.5) >= 0;
    }

    public static double getContrast(@NotNull Color c1, @NotNull Color c2) {
        if (c1 == null) {
            ColorUtil.$$$reportNull$$$0(47);
        }
        if (c2 == null) {
            ColorUtil.$$$reportNull$$$0(48);
        }
        double l1 = ColorUtil.getLuminance(c1);
        double l2 = ColorUtil.getLuminance(c2);
        return (Math.max(l1, l2) + 0.05) / (Math.min(l2, l1) + 0.05);
    }

    public static double getLuminance(@NotNull Color color) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(49);
        }
        return ColorUtil.getLinearRGBComponentValue((double)color.getRed() / 255.0) * 0.2126 + ColorUtil.getLinearRGBComponentValue((double)color.getGreen() / 255.0) * 0.7152 + ColorUtil.getLinearRGBComponentValue((double)color.getBlue() / 255.0) * 0.0722;
    }

    private static double getLinearRGBComponentValue(double colorValue) {
        if (colorValue <= 0.03928) {
            return colorValue / 12.92;
        }
        return Math.pow((colorValue + 0.055) / 1.055, 2.4);
    }

    @NotNull
    public static Color mix(@NotNull Color c1, @NotNull Color c2, double balance) {
        if (c1 == null) {
            ColorUtil.$$$reportNull$$$0(50);
        }
        if (c2 == null) {
            ColorUtil.$$$reportNull$$$0(51);
        }
        if (balance <= 0.0) {
            Color color = c1;
            if (color == null) {
                ColorUtil.$$$reportNull$$$0(52);
            }
            return color;
        }
        if (balance >= 1.0) {
            Color color = c2;
            if (color == null) {
                ColorUtil.$$$reportNull$$$0(53);
            }
            return color;
        }
        MixedColorProducer func = new MixedColorProducer(c1, c2, balance);
        Color color = c1 instanceof JBColor || c2 instanceof JBColor ? new JBColor(func) : (Color)func.produce();
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(54);
        }
        return color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 22: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 52: 
            case 53: 
            case 54: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 22: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 52: 
            case 53: 
            case 54: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 22: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 52: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ColorUtil";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 29: 
            case 31: 
            case 34: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 36: 
            case 41: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 45: 
            case 47: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 46: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ColorUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "marker";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "softer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "darker";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "brighter";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "hackBrightness";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "saturate";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "desaturate";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "dimmer";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "shift";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "withAlpha";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "srcOver";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "withPreAlpha";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "toAlpha";
                break;
            }
            case 30: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "toHex";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "toHtmlColor";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "fromHex";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "mix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "marker";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 22: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 52: 
            case 53: 
            case 54: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "softer";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "darker";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "brighter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hackBrightness";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "saturate";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "desaturate";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "dimmer";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "shift";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "withAlpha";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "srcOver";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "withPreAlpha";
                break;
            }
            case 29: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "toHex";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "toHtmlColor";
                break;
            }
            case 36: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "fromHex";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "fromHex1";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "fromHex2";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isDark";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "areContrasting";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getContrast";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getLuminance";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "mix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 22: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 52: 
            case 53: 
            case 54: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

