/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.ui.ColorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.List;
import java.util.MissingResourceException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistryValue {
    private final Registry myRegistry;
    private final String myKey;
    @Nullable
    private final RegistryKeyDescriptor myKeyDescriptor;
    private final List<RegistryValueListener> myListeners;
    private boolean myChangedSinceStart;
    private String myStringCachedValue;
    private Integer myIntCachedValue;
    private Double myDoubleCachedValue;
    private Boolean myBooleanCachedValue;
    private static final Logger LOG = Logger.getInstance(RegistryValue.class);

    RegistryValue(@NotNull Registry registry, @NotNull String key, @Nullable RegistryKeyDescriptor keyDescriptor) {
        if (registry == null) {
            RegistryValue.$$$reportNull$$$0(0);
        }
        if (key == null) {
            RegistryValue.$$$reportNull$$$0(1);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myRegistry = registry;
        this.myKey = key;
        this.myKeyDescriptor = keyDescriptor;
    }

    @NotNull
    public String getKey() {
        String string = this.myKey;
        if (string == null) {
            RegistryValue.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String asString() {
        String value = this.get(this.myKey, null, true);
        assert (value != null) : this.myKey;
        String string = value;
        if (string == null) {
            RegistryValue.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean asBoolean() {
        if (this.myBooleanCachedValue == null) {
            this.myBooleanCachedValue = Boolean.valueOf(this.get(this.myKey, "false", true));
        }
        return this.myBooleanCachedValue;
    }

    public int asInteger() {
        if (this.myIntCachedValue == null) {
            try {
                this.myIntCachedValue = Integer.valueOf(this.get(this.myKey, "0", true));
            }
            catch (NumberFormatException e) {
                String bundleValue = Registry.getInstance().getBundleValue(this.myKey, true);
                assert (bundleValue != null);
                this.myIntCachedValue = Integer.valueOf(bundleValue);
            }
        }
        return this.myIntCachedValue;
    }

    public double asDouble() {
        if (this.myDoubleCachedValue == null) {
            try {
                this.myDoubleCachedValue = Double.valueOf(this.get(this.myKey, "0.0", true));
            }
            catch (NumberFormatException e) {
                String bundleValue = Registry.getInstance().getBundleValue(this.myKey, true);
                assert (bundleValue != null);
                this.myDoubleCachedValue = Double.valueOf(bundleValue);
            }
        }
        return this.myDoubleCachedValue;
    }

    Color asColor(Color defaultValue) {
        String s = this.get(this.myKey, null, true);
        if (s != null) {
            Color color = ColorUtil.fromHex(s, null);
            if (color != null && this.myKey.contains("color")) {
                return color;
            }
            String[] rgb = s.split(",");
            if (rgb.length == 3) {
                try {
                    return new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return defaultValue;
    }

    @NotNull
    public String getDescription() {
        if (this.myKeyDescriptor != null) {
            String string = this.myKeyDescriptor.getDescription();
            if (string == null) {
                RegistryValue.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = this.get(this.myKey + ".description", "", false);
        if (string == null) {
            RegistryValue.$$$reportNull$$$0(5);
        }
        return string;
    }

    boolean isRestartRequired() {
        if (this.myKeyDescriptor != null) {
            return this.myKeyDescriptor.isRestartRequired();
        }
        return Boolean.valueOf(this.get(this.myKey + ".restartRequired", "false", false));
    }

    public boolean isChangedFromDefault() {
        return this.isChangedFromDefault(this.asString());
    }

    public boolean isContributedByThirdPartyPlugin() {
        return this.myKeyDescriptor != null && this.myKeyDescriptor.isContributedByThirdPartyPlugin();
    }

    boolean isChangedFromDefault(@NotNull String newValue) {
        if (newValue == null) {
            RegistryValue.$$$reportNull$$$0(6);
        }
        return !newValue.equals(Registry.getInstance().getBundleValue(this.myKey, false));
    }

    protected String get(@NotNull String key, String defaultValue, boolean isValue) throws MissingResourceException {
        if (key == null) {
            RegistryValue.$$$reportNull$$$0(7);
        }
        if (isValue) {
            if (this.myStringCachedValue == null) {
                this.myStringCachedValue = this._get(key, defaultValue, true);
            }
            return this.myStringCachedValue;
        }
        return this._get(key, defaultValue, false);
    }

    private String _get(@NotNull String key, String defaultValue, boolean mustExistInBundle) throws MissingResourceException {
        String userValue;
        if (key == null) {
            RegistryValue.$$$reportNull$$$0(8);
        }
        if ((userValue = this.myRegistry.getUserProperties().get(key)) != null) {
            return userValue;
        }
        String systemProperty = System.getProperty(key);
        if (systemProperty != null) {
            return systemProperty;
        }
        String bundleValue = Registry.getInstance().getBundleValue(key, mustExistInBundle);
        if (bundleValue != null) {
            return bundleValue;
        }
        return defaultValue;
    }

    public void setValue(boolean value) {
        this.setValue(Boolean.toString(value));
    }

    public void setValue(int value) {
        this.setValue(Integer.toString(value));
    }

    public void setValue(String value) {
        this.resetCache();
        for (RegistryValueListener each : this.myListeners) {
            each.beforeValueChanged(this);
        }
        this.myRegistry.getUserProperties().put(this.myKey, value);
        for (RegistryValueListener each : this.myListeners) {
            each.afterValueChanged(this);
        }
        if (!this.isChangedFromDefault() && !this.isRestartRequired()) {
            this.myRegistry.getUserProperties().remove(this.myKey);
        }
        this.myChangedSinceStart = true;
        LOG.info("Registry value '" + this.myKey + "' has changed to '" + value + '\'');
    }

    public void setValue(boolean value, Disposable parentDisposable) {
        final boolean prev = this.asBoolean();
        this.setValue(value);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                RegistryValue.this.setValue(prev);
            }
        });
    }

    public void setValue(int value, Disposable parentDisposable) {
        final int prev = this.asInteger();
        this.setValue(value);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                RegistryValue.this.setValue(prev);
            }
        });
    }

    public void setValue(String value, Disposable parentDisposable) {
        final String prev = this.asString();
        this.setValue(value);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                RegistryValue.this.setValue(prev);
            }
        });
    }

    boolean isChangedSinceAppStart() {
        return this.myChangedSinceStart;
    }

    public void resetToDefault() {
        this.setValue(Registry.getInstance().getBundleValue(this.myKey, true));
    }

    public void addListener(final @NotNull RegistryValueListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            RegistryValue.$$$reportNull$$$0(9);
        }
        if (parent == null) {
            RegistryValue.$$$reportNull$$$0(10);
        }
        this.myListeners.add(listener);
        Disposer.register(parent, new Disposable(){

            @Override
            public void dispose() {
                RegistryValue.this.myListeners.remove(listener);
            }
        });
    }

    public String toString() {
        return this.myKey + "=" + this.asString();
    }

    void resetCache() {
        this.myStringCachedValue = null;
        this.myIntCachedValue = null;
        this.myDoubleCachedValue = null;
        this.myBooleanCachedValue = null;
    }

    public boolean isBoolean() {
        return RegistryValue.isBoolean(this.asString());
    }

    private static boolean isBoolean(String s) {
        return "true".equalsIgnoreCase(s) || "false".equalsIgnoreCase(s);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registry";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/registry/RegistryValue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/registry/RegistryValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isChangedFromDefault";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "_get";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

