/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.util;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.intellij.lang.xpath.psi.XPath2Type;
import org.intellij.lang.xpath.psi.XPathElement;
import org.intellij.lang.xpath.psi.XPathExpression;
import org.intellij.lang.xpath.psi.XPathType;
import org.intellij.lang.xpath.psi.XPathVariableReference;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.psi.XsltElement;
import org.intellij.lang.xpath.xslt.psi.XsltElementFactory;
import org.intellij.lang.xpath.xslt.psi.XsltTemplate;
import org.intellij.lang.xpath.xslt.util.QNameUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XsltCodeInsightUtil {
    public static final PsiElementFilter XSLT_PARAM_FILTER = new PsiElementFilter(){

        public boolean isAccepted(@NotNull PsiElement element) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            return element instanceof XmlTag && XsltSupport.isParam((XmlTag)element);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/xpath/xslt/util/XsltCodeInsightUtil$1", "isAccepted"));
        }
    };
    public static final Comparator<PsiElement> POSITION_COMPARATOR = (o1, o2) -> o1.getTextOffset() - o2.getTextOffset();

    private XsltCodeInsightUtil() {
    }

    @Nullable
    public static XmlTag getTemplateTag(@NotNull PsiElement location, boolean isExpression, boolean requireName) {
        PsiElement p;
        if (location == null) {
            XsltCodeInsightUtil.$$$reportNull$$$0(0);
        }
        PsiElement psiElement = p = isExpression ? location.getContainingFile().getContext() : location;
        while ((p = PsiTreeUtil.getParentOfType((PsiElement)p, XmlTag.class)) != null) {
            XmlTag _p = (XmlTag)p;
            if (!XsltSupport.isTemplate(_p, requireName)) continue;
            return _p;
        }
        return null;
    }

    @Nullable
    public static XmlTag getTemplateTag(@NotNull PsiElement location, boolean isExpression) {
        if (location == null) {
            XsltCodeInsightUtil.$$$reportNull$$$0(1);
        }
        return XsltCodeInsightUtil.getTemplateTag(location, isExpression, false);
    }

    @Nullable
    public static XsltTemplate getTemplate(@NotNull PsiElement location, boolean isExpression) {
        XmlTag templateTag;
        if (location == null) {
            XsltCodeInsightUtil.$$$reportNull$$$0(2);
        }
        return (templateTag = XsltCodeInsightUtil.getTemplateTag(location, isExpression)) != null ? XsltElementFactory.getInstance().wrapElement(templateTag, XsltTemplate.class) : null;
    }

    @Nullable
    public static PsiElement findFirstRealTagChild(@NotNull XmlTag xmlTag) {
        if (xmlTag == null) {
            XsltCodeInsightUtil.$$$reportNull$$$0(3);
        }
        final PsiElement[] child = new PsiElement[1];
        xmlTag.processElements(new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_TAG_END) {
                    child[0] = element.getNextSibling();
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/xpath/xslt/util/XsltCodeInsightUtil$2", "execute"));
            }
        }, (PsiElement)xmlTag);
        return child[0];
    }

    @Nullable
    public static XPathExpression getXPathExpression(XsltElement xsltElement, String attributeName) {
        Object[] files;
        XmlAttribute attribute = xsltElement.getTag().getAttribute(attributeName, null);
        if (attribute != null && (files = XsltSupport.getFiles(attribute)).length > 0) {
            assert (files.length == 1) : "Unexpected number of XPathFiles in @" + attributeName + ": " + Arrays.toString(files);
            return (XPathExpression)PsiTreeUtil.getChildOfType((PsiElement)files[0], XPathExpression.class);
        }
        return null;
    }

    public static boolean areExpressionsEquivalent(XPathExpression x1, XPathExpression x2) {
        if (x1.getType() != x2.getType()) {
            return false;
        }
        return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)x1, (PsiElement)x2);
    }

    @Nullable
    public static XmlTag findLastParam(XmlTag templateTag) {
        ArrayList list = new ArrayList();
        PsiElementProcessor.CollectFilteredElements processor = new PsiElementProcessor.CollectFilteredElements(XSLT_PARAM_FILTER, list);
        templateTag.processElements((PsiElementProcessor)processor, (PsiElement)templateTag);
        return list.size() > 0 ? (XmlTag)list.get(list.size() - 1) : null;
    }

    @NotNull
    public static TextRange getRangeInsideHostingFile(XPathElement expr) {
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)PsiTreeUtil.getContextOfType((PsiElement)expr, PsiLanguageInjectionHost.class, (boolean)true);
        assert (host != null);
        List psi = InjectedLanguageManager.getInstance((Project)host.getProject()).getInjectedPsiFiles((PsiElement)host);
        assert (psi != null);
        for (Pair pair : psi) {
            if (!PsiTreeUtil.isAncestor((PsiElement)((PsiElement)pair.first), (PsiElement)expr, (boolean)false)) continue;
            TextRange textRange = expr.getTextRange().shiftRight(((TextRange)pair.second).getStartOffset() + host.getTextRange().getStartOffset());
            if (textRange == null) {
                XsltCodeInsightUtil.$$$reportNull$$$0(4);
            }
            return textRange;
        }
        assert (false);
        if (null == null) {
            XsltCodeInsightUtil.$$$reportNull$$$0(5);
        }
        return null;
    }

    @NotNull
    public static TextRange getRangeInsideHost(XPathElement expr) {
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)PsiTreeUtil.getContextOfType((PsiElement)expr, PsiLanguageInjectionHost.class, (boolean)true);
        assert (host != null);
        List psi = InjectedLanguageManager.getInstance((Project)host.getProject()).getInjectedPsiFiles((PsiElement)host);
        assert (psi != null);
        for (Pair pair : psi) {
            if (!PsiTreeUtil.isAncestor((PsiElement)((PsiElement)pair.first), (PsiElement)expr, (boolean)false)) continue;
            TextRange textRange = (TextRange)pair.second;
            if (textRange == null) {
                XsltCodeInsightUtil.$$$reportNull$$$0(6);
            }
            return textRange;
        }
        assert (false);
        if (null == null) {
            XsltCodeInsightUtil.$$$reportNull$$$0(7);
        }
        return null;
    }

    public static XmlTag findLastWithParam(XmlTag templateTag) {
        final XmlTag[] lastParam = new XmlTag[1];
        templateTag.processElements(new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (element instanceof XmlTag) {
                    if ("with-param".equals(((XmlTag)element).getLocalName())) {
                        lastParam[0] = (XmlTag)element;
                    } else {
                        return false;
                    }
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/lang/xpath/xslt/util/XsltCodeInsightUtil$3", "execute"));
            }
        }, (PsiElement)templateTag);
        return lastParam[0];
    }

    public static XmlTag findVariableInsertionPoint(XmlTag currentUsageTag, PsiElement usageBlock, final String referenceName, XmlTag ... moreUsages) {
        PsiElement subTags;
        XmlTag xmlTag;
        PsiElement t;
        XmlTag firstUsage;
        final TreeSet<PsiElement> usages = new TreeSet<PsiElement>(POSITION_COMPARATOR);
        usages.add((PsiElement)currentUsageTag);
        ContainerUtil.addAll(usages, (Object[])moreUsages);
        usageBlock.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof XPathVariableReference) {
                    this.visitXPathVariableReference((XPathVariableReference)element);
                } else {
                    super.visitElement(element);
                }
            }

            private void visitXPathVariableReference(XPathVariableReference reference) {
                if (referenceName.equals(reference.getReferencedName()) && reference.resolve() == null) {
                    usages.add(PsiTreeUtil.getContextOfType((PsiElement)reference, XmlTag.class, (boolean)true));
                }
            }

            public void visitXmlAttribute(XmlAttribute attribute) {
                if (XsltSupport.isXPathAttribute(attribute)) {
                    PsiFile[] xpathFiles;
                    for (PsiFile xpathFile : xpathFiles = XsltSupport.getFiles(attribute)) {
                        xpathFile.accept((PsiElementVisitor)this);
                    }
                }
            }
        });
        Iterator it = usages.iterator();
        XmlTag tag = firstUsage = (XmlTag)it.next();
        while (it.hasNext() && (t = PsiTreeUtil.findCommonParent((PsiElement)tag, (PsiElement)(xmlTag = (XmlTag)it.next()))) instanceof XmlTag) {
            tag = (XmlTag)t;
        }
        for (PsiElement xmlTag2 : subTags = tag.getSubTags()) {
            if (xmlTag2.getTextOffset() > firstUsage.getTextOffset()) break;
            tag = xmlTag2;
        }
        XmlTag parentTag = tag.getParentTag();
        if (parentTag == null) {
            return tag;
        }
        String parentName = parentTag.getLocalName();
        if ("apply-templates".equals(parentName) || "call-template".equals(parentName) || "when".equals(parentName) || "choose".equals(parentName)) {
            if ("when".equals(parentName)) {
                tag = tag.getParentTag();
            }
            assert (tag != null);
            tag = tag.getParentTag();
        }
        assert (tag != null);
        return tag;
    }

    @Nullable
    public static PsiElement getUsageBlock(XPathExpression reference) {
        XmlTag template = XsltCodeInsightUtil.getTemplateTag(reference, true);
        XmlTag tag = (XmlTag)PsiTreeUtil.getContextOfType((PsiElement)reference, XmlTag.class, (boolean)true);
        assert (tag != null);
        return template != null ? template.getNavigationElement() : tag.getParentTag();
    }

    @NotNull
    public static XmlDocument getDocument(@NotNull XmlElement element) {
        if (element == null) {
            XsltCodeInsightUtil.$$$reportNull$$$0(8);
        }
        XmlDocument document = (XmlDocument)PsiTreeUtil.getParentOfType((PsiElement)element, XmlDocument.class, (boolean)false);
        assert (document != null);
        XmlDocument xmlDocument = document;
        if (xmlDocument == null) {
            XsltCodeInsightUtil.$$$reportNull$$$0(9);
        }
        return xmlDocument;
    }

    public static XmlDocument getDocument(@NotNull XsltElement element) {
        if (element == null) {
            XsltCodeInsightUtil.$$$reportNull$$$0(10);
        }
        return XsltCodeInsightUtil.getDocument((XmlElement)element.getTag());
    }

    @Nullable
    public static XPathType getDeclaredType(XmlTag element) {
        XmlAttribute typeAttr = element.getAttribute("as");
        if (typeAttr != null) {
            String value = typeAttr.getValue();
            XPath2Type returnType = value != null ? XPath2Type.fromName(QNameUtil.createQName(value, (PsiElement)element)) : null;
            return returnType != null ? returnType : XPathType.UNKNOWN;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlTag";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/util/XsltCodeInsightUtil";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/util/XsltCodeInsightUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInsideHostingFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInsideHost";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateTag";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTemplate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFirstRealTagChild";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

