/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.runtime.java.AbstractJavaSnippet;
import java.util.HashMap;
import java.util.Map;

class Java8Snippet
extends AbstractJavaSnippet {
    private static final Map<Class<?>, Class<?>> PRIMITIVES_TO_WRAPPERS = new HashMap<Class<?>, Class<?>>(){
        {
            this.put(Boolean.TYPE, Boolean.class);
            this.put(Byte.TYPE, Byte.class);
            this.put(Character.TYPE, Character.class);
            this.put(Double.TYPE, Double.class);
            this.put(Float.TYPE, Float.class);
            this.put(Integer.TYPE, Integer.class);
            this.put(Long.TYPE, Long.class);
            this.put(Short.TYPE, Short.class);
            this.put(Void.TYPE, Void.class);
        }
    };

    Java8Snippet() {
    }

    @Override
    protected String getArgType(Class<?> argType) {
        if (argType.isPrimitive()) {
            return PRIMITIVES_TO_WRAPPERS.get(argType).getSimpleName();
        }
        return argType.getSimpleName();
    }

    public String template() {
        return "{0}(\"{1}\", ({3}) -> '{'\n    // {4}\n{5}    throw new PendingException();\n'}');\n";
    }
}

