/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac.ast;

import com.intellij.util.containers.Stack;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import gnu.trove.THashSet;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.jetbrains.jps.javac.ast.JavacReferenceCollectorListener;
import org.jetbrains.jps.javac.ast.api.JavacDef;
import org.jetbrains.jps.javac.ast.api.JavacNameTable;
import org.jetbrains.jps.javac.ast.api.JavacRef;
import org.jetbrains.jps.javac.ast.api.JavacTypeCast;

class JavacTreeRefScanner
extends TreeScanner<Tree, JavacReferenceCollectorListener.ReferenceCollector> {
    private static final Set<ElementKind> ALLOWED_ELEMENTS = EnumSet.of(ElementKind.ENUM, new ElementKind[]{ElementKind.CLASS, ElementKind.ANNOTATION_TYPE, ElementKind.INTERFACE, ElementKind.ENUM_CONSTANT, ElementKind.FIELD, ElementKind.CONSTRUCTOR, ElementKind.METHOD});
    private final Stack<TypeElement> myCurrentEnclosingElement = new Stack(1);
    private final Stack<Long> myCurrentEnclosingElementOffset = new Stack(1);
    private final Stack<NewClassTree> myCurrentAnonymousTree = new Stack(1);

    JavacTreeRefScanner() {
    }

    @Override
    public Tree visitCompilationUnit(CompilationUnitTree node, JavacReferenceCollectorListener.ReferenceCollector refCollector) {
        this.scan(node.getPackageAnnotations(), refCollector);
        this.scan(node.getTypeDecls(), refCollector);
        return node;
    }

    @Override
    public Tree visitIdentifier(IdentifierTree node, JavacReferenceCollectorListener.ReferenceCollector refCollector) {
        Element element = refCollector.getReferencedElement(node);
        if (element == null) {
            return null;
        }
        if (ALLOWED_ELEMENTS.contains((Object)element.getKind())) {
            refCollector.sinkReference(refCollector.asJavacRef(element));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tree visitNewClass(NewClassTree node, JavacReferenceCollectorListener.ReferenceCollector collector) {
        if (node.getClassBody() == null) {
            Element element = collector.getReferencedElement(node);
            if (element != null) {
                collector.sinkReference(collector.asJavacRef(element));
            }
            return (Tree)super.visitNewClass(node, collector);
        }
        this.myCurrentAnonymousTree.add((Object)node);
        try {
            this.scan(node.getEnclosingExpression(), collector);
            this.scan(node.getIdentifier(), collector);
            this.scan(node.getTypeArguments(), collector);
            this.scan(node.getClassBody(), collector);
            Tree tree = null;
            return tree;
        }
        finally {
            this.myCurrentAnonymousTree.pop();
        }
    }

    @Override
    public Tree visitVariable(VariableTree node, JavacReferenceCollectorListener.ReferenceCollector refCollector) {
        JavacRef.JavacElementRefBase ref;
        Element element = refCollector.getReferencedElement(node);
        if (element != null && element.getKind() == ElementKind.FIELD && (ref = refCollector.asJavacRef(element)) != null) {
            this.processMemberDefinition(refCollector, ref, element, element.asType());
        }
        return (Tree)super.visitVariable(node, refCollector);
    }

    @Override
    public Tree visitMemberSelect(MemberSelectTree node, JavacReferenceCollectorListener.ReferenceCollector refCollector) {
        Element element = refCollector.getReferencedElement(node);
        if (element != null && element.getKind() != ElementKind.PACKAGE) {
            ExpressionTree qualifierExpression = node.getExpression();
            Element qualifierType = null;
            TypeMirror type = refCollector.getType(qualifierExpression);
            if (type instanceof DeclaredType) {
                qualifierType = ((DeclaredType)type).asElement();
            }
            refCollector.sinkReference(refCollector.asJavacRef(element, qualifierType));
        }
        return (Tree)super.visitMemberSelect(node, refCollector);
    }

    @Override
    public Tree visitMethod(MethodTree node, JavacReferenceCollectorListener.ReferenceCollector refCollector) {
        JavacRef.JavacElementRefBase ref;
        Element element = refCollector.getReferencedElement(node);
        if (refCollector.getNameTable().isInit(node.getName()) && ((Long)this.myCurrentEnclosingElementOffset.peek()).longValue() == refCollector.getStartOffset(node)) {
            return null;
        }
        if (element != null && (ref = refCollector.asJavacRef(element)) != null) {
            this.processMemberDefinition(refCollector, ref, element, ((ExecutableElement)element).getReturnType());
        }
        return (Tree)super.visitMethod(node, refCollector);
    }

    @Override
    public Tree visitBinary(BinaryTree node, JavacReferenceCollectorListener.ReferenceCollector collector) {
        ExpressionTree rOp;
        ExpressionTree lOp;
        Set<TypeElement> typeElements;
        Tree.Kind kind = node.getKind();
        if (kind == Tree.Kind.PLUS && (typeElements = JavacTreeRefScanner.extractImplicitToStringCalls(lOp = node.getLeftOperand(), rOp = node.getRightOperand(), collector)) != null) {
            for (TypeElement element : typeElements) {
                JavacRef.JavacElementRefBase ref = collector.asJavacRef(element);
                if (ref == null) continue;
                collector.sinkImplicitToString(ref);
            }
        }
        return (Tree)super.visitBinary(node, collector);
    }

    private void processMemberDefinition(JavacReferenceCollectorListener.ReferenceCollector refCollector, JavacRef.JavacElementRefBase ref, Element element, TypeMirror retType) {
        List<? extends TypeMirror> typeArguments;
        refCollector.sinkReference(ref);
        int dimension = 0;
        if (retType.getKind() == TypeKind.ARRAY) {
            retType = ((ArrayType)retType).getComponentType();
            dimension = 1;
        } else if (retType.getKind() == TypeKind.DECLARED && (typeArguments = ((DeclaredType)retType).getTypeArguments()).size() == 1 && JavacTreeRefScanner.isIterator((TypeElement)((DeclaredType)retType).asElement(), refCollector)) {
            dimension = -1;
            retType = typeArguments.get(0);
        }
        JavacRef.JavacElementRefBase returnType = refCollector.asJavacRef(retType);
        if (returnType != null) {
            refCollector.sinkDeclaration(new JavacDef.JavacMemberDef(ref, returnType, (byte)dimension, JavacTreeRefScanner.isStatic(element)));
        }
    }

    @Override
    public Tree visitMethodInvocation(MethodInvocationTree node, JavacReferenceCollectorListener.ReferenceCollector collector) {
        Set<Modifier> modifiers;
        Element element;
        if (node.getMethodSelect() instanceof IdentifierTree && (element = collector.getReferencedElement(node.getMethodSelect())) != null && element.getKind() != ElementKind.CONSTRUCTOR && !(modifiers = element.getModifiers()).contains((Object)Modifier.STATIC) && !modifiers.contains((Object)Modifier.PRIVATE)) {
            TypeElement currentClass = (TypeElement)this.myCurrentEnclosingElement.peek();
            TypeElement actualQualifier = JavacTreeRefScanner.findQualifier(element, currentClass);
            if (actualQualifier == null) {
                actualQualifier = (TypeElement)this.myCurrentEnclosingElement.peek();
            }
            collector.sinkReference(collector.asJavacRef(element, actualQualifier));
            this.scan(node.getTypeArguments(), collector);
            this.scan(node.getArguments(), collector);
            return null;
        }
        return (Tree)super.visitMethodInvocation(node, collector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tree visitClass(ClassTree node, JavacReferenceCollectorListener.ReferenceCollector refCollector) {
        TypeElement element = (TypeElement)refCollector.getReferencedElement(node);
        if (element == null) {
            return null;
        }
        this.myCurrentEnclosingElement.add((Object)element);
        ModifiersTree modifiers = node.getModifiers();
        long modifiersEndOffset = refCollector.getEndOffset(modifiers);
        long startOffset = modifiersEndOffset == -1L ? refCollector.getStartOffset(node) : modifiersEndOffset + 1L;
        this.myCurrentEnclosingElementOffset.add((Object)startOffset);
        try {
            JavacRef[] supers;
            TypeMirror superclass = element.getSuperclass();
            List<? extends TypeMirror> interfaces = element.getInterfaces();
            if (superclass != refCollector.getTypeUtility().getNoType(TypeKind.NONE)) {
                supers = new JavacRef[interfaces.size() + 1];
                JavacRef.JavacElementRefBase ref = refCollector.asJavacRef(superclass);
                if (ref == null) {
                    Tree tree = null;
                    return tree;
                }
                supers[interfaces.size()] = ref;
            } else {
                supers = interfaces.isEmpty() ? JavacRef.EMPTY_ARRAY : new JavacRef[interfaces.size()];
            }
            int i = 0;
            for (TypeMirror tree : interfaces) {
                JavacRef.JavacElementRefBase ref = refCollector.asJavacRef(tree);
                if (ref == null) {
                    Tree tree2 = null;
                    return tree2;
                }
                supers[i++] = ref;
            }
            JavacRef.JavacElementRefBase aClass = refCollector.asJavacRef(element);
            if (aClass == null) {
                Tree tree = null;
                return tree;
            }
            refCollector.sinkReference(aClass);
            refCollector.sinkDeclaration(new JavacDef.JavacClassDef(aClass, supers));
            if (((JavacRef.JavacClass)((Object)aClass)).isAnonymous()) {
                this.scan(((NewClassTree)this.myCurrentAnonymousTree.peek()).getArguments(), refCollector);
            }
            super.visitClass(node, refCollector);
        }
        finally {
            this.myCurrentEnclosingElement.pop();
            this.myCurrentEnclosingElementOffset.pop();
        }
        return null;
    }

    @Override
    public Tree visitTypeCast(TypeCastTree node, JavacReferenceCollectorListener.ReferenceCollector collector) {
        super.visitTypeCast(node, collector);
        Element castType = collector.getReferencedElement(node.getType());
        if (castType == null) {
            return null;
        }
        JavacRef.JavacElementRefBase castTypeElement = collector.asJavacRef(castType);
        if (!(castTypeElement instanceof JavacRef.JavacClass)) {
            return null;
        }
        TypeMirror operandType = collector.getType(node.getExpression());
        if (operandType == null) {
            return null;
        }
        JavacRef.JavacElementRefBase operandTypeElement = collector.asJavacRef(operandType);
        if (!(operandTypeElement instanceof JavacRef.JavacClass)) {
            return null;
        }
        collector.sinkTypeCast(new JavacTypeCast((JavacRef.JavacClass)((Object)operandTypeElement), (JavacRef.JavacClass)((Object)castTypeElement)));
        return null;
    }

    static JavacTreeRefScanner createASTScanner() {
        try {
            Class<?> aClass = Class.forName("org.jetbrains.jps.javac.ast.Javac8RefScanner");
            return (JavacTreeRefScanner)aClass.newInstance();
        }
        catch (Throwable ignored) {
            return new JavacTreeRefScanner();
        }
    }

    private static boolean isStatic(Element element) {
        return element.getModifiers().contains((Object)Modifier.STATIC);
    }

    private static TypeElement findQualifier(Element method, TypeElement scopeClass) {
        Element containingClass = method.getEnclosingElement();
        if (containingClass == null) {
            return null;
        }
        while (scopeClass != null) {
            Element parent = JavacTreeRefScanner.getClassOrPackageParent(scopeClass);
            if (scopeClass.getModifiers().contains((Object)Modifier.STATIC) || parent instanceof PackageElement || JavacTreeRefScanner.isInheritorOrSelf(scopeClass, (TypeElement)containingClass)) {
                return scopeClass;
            }
            if (JavacTreeRefScanner.isPackageOrNull(parent)) {
                return null;
            }
            scopeClass = (TypeElement)parent;
        }
        return null;
    }

    private static boolean isIterator(TypeElement aClass, JavacReferenceCollectorListener.ReferenceCollector collector) {
        JavacNameTable table = collector.getNameTable();
        TypeElement iterable = table.getIterableElement();
        if (iterable != null && JavacTreeRefScanner.isInheritorOrSelf(aClass, iterable)) {
            return true;
        }
        TypeElement stream = table.getStreamElement();
        if (stream != null && JavacTreeRefScanner.isInheritorOrSelf(aClass, stream)) {
            return true;
        }
        TypeElement iterator = table.getIteratorElement();
        return iterator != null && JavacTreeRefScanner.isInheritorOrSelf(aClass, iterator);
    }

    private static Element getClassOrPackageParent(Element element) {
        for (element = element.getEnclosingElement(); element != null; element = element.getEnclosingElement()) {
            ElementKind kind = element.getKind();
            if (kind != ElementKind.CLASS && kind != ElementKind.INTERFACE && kind != ElementKind.ENUM && kind != ElementKind.PACKAGE) continue;
            return element;
        }
        return null;
    }

    private static boolean isPackageOrNull(Element element) {
        return element == null || element.getKind() == ElementKind.PACKAGE;
    }

    private static boolean isInheritorOrSelf(TypeElement aClass, TypeElement baseClass) {
        if (aClass == baseClass) {
            return true;
        }
        TypeMirror superType = aClass.getSuperclass();
        if (JavacTreeRefScanner.isTypeCorrespondsToElement(superType, baseClass)) {
            return true;
        }
        List<? extends TypeMirror> interfaces = aClass.getInterfaces();
        for (TypeMirror typeMirror : interfaces) {
            if (!JavacTreeRefScanner.isTypeCorrespondsToElement(typeMirror, baseClass)) continue;
            return true;
        }
        if (JavacTreeRefScanner.isInheritorOrSelf(superType, baseClass)) {
            return true;
        }
        for (TypeMirror typeMirror : interfaces) {
            if (!JavacTreeRefScanner.isInheritorOrSelf(typeMirror, baseClass)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInheritorOrSelf(TypeMirror classType, TypeElement baseClass) {
        if (classType != null && classType.getKind() != TypeKind.NONE) {
            return JavacTreeRefScanner.isInheritorOrSelf((TypeElement)((DeclaredType)classType).asElement(), baseClass);
        }
        return false;
    }

    private static boolean isTypeCorrespondsToElement(TypeMirror type, TypeElement baseClass) {
        DeclaredType superClass;
        Element superClassElement;
        return type != null && type.getKind() != TypeKind.NONE && (superClassElement = (superClass = (DeclaredType)type).asElement()) == baseClass;
    }

    private static Set<TypeElement> extractImplicitToStringCalls(Tree lOp, Tree rOp, JavacReferenceCollectorListener.ReferenceCollector collector) {
        TypeMirror lTypeMirror = collector.getType(lOp);
        if (lTypeMirror == null) {
            return null;
        }
        TypeElement lType = JavacTreeRefScanner.asTypeElement(lTypeMirror, collector.getTypeUtility());
        if (lType == null) {
            return null;
        }
        TypeMirror rTypeMirror = collector.getType(rOp);
        if (rTypeMirror == null) {
            return null;
        }
        TypeElement rType = JavacTreeRefScanner.asTypeElement(rTypeMirror, collector.getTypeUtility());
        if (rType == null) {
            return null;
        }
        if (JavacTreeRefScanner.isToStringImplicitCall(lType, rType, collector)) {
            THashSet result = new THashSet();
            JavacTreeRefScanner.visitTypeHierarchy(rType, (Set<TypeElement>)result, collector.getTypeUtility());
            return result;
        }
        if (JavacTreeRefScanner.isToStringImplicitCall(rType, lType, collector)) {
            THashSet result = new THashSet();
            JavacTreeRefScanner.visitTypeHierarchy(lType, (Set<TypeElement>)result, collector.getTypeUtility());
            return result;
        }
        return null;
    }

    private static TypeElement asTypeElement(TypeMirror typeMirror, Types typeUtility) {
        if (typeMirror.getKind().isPrimitive()) {
            return typeUtility.boxedClass((PrimitiveType)typeMirror);
        }
        Element element = typeUtility.asElement(typeMirror);
        return element instanceof TypeElement ? (TypeElement)element : null;
    }

    private static boolean isToStringImplicitCall(TypeElement strElement, TypeElement element, JavacReferenceCollectorListener.ReferenceCollector collector) {
        TypeElement string = collector.getNameTable().getStringElement();
        return strElement == string && element != string;
    }

    private static void visitTypeHierarchy(TypeElement element, Set<TypeElement> collector, Types typeUtility) {
        if (collector.add(element)) {
            TypeMirror superclass = element.getSuperclass();
            Element superClass = typeUtility.asElement(superclass);
            if (superClass instanceof TypeElement) {
                JavacTreeRefScanner.visitTypeHierarchy((TypeElement)superClass, collector, typeUtility);
            }
            for (TypeMirror typeMirror : element.getInterfaces()) {
                if (!(typeMirror instanceof TypeElement)) continue;
                JavacTreeRefScanner.visitTypeHierarchy((TypeElement)((Object)typeMirror), collector, typeUtility);
            }
        }
    }
}

