/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sa.jdi;

import com.jetbrains.sa.jdi.LineInfo;
import com.jetbrains.sa.jdi.MethodImpl;
import com.jetbrains.sa.jdi.ReferenceTypeImpl;
import com.jetbrains.sa.jdi.SDE;
import com.jetbrains.sa.jdi.StratumLineInfo;
import sun.jvm.hotspot.oops.Method;

public class LocationImpl {
    private final ReferenceTypeImpl declaringType;
    private MethodImpl method;
    private Method methodRef;
    private long codeIndex;
    private LineInfo baseLineInfo = null;
    private LineInfo otherLineInfo = null;

    LocationImpl(MethodImpl method, long codeIndex) {
        this.method = method;
        this.codeIndex = method.isNative() ? -1L : codeIndex;
        this.declaringType = method.declaringType();
    }

    LocationImpl(ReferenceTypeImpl declaringType, Method methodRef, long codeIndex) {
        this.method = null;
        this.codeIndex = codeIndex;
        this.declaringType = declaringType;
        this.methodRef = methodRef;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LocationImpl) {
            LocationImpl other = (LocationImpl)obj;
            return this.method().equals(other.method()) && this.codeIndex() == other.codeIndex() && super.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return this.method().hashCode() + (int)this.codeIndex();
    }

    public int compareTo(LocationImpl other) {
        int rc = this.method().compareTo(other.method());
        if (rc == 0) {
            long diff = this.codeIndex() - other.codeIndex();
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }
        return rc;
    }

    public ReferenceTypeImpl declaringType() {
        return this.declaringType;
    }

    public MethodImpl method() {
        if (this.method == null) {
            this.method = this.declaringType.getMethodMirror(this.methodRef);
            if (this.method.isNative()) {
                this.codeIndex = -1L;
            }
        }
        return this.method;
    }

    public long codeIndex() {
        this.method();
        return this.codeIndex;
    }

    LineInfo getBaseLineInfo(SDE.Stratum stratum) {
        if (this.baseLineInfo != null) {
            return this.baseLineInfo;
        }
        MethodImpl methodImpl = this.method();
        LineInfo lineInfo = methodImpl.codeIndexToLineInfo(stratum, this.codeIndex());
        this.addBaseLineInfo(lineInfo);
        return lineInfo;
    }

    LineInfo getLineInfo(SDE.Stratum stratum) {
        if (stratum.isJava()) {
            return this.getBaseLineInfo(stratum);
        }
        LineInfo lineInfo = this.otherLineInfo;
        if (lineInfo != null && stratum.id().equals(lineInfo.liStratum())) {
            return lineInfo;
        }
        int baseLineNumber = this.lineNumber("Java");
        SDE.LineStratum lineStratum = stratum.lineStratum(this.declaringType, baseLineNumber);
        if (lineStratum != null && lineStratum.lineNumber() != -1) {
            lineInfo = new StratumLineInfo(stratum.id(), lineStratum.lineNumber(), lineStratum.sourceName(), lineStratum.sourcePath());
        } else {
            MethodImpl methodImpl = this.method();
            lineInfo = methodImpl.codeIndexToLineInfo(stratum, this.codeIndex());
        }
        this.addStratumLineInfo(lineInfo);
        return lineInfo;
    }

    void addStratumLineInfo(LineInfo lineInfo) {
        this.otherLineInfo = lineInfo;
    }

    void addBaseLineInfo(LineInfo lineInfo) {
        this.baseLineInfo = lineInfo;
    }

    public int lineNumber() {
        return this.lineNumber((String)null);
    }

    public int lineNumber(String stratumID) {
        return this.lineNumber(this.declaringType.stratum(stratumID));
    }

    int lineNumber(SDE.Stratum stratum) {
        return this.getLineInfo(stratum).liLineNumber();
    }

    public String toString() {
        if (this.lineNumber() == -1) {
            return this.method().toString() + "+" + this.codeIndex();
        }
        return this.declaringType().name() + ":" + this.lineNumber();
    }
}

